/* ====================================================================
 * Copyright (c) 2003-2008, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REVISIONWIDGET_H
#define _SC_REVISIONWIDGET_H

// sc
#include "svn/Revision.h"
class RevisionProvider;
class ExternButton;

// qt
#include <QtGui/QWidget>
class QStackedWidget;
class QDateTimeEdit;
class QToolButton;
class QCheckBox;
class QComboBox;
class QDateTime;
class QSpinBox;
class QLabel;
class QMenu;


class RevisionWidget : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  /**
   * construct a RevisionWidget.
   * @param types     combination of "S"ymbolic, "N"umeric and "D"ate
   * @param symbols   combination of "H"ead, "B"ase, "C"ommitted, "P"revious,
   *                  "W"orking
   */

  RevisionWidget( bool allowNoRevision, const QString& types, const QString& symbols,
    RevisionProvider* prov, QWidget *parent );
  virtual ~RevisionWidget();

  svn::Revision* getRevision() const;
  void setRevision( const svn::Revision* );
  void setRevision( svn::RevisionPtr );
  void setTitle( const QString& title );

private slots:
  void toggled( bool );
  void signalRev();
  void signalRev(int);
  void signalRev(bool);
  void signalRev(const QDateTime&);

signals:
  void revChanged( svn::RevisionPtr rev );

private:
  void addType( const QChar& );
  void addSymbol( const QChar& );

private:
  QLabel*           _title;
  QCheckBox*        _disable;
  QStackedWidget*   _stack;
  QComboBox*        _symRev;
  QSpinBox*         _numRev;
  QDateTimeEdit*    _dateRev;
  QToolButton*      _menuButton;
  QMenu*            _menu;
  QLayout*          _revBox;

  ExternButton*     _extern;
  RevisionProvider* _revpro;
};


#endif // _SC_REVISIONWIDGET_H
