/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPVIEWTREEWIDGET_H
#define _SC_RPVIEWTREEWIDGET_H

// sc
class RpViewTree;
class RpViewModel;
class RpViewState;
class ActionStorage;
namespace sc {
  class String;
}

// qt
#include <QtGui/QWidget>
class QToolButton;
class QCheckBox;
class QLabel;


class RpViewTreeWidget : public QWidget
{
  typedef QWidget super;
  Q_OBJECT

public:
  RpViewTreeWidget( RpViewModel*, ActionStorage*, QWidget* parent );

public slots:
  void historyChange();
  void fetch( const sc::String& path );

private:
  RpViewModel* _model;
  RpViewTree*  _tree;
  RpViewState* _state;

  QToolButton* _back;
  QToolButton* _forward;

  //QCheckBox*   _updates;
  QLabel*      _version;
};


#endif // _SC_RPVIEWTREEWIDGET_H
