/* ====================================================================
 * Copyright (c) 2007-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWTREEPROXYMODEL_H
#define _SC_WCVIEWTREEPROXYMODEL_H

// sc
#include "WcViewItemModel.h"
#include "TextStatusFilter.h"
#include "util/String.h"

// qt
#include <QtGui/QSortFilterProxyModel>

/**
 * Proxy model for WcViewTree.
 */
class WcViewTreeProxyModel : public QSortFilterProxyModel, public WcViewItemModel
{
  typedef QSortFilterProxyModel super;
  Q_OBJECT

public:
  WcViewTreeProxyModel();
  ~WcViewTreeProxyModel();

  // QAbstractItemModel
  QModelIndex index( int row, int column, const QModelIndex& parent = QModelIndex() ) const;
  QVariant data( const QModelIndex& index, int role ) const;
  Qt::ItemFlags flags( const QModelIndex &index ) const;

  /** Filter @a sourceRow based on the current filter settings. */
  bool filterAcceptsRow( int sourceRow, const QModelIndex& sourceParent ) const;

  /** Compares the content of @a left and @a right index. */
  bool lessThan(const QModelIndex &left, const QModelIndex &right) const;

  /** Set the @a current dir. This is a filter settings. Any path requested 
   *  by calling data() will have it stripped from the path. */
  void setCurrentPath( const sc::String& current );

  /** Use flat filter. */
  void setFilterFlat( bool on );
  /** Show all items. Defaults is false. */
  void setFilterAll( bool on );
  /** Show out of date items. Defaults is false. */
  void setFilterOutOfDate( bool on );
  /** Show only items with a TextStatus in @a filter. */
  void setFilterTextStatus( const TextStatusFilter& filter );
  
  /** Show only modified folders. Defaults is false. */
  void setFilterModifiedFolder( bool on );

  // WcViewItemModel
  QModelIndex index( const sc::String& name ) const;

public slots:
  // WcViewItemModel
  void insert( const sc::String& path, const WcViewItems& );
  void remove( const sc::String& path );

private:
  WcViewItemModel* sourceModel2() const;
  
  // filter conditions
  bool isSelf( const sc::String& path ) const;
  bool isSibling( const sc::String& path ) const;
  bool isVisible( bool outofdate ) const;

  sc::String  _current;      ///< the current dir.

  bool _flat;                ///< filter, use flat or tree filter.

  bool _all;                 ///< filter, show all items.
  bool _outofdate;           ///< filter, show out of date items.
  TextStatusFilter _status;  ///< filter, show changed items status. 
  
  bool _modifiedFolder;      ///< filter, show only modified folders.
};

#endif // _SC_WCVIEWTREEROXYMODEL_H
