/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COPYPARAM_H
#define _SC_COPYPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "svn/CommitInfo.h"
#include "svn/Revision.h"
#include "util/String.h"


/**
 * Parameter class for CopyCmd.
 */
class CopyParam : public ScParam
{
public:
  CopyParam( const svn::Paths& srcPathsOrUrls, const svn::RevisionPtr srcRev, const char* dstPathOrUrl )
    : _srcPathsOrUrls(srcPathsOrUrls), _srcRev(srcRev), _dstPathOrUrl(dstPathOrUrl)
  {
  }

  ~CopyParam()
  {
  }

  const svn::Paths& getSrcPathsOrUrls() const
  {
    return _srcPathsOrUrls;
  }

  void setSrcPathsOrUrls( const svn::Paths& pathsOrUrls )
  {
    _srcPathsOrUrls = pathsOrUrls;
  }

  const svn::RevisionPtr getSrcRevision() const
  {
    return _srcRev;
  }

  void setSrcRevision( svn::RevisionPtr rev )
  {
    _srcRev = rev;
  }

  const sc::String& getDstPathOrUrl() const
  {
    return _dstPathOrUrl;
  }

  void setDstPathOrUrl( const sc::String& dstPathOrUrl )
  {
    _dstPathOrUrl = dstPathOrUrl;
  }

  svn::CommitInfo& getCommitInfo()
  {
    return _info;
  }

  ScParamAccept(CopyParam);

private:
  // in
  svn::Paths       _srcPathsOrUrls;
  svn::RevisionPtr _srcRev;

  sc::String       _dstPathOrUrl;

  // out
  svn::CommitInfo  _info;
};

#endif // _SC_COPYPARAM_H
