/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DETAILSCMD_H
#define _SC_DETAILSCMD_H

// sc
#include "ScCmd.h"
class DetailsParam;
class CmdResultCallback;


/**
 * Command for ...
 */
class DetailsCmd : public ScCmd
{
public:
  /**
   * Construct an DetailsCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  DetailsCmd( DetailsParam* param, CmdResultCallback* cb );
  ~DetailsCmd();

  void run();

private:
  // in
  DetailsParam*      _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_DETAILSCMD_H
