/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOCKCMD_H
#define _SC_LOCKCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class LockParam;


/**
 * Command for locking paths or urls.
 */
class LockCmd : public ScCmd
{
public:
  /**
   * Construct a LockCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  LockCmd( LockParam* param, CmdResultCallback* cb );
  ~LockCmd();

  void run();

private:
  // in
  LockParam*         _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_LOCKCMD_H
