/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPSETREVCMD_H
#define _SC_PROPSETREVCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class PropSetRevParam;


/**
 * Command for setting revision properties.
 */
class PropSetRevCmd : public ScCmd
{
public:
  /**
   * Construct a PropSetRevCmd.
   *
   * \param param the parameters for the command. The command takes ownership
   * of the parameter object and deletes it if it itself destroyed.
   *
   * \param cb the callback that gets called when the command has finished.
   * 
   */
  PropSetRevCmd( PropSetRevParam* param, CmdResultCallback* cb );
  ~PropSetRevCmd();

  void run();

private:
  // in
  PropSetRevParam*   _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_PROPSETREVCMD_H
