/* ====================================================================
 * Copyright 2006,          Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMMITLOGHISTORY_H
#define _SC_COMMITLOGHISTORY_H

// sc
#include "util/String.h"

// sys
#include <vector>

/**
 * interface for getting and settings the commit log
 * history.
 */
class CommitLogHistory
{
public:
  typedef std::vector<sc::String> Logs;

  virtual ~CommitLogHistory(){}

  virtual void getLogs( Logs& logs ) = 0;
  virtual void addLog( const sc::String& ) = 0;
};

#endif // _SC_COMMITLOGHISTORY_H
