/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */
#ifndef _SC_MACSTYLE_H
#define _SC_MACSTYLE_H


// qt
#include <QtCore/qglobal.h>

#if defined(Q_OS_MACX)

#include <QtGui/qmacstyle_mac.h>
typedef QMacStyle QBaseStyle;
#define SC_ENABLE_STYLE 1

#elif defined(Q_OS_WIN32)

#include <QtGui/qwindowsstyle.h>
typedef QWindowsStyle QBaseStyle;
#define SC_ENABLE_STYLE 1

#endif


/**
 * Subcommander specific style modifications.
 * \todo rename to ScStyle
 */
#if defined SC_ENABLE_STYLE
class MacStyle : public QBaseStyle
{
  typedef QBaseStyle super;

public:
  MacStyle();
  ~MacStyle();
  
  void drawPrimitive( PrimitiveElement pe, const QStyleOption* so, QPainter* p,
    const QWidget* widget ) const;

  void drawComplexControl( ComplexControl control, const QStyleOptionComplex* so,
    QPainter* painter, const QWidget* widget ) const;
  
private:
  // disable..
  MacStyle( const MacStyle & );
  MacStyle& operator=( const MacStyle & );
};
#endif // SC_ENABLE_STYLE


#endif // _SC_MACSTYLE_H
