/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PATHSIMPLIFIER_H
#define _PATHSIMPLIFIER_H

// sc
#include "util/String.h"


/** remove duplication from the given paths. */
class PathSimplifier
{
public:
  PathSimplifier( const sc::String& path1, const sc::String& path2 );

  const sc::String& getPrefix() const;
  const sc::String& getPath1() const;
  const sc::String& getPath2() const;

private:
  void simplify( const sc::String& path );
  void simplify( const sc::String& path1, const sc::String& path2 );

  // out
  sc::String _prefix;
  sc::String _path1;
  sc::String _path2;
};

#endif // _PATHSIMPLIFIER_H
