/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "ColorSettingsWidget.h"
#include "sublib/ExternButton.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QLabel>
#include <QtGui/QColor>
#include <QtGui/QColorDialog>
#include <QtGui/QTreeWidget>
#include <QtGui/QTreeWidgetItem>

// sys
#include <cassert>


/////////////////////////////////////////////////////////////////////


class ColorLvi : public QTreeWidgetItem
{
  typedef QTreeWidgetItem super;

public:
  ColorLvi( QTreeWidget* parent, const Color& color )
    : super(parent,QTreeWidgetItem::UserType), _color(color)
  {
    setText( 0, _color._name );
    setBackground( 1, _color._color );
  }

  virtual ~ColorLvi()
  {
  }

  const Color& getColor()
  {
    return _color;
  }

  void setColor( const Color& c )
  {
    _color = c;
    setBackground( 1, _color._color );
  }

private:
  Color _color;
};


/////////////////////////////////////////////////////////////////////

ColorSettingsWidget::ColorSettingsWidget( QWidget *parent )
: super(parent)
{
  QVBoxLayout* vl = new QVBoxLayout(this);
  vl->setContentsMargins(2,2,2,2);
  vl->setSpacing(5);
  {
    _clist = new QTreeWidget(this);
    _clist->setColumnCount(2);
    _clist->setHeaderLabels( QStringList() << _q("color type") << _q("color") );
    _clist->setRootIsDecorated(false);
    vl->addWidget(_clist);

    connect( 
      _clist, SIGNAL(itemDoubleClicked(QTreeWidgetItem*,int)),
      this,   SLOT(itemDoubleClicked(QTreeWidgetItem*,int)) );
    connect(
      _clist, SIGNAL(itemClicked(QTreeWidgetItem*,int)),
      this,   SLOT(itemClicked(QTreeWidgetItem*,int)) );

    _desc = new QLabel(this);
    vl->addWidget(_desc);
  }
}

ColorSettingsWidget::~ColorSettingsWidget()
{
}

void ColorSettingsWidget::itemDoubleClicked( QTreeWidgetItem* lvi, int column )
{
  ColorLvi* clvi  = dynamic_cast<ColorLvi*>(lvi);
  Color     color = clvi->getColor();
  QColor  choosen = QColorDialog::getColor( color._color, this );

  if( choosen.isValid() && choosen != color._color )
  {
    color._color = choosen;
    clvi->setColor(color);
    emit modified();
  }
}

void ColorSettingsWidget::itemClicked( QTreeWidgetItem* lvi, int column )
{
  ColorLvi* clvi  = dynamic_cast<ColorLvi*>(lvi);
  if( ! clvi )
  {
    return;
  }

  _desc->setText( clvi->getColor()._desc );
}


void ColorSettingsWidget::setColors( const Colors& colors )
{
  _clist->clear();

  for( Colors::const_iterator it = colors.begin(); it != colors.end(); it++ )
  {
    const Color& c = *it;
    new ColorLvi( _clist, c );
  }
}

void ColorSettingsWidget::getColors( Colors& colors )
{
  QTreeWidgetItemIterator it(_clist);
  while(*it)
  {
    ColorLvi* lvi = dynamic_cast<ColorLvi*>(*it);
    colors.push_back( lvi->getColor() );
    ++it;
  }
}
