/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_AUTHPROMPTPROVIDER_H
#define _SVN_AUTHPROMPTPROVIDER_H

// sc
#include "util/String.h"


namespace svn
{

/**
 * This interface represents subversions svn_client_get_XXX_prompt_provider,
 * prompt_func, prompt_baton.
 */
class AuthPromptProvider
{
public:
  virtual ~AuthPromptProvider() {}

  /** svn_auth_cred_simple_t */
  struct simpleCredentials
  {
    sc::String _username;
    sc::String _password;
    bool        _save;
  };

  /** svn_auth_simple_prompt_func_t */
  virtual bool simplePrompt( const char* realm, const char* username, bool maySave,
    simpleCredentials& cred ) = 0;



  /** svn_auth_ssl_server_cert_info_t */
  struct sslServerCertInfo 
  {
    const char* hostname;
    const char* fingerprint;
    const char* validFrom;
    const char* validUntil;
    const char* issuerDName;
    const char* asciiCert;
  };

  /** svn_auth_cred_ssl_server_trust_t */
  struct sslServerTrustCredentials
  {
    unsigned long _acceptedFailures;  ///< 32 bit
    bool          _save;
  };

  /** svn_auth_ssl_server_trust_prompt_func_t */
  virtual bool sslServerTrustPrompt( const char* realm, unsigned long failures,
    const sslServerCertInfo& certinfo, bool maySave, sslServerTrustCredentials& cred ) = 0;
};

} // namespace

#endif // _SVN_AUTHPROMPTPROVIDER_H

