/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_COMMITINFO_H
#define _SVN_COMMITINFO_H

// sc
#include "svn.h"
#include "util/String.h"

// svn
struct svn_client_commit_info_t;


namespace svn
{

/**
 * svn_client_commit_info_t
 * commit result.
 */
class CommitInfo
{
public:
  CommitInfo();

  void operator=( svn_client_commit_info_t* info );

  Revnumber getRevnumber() const;
  const sc::String& getDate() const;
  const sc::String& getAuthor() const;

private:
  Revnumber   _revnum;
  sc::String  _date;
  sc::String  _author;
};


} // namespace

#endif //  _SVN_COMMITINFO_H

