/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_WCNOTIFY_H
#define _SVN_WCNOTIFY_H

// sc
#include "svn.h"
#include "util/String.h"
#include "util/Error.h"

// svn
#include <svn_wc.h>

namespace svn
{
class Lock;

// svn_wc_notify_action_t
enum WcNotifyAction
{
  WcNotify_Add                  = svn_wc_notify_add,
  WcNotify_Copy                 = svn_wc_notify_copy,
  WcNotify_Delete               = svn_wc_notify_delete,
  WcNotify_Restore              = svn_wc_notify_restore,
  WcNotify_Revert               = svn_wc_notify_revert,
  WcNotify_FailedRevert         = svn_wc_notify_failed_revert,
  WcNotify_Resolved             = svn_wc_notify_resolved,
  WcNotify_Skip                 = svn_wc_notify_skip,
  WcNotify_UpdateDelete         = svn_wc_notify_update_delete,
  WcNotify_UpdateAdd            = svn_wc_notify_update_add,
  WcNotify_UpdateUpdate         = svn_wc_notify_update_update,
  WcNotify_UpdateCompleted      = svn_wc_notify_update_completed,
  WcNotify_UpdateExternal       = svn_wc_notify_update_external,
  WcNotify_StatusCompleted      = svn_wc_notify_status_completed,
  WcNotify_StatusExternal       = svn_wc_notify_status_external,
  WcNotify_CommitModified       = svn_wc_notify_commit_modified,
  WcNotify_CommitAdded          = svn_wc_notify_commit_added,
  WcNotify_CommitDeleted        = svn_wc_notify_commit_deleted,
  WcNotify_CommitReplaced       = svn_wc_notify_commit_replaced,
  WcNotify_CommitPostfixTxdelta = svn_wc_notify_commit_postfix_txdelta,
  WcNotify_BlameRevision        = svn_wc_notify_blame_revision,
  WcNotify_Locked               = svn_wc_notify_locked,          ///< new in svn 1.2
  WcNotify_Unlocked             = svn_wc_notify_unlocked,
  WcNotify_FailedLock           = svn_wc_notify_failed_lock,
  WcNotify_FailedUnlock         = svn_wc_notify_failed_unlock
};

// svn_wc_notify_state_t
enum WcNotifyState
{
  WcNotifyState_Inapplicable = svn_wc_notify_state_inapplicable,
  WcNotifyState_Unknown      = svn_wc_notify_state_unknown,
  WcNotifyState_Unchanged    = svn_wc_notify_state_unchanged,
  WcNotifyState_Missing      = svn_wc_notify_state_missing,
  WcNotifyState_Obstructed   = svn_wc_notify_state_obstructed,
  WcNotifyState_Changed      = svn_wc_notify_state_changed,
  WcNotifyState_Merged       = svn_wc_notify_state_merged,
  WcNotifyState_Conflicted   = svn_wc_notify_state_conflicted
};

// svn_wc_notify_lock_state_t
enum WcNotifyLockState
{
  WcNotifyLockState_Inapplicable = svn_wc_notify_lock_state_inapplicable,
  WcNotifyLockState_Unknown      = svn_wc_notify_lock_state_unknown,
  WcNotifyLockState_Unchanged    = svn_wc_notify_lock_state_unchanged,
  WcNotifyLockState_Locked       = svn_wc_notify_lock_state_locked,
  WcNotifyLockState_Unlocked     = svn_wc_notify_lock_state_unlocked
};


class WcNotify
{
public:
  WcNotify( const svn_wc_notify_t* );
  ~WcNotify();

  const sc::String& getPath() const;
  WcNotifyAction    getAction() const;
  WcNotifyState     getStatus() const;
  WcNotifyState     getPropStatus() const;
  WcNotifyLockState getLockStatus() const;
  const sc::Error*  getError() const;

private:
  WcNotify( const WcNotify& );

  sc::String        _path;
  WcNotifyAction    _action;
  NodeKind          _kind;
  sc::String        _mimetype;
  Lock*             _lock;
  sc::Error*        _error;
  WcNotifyState     _contState;
  WcNotifyState     _propState;
  WcNotifyLockState _lockState;
  Revnumber         _revision;
};

} // namespace

#endif // _SVN_WCNOTIFY_H
