/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _LINETOKENIZER_TEST_H
#define _LINETOKENIZER_TEST_H

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

class LineTokenizerTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( LineTokenizerTest );
  CPPUNIT_TEST( testNoLine );
  CPPUNIT_TEST( testEmptyLine );
  CPPUNIT_TEST( testEmptyLines );
  CPPUNIT_TEST( testSingleLine );
  CPPUNIT_TEST( testSingleLineNoFinalLF );
  CPPUNIT_TEST( testMultipleLines );
  CPPUNIT_TEST( testMultipleLinesNoFinalLF );
  
  CPPUNIT_TEST( testTokenStream );
  CPPUNIT_TEST( testTokenStreamError );
  CPPUNIT_TEST( testTokenStreamNoFinalLF );

  CPPUNIT_TEST( testWriteStream );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void testNoLine();
  void testEmptyLine();
  void testEmptyLines();
  void testSingleLine();
  void testSingleLineNoFinalLF();
  void testMultipleLines();
  void testMultipleLinesNoFinalLF();

  void testTokenStream();
  void testTokenStreamError();
  void testTokenStreamNoFinalLF();

  void testWriteStream();
};

#endif // _LINETOKENIZER_TEST_H
