/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef	_CalendarP_H_
#define _CalendarP_H_

#include	<Nws/BaseP.h>
#include	<Nws/Calendar.h>
#include	<time.h>

typedef struct {
	int empty;
} CalendarClassPart;

typedef struct _CalendarClassRec {
	CoreClassPart		core_class;
	BaseClassPart		base_class;
	CalendarClassPart	calendar_class;
} CalendarClassRec;

extern CalendarClassRec calendarClassRec;

typedef struct {
	/* resources */
	XtCallbackList	activate;
	Pixel		month_color;
	Pixel		sunday_color;
	Pixel		selector_color;
	struct tm	* _time;
	XFontStruct	*day_font;
	XFontStruct	*month_font;
	int		spacing;
	char		**day_names;
	char		**month_names;
	/* hidden */
	GC		grc;
	GC		selector_gc;
	int		selected;
	int		base;
} CalendarPart;

typedef struct _CalendarRec {
	CorePart	core;
	BasePart	base;
	CalendarPart	calendar;
} CalendarRec;

#endif
