/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _MenuBarP_H_
#define _MenuBarP_H_

#include	<Nws/RowP.h>
#include	<Nws/MenuBar.h>

#if NeedFunctionPrototypes
typedef void (*unactivate_Proc) (Widget);
#else
typedef void (*unactivate_Proc) ();
#endif

#define XtInheritUnactivate ((unactivate_Proc) _XtInherit)

typedef struct {
	unactivate_Proc	unactivate;
} MenuBarClassPart;

typedef struct _MenuBarClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	BaseConstClassPart	baseConst_class;
	RowClassPart		row_class;
	MenuBarClassPart	menuBar_class;
} MenuBarClassRec;

extern MenuBarClassRec menuBarClassRec;

typedef struct {
	/* resources */
	/* private */
	Boolean		do_popdown;
	Widget 		*last_activated;
	Boolean		is_activated;
	Boolean		have_grab;
} MenuBarPart;

typedef struct _MenuBarRec {
	CorePart		core;
	CompositePart		composite;
	ConstraintPart		constraint;
	BaseConstPart		baseConst;
	RowPart			row;
	MenuBarPart		menuBar;
} MenuBarRec;


typedef struct _MenuBarConstraintsRec {
	RowConstraintsPart	row;
} MenuBarConstraintsRec, *MenuBarConstraints;

#endif
