/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/Converters.h>

#include <Nws/PulldownShellP.h>
#include <Nws/Init.h>
#include <Nws/utils.h>
#include <Nws/misc.h>


#define PDTIME 500

#define offset(field) XtOffsetOf(PulldownShellRec, pulldownShell.field)

static XtResource resources[] = { 
	{
	 XtNcursor,
	 XtCCursor,
	 XtRCursor,
	 sizeof(Cursor),
	 offset(cursor),
	 XtRString,
	 (XtPointer) None
	},
	{
	 XtNbox_type,
	 XtCBox_type,
	 XtRBox_type,
	 sizeof(int),
	 offset(box_type),
	 XtRImmediate,
	 (XtPointer) XtCup_box
	},
	{
	 XtNbox_width,
	 XtCBox_width,
	 XtRInt,
	 sizeof(int),
	 offset(box_width),
	 XtRImmediate,
	 (XtPointer) 2
	},
	{
	 XtNbox_intensity,
	 XtCBox_intensity,
	 XtRInt,
	 sizeof(int),
	 offset(box_intensity),
	 XtRImmediate,
	 (XtPointer) 10000
	},
	{
	 XtNbox_color,
	 XtCBox_color,
	 XtRPixel,
	 sizeof(Pixel),
	 offset(box_color),
	 XtRString,
	 (XtPointer) XtDefaultForeground
	},
	{
	 XtNborderWidth,
	 XtCBorderWidth,
	 XtRInt,
	 sizeof(Dimension),
	 XtOffsetOf(PulldownShellRec,core.border_width),
	 XtRImmediate,
	 (XtPointer) 0
	},
	{
	 XtNbacking_store ,
	 XtCBacking_store ,
	 XtRBackingStore ,
	 sizeof(int) ,
	 offset(backing_store) ,
	 XtRImmediate ,
	 (XtPointer) (Always | WhenMapped | NotUseful)
	}
};

static void BRelease();

static XtActionsRec action [] = {
	{"buttonrelease" , BRelease} ,
};

static char trans_tab [] =
	"<BtnUp>: buttonrelease() \n\
	 ";

#if NeedFunctionPrototypes
	static void GetInternalDimension(Widget,Position *,Position *,Dimension *,Dimension *);
	static void SetInternalDimension(Widget,Dimension,Dimension);
#else
	static void GetInternalDimension();
	static void SetInternalDimension();
#endif


static void ClassInitialize ();
static void ChangeManaged ();
static void ResolveInheritance();
static void PostInitialization();
static void Redisplay();
static void Resize();
static void Initialize();
static void Realize();
static Boolean SetValues();

static void GrabAll();
static void UnGrabAll();
static void timerCB();
static void SetFocus();

PulldownShellClassRec pulldownShellClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &overrideShellClassRec,
    /* class_name            */ "PulldownShell",
    /* widget_size           */ sizeof(PulldownShellRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ ResolveInheritance ,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ PostInitialization,
    /* realize               */ Realize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources ,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ True,
    /* compress_exposure     */ True,
    /* compress_enterleave   */ True,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ Resize,
    /* expose                */ Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues ,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */ 
   {
    /* geometry_manager	    */	XtInheritGeometryManager,
    /* change_managed	    */	ChangeManaged,
    /* insert_child	    */	XtInheritInsertChild,
    /* delete_child	    */	XtInheritDeleteChild,
    /* extension	    */	NULL
   },
/* shell */
   {
    /* extension	    */	NULL
   },
/* override shell */
   {
    /* extension	    */	NULL
   },
/* pulldownShell */
   {
    /* get_internal_dimension  */ GetInternalDimension,
    /* set_internal_dimension  */ SetInternalDimension,
   },
};

WidgetClass pulldownShellWidgetClass = (WidgetClass) & pulldownShellClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void ResolveInheritance(class)
WidgetClass class;
{
	PulldownShellWidgetClass c = (PulldownShellWidgetClass) class;
	PulldownShellWidgetClass super;
	static CompositeClassExtensionRec extension_rec = {
		NULL, NULLQUARK, XtCompositeExtensionVersion,
		sizeof(CompositeClassExtensionRec), True};
	CompositeClassExtensionRec *ext;

  	ext = (XtPointer)XtMalloc(sizeof(*ext));
	*ext = extension_rec;
	ext->next_extension = c->composite_class.extension;
	c->composite_class.extension = ext;

	if (class == pulldownShellWidgetClass) return;
	super = (PulldownShellWidgetClass)class->core_class.superclass;

	if (c->pulldownShell_class.get_internal_dimension == XtInheritGetInternalDimension)
		c->pulldownShell_class.get_internal_dimension =
			super->pulldownShell_class.get_internal_dimension;

	if (c->pulldownShell_class.set_internal_dimension == XtInheritSetInternalDimension)
		c->pulldownShell_class.set_internal_dimension =
			super->pulldownShell_class.set_internal_dimension;

}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	PulldownShellWidget nw = (PulldownShellWidget) new_widget;
	XColor	dark,light,bg;
	Display *dpy=XtDisplay(new_widget);

	bg.pixel = nw->pulldownShell.box_color;
	
	XQueryColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&bg);
	
	LightColor(nw->pulldownShell.box_intensity,bg,light);
	DarkColor(nw->pulldownShell.box_intensity,bg,dark);

	nw->pulldownShell.light = light.pixel;
	nw->pulldownShell.dark = dark.pixel;
}

static void PostInitialization(w)
Widget w;
{
	XtAddCallback(w , XtNpopupCallback, GrabAll , (XtPointer)NULL);
	XtAddCallback(w , XtNpopdownCallback, UnGrabAll , (XtPointer)NULL);
	XtAddEventHandler(w , MapNotify , False , SetFocus , NULL);
}

static void ChangeManaged(w)
Widget w;
{
	Position x,y;
	Dimension height , width;
	PulldownShellWidget cw = (PulldownShellWidget) w;

	pulldownShellClassRec.pulldownShell_class.get_internal_dimension((Widget) cw , 
		&x , &y , &width , &height);

	if (cw->composite.num_children > 0)
	{
		XtConfigureWidget(cw->composite.children[0] , x , y , width , height ,
			cw->composite.children[0]->core.border_width);
	}
}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow (w);

	if (region == NULL) XClearWindow(dpy , win);

	switch (cw->pulldownShell.box_type)
	{
		case XtCno_box:
		case XtCshadow_box:
			break;

		case XtCsimple_box:
			X_DrawSimpleRawFrame(dpy , win , 0 , 0 , cw->core.width ,
					cw->core.height , cw->pulldownShell.box_width ,
					cw->pulldownShell.box_color);
			break;
		case XtCup_box:
			X_DrawSimple3DFrame(dpy , win , 0 , 0 , cw->core.width ,
				cw->core.height , cw->pulldownShell.box_width ,
				cw->pulldownShell.light , cw->pulldownShell.dark);
			break;
		case XtCdown_box:
			X_DrawSimple3DFrame(dpy , win , 0 , 0 , cw->core.width ,
				cw->core.height , cw->pulldownShell.box_width ,
				cw->pulldownShell.dark , cw->pulldownShell.light);
			break;

		case XtCframein_box:
			X_DrawSimple3DFrame(dpy , win ,0 , 0 , cw->core.width ,
				cw->core.height , cw->pulldownShell.box_width / 2 ,
				cw->pulldownShell.dark , cw->pulldownShell.light);
			X_DrawSimple3DFrame(dpy , win , cw->pulldownShell.box_width / 2 ,
				cw->pulldownShell.box_width / 2 ,
				cw->core.width - 2 * (cw->pulldownShell.box_width / 2),
				cw->core.height - 2 * (cw->pulldownShell.box_width / 2),
				cw->pulldownShell.box_width / 2 ,
				cw->pulldownShell.light , cw->pulldownShell.dark);
			break;
		case XtCframeout_box:
			X_DrawSimple3DFrame(dpy , win , 0 , 0 , cw->core.width ,
				cw->core.height , cw->pulldownShell.box_width / 2 ,
				cw->pulldownShell.light , cw->pulldownShell.dark);
			X_DrawSimple3DFrame(dpy , win ,cw->pulldownShell.box_width / 2 ,
				cw->pulldownShell.box_width / 2 , 
				cw->core.width - 2 * (cw->pulldownShell.box_width / 2),
				cw->core.height - 2 * (cw->pulldownShell.box_width / 2), 
				cw->pulldownShell.box_width / 2 ,
				cw->pulldownShell.dark , cw->pulldownShell.light);
			break;

	}
}

static void Realize(w, valueMask, attributes)
Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;
	Position x , y;
	Dimension width , height;
	
	pulldownShellClassRec.pulldownShell_class.
		get_internal_dimension(w , &x , &y , &width , &height);
	
	if ((attributes->cursor = cw->pulldownShell.cursor) != None)
		*valueMask |= CWCursor;

	if ((cw->pulldownShell.backing_store == Always) ||
		(cw->pulldownShell.backing_store == NotUseful) ||
		(cw->pulldownShell.backing_store == WhenMapped) ) {

		*valueMask |= CWBackingStore;
		attributes->backing_store = cw->pulldownShell.backing_store;
	}
	else *valueMask &= ~CWBackingStore;

	overrideShellClassRec.core_class.realize(w,valueMask,attributes);

}

static void Resize(w)
Widget w;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;
	Position x , y;
	Dimension width , height;
	
	pulldownShellClassRec.pulldownShell_class.
		get_internal_dimension(w , &x , &y , &width , &height);

	if ( !XtIsRealized(w) ) return;

	if (cw->composite.num_children > 0)
	{
		XtConfigureWidget(cw->composite.children[0] , x , y , width , height ,
			cw->composite.children[0]->core.border_width);
	}

}

#define WidgetValuesDiffer(w1,w2,component) (w1->pulldownShell.component != \
                                             w2->pulldownShell.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	PulldownShellWidget cw = (PulldownShellWidget) current;
	PulldownShellWidget nw = (PulldownShellWidget) new_widget;

	Boolean redraw=False;

	if WidgetValuesDiffer( cw , nw , cursor)
	{
		XDefineCursor(XtDisplay(current),XtWindow(current),nw->pulldownShell.cursor);
	}

	return redraw;
}

static void GetInternalDimension(w,x,y,width,height)
Widget w;
Position *x;
Position *y;
Dimension *width;
Dimension *height;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;
	
	switch (cw->pulldownShell.box_type)
	{
		case XtCshadow_box:
		case XtCno_box:
			*x = 0;
			*width = cw->core.width;
			*y = 0;
			*height = cw->core.height;
			break;

		case XtCsimple_box:
		case XtCup_box:
		case XtCdown_box:
			*x = cw->pulldownShell.box_width;
			*width = cw->core.width - 2 * cw->pulldownShell.box_width;
			*y = cw->pulldownShell.box_width;
			*height = cw->core.height - 2 * cw->pulldownShell.box_width;
			break;

		case XtCframein_box:
		case XtCframeout_box:
			*x = 2 * (cw->pulldownShell.box_width / 2);
			*y = 2 * (cw->pulldownShell.box_width / 2);
			*width = cw->core.width - 4 * (cw->pulldownShell.box_width /2);
			*height = cw->core.height - 4 * (cw->pulldownShell.box_width /2);
			break;
	}
}

static void SetInternalDimension(w,width,height)
Widget w;
Dimension width;
Dimension height;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;

	switch (cw->pulldownShell.box_type)
	{
		case XtCshadow_box:
		case XtCno_box:
			cw->core.width=width;
			cw->core.height=height;
			break;
			
		case XtCsimple_box:
		case XtCup_box:
		case XtCdown_box:
			cw->core.width = width + 2 * cw->pulldownShell.box_width;
			cw->core.height = height + 2 * cw->pulldownShell.box_width;
			break;
			
		case XtCframein_box:
		case XtCframeout_box:	
			cw->core.width = width + 4 * (cw->pulldownShell.box_width /2);
			cw->core.height = height + 4 * (cw->pulldownShell.box_width /2);
			break;

	}
	XtResizeWidget(w , cw->core.width , cw->core.height , cw->core.border_width);
}

static void GrabAll(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;
	Display *dpy = XtDisplay(w);
	Window Root = DefaultRootWindow(dpy);


	XGrabPointer(dpy , Root , True , 
		ButtonReleaseMask | ButtonPressMask,
		GrabModeAsync , GrabModeAsync ,
		None , cw->pulldownShell.cursor ,
		CurrentTime);

	XGrabButton(dpy , AnyButton , AnyModifier , Root , True , 
		ButtonReleaseMask | ButtonPressMask,
		GrabModeAsync , GrabModeAsync ,
		cw->core.window , cw->pulldownShell.cursor);
		
	XChangeActivePointerGrab(dpy , ButtonReleaseMask | ButtonPressMask,
		cw->pulldownShell.cursor , XtLastTimestampProcessed(XtDisplay(w)));

	cw->pulldownShell.down_after_br = False;

	cw->pulldownShell.timer = XtAppAddTimeOut(XtWidgetToApplicationContext(w) , 
		PDTIME , timerCB , w);

}

static void UnGrabAll(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XUngrabPointer(XtDisplay(w),CurrentTime);
	XUngrabButton(XtDisplay(w),AnyButton , AnyModifier , 
			DefaultRootWindow(XtDisplay(w)));

}

static void timerCB(client_data,timer)
XtPointer  client_data;
XtIntervalId * timer;
{
	PulldownShellWidget w = (PulldownShellWidget) client_data;

	w->pulldownShell.down_after_br = True;
}

static void BRelease (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;
	int x,y;

	X_GetWindowRootPosition(XtDisplay(w) , XtWindow(w) , &x , &y);

	if (BETWEEN(event->xbutton.x_root , x , x + cw->core.width) &&
	    BETWEEN(event->xbutton.y_root , y , y + cw->core.height))  return;

	if (cw->pulldownShell.down_after_br)
	{
		XtPopdown(w);
	}
	cw->pulldownShell.down_after_br = True;

}

static void SetFocus(w , client_data , event , ctd)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean * ctd;
{
	PulldownShellWidget cw = (PulldownShellWidget) w;

	if (cw->composite.num_children > 0)
	{
		XSetInputFocus(XtDisplay(w), XtWindow(cw->composite.children[0]), 
			RevertToParent, CurrentTime);
	}
}
