/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>
#include <errno.h>

#include "config.h"
#include "tools.h"
#include "ftp.h"
#include "http.h"
#include "gopher.h"
#include "times.h"
#include "html.h"
#include "lfname.h"
#include "re.h"

#ifdef _GTK_FEATURES_1_2
#include "gaccel.h"
#endif

static double _default_maxrate = 0.0f;
static double _default_minrate = 0.0f;

static cfg_param params[] = {
#ifdef I_FACE
	{
	 "-X" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.xi_face , 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-X                 - start GUI interface\n") ,
	} ,
	{
	 "-runX" , 
	 "RunX:" , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.run_iface , 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-runX              - after start of GUI interface, immediately\n"
		     "\t                     start processing of entered URLs\n") ,
	} ,
	{
	 "-prefs" ,
	 "UsePreferences:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.use_prefs ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-prefs/-noprefs    - load preferences from ~/.pavuk_prefs file\n")
	},	{
	 "-noprefs" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.use_prefs ,
	 NULL ,
	 NULL ,
	 NULL ,
	},
#ifdef GTK_FACE
	{
	 NULL ,
	 "BtnConfigureIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_cfg ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnConfigureIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_cfg_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnLimitsIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_lim ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnLimitsIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_lim_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnGoBgIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_gobg ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnGoBgIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_gobg_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnRestartIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_rest ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnRestartIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_rest_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnContinueIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_cont ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnContinueIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_cont_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnStopIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_stop ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnStopIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_stop_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnBreakIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_brk ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnBreakIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_brk_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnExitIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_exit ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnExitIcon_s:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_exit_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnMinimizeIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_mtb ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 NULL ,
	 "BtnMaximizeIcon:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.gtk.bt_icon_mtb_s ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
#endif
#endif
	{
	 "-progress" , 
	 "ShowProgress:" , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.progres , 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-progress/-noprogress\n"
		     "\t                   - show retrieving progress while running on terminal\n") ,
	},
	{
	 "-noprogress" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.progres , 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-lmax" , 
	 "MaxLevel:" , 
	 PARAM_NUM , 
	 (void *) 0 , 
	 &cfg.condition.max_levels, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-lmax $nr          - allowed depth of tree\n") ,
	} ,
	{
	 "-dmax" , 
	 "MaxDocs:" , 
	 PARAM_NUM , 
	 (void *) 0 , 
	 &cfg.condition.max_documents, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-dmax $nr          - maximal number of downloaded documents\n") ,
	} ,
	{
	 "-sleep" , 
	 "SleepBetween:" , 
	 PARAM_NUM , 
	 (void *) 0 , 
	 &cfg.sleep, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-sleep $nr         - sleep for $nr seconds between transfers,\n"
		     "\t                     default 0 seconds\n") ,
	} ,
	{
	 "-retry" , 
	 "MaxRetry:" , 
	 PARAM_NUM , 
	 (void *) 1 , 
	 &cfg.nretry, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-retry $nr         - number of retries if anything failed\n") ,
	} ,
	{
	 "-nregets" , 
	 "MaxRegets:" , 
	 PARAM_NUM , 
	 (void *) 2 , 
	 &cfg.nreget, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-nregets $nr       - max number of regets on single file, default 2\n") ,
	} ,
	{
	 "-nredirs" , 
	 "MaxRedirections:" , 
	 PARAM_NUM , 
	 (void *) 5 , 
	 &cfg.nredir, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-nredirs $nr       - max number of followed HTTP redirections, default 5\n") ,
	} ,
	{
	 "-timeout" , 
	 "CommTimeout:" , 
	 PARAM_NUM , 
	 (void *) 0 , 
	 &cfg.ctimeout, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-timeout $nr       - timeout for network communications (min).\n"
		     "\t                     0 == no timeout,\n"
		     "\t                     default = 0\n") ,
	} ,
	{
	 "-rollback" , 
	 "RegetRollbackAmount:" , 
	 PARAM_NUM , 
	 (void *) 0 , 
	 &cfg.rollback, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-rollback $nr      - number of bytes to discard (counted from end\n"
		     "\t                     of file) if regetting, default 0\n") ,

	} ,
	{
	 "-ddays" , 
	 "DocExpiration:" , 
	 PARAM_NUM , 
	 (void *) 0 , 
	 &cfg.ddays, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-ddays $nr         - number of days since last access when document is\n"
		     "\t                     checked in sync mode\n"),
	} ,
	{
	 "-nocache" , 
	 "UseCache:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.cache, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-nocache/-cache    - disallow caching of HTTP documents (on proxy cache)\n") ,
	} ,
	{
	 "-cache" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.cache, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-noRobots" , 
	 "UseRobots:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.allow_robots, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noRobots/-Robots  - care about \"robots.txt\" file ?\n") ,
	} ,
	{
	 "-Robots" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.allow_robots, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-noFTP" , 
	 "AllowFTP:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.ftp, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noFTP/-FTP        - don't download FTP files\n") ,
	} ,
	{
	 "-FTP" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.ftp, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-noHTTP" , 
	 "AllowHTTP:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.http, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noHTTP/-HTTP      - don't download HTTP files\n") ,
	} ,
	{
	 "-HTTP" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.http, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
#ifdef USE_SSL
	{
	 "-noSSL" , 
	 "AllowSSL:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.https, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noSSL/-SSL        - don't download (HTTPS) SSL files\n"),
	} ,
	{
	 "-SSL" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.https, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-noFTPS" , 
	 "AllowFTPS:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.ftps, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noFTPS/-FTPS      - don't download FTPS files\n") ,
	} ,
	{
	 "-FTPS" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.ftps, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
#endif
	{
	 "-noGopher" , 
	 "AllowGopher:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.gopher, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noGopher/-Gopher  - download Gopher files ?\n") ,
	} ,
	{
	 "-Gopher" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.gopher, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-noCGI" , 
	 "AllowCGI:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.cgi, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noCGI/-CGI        - download parametric CGI pages ?\n") ,
	} ,
	{
	 "-CGI" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.condition.cgi, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-noEnc" , 
	 "AllowGZEncoding:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.use_enc, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noEnc/-Enc        - allow transfer of encoded files ?\n") ,
	} ,
	{
	 "-Enc" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.use_enc, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-noRelocate" , 
	 "AllowRelocation:" , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.rewrite_links, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-noRelocate/-Relocate\n"
		     "\t                   - don't rewrite links\n") ,
	} ,
	{
	 "-Relocate" , 
	 NULL , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.rewrite_links, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-FTPhtml" , 
	 "FTPhtml:" , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.ftp_html, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-FTPhtml/-noFTPhtml\n"
		     "\t                   - process HTML files downloaded over FTP\n") ,
	} ,
	{
	 "-noFTPhtml" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.ftp_html, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-FTPlist" , 
	 "FTPListCMD:" , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.ftp_list, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-FTPlist/-noFTPlist\n"
		     "\t                   - use wide FTP directory listing\n") ,
	} ,
	{
	 "-noFTPlist" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.ftp_list, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-FTPdir" , 
	 "AllowFTPRecursion:" , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.condition.ftpdir, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-FTPdir/-noFTPdir  - recurse FTP directory\n") ,
	} ,
	{ 
	 "-noFTPdir" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.condition.ftpdir, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-store_index" , 
	 "StoreDirIndexFile:" , 
	 PARAM_PBOOL , 
	 (void *) TRUE , 
	 &cfg.store_index, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-store_index/-nostore_index\n"
		     "\t                   - store directory URLs as index files\n") ,
	} ,
	{ 
	 "-nostore_index" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) TRUE , 
	 &cfg.store_index, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-force_reget" , 
	 "ForceReget:" , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.freget, 
	 NULL , 
	 NULL ,
	 gettext_nop("\t-force_reget/-noforce_reget\n"
		     "\t                   - force reget of whole file when server doesn't\n"
		     "\t                     support reget\n") ,

	} ,
	{
	 "-noforce_reget" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.freget, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
#ifdef DEBUG
	{
	 "-debug" , 
	 "Debug:" , 
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.debug, 
 	 NULL , 
	 NULL ,
	 gettext_nop("\t-debug             - turn on debug mode\n") ,
	} ,
	{
	 "-nodebug" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.debug, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-debug_level" , 
	 "DebugLevel:" , 
	 PARAM_DEBUGL , 
	 (void *) 0 , 
	 &cfg.debug_level, 
 	 NULL , 
	 NULL ,
	 gettext_nop("\t-debug_level $l    - debug level number, see manual for $l description\n") ,
	} ,
#endif
	{
	 "-asite" , 
	 "AllowedSites:" , 
	 PARAM_STRLIST , 
	 (void *) NULL , 
	 &cfg.condition.sites, 
	 (void *) TRUE , 
	 &cfg.condition.allow_site ,
	 gettext_nop("\t-asite $list       - comma-separated list of allowed sites\n") ,
	} ,
	{
	 "-dsite" , 
	 "DisallowedSites:" , 
	 PARAM_STRLIST , 
	 (void *) NULL , 
	 &cfg.condition.sites,
	 (void *) FALSE , 
	 &cfg.condition.allow_site ,
	 gettext_nop("\t-dsite $list       - comma-separated list of disallowed sites\n") ,
	} ,
	{
	 "-adomain" ,
	 "AllowedDomains:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.domains,
	 (void *) TRUE ,
	 &cfg.condition.allow_domain ,
	 gettext_nop("\t-adomain $list     - list of allowed domains\n") ,
	} ,
	{
	 "-ddomain" ,
	 "DisallowedDomains:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.domains,
	 (void *) FALSE ,
	 &cfg.condition.allow_domain ,
	 gettext_nop("\t-ddomain $list     - list of disallowed domains\n") ,
	} ,
	{
	 "-aprefix" ,
	 "AllowedPrefixes:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.dir_prefix,
	 (void *) TRUE ,
	 &cfg.condition.allow_prefix ,
	 gettext_nop("\t-aprefix $list     - list of allowed directory/file prefixes\n") ,
	} ,
	{
	 "-dprefix" , 
	 "DisallowedPrefixes:" , 
	 PARAM_STRLIST , 
	 (void *) NULL , 
	 &cfg.condition.dir_prefix, 
	 (void *) FALSE , 
	 &cfg.condition.allow_prefix ,
	 gettext_nop("\t-dprefix $list     - list of disallowed directory/file prefixes\n") ,
	} ,
	{
	 "-asfx" , 
	 "AllowedSuffixes:" , 
	 PARAM_STRLIST , 
	 (void *) NULL , 
	 &cfg.condition.sufix,  
	 (void *) TRUE , 
	 &cfg.condition.allow_sufix ,
	 gettext_nop("\t-asfx $list        - list of allowed suffixes\n") ,
	} ,
	{
	 "-dsfx" , 
	 "DisallowedSuffixes:" , 
	 PARAM_STRLIST ,
 	 (void *) NULL ,
	 &cfg.condition.sufix,
	 (void *) FALSE , 
	 &cfg.condition.allow_sufix ,
	 gettext_nop("\t-dsfx $list        - list of disallowed suffixes\n") ,
	} ,
	{
	 "-amimet" ,
	 "AllowedMIMETypes:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.mime ,
	 (void *) TRUE ,
	 &cfg.condition.allow_mime ,
	 gettext_nop("\t-amimet $list      - list of alloved MIME types\n") ,
	},
	{
	 "-dmimet" ,
	 "DisallowedMIMETypes:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.mime ,
	 (void *) FALSE ,
	 &cfg.condition.allow_mime ,
	 gettext_nop("\t-dmimet $list      - list of disallowed MIME types\n") ,
	},
	{
	 "-alang" , 
	 "PreferredLanguages:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.accept_lang,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-alang $list       - list of preferred languages (only via HTTP)\n") ,
	} ,
	{
	 "-acharset" , 
	 "PreferredCharset:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.accept_chars,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-acharset $list    - list of preferred character sets (only via HTTP)\n") ,
	} ,
	{
	 "-scnDir" ,
	 "ScenarioDirectory:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.scndir ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-scndir $dir       - directory ,where are stored your scenarios\n"
		     "\t                     (config files)\n")
	} ,
	{
	 "-cdir" ,
	 "WorkingDir:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.cache_dir,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-cdir $dir         - directory for storing documents\n") ,
	} ,
	{
	 "-subdir" ,
	 "WorkingSubDir:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.subdir,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-subdir $dir       - subdirectory of cdir to operate on\n") ,
	} ,
	{
	 "-scenario" ,
	 NULL ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.scenario ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-scenario $str     - name of scenario from scenario directory to load\n"
                     "\t                     and or run\n"),
	} ,
	{
	 "-auth_scheme" ,
	 "HTTPAuthorizationScheme:" ,
	 PARAM_AUTHSCH ,
	 (void *) 2 ,
	 &cfg.auth_scheme ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-auth_scheme 1/2/3 - HTTP authorization scheme 1-user 2-Basic 3-Digest,\n"
		     "\t                     default 2\n") ,
	} ,
	{
	 "-auth_name" ,
	 "HTTPAuthorizationName:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.name_auth ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-auth_name $str    - name for Authorization (only via HTTP)\n") ,
	} ,
	{
	 "-auth_passwd" ,
	 "HTTPAuthorizationPassword:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.passwd_auth ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-auth_passwd $str  - password for Authorization (only via HTTP)\n") ,
	} ,
	{
	 "-auth_reuse_nonce" ,
	 "AuthReuseDigestNonce:" ,
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.auth_reuse_nonce, 
 	 NULL , 
	 NULL ,
	 gettext_nop("\t-auth_reuse_nonce/-noauth_reuse_nonce\n"
		     "\t                   - reuse one HTTP digest access authorization\n"
		     "\t                     nonce for more requests\n") ,
	} ,
	{
	 "-noauth_reuse_nonce" , 
	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.auth_reuse_nonce, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
	{
	 "-auth_reuse_proxy_nonce" ,
	 "AuthReuseProxyDigestNonce:" ,
	 PARAM_PBOOL , 
	 (void *) FALSE , 
	 &cfg.auth_reuse_proxy_nonce, 
 	 NULL , 
	 NULL ,
	 gettext_nop("\t-auth_reuse_proxy_nonce/-noauth_reuse_proxy_nonce\n"
		     "\t                   - reuse one HTTP proxy digest access\n"
		     "\t                     authorization nonce for more requests\n") ,
	} ,
	{
	 "-noauth_reuse_proxy_nonce" , 
 	 NULL , 
	 PARAM_NBOOL , 
	 (void *) FALSE , 
	 &cfg.auth_reuse_proxy_nonce, 
	 NULL , 
	 NULL ,
	 NULL ,
	} ,
#ifdef USE_SSL
	{
	 "-ssl_cert_passwd" ,
	 "SSLCertPassword:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.ssl_cert_passwd ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ssl_cert_passwd $str\n"
		     "\t                   - password for SSL certifiaction file\n") ,
	},
	{
	 "-ssl_cert_file" ,
	 "SSLCertFile:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.ssl_cert_file ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ssl_cert_file $str\n"
		     "\t                   - SSL certifiaction file\n") ,
	},
	{
	 "-ssl_key_file" ,
	 "SSLKeyFile:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.ssl_key_file ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ssl_key_file $str - SSL certifiaction key file\n") ,
	},
	{
	 "-ssl_cipher_list" ,
	 "SSLCipherList:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.ssl_cipher_list ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ssl_cipher_list $str\n"
		     "\t                   - list of prefered SSL ciphers in SSL communication\n") ,
	},
#endif
	{
	 "-from" ,
	 "EmailAddress:" ,
	 PARAM_STR ,
	 (void*) NULL ,
	 &cfg.from ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-from $str         - e-mail address used for user identification\n") ,
	} ,
	{
	 "-send_from" ,
	 "SendFromHeader:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.send_from ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-send_from/-nosend_from\n"
		     "\t                   - send From: header in HTTP request with your\n"
		     "\t                     e-mail address\n") ,
	} ,
	{
	 "-nosend_from" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.send_from ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-identity" ,
	 "Identity:" ,
	 PARAM_STR ,
	 (void*) NULL ,
	 &cfg.identity ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-identity $str     - contents of User-agent: field in HTTP request\n") ,
	} ,
	{
	 "-pattern" , 
	 "MatchPattern:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.pattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-pattern $list     - list of wildcard patterns for files\n") ,
	} ,
#ifdef HAVE_REGEX
	{
	 "-rpattern" , 
	 "REMatchPattern:" ,
	 PARAM_RE ,
	 (void *) NULL ,
	 &cfg.condition.rpattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-rpattern $re      - RE matching pattern for files\n") ,
	} ,
#endif
	{
	 "-skip_pattern" , 
	 "SkipMatchPattern:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.skip_pattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-skip_pattern $list\n"
	   	     "\t                   - list of skip wildcard patterns for files\n") ,
	} ,
#ifdef HAVE_REGEX
	{
	 "-skip_rpattern" , 
	 "SkipREMatchPattern:" ,
	 PARAM_RE ,
	 (void *) NULL ,
	 &cfg.condition.rskip_pattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-skip_rpattern $re\n"
	   	     "\t                   - skip RE matching pattern for files\n") ,
	} ,
#endif
	{
	 "-url_pattern" , 
	 "URLMatchPattern:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.url_pattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-url_pattern $list - list of wildcard patterns for urls\n") ,
	} ,
#ifdef HAVE_REGEX
	{
	 "-url_rpattern" , 
	 "URLREMatchPattern:" ,
	 PARAM_RE ,
	 (void *) NULL ,
	 &cfg.condition.rurl_pattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-url_rpattern $re  - RE matching pattern for urls\n") ,
	} ,
#endif
	{
	 "-skip_url_pattern" , 
	 "SkipURLMatchPattern:" ,
	 PARAM_STRLIST ,
	 (void *) NULL ,
	 &cfg.condition.skip_url_pattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-skip_url_pattern $list\n"
		     "\t                   - list of wildcard patterns for urls\n") ,
	} ,
#ifdef HAVE_REGEX
	{
	 "-skip_url_rpattern" , 
	 "SkipURLREMatchPattern:" ,
	 PARAM_RE ,
	 (void *) NULL ,
	 &cfg.condition.rskip_url_pattern ,
	 NULL ,
	 NULL , 
	 gettext_nop("\t-skip_url_rpattern $re\n"
		     "\t                   - RE matching patterns for urls\n") ,
	} ,
#endif
	{
	 "-mode" , 
	 "DefaultMode:" ,
	 PARAM_MODE ,
	 (void *) MODE_NORMAL ,
	 &cfg.mode ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-mode $mode        - set operation mode\n"
		     "\t                         normal - recurse throught WWW (default)\n"
		     "\t                         linkupdate - update remote links in local tree\n"
		     "\t                         sync - synchronize local tree with remote WWW\n"
		     "\t                                servers\n"
		     "\t                         singlepage - single page with inline objects\n"
		     "\t                         singlereget - reget file until not whole\n"
		     "\t                         resumeregets - reget all files which are broken\n"
		     "\t                         dontstore - transfer documents, but don't store\n"
		     "\t                         reminder - checks URLs if they are changed\n"
		     "\t                         ftpdir - list content of FTP directory\n") ,
	} ,
	{
	 "-ftp_proxy" ,
	 "FTPProxy:" ,
	 PARAM_CONN ,
	 (void *) NULL ,
	 &cfg.ftp_proxy ,
	 (void *) DEFAULT_FTP_PROXY_PORT ,
	 &cfg.ftp_proxy_port ,
	 gettext_nop("\t-ftp_proxy $site[:$port]\n"
		     "\t                   - ftp proxy/cache server\n") ,
	} ,
	{
	 "-http_proxy" ,
	 "HTTPProxy:" ,
	 PARAM_CONN ,
	 (void *) NULL ,
	 &cfg.http_proxy ,
	 (void *) DEFAULT_HTTP_PROXY_PORT ,
	 &cfg.http_proxy_port ,
	 gettext_nop("\t-http_proxy $site[:$port]\n"
		     "\t                   - http proxy/cache server\n") ,
	} ,
	{
	 "-gopher_proxy" ,
	 "GopherProxy:" ,
	 PARAM_CONN ,
	 (void *) NULL ,
	 &cfg.gopher_proxy ,
	 (void *) DEFAULT_GOPHER_PROXY_PORT ,
	 &cfg.gopher_proxy_port ,
	 gettext_nop("\t-gopher_proxy $site[:$port]\n"
		     "\t                   - gopher proxy/cache server\n") ,
	} ,
#ifdef USE_SSL
	{
	 "-ssl_proxy" ,
	 "SSLProxy:" ,
	 PARAM_CONN ,
	 (void *) NULL ,
	 &cfg.ssl_proxy ,
	 (void *) DEFAULT_SSL_PROXY_PORT ,
	 &cfg.ssl_proxy_port ,
	 gettext_nop("\t-ssl_proxy $site[:$port]\n"
		     "\t                   - ssl proxy server\n") ,
	} ,
#endif
	{
	 "-gopher_httpgw" ,
	 "GopherViaHTTPProxy:" ,
	 PARAM_PBOOL ,	
	 (void *) FALSE ,
	 &cfg.gopher_via_http ,
	 NULL ,	
	 NULL ,
	 gettext_nop("\t-gopher_httpgw/-nogopher_httpgw\n"
		     "\t                   - specified gopher proxy is HTTP gateway for Gopher\n") ,

	} ,
	{
	 "-nogopher_httpgw" ,
	 NULL ,
	 PARAM_NBOOL ,	
	 (void *) FALSE ,
	 &cfg.gopher_via_http ,
	 NULL ,	
	 NULL ,
	 NULL ,
	} , 
	{
	 "-ftp_httpgw" ,
	 "FTPViaHTTPProxy:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.ftp_via_http ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ftp_httpgw/-noftp_httpgw\n"
		     "\t                   - specified ftp proxy is HTTP gateway for FTP\n") ,

	} ,
	{
	 "-noftp_httpgw" ,
	 NULL ,
	 PARAM_NBOOL ,	
	 (void *) FALSE ,
	 &cfg.ftp_via_http ,	
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-ftp_dirtyproxy" ,
	 "FTPDirtyProxy:" ,	
	 PARAM_PBOOL ,	
	 (void *) FALSE ,
	 &cfg.ftp_dirtyp ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ftp_dirtyproxy/-noftp_dirtyproxy\n"
		     "\t                   - use CONNECT request to HTTP proxy for FTP\n"
		     "\t                     connections\n") ,
	} ,
	{
	 "-noftp_dirtyproxy" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.ftp_dirtyp ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
#ifdef I_FACE
#ifdef WITH_TREE
	{
	 "-browser" ,
	 "Browser:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.browser ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-browser $str      - your preferred browser programm\n") ,
	} ,
#endif
	{
	 "-xmaxlog" ,
	 "XMaxLogSize:" ,
	 PARAM_NUM ,
	 (void *) NULL ,
	 &cfg.xlogsize ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-xmaxlog           - maximal length of log window\n") ,
	} ,
#endif
	{
	 "-dumpscn" ,
	 NULL ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.save_scn ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-dumpscn $str      - save scenario in scndir with name $str\n") ,
	} ,
	{
	 "-maxsize" ,
	 "MaxSize:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.condition.max_size ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-maxsize $nr       - maximal allowed size of document in bytes\n") ,
	} ,
	{
	 "-minsize" ,
	 "MinSize:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.condition.min_size ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-minsize $nr       - minimal allowed size of document in bytes\n") ,
	} ,
	{
	 "-http_proxy_pass" ,
	 "HTTPProxyPass:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.http_proxy_pass ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-http_proxy_pass $str\n"
		     "\t                   - password for HTTP proxy authorization\n") ,
	} ,
	{
	 "-http_proxy_user" ,
	 "HTTPProxyUser:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.http_proxy_user ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-http_proxy_user $str\n"
		     "\t                   - user name for HTTP proxy authorization\n") ,
	} ,
	{
	 "-http_proxy_auth" ,
	 "HTTPProxyAuth:" ,
	 PARAM_AUTHSCH ,
	 (void *) 2 ,
	 &cfg.proxy_auth_scheme ,
	 NULL ,	
	 NULL ,
	 gettext_nop("\t-http_proxy_auth 1/2/3\n"
		     "\t                   - authorization scheme for HTTP proxy authorization\n") ,
	} ,
	{
	 "-logfile" ,
	 "LogFile:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.logfile ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-logfile $file     - name of file where mesages are stored\n") ,
	} ,
	{
	 "-slogfile" ,
	 "SLogFile:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.short_logfile ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-slogfile $file    - name of file where short log will be stored\n") ,
	} ,
	{
	 "-stime" ,
	 "ShowDownloadTime:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.show_time ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-stime/-nostime    - write starting and ending time of transfer\n") ,
	} ,
	{
	 "-nostime" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.show_time ,
	 NULL ,
	 NULL ,
	 NULL ,
	},
	{
	 "-remove_old" ,
	 "RemoveOldDocuments:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.remove_old ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-remove_old/-noremove_old\n"
		     "\t                   - remove improper files or directories while running\n"
		     "\t                     in sync mode\n") ,

	},
	{
	 "-noremove_old" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.remove_old ,
	 NULL ,
	 NULL ,
	 NULL ,
	},
	{
	 "-auth_file" ,
	 "AuthFile:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.auth_file ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-auth_file $file   - file where you have stored your auth infos\n"
		     "\t                     see manual for format description\n"),
	},
	{
	 "-base_level" ,
	 "BaseLevel:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.base_level ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-base_level $nr    - number of levels of directory tree to omit from top\n") ,
	},
	{
	 "-ftp_active" ,
	 "ActiveFTPData:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.ftp_activec ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ftp_active        - select active FTP data connection\n") ,
	} ,
	{
	 "-ftp_passive" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.ftp_activec ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ftp_passive       - select passive FTP data connection\n") ,
	} ,
#ifdef GETTEXT_NLS
	{
	 "-msgcat" ,
	 "NLSMessageCatalogDir:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.msgcatd ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-msgcat $dir       - directory where message catalogs are stored\n") ,
	} ,
	{
	 "-language" ,
	 "Language:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.language ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-language $str     - set language for messages\n")
	} ,
#endif
	{
	 "-quiet" ,
	 "Quiet:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.quiet ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-quiet             - don't show output messages\n")
	} ,
	{
	 "-verbose" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.quiet ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-verbose           - show output messages (default)\n")
	} ,
	{
	 "-newer_than" ,
	 "NewerThan:" ,
	 PARAM_TIME ,
	 (void *) 0 ,
	 &cfg.condition.btime ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-newer_than $time  - download only documents newer than $time\n"
		     "\t                     format of $time: YYYY.MM.DD.hh:mm\n")
	} ,
	{
	 "-older_than" ,
	 "OlderThan:" ,
	 PARAM_TIME ,
	 (void *) 0 ,
	 &cfg.condition.etime ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-older_than $time  - download only documents older than $time\n"
		     "\t                     format of $time: YYYY.MM.DD.hh:mm\n")
	} ,
	{
	 "-schedule" ,
	 NULL ,
	 PARAM_TIME ,
	 (void *) 0 ,
	 &cfg.schtime ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-schedule $time    - schedule pavuk start at $time\n"
		     "\t                     format of $time: YYYY.MM.DD.hh:mm\n")
	} ,
	{
	 "-reschedule" ,
	 "Reschedule:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.reschedh ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-reschedule $nr    - number of hours between two runs\n"
		     "\t                     for cyclic scheduling\n")
	} ,
	{
	 "-dont_leave_site" ,
	 "DontLeaveSite:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.condition.dont_leave_site ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-dont_leave_site/-leave_site\n"
		     "\t                   - don't/leave site of starting URL\n")
 	} ,
	{
	 "-leave_site" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.condition.dont_leave_site ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-dont_leave_dir" ,
	 "DontLeaveDir:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.condition.dont_leave_dir ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-dont_leave_dir/-leave_dir\n"
		     "\t                   - don't/leave directory of starting URL\n")
	} ,
	{
	 "-leave_dir" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.condition.dont_leave_dir ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-preserve_time" ,
	 "PreserveTime:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.preserve_time ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-preserve_time/-nopreserve_time\n"
		     "\t                   - preserve document modification time\n")
	} ,
	{
	 "-nopreserve_time" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.preserve_time ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-preserve_perm" ,
	 "PreservePermisions:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.preserve_perm ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-preserve_perm/-nopreserve_perm\n"
		     "\t                   - preserve document permissions\n")
	} ,
	{
	 "-nopreserve_perm" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.preserve_perm ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-preserve_slinks" ,
	 "PreserveAbsoluteSymlinks:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.preserve_links ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-preserve_slinks/-nopreserve_slinks\n"
		     "\t                   - preserve absolute symlinks\n")
	} ,
	{
	 "-nopreserve_slinks" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.preserve_links ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-leave_level" ,
	 "LeaveLevel:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.condition.leave_level ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-leave_level $nr   - how many tree levels leave from starting\n"
		     "\t                     site , (0 == don't care) default 0\n")
	} ,
	{
	 "-cookie_file" ,
	 "CookieFile:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.cookie_file ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-cookie_file $file - file where are stored cookie infos\n")
	} ,
	{
	 "-cookie_send" ,
	 "CookieSend:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.send_cookies ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-cookie_send/-nocookie_send\n"
		     "\t                   - send cookie info in HTTP request\n")
	} ,
	{
	 "-nocookie_send" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.send_cookies ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-cookie_recv" ,
	 "CookieRecv:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.recv_cookies ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-cookie_recv/-nocookie_recv\n"
		     "\t                   - accept cookies from HTTP response\n")
	} ,
	{
	 "-nocookie_recv" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.recv_cookies ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-cookie_update" ,
	 "CookieUpdate:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.update_cookies ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-cookie_update/-nocookie_update\n"
		     "\t                   - update cookies in cookies file\n")
	} ,
	{
	 "-nocookie_update" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.update_cookies ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-cookie_check" ,
	 "CookieCheckDomain:" ,
	 PARAM_PBOOL ,
	 (void *) TRUE ,
	 &cfg.cookie_check_domain ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-cookie_check/-nocookie_check\n"
		     "\t                   - check if cookies are set for source domain\n")
	} ,
	{
	 "-nocookie_check" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) TRUE,
	 &cfg.cookie_check_domain ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-cookies_max" ,
	 "CookiesMax:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.cookies_max ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-cookies_max $nr   - maximal number of cookies in cookie cache\n")
	} ,
	{
	 "-disabled_cookie_domains" , 
	 "DisabledCookieDomains:" , 
	 PARAM_STRLIST , 
	 (void *) NULL , 
	 &cfg.cookies_disabled_domains, 
	 (void *) NULL , 
	 NULL ,
	 gettext_nop("\t-disabled_cookie_domains $list\n"
		     "\t                   - comma-separated list of disabled cookie domains\n") ,
	} ,
	{
	 "-disable_html_tag" ,
	 "DisableHTMLTag:" ,
	 PARAM_HTMLTAG ,
	 (void *) TRUE ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-disable_html_tag $TAG,[$ATTRIB][;...]\n"
		     "\t                   - disable processing of URLs from\n"
		     "\t                     attribute $ATTRIB of HTML tag $TAG\n")
	} ,
	{
	 "-enable_html_tag" ,
	 "EnableHTMLTag:" ,
	 PARAM_HTMLTAG ,
	 (void *) FALSE ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-enable_html_tag $TAG,[$ATTRIB][;...]\n"
		     "\t                   - enable proccessing of URLs from\n"
		     "\t                     attribute $ATTRIB of HTML tag $TAG\n")
	} , 
#ifdef I_FACE
	{
	 "-gui_font" ,
	 "GUIFont:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.fontname ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-gui_font $font    - font name used in GUI interface\n")
	} ,
#endif
	{
	 "-user_condition" ,
	 "UserCondition:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.condition.uexit,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-user_condition $str\n"
		     "\t                   - user exit script used to restrict some URLs\n"
		     "\t                     for more informations see manpage\n") ,
	} ,
	{
	 "-tr_del_chr" ,
	 "TrDeleteChar:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.tr_del_chr ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-tr_del_chr $str   - characters that will be deleted from\n"
		     "\t                     local filename\n") ,
	} ,
	{
	 "-tr_str_str" ,
	 "TrStrToStr:" ,
	 PARAM_TWO_QSTR ,
	 (void *) NULL ,
	 &cfg.tr_str_s1 ,
	 (void *) NULL ,
	 &cfg.tr_str_s2 ,
	 gettext_nop("\t-tr_str_str $str1 $str2\n"
		     "\t                   - translate $str1 to $str2 in local filename\n") ,
	} ,
	{
	 "-tr_chr_chr" ,
	 "TrChrToChr:" ,
	 PARAM_TWO_QSTR ,
	 (void *) NULL ,
	 &cfg.tr_chr_s1 ,
	 (void *) NULL ,
	 &cfg.tr_chr_s2 ,
	 gettext_nop("\t-tr_chr_chr $chrset1 $chrset2\n"
		     "\t                   - translate $chrset1 to $chrset2 in local filename\n") ,
	} ,
	{
	 "-index_name" ,
	 "IndexName:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.index_name ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-index_name $str   - name of directory index instead of _._.html\n") ,
	} ,
	{
	 "-store_name" ,
	 "StoreName:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.store_name ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-store_name $str   - filename for document downloaded with\n"
		     "\t                     -mode singlepage\n") ,
	} ,
	{
	 "-htDig" ,
	 NULL ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.htdig ,
	 NULL ,
	 NULL ,
         NULL ,
	} ,
	{
	 "-check_size",
	 "CheckSize:" ,
	 PARAM_PBOOL ,
	 (void *) TRUE ,
	 &cfg.check_size ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-check_size/-nocheck_size\n"
		     "\t                   - compare received size of file with\n"
		     "\t                     that provided by remote server\n")
	} ,
	{
	 "-nocheck_size",
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) TRUE ,
	 &cfg.check_size ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-urls_file",
	 "URLsFile:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.urls_file ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-urls_file $file   - URLs should be read from file, until\n"
		     "\t                     line with single \".\" occurs in input\n") 
	} ,
	{
	 "-bg" ,
	 "BgMode:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.bgmode ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-bg/-nobg          - detach pavuk proces from terminal and\n"
		     "\t                     don't output any messages on screen\n")
	} ,
	{
	 "-nobg" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.bgmode ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-maxrate" ,
	 "MaxRate:" ,
	 PARAM_DOUBLE ,
	 (void *) &_default_maxrate ,
	 &cfg.maxrate ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-maxrate $nr       - limit to maximal speed of transfer (kB/s)\n") ,
	} ,
	{
	 "-minrate" ,
	 "MinRate:" ,
	 PARAM_DOUBLE ,
	 (void *) &_default_minrate ,
	 &cfg.minrate ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-minrate $nr       - limit to minimal speed of transfer (kB/s)\n") ,
	} ,
	{
	 "-bufsize" ,
	 "ReadBufferSize:" ,
	 PARAM_NUM ,
	 (void *) 32 ,
	 &cfg.bufsize ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-bufsize $nr       - size of read buffer (kB)\n") ,
	} ,
	{
	 "-file_quota" ,
	 "FileSizeQuota:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.file_quota ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-file_quota $nr    - maximal size of file to transfer (kB)\n") ,
	} ,
	{
	 "-trans_quota" ,
	 "TransferQuota:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.trans_quota ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-trans_quota $nr   - maximal amount of transfer per session (kB)\n") ,
	} ,
	{
	 "-fs_quota" ,
	 "FSQuota:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.fs_quota ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-fs_quota $nr      - disk free space quota (kB)\n") ,
	} ,
	{
	 "-enable_js" ,
	 "EnableJS:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.enable_js ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-enable_js/-disable_js\n"
		     "\t                   - enable downloading of javascript source files\n") ,
	} ,
	{
	 "-disable_js" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.enable_js ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-fnrules" ,
	 "FnameRules:" ,
	 PARAM_LFNAME ,
	 (void *) NULL ,
	 &cfg.lfnames ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-fnrules $t $m $r  - local filename construction rules\n"
		     "\t                     (for better description see manual)\n") 
	} ,
	{
	 "-store_info" ,
	 "StoreDocInfoFiles:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.enable_info ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-store_info/-nostore_info\n"
		     "\t                   - store document info files with each document\n")
	} ,
	{
	 "-nostore_info" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.enable_info ,
	 NULL ,
	 NULL ,
	 NULL ,
	} ,
	{
	 "-all_to_local" ,
	 "AllLinksToLocal:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.all_to_local ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-all_to_local/-noall_to_local\n"
		     "\t                   - change all links inside HTML document to\n"
		     "\t                     local immediately after download\n")
	} ,
	{
	 "-noall_to_local" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.all_to_local ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-sel_to_local" ,
	 "SelectedLinksToLocal:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.sel_to_local ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-sel_to_local/-nosel_to_local\n"
		     "\t                   - change all links inside HTML document\n"
		     "\t                     which acomplish the limits, to\n"
		     "\t                     local immediately after download\n")
	} ,
	{
	 "-nosel_to_local" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.sel_to_local ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-all_to_remote" ,
	 "AllLinksToRemote:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.all_to_remote ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-all_to_remote/-noall_to_remote\n"
		     "\t                   - change all links inside HTML document to\n"
		     "\t                     remote immediately after download and\n"
		     "\t                     don't do any further changes to it\n")
	} ,
	{
	 "-noall_to_remote" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.all_to_remote ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-remind_cmd" ,
	 "ReminderCMD:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.remind_cmd ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-remind_cmd $str   - command which sends result from reminder mode\n")
	} ,
	{
	 "-auto_referer" ,
	 "AutoReferer:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.auto_referer ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-auto_referer/-noauto_referer\n"
		     "\t                   - in HTTP request send for each starting URL\n"
		     "\t                     Referer: field which contains its own URL\n")
	} ,
	{
	 "-noauto_referer" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.auto_referer ,
	 NULL ,
	 NULL ,
	 NULL
	} ,
	{
	 "-url_strategy" ,
	 "UrlSchedulingStrategy:" ,
	 PARAM_USTRAT ,
	 (void *) SSTRAT_DO_SIRKY ,
	 &cfg.scheduling_strategie ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-url_strategy $strategy\n"
		     "\t                   - scheduling strategy for URLs\n"
		     "\t                     (this means order how URLs will be downloaded)\n"
		     "\t                     $strategy is one of :\n"
		     "\t                        level  - level order in URL tree\n"
		     "\t                        leveli - level order in URL tree,\n"
		     "\t                                 but inline objects go first\n"
		     "\t                        pre    - pre-order in URL tree\n"
		     "\t                        prei   - pre-order in URL tree,\n"
		     "\t                                 but inline objects go first\n")
	} ,
#ifdef HAVE_DBOPEN
	{
	 "-nscache_dir" ,
	 "NetscapeCacheDir:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.ns_cache_dir , 
	 NULL ,
	 NULL ,
	 gettext_nop("\t-nscache_dir $dir  - path to Netcape browser cache directory\n")
	} ,
#endif
#ifdef HAVE_REGEX
	{
	 "-remove_adv" ,
	 "RemoveAdvertisement:" ,
	 PARAM_PBOOL ,
	 (void *) TRUE ,
	 &cfg.remove_adv ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-remove_adv/-noremove_adv\n"
		     "\t                   - enable removing of advertisement banners\n"
		     "\t                     assumes you have setup regular expresions\n"
		     "\t                     for matching adv banners with -adv_re option\n")
	},
	{
	 "-noremove_adv" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) TRUE ,
	 &cfg.remove_adv ,
	 NULL ,
	 NULL ,
	 NULL
	},
	{
	 "-adv_re" ,
	 "AdvBannerRE:" ,
	 PARAM_RE ,
	 (void *) NULL ,
	 &cfg.advert_res ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-adv_re $RE        - regular expressions for matching advertisement\n"
		     "\t                     banner URLs\n")
	},
#endif
#ifdef HAVE_TERMIOS
	{
	 "-check_bg" ,
	 "CheckIfRunnigAtBackground:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.tccheck ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-check_bg/-nocheck_bg\n"
		     "\t                   - if running at background, don't write any\n"
		     "\t                     messages to screen\n")
	},
	{
	 "-nocheck_bg" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.tccheck ,
	 NULL ,
	 NULL ,
	 NULL
	},
#endif
	{
	 "-send_if_range" ,
	 "SendIfRange:" ,
	 PARAM_PBOOL ,
	 (void *) TRUE ,
	 &cfg.send_if_range ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-send_if_range/-nosend_if_range\n"
		     "\t                   - send If-Range header in HTTP request\n"
		     "\t                     turn this of when server support reget, but\n"
		     "\t                     generates different Etags for two requests\n")
	},
	{
	 "-nosend_if_range" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) TRUE ,
	 &cfg.send_if_range ,
	 NULL ,
	 NULL ,
	 NULL
	},
	{
	 "-sched_cmd" ,
	 "SchedulingCommand:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.sched_cmd ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-sched_cmd $str    - command for scheduling\n")
	},
	{
	 "-unique_log" ,
	 "UniqueLogName:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.gen_logname ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-unique_log/-nounique_log\n"
		     "\t                   - when original log file locked try to find other\n"
		     "\t                     with numbering extension which is not locked\n")
	},
	{
	 "-nounique_log" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.gen_logname ,
	 NULL ,
	 NULL ,
	 NULL
	},
	{
	 "-post_cmd" ,
	 "PostCommand:" ,
	 PARAM_STR ,
	 (void *) NULL ,
	 &cfg.post_cmd ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-post_cmd $str     - postprocessing command, which will be invoked\n"
		     "\t                     after document will be successfully downloaded\n")
	},
#ifdef USE_SSL
	{
	 "-ssl_version" ,
	 "SSLVersion:" ,
	 PARAM_SSLVER ,
	 (void *) 1 ,
	 &cfg.ssl_version ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ssl_version $v    - version of SSL protocol used for communication,\n"
		     "\t                     valid values: ssl23,ssl2,ssl3\n")
	},
	{
	 "-unique_sslid" ,
	 "UniqueSSLID:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.unique_sslid ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-unique_sslid/-nounique_sslid\n"
		     "\t                   - use unique SSL ID with each SSL session\n")
	},
	{
	 "-nounique_sslid" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.unique_sslid ,
	 NULL ,
	 NULL ,
	 NULL ,
	},
#endif
	{
	 "-httpad" ,
	 "AddHTTPHeader:" ,
	 PARAM_HTTPHDR ,
	 (void *) NULL ,
	 &cfg.http_headers ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-httpad $hdr       - additional HTTP header\n")
	},
	{
	 "-statfile" ,
	 "StatisticsFile:" ,
	 PARAM_PATH ,
	 (void *) NULL ,
	 &cfg.stats_file ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-statfile $str     - statistical report from downloading progress\n") 
	},
#ifdef _WIN32
	{
	 "-ewait" ,
	 "WaitOnExit:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.wait_on_exit ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-ewait             - wait to finish program after downloading progress\n"
		     "\t                     is done\n")
	},
	{
	 "-noewait" ,
	 NULL ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.wait_on_exit ,
	 NULL ,
	 NULL ,
	 NULL ,
	},
#endif
#ifdef HAVE_REGEX
	{
	 "-aip_pattern" ,
	 "AllowedIPAdrressPattern:" ,
	 PARAM_RE ,
	 (void *) NULL ,
	 &cfg.condition.aip ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-aip_pattern $re   - pattern for allowed IP addresses of servers\n"),
	},
	{
	 "-dip_pattern" ,
	 "DisallowedIPAdrressPattern:" ,
	 PARAM_RE ,
	 (void *) NULL ,
	 &cfg.condition.skipip ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-dip_pattern $re   - pattern for disallowed IP addresses of servers\n"),
	},
#endif
	{
	 "-site_level" ,
	 "SiteLevel:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.condition.site_level ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-site_level $nr    - maximum allowed number of sites to leave from\n"
		     "\t                     starting site\n"),
	},
	{
	 "-use_http11" ,
	 "UseHTTP11:" ,
	 PARAM_PBOOL ,
	 (void *) FALSE ,
	 &cfg.use_http11 ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-use_http11/-nouse_http11\n"
		     "\t                   - enable or disable using of HTTP/1.1 protocol\n"
		     "\t                     features, default is off now\n"),
	},
	{
	 "-nouse_http11" ,
	 NULL ,
	 PARAM_NBOOL ,
	 (void *) FALSE ,
	 &cfg.use_http11 ,
	 NULL ,
	 NULL ,
	 NULL ,
	},
	{
	 "-max_time" ,
	 "MaxRunTime:" ,
	 PARAM_NUM ,
	 (void *) 0 ,
	 &cfg.max_time ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-max_time $nr      - set maximal amount of times for program run\n"
		     "\t                     in minutes, default 0 == no limit\n"),
	},
	{
	 "-local_ip" ,
	 "LocalIP:" ,
	 PARAM_STR ,
	 NULL ,
	 &cfg.local_ip ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-local_ip $str     - use this local ip address of network interface.\n"
		     "\t                     This option is for multihomed machines.\n"),
	},
	{
	 "-request" ,
	 "RequestInfo:" ,
	 PARAM_REQUEST ,
	 NULL ,
	 &cfg.request ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-request $req      - rich request informations, used to specify\n"
		     "\t                     information for GET or POST requests\n"
		     "\t                     format of $req :\n"
		     "\t                     \"URL:$url METHOD:[GET|POST] ENCODING:[m|u]\n"
		     "\t                       FIELD:$variable=$value\n"
		     "\t                       FILE:$variable=$filename\"\n"
		     "\t                     (for more informations see manual page)\n")
	},
	{
	 "-hash_size" ,
	 "HashSize:" ,
	 PARAM_NUM ,
	 (void *) HASH_TBL_SIZE ,
	 &cfg.hash_size ,
	 NULL ,
	 NULL ,
	 gettext_nop("\t-hash_size $nr     - size of internal hash tables for performance tuning\n")
	},
};

struct strategie_mapt {
	strategie	id;
	char 		*name;
	char		*label;
};

struct strategie_mapt strategie_map[] = {
	{SSTRAT_DO_SIRKY , "level" , gettext_nop("Level order")},
	{SSTRAT_DO_SIRKY_I , "leveli" , gettext_nop("Level order, inline first")},
	{SSTRAT_DO_HLBKY , "pre" , gettext_nop("Pre order")},
	{SSTRAT_DO_HLBKY_I , "prei" , gettext_nop("Pre order, inline first")},
};
 
static strategie get_strategie_by_str(str)
char *str;
{
	int i;

	for (i = 0 ; i < SSTRAT_LAST ; i++)
	{
		if (!strcasecmp(str , strategie_map[i].name))
			return strategie_map[i].id;
	}

	return SSTRAT_LAST;
}

static char *get_strategie_str(id)
strategie id;
{
	return strategie_map[id].name;
}

char *get_strategie_label(id)
strategie id;
{
	return gettext(strategie_map[id].label);
}

struct {
	char *name;
	int id;
} _ssl_versions[] = {
	{"ssl23" , 1} ,
	{"ssl2" , 2} ,
	{"ssl3" , 3} ,
};

static strategie get_ssl_version_by_str(str)
char *str;
{
	int i;

	for (i = 0 ; i < NUM_ELEM(_ssl_versions) ; i++)
	{
		if (!strcasecmp(str , _ssl_versions[i].name))
			return _ssl_versions[i].id;
	}

	return -1;
}

static char *get_ssl_version_str(id)
strategie id;
{
	return _ssl_versions[id-1].name;
}

/********************************/
/* vypis prepinacov programu	*/
/********************************/
void usage(prg)
char *prg;
{
	int i;

	printf(gettext("Usage:  %s  [options]  [any number of URLS]\npavuk-%s\n") , prg , VERSION);

	for(i = 0 ; i < NUM_ELEM(params) ; i++)
	{
		if (params[i].help) printf(gettext(params[i].help));
	}

	printf(gettext("\t-h                 - help\n"));
	printf(gettext("\t-v                 - print version number\n"));

	fflush(stdout);
	pavuk_do_at_exit();
	_exit(1);
}

void usage_short(prg)
char *prg;
{
	printf("pavuk-%s\n" , VERSION);
	printf(gettext("Type \"%s -h\" for long help\n") , prg);
	pavuk_do_at_exit();
	_exit(1);
}

int htmltag_set_disabled(tagstr , disable)
char *tagstr;
int disable;
{
	int i,j;
	bool tfound,afound;
	char *tag;
	char *attrib;
	char *pom = new_string(tagstr);

	tag = strtokc(pom , ',');
	attrib = strtokc(NULL , ';');

	while (tag) 
	{
	    tfound = FALSE;
	    afound = FALSE;
	    for (i = 0 ; i < NUM_ELEM(linky) ; i++)
	    {
		if (!strcasecmp(linky[i].tag , tag))
		{
			tfound = TRUE;
                	for(j = 0 ; linky[i].attribs[j].attrib ; j++)
                	{
				if (attrib && *attrib)
				{
					if (!strcasecmp(linky[i].attribs[j].attrib , attrib))
					{
						afound = TRUE;
						if (disable)
							linky[i].attribs[j].stat |= LINK_DISABLED;
						else
							linky[i].attribs[j].stat &= ~LINK_DISABLED;
						break;
					}
				}
				else
				{
					afound = TRUE;
					if (disable)
						linky[i].attribs[j].stat |= LINK_DISABLED;
					else
						linky[i].attribs[j].stat &= ~LINK_DISABLED;
				}
			}
			break;
		}
	    }
	    if (!(tfound && afound))
	    {
		xprintf(0 , gettext("HTML tag not supported : %s.%s\n") , tag , attrib ? attrib : "(null)");
	    }

	    tag = strtokc(NULL , ',');
	    attrib = strtokc(NULL , ';');
	}

	_free(pom);
	return -1;
}

void cfg_set_to_default(i)
int i;
{
	char **p;
	int x,j;

	switch (params[i].type)
	{
		case PARAM_NUM:
			*((int *) params[i].val_adr) = (int) params[i].default_val;
		break;
		case PARAM_PBOOL:
			*((bool *) params[i].val_adr) = (bool)(int) params[i].default_val;
		break;
		case PARAM_NBOOL:
			*((bool *) params[i].val_adr) = (bool)(int) params[i].default_val;
		break;
		case PARAM_PATH:
		case PARAM_STR:
			_free(*((char **) params[i].val_adr));
			*((char **) params[i].val_adr) = (char *) params[i].default_val;
		break;
		case PARAM_STRLIST:		
			for (p = *((char ***) params[i].val_adr) ; p && *p ; p++)
				_free(*p);
			_free(*(char ***) params[i].val_adr);

			*((char ***) params[i].val_adr) = (char **) params[i].default_val;
			if (params[i].mval_adr)
				*((bool *) params[i].mval_adr) = (bool)(int) params[i].mdefault_val;				
		break;
		case PARAM_CONN:
			_free(*((char **) params[i].val_adr));
			*((char **) params[i].val_adr) = (char *) params[i].default_val;
			if (params[i].mval_adr)
				*((int *) params[i].mval_adr) = (int) params[i].mdefault_val;
		break;
		case PARAM_AUTHSCH:
			*((int *) params[i].val_adr) = (int) params[i].default_val;
		break;
		case PARAM_MODE:
			*((int *) params[i].val_adr) = (int) params[i].default_val;
		break;
		case PARAM_TIME:
			*((time_t *) params[i].val_adr) = (time_t)0;
		break;
		case PARAM_HTMLTAG:
	    		for (x = 0 ; x < NUM_ELEM(linky) ; x++)
                		for(j = 0 ; linky[x].attribs[j].attrib ; j++)
					linky[x].attribs[j].stat &= ~LINK_DISABLED;
		break;
		case PARAM_TWO_QSTR:
			*((char **) params[i].val_adr) = (char *) params[i].default_val;
			*((char **) params[i].mval_adr) = (char *) params[i].mdefault_val;
		break;
		case PARAM_DOUBLE:
			*((double *) params[i].val_adr) = *(double *)params[i].default_val;
		break;
		case PARAM_LFNAME:
		{
			while(cfg.lfnames)
			{
				lfname_free((lfname *)cfg.lfnames->data);
				cfg.lfnames = dllist_remove_entry(cfg.lfnames , cfg.lfnames);
			}
		}
		break;
		case PARAM_RE:
#ifdef HAVE_REGEX
		{
			dllist *ptr = *((dllist **) params[i].val_adr);

			*((dllist **) params[i].val_adr) = NULL;

			while(ptr)
			{
				re_free((re_entry *)ptr->data);
				ptr = dllist_remove_entry(ptr,ptr);
			}
		}
#endif
		break;
		case PARAM_USTRAT:
			*((strategie *) params[i].val_adr) = (strategie) params[i].default_val;
		break;
		case PARAM_SSLVER:
			*((int *) params[i].val_adr) = (int) params[i].default_val;
		break;
		case PARAM_HTTPHDR:
		{
			dllist *ptr = *(dllist **) params[i].val_adr;
			while(ptr)
			{
				httphdr_free(ptr->data);
				ptr = dllist_remove_entry(ptr,ptr);
			}
			*(dllist **) params[i].val_adr = NULL;
		}
		break;
		case PARAM_DEBUGL:
			*((int *) params[i].val_adr) = (int) params[i].default_val;
		break;
		case PARAM_REQUEST:
		{
			dllist *ptr = *(dllist **) params[i].val_adr;
			while(ptr)
			{
				url_info_free((url_info *)ptr->data);
				ptr = dllist_remove_entry(ptr,ptr);
			}
			*(dllist **) params[i].val_adr = NULL;
		}
		break;
	}
}

void cfg_setup_default()
{
	int i,x,j;

	for (i = 0; i < NUM_ELEM(params) ; i++)
	{
		switch (params[i].type)
		{
			case PARAM_NUM:
				*((int *) params[i].val_adr) = (int) params[i].default_val;
			break;
			case PARAM_PBOOL:
				*((bool *) params[i].val_adr) = (bool)(int) params[i].default_val;
			break;
			case PARAM_NBOOL:
				*((bool *) params[i].val_adr) = (bool)(int) params[i].default_val;
			break;
			case PARAM_PATH:
			case PARAM_STR:
				*((char **) params[i].val_adr) = (char *) params[i].default_val;
			break;
			case PARAM_STRLIST:
				*((char ***) params[i].val_adr) = (char **) params[i].default_val;
				if (params[i].mval_adr)
					*((bool *) params[i].mval_adr) = (bool)(int) params[i].mdefault_val;				
			break;
			case PARAM_CONN:
				*((char **) params[i].val_adr) = (char *) params[i].default_val;
				if (params[i].mval_adr)
					*((int *) params[i].mval_adr) = (int) params[i].mdefault_val;
			break;
			case PARAM_AUTHSCH:
				*((int *) params[i].val_adr) = (int) params[i].default_val;
			break;
			case PARAM_MODE:
				*((int *) params[i].val_adr) = (int) params[i].default_val;
			break;
			case PARAM_TIME:
				*((time_t *) params[i].val_adr) = (time_t)0;
			break;
			case PARAM_HTMLTAG:
	    			for (x = 0 ; x < NUM_ELEM(linky) ; x++)
                			for(j = 0 ; linky[x].attribs[j].attrib ; j++)
						linky[x].attribs[j].stat &= ~LINK_DISABLED;
			break;
			case PARAM_TWO_QSTR:
				*((char **) params[i].val_adr) = (char *) params[i].default_val;
				*((char **) params[i].mval_adr) = (char *) params[i].mdefault_val;
			break;
			case PARAM_DOUBLE:
				*((double *) params[i].val_adr) = *(double *)params[i].default_val;
			break;
			case PARAM_LFNAME:
				cfg.lfnames = NULL;
			break;
			case PARAM_RE:
#ifdef HAVE_REGEX
				*((dllist **) params[i].val_adr) = NULL;
#endif
			break;
			case PARAM_USTRAT:
				*((strategie *) params[i].val_adr) = (strategie)params[i].default_val;
			break;
			case PARAM_SSLVER:
				*((int *) params[i].val_adr) = (int) params[i].default_val;
			break;
			case PARAM_HTTPHDR:
				*((dllist **) params[i].val_adr) = NULL;
			break;
			case PARAM_DEBUGL:
				*((int *) params[i].val_adr) = (int) params[i].default_val;
			break;
			case PARAM_REQUEST:
				*((dllist **) params[i].val_adr) = NULL;
			break;
		}
	}
}

void cfg_setup_cmdln(argc , argv)
int argc;
char **argv;
{
	int i , j;
	bool found;
	int nr=0;
	double dnr=0.0;
	char *p=NULL;
	char **pl=NULL;

	for (j = 1 ; j < argc ; j++)
	{
		found = FALSE;
		for (i = 0; i < NUM_ELEM(params) ; i++)
		{
			if (!params[i].par_cmd) continue;

			if (!strcasecmp(argv[j] , params[i].par_cmd))
			{
				found = TRUE;
				switch (params[i].type)
				{
					case PARAM_NUM:
						j++;
						if (j < argc)
						{
							nr = _atoi(argv[j]);
							if (errno == ERANGE)
							{
								printf(gettext("Please specify number with parameter \"%s\"\n") , params[i].par_cmd);
								usage_short(argv[0]);
							}
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						*((int *) params[i].val_adr) = nr;
					break;
					case PARAM_PBOOL:
						*((bool *) params[i].val_adr) = TRUE;
					break;
					case PARAM_NBOOL:
						*((bool *) params[i].val_adr) = FALSE;
					break;
					case PARAM_STR:
						j++;
						if (j < argc)
						{
							if (argv[j][0])
								p = new_string(argv[j]);
							else p = NULL;
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						*((char **) params[i].val_adr) = p;
					break;
					case PARAM_PATH:
						j++;
						if (j < argc)
						{
							if (argv[j][0])
#ifdef _WIN32
								p = cvt_win32_to_unix_path(argv[j]);
#else
								p = get_abs_file_path_oss(argv[j]);
#endif
							else
								p = NULL;
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						*((char **) params[i].val_adr) = p;
					break;
					case PARAM_STRLIST:
						j++;
						if (j < argc)
						{
							pl = make_list(argv[j] , ",");
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						if (params[i].mval_adr)
							*((bool *) params[i].mval_adr) = (bool)(int) params[i].mdefault_val;
						*((char ***) params[i].val_adr) = pl;
					break;
					case PARAM_CONN:
						j++;
						if (j < argc)
						{
							if (argv[j][0])
							{
								p = strchr(argv[j] , ':');
								if (p)
								{
									nr = _atoi(p+1);
									if (errno == ERANGE)
									{
										struct servent *se;
									
										if ((se = getservbyname(p+1 , "tcp")))
										{
											nr = ntohs(se->s_port);
										}
										else
										{
											printf(gettext("Unknown port \"%s\"\n") , p+1);
										}
									}
									if (params[i].mval_adr)
										*((int *) params[i].mval_adr) = (int) nr;
								}
							}
							else
								p = NULL;
							*((char **) params[i].val_adr) = p ? new_n_string(argv[j] , p - argv[j]) : new_string(argv[j]);
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}

					break;
					case PARAM_AUTHSCH:
						j++;
						if (j < argc)
						{
							nr = _atoi(argv[j]);
							if (errno == ERANGE)
							{
								printf(gettext("Bad auth scheme \"%s\"\n") , argv[j]);
								usage_short(argv[0]);
							}
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						if (!(nr == 1 || nr == 2 || nr == 3))
						{
							printf(gettext("Bad auth scheme \"%s\"\n") , argv[j]);
							usage_short(argv[0]);
						}
						else
						*((int *) params[i].val_adr) = nr;
					break;
					case PARAM_MODE:
						j++;
						if (j < argc)
						{
							cfg.mode = mode_get_by_str(argv[j]);
							if (cfg.mode == MODE_UNKNOWN)
							{
								printf(gettext("Unknow operation mode \"%s\"\n") , argv[j]);
								usage_short(argv[0]);
							}
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
					break;
					case PARAM_TIME:
						j++;
						if (j < argc)
						{
							*((time_t *) params[i].val_adr) = time_scn_cmd(argv[j]);
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
					break;					
					case PARAM_HTMLTAG:
						j++;
						htmltag_set_disabled(argv[j] , params[i].default_val);
					break;
					case PARAM_TWO_QSTR:
						j++;
						if (j < argc)
						{
							p = new_string(argv[j]);
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						*((char **) params[i].val_adr) = p;

						j++;
						if (j < argc)
						{
							p = new_string(argv[j]);
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						*((char **) params[i].mval_adr) = p;
					break;
					case PARAM_DOUBLE:
						j++;
						if (j < argc)
						{
							dnr = _atof(argv[j]);
							if (errno == ERANGE)
							{
								printf(gettext("Please specify floating number with parameter \"%s\"\n") , params[i].par_cmd);
								usage_short(argv[0]);
							}
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						*((double *) params[i].val_adr) = dnr;
					break;
					case PARAM_LFNAME:
						if ((j + 3) < argc)
						{
							lfname_type t;
							lfname *lfnm;

							if (!strcasecmp(argv[j+1] , "F"))
								t = LFNAME_FNMATCH;
#ifdef HAVE_REGEX
							else if (!strcasecmp(argv[j+1] , "R"))
								t = LFNAME_REGEX;
#endif
							else
							{
								t = LFNAME_UNKNOWN;
								printf(gettext("Please specify proper condition type for %s (%s)\n") , params[i].par_cmd ,
#ifdef HAVE_REGEX
									"F or R"
#else
									"F"
#endif
								);
								usage_short(argv[0]);
							}
							lfnm = lfname_new(t , argv[j+2] , argv[j+3]);
							if (!lfnm)
								usage_short(argv[0]);

							cfg.lfnames = dllist_append(cfg.lfnames , lfnm);
							j += 3;
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
					break;
					case PARAM_RE:
#ifdef HAVE_REGEX
					{
						re_entry *ree = NULL;
						j++;
						if (j < argc)
						{
							if (!(ree = re_make(argv[j])))
							{
								printf(gettext("Please specify valid RE with parameter \"%s\"\n") , params[i].par_cmd);
								usage_short(argv[0]);
							}
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
						*((dllist **) params[i].val_adr) = dllist_append(*((dllist **) params[i].val_adr) , ree);
					}
#endif
					break;
					case PARAM_USTRAT:
						j++;
						if (j < argc)
						{
							*(strategie *)params[i].val_adr = get_strategie_by_str(argv[j]);
							if (*(strategie *)params[i].val_adr == SSTRAT_LAST)
							{
								printf(gettext("Unknown URL scheduling strategy - \"%s\"\n") , argv[j]);
								usage_short(argv[0]);
							}
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
					break;
					case PARAM_SSLVER:
						j++;
						if (j < argc)
						{
							*(int *) params[i].val_adr = get_ssl_version_by_str(argv[j]);
							if (*(int *) params[i].val_adr == -1)
							{
								printf(gettext("Unknown SSL version - \"%s\"\n") , argv[j]);
								usage_short(argv[0]);
							}
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
					break;
					case PARAM_HTTPHDR:
						j++;
						if (j < argc)
						{
							httphdr *hr = httphdr_parse(argv[j]);
							if (!hr)
							{
								printf(gettext("Invalid additional HTTP header - \"%s\"\n") , argv[j]);
								usage_short(argv[0]);
							}
							*((dllist **) params[i].val_adr) = dllist_append(*((dllist **) params[i].val_adr) , hr);
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
					break;
					case PARAM_DEBUGL:
#ifdef DEBUG
						j++;
						if (j < argc)
						{
							int dl = debug_level_parse(argv[j]);
							if (dl == -1)
							{
								usage_short(argv[0]);
							}
							*((int *) params[i].val_adr) = dl;
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
#endif
					break;
					case PARAM_REQUEST:
						j++;
						if (j < argc)
						{
							url_info *ui = url_info_parse(argv[j]);
							if (!ui)
							{
								printf(gettext("Invalid request specification - \"%s\"\n") , argv[j]);
								usage_short(argv[0]);
							}
							*((dllist **) params[i].val_adr) = dllist_append(*((dllist **) params[i].val_adr) , ui);
						}
						else
						{
							printf(gettext("Not enough number of parameters \"%s\"\n") , params[i].par_cmd);
							usage_short(argv[0]);
						}
					break;
				}
			}
		}
		if (!found)
		{
			if (!strcasecmp(argv[j] , "-h")) usage(argv[0]);
			else if (!strcasecmp(argv[j] , "-v")) 
			{
				printf("pavuk %s\n",VERSION);
				printf(gettext("Optional features available :\n"));
#ifdef DEBUG
				printf(gettext(" - Debug mode\n"));
#endif

#ifdef GETTEXT_NLS
				printf(gettext(" - GNU gettext internationalization of messages\n"));
#endif

#ifdef HAVE_FLOCK
				printf(gettext(" - flock() document locking\n"));
#endif

#ifdef HAVE_FCNTL_LOCK
				printf(gettext(" - fcntl() document locking\n"));
#endif

#ifdef I_FACE
#ifdef GTK_FACE
				printf(gettext(" - Gtk GUI interface\n"));
#endif
#ifdef X_FACE
				printf(gettext(" - Xt GUI interface\n"));
#endif 
#ifdef WITH_TREE
				printf(gettext(" - URL tree preview\n"));
#endif
#endif

#ifdef USE_SSL
				printf(gettext(" - http over SSL\n"));
#endif

#ifdef SOCKS
#ifdef SOCKS5
				printf(gettext(" - Socks v4 proxy support\n"));
#else
				printf(gettext(" - Socks v5 proxy support\n"));
#endif
#endif
#ifdef HAVE_FSTATFS
				printf(gettext(" - with filesystem free space checking\n"));
#endif

#ifdef HAVE_REGEX
				printf(gettext(" - with optional regex patterns in -fnrules and -*rpattern options\n"));
#endif

#ifdef HAVE_POSIX_REGEX
				printf(gettext(" - with POSIX regexp\n"));
#endif

#ifdef HAVE_V8_REGEX
				printf(gettext(" - with Bell V8 regexp\n"));
#endif

#ifdef HAVE_BSD_REGEX
				printf(gettext(" - with BSD regexp\n"));
#endif

#ifdef HAVE_GNU_REGEX
				printf(gettext(" - with GNU regexp\n"));
#endif

#ifdef HAVE_DBOPEN
				printf(gettext(" - with support for loading files from Netscape browser cache\n"));
#endif

#ifdef HAVE_TERMIOS
				printf(gettext(" - with support for detecting whether pavuk is running as background job\n"));
#endif
				pavuk_do_at_exit();
				exit(0);
			}
			else if (*(argv[j]) == '-')
			{
				printf(gettext("Unknown switch %s\n") , argv[j]);
				usage_short(argv[0]);
			}
			else
			{
				url_info *ui;
				ui = url_info_new(argv[j]);
				cfg.request = dllist_append(cfg.request , ui);
				cfg.total_cnt++;
			}
		}
	}
}


int cfg_load_fd(fd)
bufio *fd;
{
	int i;
	bool found;
	int nr;
	double dnr;
	char *p;
	char lnbuf[4096];
	char *lns;
	int sz;
	pavuk_mode temp_mode;

	while((sz = bufio_readln(fd , lnbuf , sizeof(lnbuf)) > 0))
	{
		strip_nl(lnbuf);
		for(lns = lnbuf ; *lns && isspace(*lns) ; lns++);
		if (*lns == '#' || !*lns) continue;

		found = FALSE;

		for (i = 0; i < NUM_ELEM(params) ; i++)
		{
			if (! params[i].par_entry) continue;
			if (!strncasecmp(lns , params[i].par_entry , strlen(params[i].par_entry)))
			{
				
				lns += strlen(params[i].par_entry);
				for( ; *lns && isspace(*lns) ; lns++);
				for(p = lns + strlen(lns) - 1 ; p >= lns && isspace(*p) ; p--) *p = '\0';

				if (!*lns) 
				{
					cfg_set_to_default(i);
					continue;
				}

				found = TRUE;
				switch (params[i].type)
				{
					case PARAM_NUM:
						nr = _atoi(lns);
						if (errno == ERANGE)
						{
							xprintf(0 , gettext("Please specify number \"%s\"\n") , params[i].par_entry);
						}
						else
							*((int *) params[i].val_adr) = nr;
					break;
					case PARAM_PBOOL:
					case PARAM_NBOOL:
						if (!strcasecmp(lns , "false"))
						{
							*((bool *) params[i].val_adr) = FALSE;
						}
						else if (!strcasecmp(lns , "true"))
						{
							*((bool *) params[i].val_adr) = TRUE;
						}
						else xprintf(0 , gettext("Only \"true\" & \"false\" is allowed : \"%s\"\n") , lns);
					break;
					case PARAM_STR:
						*((char **) params[i].val_adr) = *lns ? new_string(lns) : NULL;
					break;
					case PARAM_PATH:
#ifdef _WIN32
						*((char **) params[i].val_adr) = *lns ? cvt_win32_to_unix_path(lns) : NULL;
#else
						*((char **) params[i].val_adr) = *lns ? get_abs_file_path_oss(lns) : NULL;
#endif
					break;
					case PARAM_STRLIST:
						if (params[i].mval_adr)
							*((bool *) params[i].mval_adr) = (bool)(int) params[i].mdefault_val;
						*((char ***) params[i].val_adr) = *lns ? make_list(lns , ",") : NULL;
					break;
					case PARAM_CONN:
						p = strchr(lns , ':');
						if (p)
						{
							nr = _atoi(p+1);
							if (errno == ERANGE)
							{
								struct servent *se;

								if ((se = getservbyname(p+1 , "tcp")))
								{
									nr = ntohs(se->s_port);
								}
								else
								{
									xprintf(0 , gettext("Unknown port \"%s\"\n") , p+1);
								}
							}
							if (params[i].mval_adr)
								*((int *) params[i].mval_adr) = (int) nr;
						}
						*((char **) params[i].val_adr) = p ? new_n_string(lns , p - lns) : new_string(lns);
					break;
					case PARAM_AUTHSCH:
						nr = _atoi(lns);
						if (errno == ERANGE)
						{
							xprintf(0 , gettext("Bad auth scheme \"%s\"\n") , lns);
						}
						else if (!(nr == 1 || nr == 2))
						{
							xprintf(0 , gettext("Bad auth scheme \"%s\"\n") , lns);
						}
						else
							*((int *) params[i].val_adr) = nr;
					break;
					case PARAM_MODE:
						temp_mode = mode_get_by_str(lns);
						if (temp_mode == MODE_UNKNOWN)
						{
							xprintf(0 , gettext("Unknow operation mode \"%s\"\n") , lns);
						}
						else
							*((pavuk_mode *) params[i].val_adr) = temp_mode;
					break;
					case PARAM_TIME:
					{
						time_t ttm = time_scn_cmd(lns);
						if (!params[i].val_adr)
						{
							xprintf(0 , gettext("Bad time parameter \"%s\"\n") , lns);
						}
						else
							*(time_t *) params[i].val_adr = ttm;
					}
					break;
					case PARAM_HTMLTAG:
						htmltag_set_disabled(lns , params[i].default_val);
					break;
					case PARAM_TWO_QSTR:
					{
						if (lns && *lns)
						{
							char *xp = new_string(lns);

							*(char **) params[i].val_adr = new_string(get_1qstr(xp));
							*(char **) params[i].mval_adr = new_string(get_1qstr(NULL));

							_free(xp);
						}
						else
						{
							*(char **) params[i].val_adr = NULL;
							*(char **) params[i].mval_adr = NULL;
						}
					}
					break;
					case PARAM_DOUBLE:
						dnr = _atof(lns);
						if (errno == ERANGE)
						{
							xprintf(0 , gettext("Please specify floating number \"%s\"\n") , params[i].par_entry);
						}
						else
							*(double *) params[i].val_adr = dnr;
					break;
					case PARAM_LFNAME:
					{
						char *ps1 = get_1qstr(lns);
						char *ps2 = get_1qstr(NULL);
						char *ps3 = get_1qstr(NULL);
						lfname_type t;
						lfname *lfnm;

						if (!ps1 || !ps2 || !ps3)
						{
							t = LFNAME_UNKNOWN;
							xprintf(0 , gettext("Please specify proper arguments for %s\n") , params[i].par_entry);
						}
						else if (!strcasecmp(ps1 , "F"))
							t = LFNAME_FNMATCH;
#ifdef HAVE_REGEX
						else if (!strcasecmp(ps1 , "R"))
							t = LFNAME_REGEX;
#endif
						else
						{
							t = LFNAME_UNKNOWN;
							xprintf(0 , gettext("Please specify proper condition type for %s (%s)\n") , params[i].par_entry ,
#ifdef HAVE_REGEX
								"F or R"
#else
								"F"
#endif
							);
						}
						if (t != LFNAME_UNKNOWN)
						{
							lfnm = lfname_new(t , ps2 , ps3);
							if (lfnm)
								cfg.lfnames = dllist_append(cfg.lfnames , lfnm);
						}
					}
					break;
					case PARAM_RE:
#ifdef HAVE_REGEX
					{
						re_entry *ree;
						if (!(ree = re_make(lns)))
						{
							xprintf(0 , gettext("Please specify valid RE \"%s\"\n") , params[i].par_entry);
						}
						else
							*(dllist **) params[i].val_adr = dllist_append(*((dllist **) params[i].val_adr) , ree);
					}
#endif
					break;
					case PARAM_USTRAT:
					{
						strategie strtg = get_strategie_by_str(lns);
						if (strtg == SSTRAT_LAST)
						{
							xprintf(0 , gettext("Unknown URL scheduling strategy - \"%s\"\n") , lns);
						}
						else *(strategie *)params[i].val_adr = strtg;
					}
					break;
					case PARAM_SSLVER:
					{
						int sslv = get_ssl_version_by_str(lns);
						if (sslv == -1)
						{
							xprintf(0 , gettext("Unknown SSL version - \"%s\"\n") , lns);
						}
						else *(int *)params[i].val_adr = sslv;
					}
					break;
					case PARAM_HTTPHDR:
					{
						httphdr *hr = httphdr_parse(lns);
						if (!hr)
						{
							xprintf(0, gettext("Invalid additional HTTP header - \"%s\"\n") , lns);
						}
						else
							*((dllist **) params[i].val_adr) = dllist_append(*((dllist **) params[i].val_adr) , hr);
					}
					break;
					case PARAM_DEBUGL:
#ifdef DEBUG
					{
						int dl = debug_level_parse(lns);
						if (dl != -1)
							*((int *) params[i].val_adr) = dl;
					}
#endif
					break;
					case PARAM_REQUEST:
					{
						url_info *ui = url_info_parse(lns);
						if (!ui)
						{
							xprintf(0, gettext("Invalid request specification - \"%s\"\n") , lns);
						}
						else
							*((dllist **) params[i].val_adr) = dllist_append(*((dllist **) params[i].val_adr) , ui);
					}
					break;
				}
			}
		}
		if (!found && !strncasecmp(lns , "URL:" , 4))
		{
			url_info *ui;

			lns += 4;
			for( ; *lns && isspace(*lns) ; lns++);
			for(p = lns + strlen(lns) ; *p && isspace(*p) ; p--) *p = '\0';
			if (!*lns) continue;

			ui = url_info_new(lns);
			cfg.request = dllist_append(cfg.request , ui);
			cfg.total_cnt++;
		}
		else if (!found) xprintf(0 , gettext("Unable to parse \"%s\"\n") , lns);
	}

	return 0;
}

int cfg_load(filename)
char *filename;
{
	bufio *fd;

	if (!(fd = bufio_open(filename , O_BINARY | O_RDONLY)))
	{
		xperror(filename);
		return -1;
	}	

	cfg_load_fd(fd);

	bufio_close(fd);

	return 0;
}

void cfg_load_setup()
{
	char pom[PATH_MAX];
	char *p;

#ifdef DEFAULTRC
	if (!access(DEFAULTRC , R_OK))
		cfg_load(DEFAULTRC);
#endif
	p = getenv("PAVUKRC_FILE");
	if (!p)
	{
		sprintf(pom , "%s/%s" , cfg.path_to_home , ".pavukrc");
		p = pom;
	}
	if (!access(p , R_OK))
		cfg_load(p);
}


int cfg_dump_fd(fd)
int fd;
{
	int i,j;
	char pom[8192];
	char pom2[20];
	char **pl;

	if (cfg.request)
	{
		dllist *dptr;

		for(dptr = cfg.request ; dptr ; dptr = dptr->next)
		{
			url_info *ui = (url_info *)dptr->data;

			if (ui->type == URLI_NORMAL)
			{
				write(fd , "URL: " , 5);
				write(fd , ui->urlstr , strlen(ui->urlstr));
				write(fd , "\n" , 1);
			}
		}
	}
	
	for (i = 0; i < NUM_ELEM(params) ; i++)
	{
		if (! params[i].par_entry ) continue;
		switch (params[i].type)
		{
			case PARAM_NUM:
				sprintf(pom , "%s %d\n" , params[i].par_entry , *((int *) params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_NBOOL:
			case PARAM_PBOOL:
				if (*((bool *) params[i].val_adr))
					sprintf(pom , "%s true\n" , params[i].par_entry);
				else
					sprintf(pom , "%s false\n" , params[i].par_entry);
				write(fd , pom , strlen(pom));
			break;
			case PARAM_PATH:
			case PARAM_STR:
				if (*((char **) params[i].val_adr))
				{
					sprintf(pom , "%s %s\n" , params[i].par_entry , *((char **) params[i].val_adr));
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_STRLIST:
				if (!params[i].mval_adr || (params[i].mval_adr &&  
				    (*((bool *) params[i].mval_adr) == (bool)(int) params[i].mdefault_val)))
				{
					pl = *((char ***) params[i].val_adr);
					if (pl && pl[0])
					{
						sprintf(pom , "%s %s" , params[i].par_entry , pl[0]);
						write(fd , pom , strlen(pom));				

						j = 1;
						while (pl[j])
						{
							write(fd , "," , 1);
							write(fd , pl[j] , strlen(pl[j]));
							j++;
						}
						write(fd , "\n" , 1);
					}
				}
			break;
			case PARAM_CONN:
				if (*((char **) params[i].val_adr))
				{
					sprintf(pom , "%s %s:%d\n" , params[i].par_entry , *((char **) params[i].val_adr),*((int *) params[i].mval_adr));
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_AUTHSCH:
				sprintf(pom , "%s %d\n" , params[i].par_entry , *((int *) params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_MODE:
				sprintf(pom , "%s %s\n" , params[i].par_entry , mode_get_str(cfg.mode));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_TIME:
				if (*((time_t *) params[i].val_adr))
				{
					LOCK_TIME
					strftime(pom2 , sizeof(pom2) , "%Y.%m.%d.%H:%M" , localtime((time_t *)params[i].val_adr));
					UNLOCK_TIME
					sprintf(pom , "%s %s\n" ,  params[i].par_entry , pom2);
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_HTMLTAG:
			{
				int x,y;
				bool first = TRUE;

				sprintf(pom , "%s " , params[i].par_entry);
				for (x = 0 ; x < NUM_ELEM(linky) ; x++)
				{
					for(y = 0 ; linky[x].attribs[y].attrib ; y++)
					{
						if (!(linky[x].attribs[y].stat & LINK_DISABLED) ==
						    !(params[i].default_val))
						{
							if (!first) strcat(pom , ";");
							strcat(pom , linky[x].tag);
							strcat(pom , ",");
							strcat(pom , linky[x].attribs[y].attrib);
							first = FALSE;
						}
					}
				}
				strcat(pom , "\n");
				if (!first)
					write(fd , pom , strlen(pom));
			}
			break;
			case PARAM_TWO_QSTR:
				if (*((char **) params[i].val_adr))
				{
					char *p1,*p2;
					p1 = escape_str(*((char **) params[i].val_adr) , "\\\"");
					p2 = escape_str(*((char **) params[i].mval_adr) , "\\\"");
					sprintf(pom , "%s \"%s\" \"%s\"\n" , params[i].par_entry , p1 , p2);
					_free(p1);
					_free(p2);
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_DOUBLE:
				sprintf(pom , "%s %.3f\n" , params[i].par_entry , *((double *) params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_LFNAME:
			{
				dllist *pdl = cfg.lfnames;
				while(pdl)
				{
					lfname *lfnm = pdl->data;
					char *p1,*p2;

					p1 = escape_str(lfnm->matchstr , "\\\"");
					p2 = escape_str(lfnm->transstr , "\\\"");

					sprintf(pom , "%s \"%s\" \"%s\" \"%s\"\n" , params[i].par_entry , 
						(lfnm->type == LFNAME_FNMATCH) ? "F" : "R" , p1 , p2);
					_free(p1);
					_free(p2);
					write(fd , pom , strlen(pom));

					pdl = pdl->next;
				}
			}
			break;
			case PARAM_RE:
#ifdef HAVE_REGEX
			{
				dllist *ptr = *((dllist **) params[i].val_adr);
				while(ptr)
				{
					re_entry *ree = ptr->data;

					sprintf(pom , "%s %s\n" , params[i].par_entry , ree->pattern);
					write(fd , pom , strlen(pom));

					ptr = ptr->next;
				}
			}
#endif
			break;
			case PARAM_USTRAT:
				sprintf(pom , "%s %s\n" , params[i].par_entry , get_strategie_str(*(strategie *)params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_SSLVER:
				sprintf(pom , "%s %s\n" , params[i].par_entry , get_ssl_version_str(*(int *)params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_HTTPHDR:
			{
				dllist *ptr = *((dllist **) params[i].val_adr);
				while(ptr)
				{
					httphdr *hr = ptr->data;

					sprintf(pom , "%s %s%s %s\n" , params[i].par_entry , hr->all ? "+" : "" , hr->name, hr->val);
					write(fd , pom , strlen(pom));

					ptr = ptr->next;
				}
			}
			break;
			case PARAM_DEBUGL:
#ifdef DEBUG
			{
				char strbuf[1024];
				debug_level_construct(*((int *) params[i].val_adr) , strbuf);
				sprintf(pom , "%s %s\n" , params[i].par_entry , strbuf);
				write(fd , pom , strlen(pom));
			}
#endif
			break;
			case PARAM_REQUEST:
			{
				dllist *ptr = *((dllist **) params[i].val_adr);
				while(ptr)
				{
					url_info *ui = ptr->data;

					if (ui->type != URLI_NORMAL)
					{
						sprintf(pom , "%s %s\n" , params[i].par_entry , url_info_dump(ui));
						write(fd , pom , strlen(pom));
					}

					ptr = ptr->next;
				}
			}
			break;
		}
	}
        return 0; 	
}

int cfg_dump(filename)
char *filename;
{
	int fd;

	if ((fd = open(filename , O_BINARY | O_CREAT | O_WRONLY , 0666)) < 0)
	{
		xperror(filename);
		return -1;
	}	

	ftruncate(fd , 0);

	cfg_dump_fd(fd);

	close(fd);
	return 0;
}

int cfg_load_pref()
{
	bufio *fd;
	char filename[PATH_MAX];

	sprintf(filename , "%s/.pavuk_prefs" , cfg.path_to_home);

	if (!(fd = bufio_open(filename , O_BINARY | O_RDONLY)))
	{
		return -1;
	}	

	cfg_load_fd(fd);

	bufio_close(fd);

	return 0;
}

int cfg_dump_pref()
{
	int fd;
	char filename[PATH_MAX];

	sprintf(filename , "%s/.pavuk_prefs" , cfg.path_to_home);

	if ((fd = open(filename , O_BINARY | O_CREAT | O_WRONLY , 0666)) < 0)
	{
		xperror(filename);
		return -1;
	}	

	ftruncate(fd , 0);

	cfg_dump_fd(fd);

	close(fd);
	return 0;
}

int cfg_dump_cmd(filename)
char *filename;
{
	int i,j;
	int fd;
	char pom[8192];
	char pom2[20];
	char **pl;

	if ((fd = open(filename , O_BINARY | O_CREAT  | O_WRONLY , 0666)) < 0)
	{
		xperror(filename);
		return -1;
	}	

	ftruncate(fd , 0);

	write(fd , cfg.prg_path , strlen(cfg.prg_path));
	
	write(fd , " " , 1);

	if (cfg.request)
	{
		dllist *dptr;

		for(dptr = cfg.request ; dptr ; dptr = dptr->next)
		{
			url_info *ui = (url_info *) dptr->data;

			if (ui->type == URLI_NORMAL)
			{
				write(fd , " '" , 2);
				write(fd , ui->urlstr , strlen(ui->urlstr));
				write(fd , "' " , 2);
			}
		}
	}

	for (i = 0; i < NUM_ELEM(params) ; i++)
	{
		if (!params[i].par_cmd) continue;
		if (!params[i].par_entry && (params[i].type != PARAM_PBOOL) && (params[i].type != PARAM_NBOOL)) continue;
		switch (params[i].type)
		{
			case PARAM_NUM:
				sprintf(pom , " %s %d " , params[i].par_cmd , *((int *) params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_NBOOL:
				if (!*((bool *) params[i].val_adr))
				{
					write(fd , " " , 1);
					write(fd ,  params[i].par_cmd , strlen(params[i].par_cmd));
					write(fd , " " , 1);
				}
			break;
			case PARAM_PBOOL:
				if (*((bool *) params[i].val_adr))
				{
					write(fd , " " , 1);
					write(fd , params[i].par_cmd , strlen(params[i].par_cmd));
					write(fd , " " , 1);
				}
			break;
			case PARAM_PATH:
			case PARAM_STR:
				if (*((char **) params[i].val_adr))
				{
					sprintf(pom , " %s '%s' " , params[i].par_cmd , *((char **) params[i].val_adr));
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_STRLIST:
				if (!params[i].mval_adr || (params[i].mval_adr &&
				    (*((bool *) params[i].mval_adr) == (bool)(int) params[i].mdefault_val)))
				{
					pl = *((char ***) params[i].val_adr);
					if (pl && pl[0])
					{
						sprintf(pom , " %s '%s" , params[i].par_cmd , pl[0]);
						write(fd , pom , strlen(pom));				

						j = 1;
						while (pl[j])
						{
							write(fd , "," , 1);
							write(fd , pl[j] , strlen(pl[j]));
							j++;
						}
						write(fd , "' " , 2);
					}
				}
			break;
			case PARAM_CONN:
				if (*((char **) params[i].val_adr))
				{
					sprintf(pom , " %s %s:%d " , params[i].par_cmd , *((char **) params[i].val_adr),*((int *) params[i].mval_adr));
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_AUTHSCH:
				sprintf(pom , " %s %d " , params[i].par_cmd , *((int *) params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_MODE:
				sprintf(pom , " %s %s " , params[i].par_cmd , mode_get_str(cfg.mode));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_TIME:
				if (*((time_t *) params[i].val_adr))
				{
					LOCK_TIME
					strftime(pom2 , sizeof(pom2) , "%Y.%m.%d.%H:%M" , localtime((time_t *)params[i].val_adr));
					UNLOCK_TIME
					sprintf(pom , " %s %s " ,  params[i].par_cmd , pom2);
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_HTMLTAG:
			{
				int x,y;
				bool first = TRUE;

				sprintf(pom , " %s '" , params[i].par_cmd);
				for (x = 0 ; x < NUM_ELEM(linky) ; x++)
				{
					for(y = 0 ; linky[x].attribs[y].attrib ; y++)
					{
						if (!(linky[x].attribs[y].stat & LINK_DISABLED) ==
						    !(params[i].default_val))
						{
							if (!first) strcat(pom , ";");
							strcat(pom , linky[x].tag);
							strcat(pom , ",");
							strcat(pom , linky[x].attribs[y].attrib);
							first = FALSE;
						}
					}
				}
				strcat(pom , "' ");
				if (!first)
					write(fd , pom , strlen(pom));
			}
			break;
			case PARAM_TWO_QSTR:
				if (*((char **) params[i].val_adr))
				{
					sprintf(pom , " %s '%s' '%s' " , params[i].par_cmd , *((char **) params[i].val_adr) , *((char **) params[i].mval_adr));
					write(fd , pom , strlen(pom));
				}
			break;
			case PARAM_DOUBLE:
				sprintf(pom , " %s %.3f " , params[i].par_cmd , *((double *) params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_LFNAME:
			{
				dllist *pdl = cfg.lfnames;
				while(pdl)
				{
					lfname *lfnm = pdl->data;

					sprintf(pom , " %s \'%s\' \'%s\' \'%s\' " , params[i].par_cmd , 
						(lfnm->type == LFNAME_FNMATCH) ? "F" : "R" ,
						lfnm->matchstr , lfnm->transstr);
					write(fd , pom , strlen(pom));

					pdl = pdl->next;
				}
			}
			break;
			case PARAM_RE:
#ifdef HAVE_REGEX
			{
				dllist *ptr = *((dllist **) params[i].val_adr);
				while(ptr)
				{
					re_entry *ree = ptr->data;

					sprintf(pom , " %s \'%s\' " , params[i].par_cmd , ree->pattern);
					write(fd , pom , strlen(pom));

					ptr = ptr->next;
				}
			}
#endif
			break;
			case PARAM_USTRAT:
				sprintf(pom , " %s %s " , params[i].par_cmd , get_strategie_str(*(strategie *)params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_SSLVER:
				sprintf(pom , " %s %s " , params[i].par_cmd , get_ssl_version_str(*(int *)params[i].val_adr));
				write(fd , pom , strlen(pom));
			break;
			case PARAM_HTTPHDR:
			{
				dllist *ptr = *((dllist **) params[i].val_adr);
				while(ptr)
				{
					httphdr *hr = ptr->data;

					sprintf(pom , " %s \"%s%s %s\" " , params[i].par_cmd , hr->all ? "+" : "" , hr->name, hr->val);
					write(fd , pom , strlen(pom));

					ptr = ptr->next;
				}
			}
			break;
			case PARAM_DEBUGL:
#ifdef DEBUG
			{
				char strbuf[1024];
				debug_level_construct(*((int *) params[i].val_adr) , strbuf);
				sprintf(pom , " %s \'%s\' " , params[i].par_cmd , strbuf);
				write(fd , pom , strlen(pom));
			}
#endif
			break;
			case PARAM_REQUEST:
			{
				dllist *ptr = *((dllist **) params[i].val_adr);
				while(ptr)
				{
					url_info *ui = ptr->data;

					if (ui->type != URLI_NORMAL)
					{
						sprintf(pom , " %s \'%s\' " , params[i].par_cmd , url_info_dump(ui));
						write(fd , pom , strlen(pom));
					}

					ptr = ptr->next;
				}
			}
			break;
		}
	}

	close(fd);
	return 0;
}

void cfg_free_params()
{
	int i;

	for (i = 0 ; i < NUM_ELEM(params) ; i++)
		cfg_set_to_default(i);
}

