/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include "http.h"
#include "bufio.h"
#include "errcode.h"

#ifdef USE_SSL

#ifdef OPENSSL
#include <openssl/rsa.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#else
#include <rsa.h>
#include <crypto.h>
#include <x509.h>
#include <pem.h>
#include <ssl.h>
#include <err.h>
#endif

/*
Most of this code is inspired by example programs from SSLeay package
*/

static int ssl_passwd_callback(char *buf, int num, int verify)
{
	if(verify)
		xprintf(1, "%s\n", buf);
	else
	{
		if(num > strlen(cfg.ssl_cert_passwd))
		{
			strcpy(buf, cfg.ssl_cert_passwd);
			return strlen(buf);
		}
	}
	return 0;
}

int ssl_do_connect(docp, socket, ssl_con, ssl_ctx, ssl_method, ssl_bio, parent_ssl_con)
doc *docp;
bufio *socket;
SSL **ssl_con;
SSL_CTX **ssl_ctx;
SSL_METHOD **ssl_method;
BIO **ssl_bio;
SSL *parent_ssl_con;
{
	int rv;

	if (cfg.ssl_proxy)
	{
		if (http_dumy_proxy_connect(docp, 
			url_get_site(docp->doc_url), url_get_port(docp->doc_url)))
		{
			docp->errcode = ERR_PROXY_CONNECT;
			xperror("ssl proxy connect req");
			return FALSE;
		}
	}

	if (!*ssl_method)
	{
		SSL_load_error_strings();
		switch(cfg.ssl_version)
		{
			case 1:
				*ssl_method = SSLv23_client_method();
			break;
			case 2:
				*ssl_method = SSLv2_client_method();
			break;
			case 3:
				*ssl_method = SSLv3_client_method();
			break;
		}
		SSLeay_add_ssl_algorithms();
	}

	if (!cfg.unique_sslid || !*ssl_ctx)
	{
		*ssl_ctx = SSL_CTX_new(*ssl_method);
		if (cfg.ssl_cipher_list)
			SSL_CTX_set_cipher_list(*ssl_ctx, cfg.ssl_cipher_list);
	}
	
/* SSL Certification stuff */
	if ((!cfg.unique_sslid || !*ssl_con) && cfg.ssl_cert_file != NULL)
	{
		SSL *ssl;
		X509 *x509;

		if(cfg.ssl_cert_passwd)
		{
			SSL_CTX_set_default_passwd_cb(*ssl_ctx , ssl_passwd_callback);
		}

		if (SSL_CTX_use_certificate_file(*ssl_ctx , cfg.ssl_cert_file,
				SSL_FILETYPE_PEM) <= 0)
		{
			xprintf(1 , gettext("Unable to set certificate file (wrong password?)\n"));
			return FALSE;
		}

		if (cfg.ssl_key_file == NULL) 
			cfg.ssl_key_file = new_string(cfg.ssl_cert_file);

		if (SSL_CTX_use_PrivateKey_file(*ssl_ctx , cfg.ssl_key_file,
				SSL_FILETYPE_PEM) <= 0) 
		{
			xprintf(1, gettext("Unable to set public key file\n"));
			return FALSE;
		}

		ssl = SSL_new(*ssl_ctx);
	    
		x509 = SSL_get_certificate(ssl);
    
		if (x509 != NULL)
			EVP_PKEY_copy_parameters(X509_get_pubkey(x509),
			SSL_get_privatekey(ssl));

		SSL_free(ssl);

		if (!SSL_CTX_check_private_key(*ssl_ctx))
		{
			xprintf(1, gettext("Private key does not match the certificate public key\n"));
			return FALSE;
		}    
	}	
/* End SSL Certification stuff */
	
	if (!cfg.unique_sslid || !*ssl_con)
		*ssl_con = SSL_new(*ssl_ctx);
	*ssl_bio = BIO_new_socket(bufio_getfd(socket), BIO_NOCLOSE);
	SSL_set_bio(*ssl_con , *ssl_bio , *ssl_bio);
	if (parent_ssl_con)
		SSL_copy_session_id(*ssl_con, parent_ssl_con);
	SSL_set_connect_state(*ssl_con);
	SSL_do_handshake(*ssl_con);

	while((rv = SSL_in_init(*ssl_con)) && 
		SSL_get_error(*ssl_con , rv) == SSL_ERROR_WANT_CONNECT)
	{
		my_msleep(2);
	}

	if (rv < 0)
	{
#ifdef DEBUG
		SSL_get_error(*ssl_con , -1);
		ERR_print_errors_fp(stdout);
#endif
		if (cfg.unique_sslid)
		{
			SSL_set_shutdown(*ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
		}
		else
		{
			SSL_free(*ssl_con);
			SSL_CTX_free(*ssl_ctx);
			*ssl_con = NULL;
			*ssl_ctx = NULL;
		}
		return FALSE;
	}
#if 0
/*** this is broken because of non-blocking IO ***/
#ifdef DEBUG
	else if (cfg.debug)
	{
		X509* server_cert;
		char *str;

		xprintf(1 , gettext("SSL connection is using %s\n"), SSL_get_cipher(cfg.ssl_con));

		server_cert = SSL_get_peer_certificate(cfg.ssl_con);
		xprintf(1 , gettext("Server certificate:\n"));
  
		str = X509_NAME_oneline(X509_get_subject_name(server_cert) ,
					NULL , 0);
		xprintf(1 , gettext("\t subject: %s\n"), str);
		_free (str);

		str = X509_NAME_oneline(X509_get_issuer_name(server_cert) ,
					NULL , 0);
		xprintf(1 , gettext("\t issuer: %s\n"), str);
		_free (str);

		X509_free (server_cert);
	}
#endif
#endif
	return TRUE;
}

#endif

