#ifndef __htmlh__
#define __htmlh__

#ifndef __errorh__
  #include "error.h"
#endif
#ifndef __varsh__
  #include "vars.h"
#endif
#ifndef __tokenmaph__
  #include "tokenmap.h"
#endif
#include <iostream.h>
#include <map>
#include <list>
#include <string>
#include <algorithm>

//class Vars;

class ParamMap:public map<string,string>{
public:
  inline bool Defined(const string& name)const{return find(name)!=end();}
  inline bool Retrieve(const string& name,string& value)const{
    const_iterator pos;
    if((pos=find(name))==end()) return false;
    value=pos->second;
    return true;
  }
  inline bool Test(const string& name)const{
    return(find(name)!=end());
  }
  inline bool RetrieveToken(const string& name,TokenMap::Token& value)const{
    string temp;
    if(!Retrieve(name,temp)){
      value=-1;
      return false;
    }
    value=TokenMap::NameToTokenNum(temp);
    return true;
  }
  inline bool RetrieveNum(const string& name,int& value)const{
    const_iterator pos;
    if((pos=find(name))==end()) return false;
    value=atoi(pos->second.c_str());
    return true;
  }
};

class HTML{
  friend ostream& operator<<(ostream& out,const HTML& what);
public:
  typedef bool PartType;
  static const bool Text=false,Markup=true;
  HTML(const string& content):m_type(Text),m_content(content){}
  HTML(PartType type,const string& content):m_type(type),
    m_content(content),m_line(0){if(type){UpdateCache();CheckExpandable();}}
  HTML(const string& fname,int line,PartType type,const string& content):
    m_type(type),m_content(content),m_fname(fname),m_line(line){
    if(type){UpdateCache();CheckExpandable();}
  }

  HTML(const HTML& original):m_myPair(NULL),m_myElse(NULL),
    m_type(original.m_type),m_content(original.m_content),
    m_tagName(original.m_tagName),m_token(original.m_token),
    m_firstChar(original.m_firstChar),m_isExpandable(original.m_isExpandable),
    m_fname(original.m_fname),m_line(original.m_line){}
  HTML& operator=(const HTML& original);
  string Print()const;
  string TagName()const{return m_tagName;}
  void BuildParamMap(ParamMap& paramMap)const;
  void ExpandVariables(const Vars& vars){
    if(m_isExpandable) ExpandVariablesEngine(vars);
  }
  void AppendToContent(const string& st);
  void DropFirstChar();
  char FirstChar()const{return m_firstChar;}
  int Token()const{if(m_type) return m_token; return -1;}

  list<HTML>::iterator m_myPair,m_myElse;
  PartType m_type;
private:
  void ExpandVariablesEngine(const Vars& vars);
  void UpdateCache();
  void CheckExpandable();
  string m_content,m_tagName;
  int m_token;
  char m_firstChar;
  bool m_isExpandable;
public:
  string m_fname;
  int m_line;
};

#endif
