#! /usr/bin/perl -wT

BEGIN {
	if ($0 =~ m/^(.*?)[\/\\]([^\/\\]+)$/) {
		$runtimedir = $1;
		$PROGNAME = $2;
	}
}

use strict;
use Getopt::Long;
use vars qw($opt_H $opt_w $opt_c $PROGNAME);
use lib $main::runtimedir;
use utils qw(%ERRORS &print_revision &support &usage);

sub print_help ();
sub print_usage ();

delete @ENV{'PATH', 'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

Getopt::Long::Configure('bundling', 'no_ignore_case');
GetOptions
	("V|version"    => \&version,
	 "h|help"       => \&help,
	 "w|warning=s"  => \$opt_w,
	 "c|critical=s" => \$opt_c,
	 "H|hostname=s" => \$opt_H);

($opt_H) || ($opt_H = shift) || usage("Host name/address not specified\n");
my $host = $1 if ($opt_H =~ m/^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+|[a-zA-Z][-a-zA-Z0-9]*(\.[a-zA-Z][-a-zA-Z0-9]*)*)$/);
($host) || usage("Invalid host: $opt_H\n");

($opt_w) || ($opt_w = shift) || usage("Warning threshold not specified\n");
my $warning = $1 if ($opt_w =~ /([0-9]{1,2}|100)+/);
($warning) || usage("Invalid warning threshold: $opt_w\n");

($opt_c) || ($opt_c = shift) || usage("Critical threshold not specified\n");
my $critical = $1 if ($opt_c =~ /([0-9]{1,2}|100)/);
($critical) || usage("Invalid critical threshold: $opt_c\n");

my $sig=0;
$sig = `/usr/bin/snmpget $host public .1.3.6.1.4.1.710.3.2.3.1.3.0`;
my @test=split(/ /,$sig);
$sig=$test[2];
$sig=int($sig);
if ($sig>100){$sig=100}

print "Signal Strength at: $sig%\n";

exit $ERRORS{'CRITICAL'} if ($sig<$critical);
exit $ERRORS{'WARNING'} if ($sig<$warning);
exit $ERRORS{'OK'};


sub print_usage () {
	print "Usage: $PROGNAME -H <host> -w <warn> -c <crit>\n";
}

sub print_help () {
	print_revision($PROGNAME,'$Revision: 1.3.2.1 $ ');
	print "Copyright (c) 2001 Jeffrey Blank/Karl DeBisschop

This plugin reports the signal strength of a Breezecom wireless equipment

";
	print_usage();
	print "
-H, --hostname=HOST
   Name or IP address of host to check
-w, --warning=INTEGER
   Percentage strength below which a WARNING status will result
-c, --critical=INTEGER
   Percentage strength below which a CRITICAL status will result

";
	support();
}

sub version () {
	print_revision($PROGNAME,'$Revision: 1.3.2.1 $ ');
	exit $ERRORS{'OK'};
}

sub help () {
	print_help();
	exit $ERRORS{'OK'};
}
