/*
 * OpenGatekeeper version setting utility
 * 
 * Copyright (c) Egoboo Ltd. 2000
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open Gatekeeper
 *
 * The Initial Developer of the Original Code is Egoboo Ltd.
 *
 * $Log: setver.cxx,v $
 * Revision 1.1  2000/05/02 16:37:25  aunitt
 * Utility used for help in creating tarballs
 *
 *
 */

#include <stdlib.h>
#include <fstream.h>
#include <ptlib.h>
#include <ptlib/pprocess.h>
#include "Version.h"

char * GetCodeStatusStr()
{
    switch( PProcess::GKVER_STATUS )
    {
        case PProcess::AlphaCode    :   return "alpha";
        case PProcess::BetaCode     :   return "beta";
        case PProcess::ReleaseCode  :   return "release";
        default                     :   return "unknown";
    }
}

int main(int argc, char *argv[])
{
    char VersionStr[80];

    if ( argc != 2 )
        return 1;

    sprintf( VersionStr,
             "%d.%d%s%d",
             GKVER_MAJOR,
             GKVER_MINOR,
             GetCodeStatusStr(),
             GKVER_BUILD
           );

    ofstream fout(argv[1]);

    if ( !fout )
        return 2;

    fout << "GKVER=" << VersionStr << endl;
    fout.close();
    return 0;
}