// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Define the opaque part to the LDAP-C-API
//
// - Automatic Version Information via RCS:
//   $Id: ldap-int.h,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/ldap-int.h,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef __LDAP_INT_H
#define __LDAP_INT_H "@(#) $Id: ldap-int.h,v 1.1 2001/12/17 16:36:17 nilsb Exp $"

#include <ptlib.h>
#include <ptlib/socket.h>
#include <ptclib/asner.h>
#include <vector>
#include <ldap_cdefs.h>
#include <ldap.h>

typedef struct ldaphostenty {
  PString hostname;
  int port;
} LDAP_Hostentry;

struct ldapoptions {
  short ldo_valid;
#define LDAP_UNINITIALIZED	0x0
#define LDAP_INITIALIZED	0x1
#define LDAP_VALID_SESSION	0x2
  
  //  int		ldo_debug;
  /* per API call timeout */
  struct timeval		*ldo_tm_api;
  struct timeval		*ldo_tm_net;
  
  int	ldo_version;
  int	ldo_deref;
  int	ldo_timelimit;
  int	ldo_sizelimit;

  vector<LDAP_Hostentry*>  ldo_hostlist;
 
  int	ldo_defport;
  char*	ldo_defbase;
  char*	ldo_defbinddn;	/* bind dn */
  
  
  int	ldo_refhoplimit;	/* limit on referral nesting */
  /* LDAPv3 server and client controls */
  LDAPControl **ldo_sctrls;
  LDAPControl **ldo_cctrls;

  //  LDAP_BOOLEANS ldo_booleans;	/* boolean options */
};

typedef struct ldapmsg {
  ldapmsg          *next;
  LDAP_LDAPMessage *message;
} LDAPMessage;

struct ldap {
#define hostlist   ld_options->ldo_hostlist
/*   PASN_Stream            *encoding_stream; */
  PSocket                *socket;
  int                     msg_id;
  int                     ld_version;
  int                     std_port;
  struct ldapoptions      *ld_options;
  PString                 ld_error;
  int                     ld_errno;
  PString                 ld_matched;
  vector<LDAPMessage *>   ld_messages;
};

#define LDAP_INT_GLOBAL_OPT() (&ldap_int_global_options)

LDAP_F(int) ldap_free LDAP_P((struct ldap *ld));

LDAP_F(struct ldap *) ldap_new LDAP_P(());

LDAP_F(void) ldap_int_initialize_global_options LDAP_P(( struct ldapoptions *gopts));

LDAP_F(void) ldap_int_initialize LDAP_P((struct ldapoptions *lo));

char * strndup(const char *, int);

#endif // __LDAP_INT_H
//
// End of ldap-int.h
//
