/***************************************************************************
                          kartei_debitor_apartner.cpp  -  description
                             -------------------
    begin                : Thu Nov 2 2000
    version              : $Id: kartei_debitor_apartner.cpp,v 1.5 2001/02/21 07:43:59 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmenubar.h>
#include <qstatusbar.h>
#include <qpopupmenu.h>
#include <qdialog.h>
#include <qmessagebox.h>

#include "kartei_debitor_apartner.h"
#include "qdbtableselect.h"
#include "buchen.h"

Kartei_Debitor_APartner::Kartei_Debitor_APartner(
				QWidget *parent, const char *name,
				SQLQuerier *sql_ptr, SQLTable *table_ptr,
				const char *tableName, SQLTable *tableRef )
	: QDBErfassung(parent,name,sql_ptr,table_ptr,tableName,false)
{
	sql = sql_ptr;
	table = table_ptr;

	// defaults
	Page1->Feldvorgabe[table->fNumber("nummer")]->append(
		tableRef->getValue( tableRef->pos, "nummer") );
	Page1->Feldvorgabe[table->fNumber("adress_art")]->append( "Debitor" );
	Page1->Feldvorgabe[table->fNumber("kom_art")]->append( "Tel" );

	// Special column headers
	//Page1->colName[table->fNumber("nummer")]->append( "Kd.-Nr." );
	//Page1->colSize[table->fNumber("nummer")] = 65;
	//Page1->colName[table->fNumber("adress_art")]->append( "Deb./Kred." );
	Page1->colName[table->fNumber("lfd_nr")]->append( "Lfd.-Nr." );
	Page1->colName[table->fNumber("kom_art")]->append( "Komm.-Art" );
	Page1->colName[table->fNumber("text")]->append( "Text" );
	Page1->colSize[table->fNumber("text")] = 170;
	Page1->colName[table->fNumber("name")]->append( "Name" );
	Page1->colSize[table->fNumber("name")] = 170;
	Page1->colName[table->fNumber("abteilung")]->append( "Abteilung" );
	Page1->colName[table->fNumber("status")]->append( "Status" );

	// Don't select the first 2 fields and activate colName's
	// and last field (status), because not important for the user.
	for (int i = 2; i < table->getnFields(); i++ ) {
		Page1->makeVisible( i );
		Page1->addCol( i );
	}

	QPopupMenu *fenster = new QPopupMenu( this );
	//fenster->insertItem( "Kladde &wechseln", this, SLOT(sKladdeWechselnClicked()) );

	menuBar()->insertItem( "&Fenster", fenster );
	//menuBar()->insertItem( "&Buchen", this, SLOT(sBuchenClicked()) );

	// to get a unique number (lfd_nr) for the tuple
	connect( Page1, SIGNAL(newTuple() ), SLOT(getLfdNr()) );

	setGeometry( x(), y(), 600, height() );
}

Kartei_Debitor_APartner::~Kartei_Debitor_APartner(){
}

void Kartei_Debitor_APartner::getLfdNr()
{
	QString s, value;

	// This should be change in the future.
	// Better -> get the highest lfd_nr from the tuples
	// and add a fixed value (like in Navision 10000) or
	// insert a number between two tuples.

	if (Page1->currentItem() != 0) {
		SQLTable *t = new SQLTable( "SELECT * FROM interne_daten" );
		t->execute();

		// read the next lfd_nr
		Page1->Feldvorgabe[table->fNumber("lfd_nr")]->truncate(0);
		Page1->Feldvorgabe[table->fNumber("lfd_nr")]->append(
			t->getValue( 0, t->fNumber("kk_zeilen_nr")));

		// Only for testing
		//QMessageBox::information( 0, "QtTudo Test",
			//Page1->Feldvorgabe[table->fNumber("lfd_nr")]->copy() );

		// Setting the number for the next accounting.
		s = "UPDATE interne_daten SET kk_zeilen_nr = ";
		value = t->getValue( 0, t->fNumber("kk_zeilen_nr"));
		value.setNum( value.toLong() + 1 );
		s.append( value );
		t = new SQLTable( s.ascii() );
	  if ( t->execute() != SUCCESS_NO_RESULTS ) {
			QMessageBox::warning( 0, "QtTudo Interne Daten", t->ErrorText );
		}
	}
}
