/* keymanager.c - Seahorse
 *
 * Copyright (C) 2000 Anthony Mulcahy
 * Copyright (C) 2000, 2001 Jos Carlos Garca Sogo <jsogo@arrakis.es>
 *
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gnome.h>

#include "gpg-interface.h"
#include "support.h"
#include "seahorse.h"
#include "seahorsesig.h"
#include "keymanager.h"

/**** Widgets shared between functions ***/

GtkWidget *changetrust;
GtkWidget *changepass;
GtkCTree *keylist;
GtkWidget *dialog;
GtkWidget *fs_dialog;

/****************************************/


/*** Internal variables ****/

guint *lsign;
gboolean recvkey_fromkeyserver = TRUE;
gboolean sendkey_tokeyserver = TRUE;
gboolean use_proxy = FALSE;

/****************************/

void
on_key_manager_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	keymanager_button_clicked (NULL, NULL);
}


void
keymanager_button_clicked (GtkButton * button, gpointer user_data)
{
  GtkCTree *KeyCTree;

  key_manager = create_key_manager ();
  keylist = (GtkCTree *) lookup_widget (key_manager, "ctree");
  KeyCTree = GTK_CTREE (keylist);
  KeyCTree->tree_indent = 8;
  KeyCTree->line_style = GTK_CTREE_LINES_DOTTED;

  display_keyring (KeyCTree);

  gtk_widget_show (key_manager);
}


void
display_keyring (GtkCTree * KeyCTree)
{
  guint key_cnt;
  gint i;
  Key *key;
 
  gtk_clist_freeze (GTK_CLIST (KeyCTree));
 
  MyKeyring = refresh_keyring (MyKeyring);

  if (keylist != NULL)
    {
      gtk_clist_clear (GTK_CLIST (keylist));
      on_ctree_tree_unselect_row (NULL, NULL, 0, NULL);
    }

  key_cnt = g_list_length (MyKeyring);

  for (i = 0; i < key_cnt; i++)
    {
      key = g_list_nth_data (MyKeyring, i);
      add_key_to_ctree (key, KeyCTree);
    }
    
  gtk_clist_thaw (GTK_CLIST (KeyCTree));
}

void
add_key_to_ctree (Key * key, GtkCTree * ctree)
{
  GtkCTreeNode *keynode;
  gchar *keydata[6];

  keydata[0] = key->UserID;
  keydata[1] = g_strdup_printf ("%i", key->bits);
  keydata[2] = key->KeyID;
  keydata[3] = algorithm_to_string (key->algorithm);
  keydata[4] = trust_to_string (key->KeyTrust);
  if (key->secret == 1)
    {
      keydata[5] = g_strdup (_("Key Pair"));
    }
  else
    keydata[5] = g_strdup (_("Public Key"));
  keynode =
    gtk_ctree_insert_node (GTK_CTREE (ctree), NULL, NULL, keydata, 0, NULL,
			   NULL, NULL, NULL, 0, 0);
  add_uids_to_ctreenode (key, GTK_CTREE_NODE (keynode), GTK_CTREE (ctree));
}

void
add_uids_to_ctreenode (Key * key, GtkCTreeNode * keynode, GtkCTree * ctree)
{
  GtkCTreeNode *uidnode;
  Uid *uiddata;
  gchar *uidstrings[6];
  gint uid_cnt;
  gint index;

  uidnode = NULL;
  uid_cnt = g_list_length (key->uids);

  for (index = 0; index < uid_cnt; index++)
    {
      uiddata = g_list_nth_data (key->uids, index);

      uidstrings[0] = uiddata->UserID;
      uidstrings[1] = NULL;
      uidstrings[2] = NULL;
      uidstrings[3] = NULL;
      uidstrings[4] = trust_to_string (uiddata->KeyTrust);
      uidstrings[5] = g_strdup (_("User ID"));

      uidnode =
	gtk_ctree_insert_node (GTK_CTREE (ctree), GTK_CTREE_NODE (keynode),
			       NULL, uidstrings, 0, NULL, NULL, NULL, NULL, 0,
			       0);

      add_sigs_to_ctreenode (uiddata, GTK_CTREE_NODE (uidnode),
			     GTK_CTREE (ctree));
    }
}

void
add_sigs_to_ctreenode (Uid * uid, GtkCTreeNode * uidnode, GtkCTree * ctree)
{
  Signature *sigdata;
  gchar *sigstrings[6];
  gint sig_cnt;
  gint index;
  GtkCTreeNode *signode = NULL;

  sig_cnt = g_list_length (uid->sigs);

  for (index = 0; index < sig_cnt; index++)
    {
      sigdata = g_list_nth_data (uid->sigs, index);

      sigstrings[0] = sigdata->UserID;
      sigstrings[1] = NULL;
      sigstrings[2] = sigdata->KeyID;
      sigstrings[3] = algorithm_to_string (sigdata->algorithm);
      sigstrings[4] = NULL;
      sigstrings[5] = g_strdup (_("Signature"));

      signode =
	gtk_ctree_insert_node (GTK_CTREE (ctree), GTK_CTREE_NODE (uidnode),
			       NULL, sigstrings, 0, NULL, NULL, NULL, NULL, 1,
			       0);
    }
}


void
on_ctree_tree_select_row (GtkCTree * ctree,
			  GList * node, gint column, gpointer user_data)
{
  GtkWidget *widget;
  gint type;


  type = keymanager_get_type_from_node ((GtkCTreeNode *) node);

  if (type == 1 || type == 0)
    {

      widget = lookup_widget (key_manager, "delkey_button");
      gtk_widget_set_sensitive (widget, TRUE);

      widget = lookup_widget (key_manager, "adduid_button");
      gtk_widget_set_sensitive (widget, TRUE);

      widget = lookup_widget (key_manager, "revoke_button");
      gtk_widget_set_sensitive (widget, TRUE);

      widget = lookup_widget (key_manager, "properties_button");
      gtk_widget_set_sensitive (widget, TRUE);

      widget = lookup_widget (key_manager, "exportkey_button");
      gtk_widget_set_sensitive (widget, TRUE);
    }

  if (type != 3)
    {
      widget = lookup_widget (key_manager, "sign_button");
      gtk_widget_set_sensitive (widget, TRUE);
    }

}				/* on_ctree_tree_select_row */


void
on_ctree_tree_unselect_row (GtkCTree * ctree,
			    GList * node, gint column, gpointer user_data)
{

  GtkWidget *widget;

  widget = lookup_widget (key_manager, "delkey_button");
  gtk_widget_set_sensitive (widget, FALSE);

  widget = lookup_widget (key_manager, "sign_button");
  gtk_widget_set_sensitive (widget, FALSE);

  widget = lookup_widget (key_manager, "adduid_button");
  gtk_widget_set_sensitive (widget, FALSE);

  widget = lookup_widget (key_manager, "revoke_button");
  gtk_widget_set_sensitive (widget, FALSE);

  widget = lookup_widget (key_manager, "exportkey_button");
  gtk_widget_set_sensitive (widget, FALSE);

  widget = lookup_widget (key_manager, "properties_button");
  gtk_widget_set_sensitive (widget, FALSE);

}				/* on_ctree_tree_unselect_row */



void
on_newkey_button_clicked (GtkButton * button, gpointer user_data)
{
  gen_key = create_gen_key();

  gtk_widget_show (gen_key);
}



/* This is a "selector" function.
* It chooses wich dialog we must show, depending on the
* type of selection.
* FIXME: We must enable the deluid and delsig dialogs
*/ 
void
on_delkey_button_clicked (GtkButton * button, gpointer user_data)
{
  GtkCTreeNode *node;
  gint type;

  node = keymanager_get_selected_node ();
  type = keymanager_get_type_from_node (node);

  if (type == 0 || type == 1)
    {
      dialog = create_delkey ();
    }
  else if (type == 2)
    {
//      dialog = create_deluid ();
	g_warning (_("Not implemented yet!"));
    }
  else if (type == 3)
    {
//      dialog = create_delsig ();
	g_warning (_("Not implemented yet!"));
    }

  if (type != 4)
    gtk_widget_show (dialog);

}



void
on_sign_button_clicked (GtkButton * button, gpointer user_data)
{
  dialog = create_signkey ();

  gtk_widget_show (dialog);

}				/* on_sign_button_clicked */




void
on_signkey_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_signkey_ok_clicked  (NULL, NULL);
}


void
on_signkey_ok_clicked (GtkButton * button, gpointer user_data)
{
  gchar *output;
  gchar *diagnostics;
  gchar *passphrase = "";
  gchar *keyid;
  gchar *uidname;
  gint result;
  GtkWidget *log_textbox;
  GtkWidget *passphrase_entry;
  GtkCTreeNode *node = NULL;
  GtkCTreeNode *keynode = NULL;
  gint type;
  gint uid_nr;
  Key *key;

  gtk_widget_hide (GTK_WIDGET (dialog));

  log_textbox = lookup_widget (main_win, "log_textbox");
  passphrase_entry = lookup_widget (dialog, "signkey_entry");

  if (check_entry (passphrase_entry, &passphrase))
    return;

  node = keymanager_get_selected_node ();
  type = keymanager_get_type_from_node (node);

  if (type == 2)
    {
     uidname = keymanager_get_username_from_node (node);
	
	keynode = GTK_CTREE_ROW(node)->parent;	
     /*keyid = keymanager_get_keyid_from_node (keynode);*/
     keyid = g_strdup (keymanager_get_keyid_from_node (keynode));
	key = keyring_get_key_with_keyid(MyKeyring, keyid);
	
     uid_nr = keyring_get_key_uid_position_with_userid (key, uidname);
    }
  else
    keyid = g_strdup (keymanager_get_keyid_from_node (node));


  /* We must change gpg_sign_key to edit only one uid */
  result = gpg_sign_key (keyid, passphrase, &output,
			 &diagnostics, log_textbox);

  gtk_widget_destroy (GTK_WIDGET (dialog));

  display_keyring (keylist);

  g_free (keyid);
}


void
on_adduid_button_clicked (GtkButton * button, gpointer user_data)
{
  dialog = create_adduid ();
  gtk_widget_show (dialog);
}


void
on_revoke_button_clicked (GtkButton * button, gpointer user_data)
{
  dialog = create_revokekey ();
  gtk_widget_show (dialog);
}


void
on_importkey_button_clicked (GtkButton * button, gpointer user_data)
{
  GtkCTreeNode *node = NULL;
  GtkWidget *keyid_entry;
  gchar *keyid;
  gint type;

  dialog = create_recvkey ();

  node = keymanager_get_selected_node ();
  type = keymanager_get_type_from_node (node);

  if (node != NULL)
    {
      keyid = g_strdup (keymanager_get_keyid_from_node (node));

      if (type != 2)
	{
	  keyid_entry = lookup_widget (dialog, "recvkey_keyid");
	  gtk_entry_set_text (GTK_ENTRY (keyid_entry), keyid);
	}
    }

  gtk_widget_show (dialog);

}


void
on_exportkey_button_clicked (GtkButton * button, gpointer user_data)
{
  GtkCTreeNode *node = NULL;
  GtkWidget *keyid_entry;
  gchar *keyid;


  dialog = create_sendkey ();

  node = keymanager_get_selected_node ();

  if (node != NULL)
    {
      keyid = g_strdup (keymanager_get_keyid_from_node (node));

      keyid_entry = lookup_widget (dialog, "sendkey_keyid");
      gtk_entry_set_text (GTK_ENTRY (keyid_entry), keyid);
    }

  gtk_widget_show (dialog);

}



void
on_properties_button_clicked (GtkButton * button, gpointer user_data)
{

  dialog = activate_keyproperties_dialog ();

  gtk_widget_show (dialog);

}


/********************  Key Properties Dialog *************** */
/* Functions related to this dialog and the ones it generates */


GtkWidget *
activate_keyproperties_dialog (void)
{
  GtkWidget *keyproperties_dialog;
  GtkCTreeNode *node = NULL;
  GtkWidget *widget = NULL;
  GtkWidget *subkeyclist;
  gchar *keyid;
  gchar *date;
  gchar *subkey_data[3];
  gchar *size;
  gint subkey_cnt;
  gint i;
  gint trustvalue;
  Key *key;
  SubKey *subkey;

  keyproperties_dialog = create_keyproperties_dialog ();

  node = keymanager_get_selected_node ();
  keyid = g_strdup (keymanager_get_keyid_from_node (node));
  key = keyring_get_key_with_keyid (MyKeyring, keyid);

  widget = lookup_widget (keyproperties_dialog, "userid_entry");
  gtk_entry_set_text (GTK_ENTRY(widget), key->UserID);

  widget = lookup_widget (keyproperties_dialog, "keyid_entry");
  gtk_entry_set_text (GTK_ENTRY(widget), key->KeyID);

  widget = lookup_widget (keyproperties_dialog, "created_entry");
  date = g_malloc (10);
  g_date_strftime (date, 10, "%x", key->CreationDate);
  gtk_entry_set_text (GTK_ENTRY (widget), date);


  widget = lookup_widget (keyproperties_dialog, "expdate_entry");
  if (key->ExpirationDate != NULL)
    {
      g_date_strftime (date, 10, "%s", key->ExpirationDate);
      gnome_date_edit_set_time (GNOME_DATE_EDIT(widget), atoi (date));
    }
  /* It should say *never* if there isn't expiration date
   * but gnome_date_edit widget doesn't allow this. */
  g_free (date);

  widget = lookup_widget (keyproperties_dialog, "size_entry");
  size = g_strdup_printf ("%i", key->bits);
  gtk_entry_set_text (GTK_ENTRY(widget), size);


  widget = lookup_widget (keyproperties_dialog, "fingerprint_entry");
  gtk_entry_set_text (GTK_ENTRY(widget), key->fpr);

  widget = lookup_widget (keyproperties_dialog, "keytrust_progressbar");
  trustvalue = trust_to_int (key->OwnerTrust);
  gtk_progress_set_value (GTK_PROGRESS (widget), trustvalue);

  /* If key algorith is RSA, the key doesn't have subkeys */
  if (key->algorithm == 1)
    {
      widget = lookup_widget (keyproperties_dialog, "notebook");
      gtk_notebook_remove_page (GTK_NOTEBOOK (widget), 1);
      return (keyproperties_dialog);
    }

  subkey_cnt = g_list_length (key->subs);
  subkeyclist = lookup_widget (keyproperties_dialog, "subkey_clist");
  for (i = 0; i < subkey_cnt; i++)
    {
      subkey = g_list_nth_data (key->subs, i);
      subkey_data[0] = g_malloc (10);
      g_date_strftime (subkey_data[0], 10, "%x", subkey->CreationDate);

      if (subkey->ExpirationDate != NULL)
	{
	  subkey_data[1] = g_malloc (10);
	  g_date_strftime (subkey_data[1], 10, "%x", subkey->ExpirationDate);
	}
     else
      subkey_data[1] = g_strdup (_("Never"));

      subkey_data[2] = g_strdup_printf ("%i", subkey->bits);

      gtk_clist_append (GTK_CLIST (subkeyclist), subkey_data);
      g_free (subkey_data[0]);
      g_free (subkey_data[1]);
      g_free (subkey_data[2]);
    }

  return (keyproperties_dialog);
}


void
on_changepass_button_clicked (GtkButton * button, gpointer user_data)
{
  changepass = create_changepass_dialog ();
  gtk_widget_show (changepass);
}


void
on_ownertrust_button_clicked (GtkButton * button, gpointer user_data)
{

  GtkWidget *trustlevel_indicator;
  GtkWidget *dontknow_btn, *donottrust_btn;
  GtkWidget *trustmarginally_btn, *trustfully_btn;
  gint trustlevel;
  gchar *keyid;
  GtkCTreeNode *node;
  Key *key;

  node = keymanager_get_selected_node ();
  keyid = keymanager_get_keyid_from_node (node);
  key = keyring_get_key_with_keyid(MyKeyring, keyid);
  trustlevel = trust_to_int (key->OwnerTrust);  

  changetrust = create_changetrust ();
  trustlevel_indicator = lookup_widget (changetrust, "trustlevel_indicator");
  if (trustlevel == 0)
   trustlevel++;

  gtk_progress_configure (GTK_PROGRESS (trustlevel_indicator),
			  trustlevel, 0, 10);

  
  dontknow_btn = lookup_widget (changetrust, "dontknow_btn");
  donottrust_btn = lookup_widget (changetrust, "donottrust_btn");
  trustmarginally_btn = lookup_widget (changetrust, "trustmarginally_btn");
  trustfully_btn = lookup_widget (changetrust, "trustfully_btn");
  
  if (trustlevel == 10)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (trustfully_btn), TRUE);
  else if (trustlevel == 5)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (trustmarginally_btn),
				  TRUE);
  else if (trustlevel == 0 || trustlevel == 1)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (dontknow_btn), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (donottrust_btn), TRUE);

  gtk_widget_show (changetrust);

}

void
on_trustgrp_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *dontknow_btn, *donottrust_btn;
	GtkWidget *trustmarginally_btn, *trustfully_btn;
	GtkWidget *trustlevel_indicator;
	gint trustlevel;

	dontknow_btn = lookup_widget (changetrust, "dontknow_btn");
	donottrust_btn = lookup_widget (changetrust, "donottrust_btn");
	trustmarginally_btn = lookup_widget (changetrust, 
			"trustmarginally_btn");
	trustfully_btn = lookup_widget (changetrust, "trustfully_btn");

	if (GTK_TOGGLE_BUTTON (trustfully_btn)->active)
		trustlevel = 10;
	else if (GTK_TOGGLE_BUTTON (trustmarginally_btn)->active)
		trustlevel = 5;
	else if (GTK_TOGGLE_BUTTON (dontknow_btn)->active)
		trustlevel = 1;
	else trustlevel = 0;

  	trustlevel_indicator = lookup_widget (changetrust,
			"trustlevel_indicator");
	gtk_progress_configure (GTK_PROGRESS (trustlevel_indicator),
			trustlevel, 0, 10);

}


void
on_changetrust_cancel_clicked (GtkButton * button, gpointer user_data)
{
  gtk_widget_destroy (changetrust);
}


void
on_changetrust_ok_clicked (GtkButton * button, gpointer user_data)
{
  gchar *output;
  gchar *diagnostics;
  gint result;
  gint trustlevel;
  GtkWidget *log_textbox;
  GtkWidget *level;
  GtkCTreeNode *node;
  gchar *keyid;
  
  log_textbox = lookup_widget (main_win, "log_textbox");
  level = lookup_widget (changetrust, "trustlevel_indicator");
  trustlevel = gtk_progress_get_value (GTK_PROGRESS(level));
  
  node = keymanager_get_selected_node ();
  keyid = keymanager_get_keyid_from_node (node);

  result = gpg_change_trust (keyid, trustlevel, &output,
		    			 &diagnostics, log_textbox);
 
  // FIXME: We should check result, and reload keytrust_level widget
  // on keyproperties_dialog, if it's necessary.
  gtk_widget_destroy (changetrust);

  display_keyring (keylist);
}



void
on_properties_ok_clicked (GtkButton * button, gpointer user_data)
{

}


/* ********************************************************* */



/* **** del[key,uid,sig] dialogs ******* */
void
on_delkey_ok_clicked (GtkButton * button, gpointer user_data)
{
  gchar *output;
  gchar *diagnostics;
  gint result;
  GtkWidget *log_textbox;
  GtkCTreeNode *node;
  gchar *keyid;
  gint type;


  gtk_widget_hide (GTK_WIDGET (dialog));
  log_textbox = lookup_widget (main_win, "log_textbox");

  node = keymanager_get_selected_node ();
  keyid = g_strdup (keymanager_get_keyid_from_node (node));

  type = keymanager_get_type_from_node (node);

  if (type == 1)
    {
      result = gpg_delete_pubkey (keyid, &output, &diagnostics, log_textbox);
    }
  else if (type == 0)
    {
      result = gpg_delete_seckey (keyid, &output, &diagnostics, log_textbox);
    }

  /* FIXME: We should take care about what is in result */

  gtk_widget_destroy (GTK_WIDGET (dialog));

  display_keyring (keylist);
}



void
on_deluid_ok_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *log_textbox;
  GtkCTreeNode *uidnode;
  GtkCTreeNode *keynode;
  /*gchar *output;
  gchar *diagnostics;*/
  gint result;
  gchar *keyid;
  gchar *username;
  gint uid_pos;
  Key *key;

  gtk_widget_hide (dialog);
  log_textbox = lookup_widget (main_win, "log_textbox");

  uidnode = keymanager_get_selected_node ();
  username = keymanager_get_username_from_node (uidnode);

  keynode = GTK_CTREE_ROW (uidnode)->parent;
  keyid = keymanager_get_keyid_from_node (keynode);

  key = keyring_get_key_with_keyid (MyKeyring, keyid);

  uid_pos = keyring_get_key_uid_position_with_userid (key, username);

  // FIXME: 2nd parameter of gpg_delete_uid is a char*
  //result =
  //  gpg_delete_uid (keyid, uid_pos, &output, &diagnostics, log_textbox);

  if (result == 0)
    {
    }
  else;

  gtk_widget_destroy (GTK_WIDGET (dialog));
  display_keyring (keylist);
}


void
on_delsig_ok_clicked (GtkButton * button, gpointer user_data)
{
  GtkWidget *log_textbox;
  GtkCTreeNode *signode = NULL;
  GtkCTreeNode *uidnode = NULL;
  GtkCTreeNode *keynode = NULL;
  /*gchar *output;
  gchar *diagnostics;*/
  gint result;
  gchar *keyid;
  gchar *username = NULL;
  gint uid_pos;
  Key *key;

  gtk_widget_hide (GTK_WIDGET (dialog));
  log_textbox = lookup_widget (main_win, "log_textbox");

  signode = keymanager_get_selected_node ();

  uidnode = GTK_CTREE_ROW (signode)->parent;

  keynode = GTK_CTREE_ROW (uidnode)->parent;

  keyid = keymanager_get_keyid_from_node (keynode);

  key = keyring_get_key_with_keyid (MyKeyring, keyid);

  uid_pos = keyring_get_key_uid_position_with_userid (key, username);


/* FIXME: here goes a gpg_delete_sig function */
//      result = gpg_delete_uid (keyid, uid_pos,
//                      &output, &diagnostics, log_textbox); 

  if (result == 0)
    {
    }
  else;

  gtk_widget_destroy (GTK_WIDGET (dialog));
  display_keyring (keylist);
}


/* ****************************************************** */



/* ****************** Add UID Dialog ******************** */
void
on_adduidentry_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_adduid_ok_clicked (NULL, NULL);
}


void
on_adduid_ok_clicked (GtkButton * button, gpointer user_data)
{
  gchar *name;
  gchar *email;
  gchar *comment;
  gchar *password;
  gchar *keyid;
  gchar *diagnostics;
  gchar *output;
  gint result;
  GtkCTreeNode *node;
  GtkWidget *widget;
  GtkWidget *log_textbox;

  node = keymanager_get_selected_node ();
  keyid = keymanager_get_keyid_from_node (node);

  log_textbox = lookup_widget (main_win, "log_textbox");

  widget = lookup_widget (dialog, "name_entry");
  if (check_entry (widget, &name))
    return;

  widget = lookup_widget (dialog, "email_entry");
  if (check_entry (widget, &email))
    return;

  widget = lookup_widget (dialog, "comment_entry");
  if (check_entry (widget, &comment))
    return;

  widget = lookup_widget (dialog, "passphrase_entry");
  if (check_entry (widget, &password))
    return;

  output = NULL;
  diagnostics = NULL;
  result = gpg_add_uid (keyid, name, email, comment, password,
			&output, &diagnostics, log_textbox);

  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, output, -1);
  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, "----\n", -1);
  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, diagnostics, -1);

  gtk_widget_destroy (dialog);
  display_keyring (keylist);

  if (result == 0)
    {
    }
  else;
}

/* ****************************************************** */



/* **************** Revoke Key Dialog ******************* */

void
on_revokekey_activate                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_revokekey_ok_clicked (NULL, NULL);
}


void
on_revokekey_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *output;
	gchar *diagnostics;
	gchar *passphrase = "";
	gint result;
	gchar *keyid;
  	GtkWidget *log_textbox;
  	GtkWidget *passphrase_entry;
	GtkCTreeNode *node;
	
 	gtk_widget_hide (dialog);
  	log_textbox = get_widget (main_win, "log_textbox");
	
	node = keymanager_get_selected_node ();
	keyid = keymanager_get_keyid_from_node (node);
	
  	passphrase_entry = lookup_widget (dialog, 
				       "revokekey_passphrase");
	if (check_entry (passphrase_entry, &passphrase))
		return;

	result = gpg_revoke_key (keyid, passphrase, &output,
			&diagnostics, log_textbox); 
  	gtk_widget_destroy (dialog);

	if (result == 0) {
	}
	else ;
}


/* ****************************************************** */




/* *************  Import & Export Dialogs *************** */


void
on_recvkey_server_radiobtn_toggled (GtkToggleButton * togglebutton,
				    gpointer user_data)
{

}


void
on_recvkey_file_radiobtn_toggled (GtkToggleButton * togglebutton,
				  gpointer user_data)
{
  GtkWidget *widget;

  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      recvkey_fromkeyserver = FALSE;
      widget = lookup_widget (dialog, "recvkey_keyserver");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "recvkey_useproxybtn");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "recvkey_keyid");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "recvkey_keyfile");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "recvkey_select_file");
      gtk_widget_set_sensitive (widget, TRUE);
    }
  else
    {
      recvkey_fromkeyserver = TRUE;
      widget = lookup_widget (dialog, "recvkey_keyserver");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "recvkey_useproxybtn");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "recvkey_keyid");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "recvkey_keyfile");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "recvkey_select_file");
      gtk_widget_set_sensitive (widget, FALSE);
    }
}



void
on_sendkey_server_radiobtn_toggled (GtkToggleButton * togglebutton,
				    gpointer user_data)
{

}


void
on_sendkey_file_radiobtn_toggled (GtkToggleButton * togglebutton,
				  gpointer user_data)
{
  GtkWidget *widget;

  if (GTK_TOGGLE_BUTTON (togglebutton)->active)
    {
      sendkey_tokeyserver = FALSE;
      widget = lookup_widget (dialog, "sendkey_keyserver");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "sendkey_useproxybtn");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "sendkey_keyfile");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "sendkey_select_file");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "ascii_arm_btn");
      gtk_widget_set_sensitive (widget, TRUE);
    }
  else
    {
      sendkey_tokeyserver = TRUE;
      widget = lookup_widget (dialog, "sendkey_keyserver");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "sendkey_useproxybtn");
      gtk_widget_set_sensitive (widget, TRUE);
      widget = lookup_widget (dialog, "sendkey_keyfile");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "sendkey_select_file");
      gtk_widget_set_sensitive (widget, FALSE);
      widget = lookup_widget (dialog, "ascii_arm_btn");
      gtk_widget_set_sensitive (widget, FALSE);

    }
}


void
on_sendkey_ok_button_clicked (GtkButton * button, gpointer user_data)
{
  gchar keyid[17];
  gchar *keyid_buf;
  gchar *keyserver;
  gchar *output;
  gchar *diagnostics;
  gchar *sendkey_keyfilename;
  gint result;
  gboolean proxy;
  gboolean ascii_arm;
  GtkWidget *key_file;
  GtkWidget *key_id;
  GtkWidget *key_server;
  GtkWidget *log_textbox;
  GtkWidget *proxy_btn;
  GtkWidget *ascii_arm_btn;


  log_textbox = lookup_widget (main_win, "log_textbox");

  key_id = get_widget (dialog, "sendkey_keyid");
  if (check_entry (key_id, &keyid_buf))
    return;
  strncpy (keyid, keyid_buf, 16);
  keyid[16] = '\0';

  if (sendkey_tokeyserver)
    {
      key_server = get_widget (dialog, "sendkey_keyserver");
      if (check_entry (key_server, &keyserver))
	return;

      proxy_btn = lookup_widget (dialog, "sendkey_useproxybtn");
      proxy = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (proxy_btn));

      result = gpg_send_key (keyserver, keyid, proxy, &output, &diagnostics);
    }
  else
    {
      key_file = get_widget (dialog, "sendkey_keyfile");
      if (check_entry (key_file, &sendkey_keyfilename))
	return;

      ascii_arm_btn = lookup_widget (dialog, "ascii_arm_btn");
      ascii_arm =
	gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ascii_arm_btn));

      result = gpg_export_key (sendkey_keyfilename, keyid,
			       ascii_arm, &output, &diagnostics);
    }
  gtk_widget_destroy (dialog);

  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, output, -1);
  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, "----\n", -1);
  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, diagnostics, -1);
  g_free (output);
  g_free (diagnostics);

  if (result == 0)
    {
    }
  else;
}


void
on_recvkey_ok_button_clicked (GtkButton * button, gpointer user_data)
{
  gchar *keyserver;
  gchar *output;
  gchar *diagnostics;
  gchar *recvkey_keyid;
  gchar *recvkey_keyfilename;
  gint result;
  gboolean use_proxy;
  GtkWidget *key_id;
  GtkWidget *key_file;
  GtkWidget *key_server;
  GtkWidget *log_textbox;
  GtkWidget *use_proxybtn;


  log_textbox = lookup_widget (main_win, "log_textbox");


  if (recvkey_fromkeyserver)
    {
      key_server = lookup_widget (dialog, "recvkey_keyserver");
      if (check_entry (key_server, &keyserver))
	return;

      key_id = lookup_widget (dialog, "recvkey_keyid");
      if (check_entry (key_id, &recvkey_keyid))
	return;

      use_proxybtn = lookup_widget (dialog, "recvkey_useproxybtn");
      use_proxy =
	gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (use_proxybtn));

      result = gpg_recv_key (keyserver, recvkey_keyid,
			     use_proxy, &output, &diagnostics);
    }
  else
    {
      key_file = get_widget (dialog, "recvkey_keyfile");
      if (check_entry (key_file, &recvkey_keyfilename))
	return;

      result = gpg_import_key (recvkey_keyfilename, &output, &diagnostics);
    }

  gtk_widget_destroy (dialog);

  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, output, -1);
  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, "----\n", -1);
  gtk_text_insert (GTK_TEXT (log_textbox), NULL, NULL, NULL, diagnostics, -1);
  g_free (output);
  g_free (diagnostics);

  if (result == 0)
    {
    }
  else;
}


void
on_recvkey_select_file_browse_clicked (GnomeFileEntry * gnomefileentry,
				       gpointer user_data)
{
  fs_dialog = create_recvkey_fs ();
}


void
on_sendkey_select_file_browse_clicked (GnomeFileEntry * gnomefileentry,
				       gpointer user_data)
{
  fs_dialog = create_sendkey_fs ();
}

/* ****************************************************** */



/* ***************** Keymanager Functions  ************** */
GtkCTreeNode *
keymanager_get_selected_node (void)
{
  GtkCTreeNode *node = NULL;
  GList *list;

  list = GTK_CLIST (keylist)->selection;
  if (list != NULL)
    node = GTK_CTREE_NODE (list->data);

  return node;
}


gchar *
keymanager_get_keyid_from_node (GtkCTreeNode * node)
{
  gchar *data;

  if (node != NULL)
    gtk_ctree_node_get_text (GTK_CTREE (keylist), node, 2, &data);

  return data;
}


gint keymanager_get_type_from_node (GtkCTreeNode * node)
{
  gchar *data;

  if (node != NULL)
    {
      gtk_ctree_node_get_text (GTK_CTREE (keylist), node, 5, &data);

      if (!strcmp (data, _("Key Pair")))
	{
	  return 0;
	}
      else if (!strcmp (data, _("Public Key")))
	{
	  return 1;
	}
      else if (!strcmp (data, _("User ID")))
	{
	  return 2;
	}
      else if (!strcmp (data, _("Signature")))
	{
	  return 3;
	}
      else
	return 4;
    }
  else
    return 4;
}

gchar *
keymanager_get_username_from_node (GtkCTreeNode * node)
{
  gchar *data;

  if (node != NULL)
    /* We can not use this function. It doesn't works on column 0.
     * gtk_ctree_node_get_text (keylist, node, 0, data);
     *
     * Instead we use this one (more generic) */

    gtk_ctree_get_node_info (GTK_CTREE (keylist), node, &data,
			     NULL, NULL, NULL, NULL, NULL, NULL, NULL);

  return data;
}

/* Callback for new key dialog */
void
on_genkey_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	char	*keytype;
	char	*realname;
	char	*email;
	char	*comment;
	char	*passphrase;
	int result;
  	GtkWidget *keytype_txtbx;
  	GtkWidget *realname_txtbx;
  	GtkWidget *email_txtbx;
  	GtkWidget *comment_txtbx;
  	GtkWidget *passphrase_txtbx;
  	GtkWidget *log_textbox;


  	log_textbox = get_widget (main_win, "log_textbox");

  	keytype_txtbx = get_widget (gen_key, "keytype_txtbx");
	if (check_entry (keytype_txtbx, &keytype))
		return;

  	realname_txtbx = get_widget (gen_key, "realname_txtbx");
	if (check_entry (realname_txtbx, &realname))
		return;
	
  	email_txtbx = get_widget (gen_key, "email_txtbx");
	if (check_entry (email_txtbx, &email))
		return;
	
  	comment_txtbx = get_widget (gen_key, "comment_txtbx");
	if (check_entry (comment_txtbx, &comment))
		return;
	
  	passphrase_txtbx = get_widget (gen_key, "passphrase_txtbx");
	if (check_entry (passphrase_txtbx, &passphrase))
		return;
	
  	gtk_widget_hide (gen_key);
	result = gpg_gen_key (keytype, 1024, 0, realname, email,
			      comment, passphrase, log_textbox);
  	gtk_widget_destroy (gen_key);

	if (result == 0) {
	}
	else ;

  	display_keyring (keylist);
}

