/* $Id: sfskeyhostid.C,v 1.6 2000/03/20 02:41:36 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "sfskey.h"

void
hostidprint (bool secure, ptr<sfscon> sc, str err)
{
  if (!sc) {
    warn << err << "\n";
    exit (1);
  }
  if (!secure)
    warnx << "WARNING: RETRIEVING HOSTID INSECURELY OVER THE NETWORK\n";
  err_flush ();
  strbuf msg;
  msg << sc->path << "\n";
  make_sync (1);
  msg.tosuio ()->output (1);
  exit (0);
}

void
sfskey_hostid (int argc, char **argv)
{
  if (getopt (argc, argv, "") != -1 || optind + 1 != argc)
    usage ();
  sfs_connectarg carg;
  carg.release = sfs_release;
  carg.name = argv[optind];
  carg.service = carg.name == "-" ? SFS_AUTHSERV : SFS_SFS;
  sfs_connect (carg, wrap (hostidprint, carg.name == "-"), false, false);
}
