
#!/usr/local/bin/perl

$prog="bf586.pl";

# base code is in microsft
# op dest, source
# format.
#

if (	($ARGV[0] eq "elf"))
	{ require "x86unix.pl"; }
elsif (	($ARGV[0] eq "a.out"))
	{ $aout=1; require "x86unix.pl"; }
elsif (	($ARGV[0] eq "sol"))
	{ $sol=1; require "x86unix.pl"; }
elsif (	($ARGV[0] eq "cpp"))
	{ $cpp=1; require "x86unix.pl"; }
elsif (	($ARGV[0] eq "win32"))
	{ require "x86ms.pl"; }
else
	{
	print STDERR <<"EOF";
Pick one target type from
	elf	- linux, FreeBSD etc
	a.out	- old linux
	sol	- x86 solaris
	cpp	- format so x86unix.cpp can be used
	win32	- Windows 95/Windows NT
EOF
	exit(1);
	}

&comment("Don't even think of reading this code");
&comment("It was automatically generated by $prog");
&comment("Which is a perl program used to generate the x86 assember for");
&comment("any of elf, a.out, Win32, or Solaris");
&comment("It can be found in SSLeay 0.7.0+");
&comment("eric <eay\@mincom.oz.au>");
&comment("");

&file("bfx86xxxx");

$BF_ROUNDS=16;
$BF_OFF=($BF_ROUNDS+2)*4;
$L="ecx";
$R="edx";
$P="edi";
$tot="esi";
$tmp1="eax";
$tmp2="ebx";
$tmp3="ebp";

&des_encrypt("BF_encrypt");

&file_end();

sub des_encrypt
	{
	local($name)=@_;

	&function_begin($name,3);

	&comment("");
	&comment("Load the 2 words");
	&mov("eax",&wparam(0));
	&mov($L,&DWP(0,"eax","",0));
	&mov($R,&DWP(4,"eax","",0));

	&comment("");
	&comment("P pointer, s and enc flag");
	&mov($P,&wparam(1));

	&xor(	$tmp1,	$tmp1);
	&xor(	$tmp2,	$tmp2);

	# encrypting part

	&mov("ebp",&wparam(2));	# get encrypt flag
	&cmp("ebp","0");
	&je(&label("start_decrypt"));

	&xor($L,&DWP(0,$P,"",0));
	for ($i=0; $i<$BF_ROUNDS; $i+=2)
		{
		&comment("");
		&comment("Round $i");
		&BF_ENCRYPT($i+1,$R,$L,$P,$tot,$tmp1,$tmp2,$tmp3);

		&comment("");
		&comment("Round ".sprintf("%d",$i+1));
		&BF_ENCRYPT($i+2,$L,$R,$P,$tot,$tmp1,$tmp2,$tmp3);
		}
	&xor($R,&DWP(($BF_ROUNDS+1)*4,$P,"",0));

	&mov("eax",&wparam(0));
	&mov(&DWP(0,"eax","",0),$R);
	&mov(&DWP(4,"eax","",0),$L);
	&function_end_A($name);

	&set_label("start_decrypt");

	&xor($L,&DWP(($BF_ROUNDS+1)*4,$P,"",0));
	for ($i=$BF_ROUNDS; $i>0; $i-=2)
		{
		&comment("");
		&comment("Round $i");
		&BF_ENCRYPT($i,$R,$L,$P,$tot,$tmp1,$tmp2,$tmp3);
		&comment("");
		&comment("Round ".sprintf("%d",$i-1));
		&BF_ENCRYPT($i-1,$L,$R,$P,$tot,$tmp1,$tmp2,$tmp3);
		}
	&xor($R,&DWP(0,$P,"",0));

	&mov("eax",&wparam(0));
	&mov(&DWP(0,"eax","",0),$R);
	&mov(&DWP(4,"eax","",0),$L);
	&function_end_A($name);

	&function_end_B($name);
	}

sub BF_ENCRYPT
	{
	local($i,$L,$R,$P,$tot,$tmp1,$tmp2,$tmp3)=@_;

	&rotr(	$R,		16);
	&mov(	$tot,		&DWP(&n2a($i*4),$P,"",0));

	&movb(	&LB($tmp1),	&HB($R));
	&movb(	&LB($tmp2),	&LB($R));

	&rotr(	$R,		16);
	&xor(	$L,		$tot);

	&mov(	$tot,		&DWP(&n2a($BF_OFF+0x0000),$P,$tmp1,4));
	&mov(	$tmp3,		&DWP(&n2a($BF_OFF+0x0400),$P,$tmp2,4));

	&movb(	&LB($tmp1),	&HB($R));
	&movb(	&LB($tmp2),	&LB($R));

	&add(	$tot,		$tmp3);
	&mov(	$tmp1,		&DWP(&n2a($BF_OFF+0x0800),$P,$tmp1,4)); # delay

	&xor(	$tot,		$tmp1);
	&mov(	$tmp3,		&DWP(&n2a($BF_OFF+0x0C00),$P,$tmp2,4));

	&add(	$tot,		$tmp3);
	&xor(	$tmp1,		$tmp1);

	&xor(	$L,		$tot);					
	# delay
	}

sub n2a
	{
	sprintf("%d",$_[0]);
	}

