/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Color
implements Codable {
    java.awt.Color _color = java.awt.Color.white;
    public static final Color red = new Color(255, 0, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color blue = new Color(0, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color orange = new Color(255, 200, 0);
    public static final Color pink = new Color(255, 175, 175);
    public static final Color white = new Color(255, 255, 255);
    public static final Color lightGray = new Color(192, 192, 192);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color darkGray = new Color(64, 64, 64);
    public static final Color black = new Color(0, 0, 0);
    static final Color gray192 = lightGray;
    static final Color gray128 = gray;
    static final Color gray231 = new Color(231, 231, 231);
    static final Color gray204 = new Color(204, 204, 204);
    static final Color gray153 = new Color(153, 153, 153);
    static final Color gray102 = new Color(102, 102, 102);
    static final Color gray51 = new Color(51, 51, 51);
    static final Color gray160 = new Color(160, 160, 164);
    static final Color gray255 = new Color(255, 251, 240);
    static final String R_KEY = "r";
    static final String G_KEY = "g";
    static final String B_KEY = "b";
    private static Class colorClass;
    public static final String COLOR_TYPE = "netscape.application.Color";

    private static Class colorClass() {
        if (colorClass == null) {
            colorClass = black.getClass();
        }
        return colorClass;
    }

    public static int rgbForHSB(float f, float f2, float f3) {
        return java.awt.Color.HSBtoRGB(f, f2, f3);
    }

    public static Color colorForHSB(float f, float f2, float f3) {
        return new Color(Color.rgbForHSB(f, f2, f3));
    }

    public Color() {
    }

    public Color(int n, int n2, int n3) {
        this();
        this._color = new java.awt.Color(n, n2, n3);
    }

    public Color(int n) {
        this();
        this._color = new java.awt.Color(n);
    }

    public Color(float f, float f2, float f3) {
        this();
        if ((double)f < 0.0) {
            f = 0.0f;
        }
        if ((double)f > 1.0) {
            f = 1.0f;
        }
        if ((double)f2 < 0.0) {
            f2 = 0.0f;
        }
        if ((double)f2 > 1.0) {
            f2 = 1.0f;
        }
        if ((double)f3 < 0.0) {
            f3 = 0.0f;
        }
        if ((double)f3 > 1.0) {
            f3 = 1.0f;
        }
        this._color = new java.awt.Color(f, f2, f3);
    }

    Color(java.awt.Color color) {
        this();
        this._color = color;
    }

    public int red() {
        return this._color.getRed();
    }

    public int green() {
        return this._color.getGreen();
    }

    public int blue() {
        return this._color.getBlue();
    }

    public int rgb() {
        return this._color.getRGB();
    }

    public int hashCode() {
        return this._color.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            return this._color.equals(color.awtColor());
        }
        if (object instanceof java.awt.Color) {
            return this._color.equals((java.awt.Color)object);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " (" + this.red() + ", " + this.green() + ", " + this.blue() + ")";
    }

    java.awt.Color awtColor() {
        return this._color;
    }

    public Color lighterColor() {
        int n;
        int n2;
        if (this == lightGray) {
            return white;
        }
        int n3 = 256 * this.red() / 192;
        if (n3 > 255) {
            n3 = 255;
        }
        if ((n2 = 256 * this.green() / 192) > 255) {
            n2 = 255;
        }
        if ((n = 256 * this.blue() / 192) > 255) {
            n = 255;
        }
        return new Color(n3, n2, n);
    }

    public Color darkerColor() {
        if (this == lightGray) {
            return gray;
        }
        int n = 128 * this.red() / 192;
        int n2 = 128 * this.green() / 192;
        int n3 = 128 * this.blue() / 192;
        return new Color(n, n2, n3);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass(COLOR_TYPE, 1);
        classInfo.addField(R_KEY, (byte)4);
        classInfo.addField(G_KEY, (byte)4);
        classInfo.addField(B_KEY, (byte)4);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeByte(R_KEY, (byte)this.red());
        encoder.encodeByte(G_KEY, (byte)this.green());
        encoder.encodeByte(B_KEY, (byte)this.blue());
    }

    public void decode(Decoder decoder) throws CodingException {
        int n = decoder.decodeByte(R_KEY) & 0xFF;
        int n2 = decoder.decodeByte(G_KEY) & 0xFF;
        int n3 = decoder.decodeByte(B_KEY) & 0xFF;
        if (this.getClass() == Color.colorClass()) {
            if (n == 0) {
                if (n2 == 0) {
                    if (n3 == 0) {
                        decoder.replaceObject((Object)black);
                        return;
                    }
                    if (n3 == 255) {
                        decoder.replaceObject((Object)blue);
                        return;
                    }
                } else if (n2 == 255) {
                    if (n3 == 0) {
                        decoder.replaceObject((Object)green);
                        return;
                    }
                    if (n3 == 255) {
                        decoder.replaceObject((Object)cyan);
                        return;
                    }
                }
            } else if (n == 255) {
                if (n2 == 255) {
                    if (n3 == 255) {
                        decoder.replaceObject((Object)white);
                        return;
                    }
                    if (n3 == 0) {
                        decoder.replaceObject((Object)yellow);
                        return;
                    }
                } else if (n2 == 0) {
                    if (n3 == 0) {
                        decoder.replaceObject((Object)red);
                        return;
                    }
                    if (n3 == 255) {
                        decoder.replaceObject((Object)magenta);
                        return;
                    }
                }
            } else if (n == 192) {
                if (n2 == 192 && n3 == 192) {
                    decoder.replaceObject((Object)lightGray);
                    return;
                }
            } else if (n == 128) {
                if (n2 == 128 && n3 == 128) {
                    decoder.replaceObject((Object)gray);
                    return;
                }
            } else if (n == 64 && n2 == 64 && n3 == 64) {
                decoder.replaceObject((Object)darkGray);
                return;
            }
        }
        this._color = new java.awt.Color(n, n2, n3);
    }

    public void finishDecoding() throws CodingException {
    }
}

