/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        this.inf = inflater;
        this.buf = new byte[n];
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater());
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        try {
            int n3;
            while ((n3 = this.inf.inflate(byArray, n, n2)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    return -1;
                }
                if (!this.inf.needsInput()) continue;
                this.fill();
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            throw new ZipException(string != null ? string : "Invalid ZLIB data format");
        }
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[512];
        long l2 = 0L;
        while (l2 < l) {
            long l3 = l - l2;
            l3 = this.read(byArray, 0, l3 < (long)byArray.length ? (int)l3 : byArray.length);
            if (l3 == -1L) break;
            l2 += l3;
        }
        return l2;
    }

    protected void fill() throws IOException {
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }
}

