/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 * 			  Centro SERRA, University of Pisa
 * 			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ntop.h"

#ifdef HAVE_GDBM_H
extern GDBM_FILE gdbm_file;
#ifdef MULTITHREADED
extern pthread_mutex_t gdbmMutex;
#endif
#endif

extern char* etheraddr_string(const u_char *ep);

/* #define DEBUG */

/* *********************************************************

 1) Download http://standards.ieee.org/regauth/oui/oui.txt  
 2) do 'grep "(hex)" oui.txt | cut -c1-8,9,34- | more'
  

 * ****************************************************** */



/* *********************************************************
 * 
 * The information contained in this file 
 * has been provided by Ethernet-codes@Cavebear.com.
 *
 * http://www.cavebear.com/CaveBear/Ethernet/vendor.html
 *
 * Courtesy of "William R. McDonough" <wrmcd@wilmcd.com>.
 *
 * ******************************************************
 */

extern unsigned int webMode;

typedef struct {
  unsigned long vendorId;
  char* vendorName;
} VendorInfo;

static VendorInfo vendorInfo[] = {
  { 0x000000, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000002, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000003, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000004, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000005, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000006, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000007, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000008, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000009, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00000A, "OMRON TATEISI ELECTRONICS CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00000B, "MATRIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00000C, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00000D, "FIBRONICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00000E, "FUJITSU LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00000F, "NEXT INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000010, "SYTEK INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000011, "NORMEREL SYSTEMES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000012, "INFORMATION TECHNOLOGY LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000013, "CAMEX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000014, "NETRONIX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000015, "DATAPOINT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000016, "DU PONT PIXEL SYSTEMS ." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000018, "WEBSTER COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000019, "APPLIED DYNAMICS INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00001A, "ADVANCED MICRO DEVICES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00001B, "NOVELL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00001C, "BELL TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00001D, "CABLETRON SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00001E, "TELSIST INDUSTRIA ELECTRONICA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00001F, "CRYPTALL LP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000020, "DATAINDUSTRIER DIAB AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000021, "SUREMAN COMP. & COMMUN. CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000022, "VISUAL TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000023, "ABB INDUSTRIAL SYSTEMS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000024, "CONNECT AS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000025, "RAMTEK CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000026, "SHAKEN CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000027, "JAPAN RADIO COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000028, "PRODIGY SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000029, "IMC NETWORKS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00002A, "TRW SEDD/INP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00002B, "CRISP AUTOMATION INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00002C, "AUTOTOTE LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00002D, "CHROMATICS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00002E, "SOCIETE EVIRA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00002F, "TIMEPLEX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000030, "VG LABORATORY SYSTEMS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000031, "QPSX COMMUNICATIONS PTY LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000032, "GPT LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000033, "EGAN MACHINERY COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000034, "NETWORK RESOURCES CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000035, "SPECTRAGRAPHICS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000036, "ATARI CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000037, "OXFORD METRICS LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000038, "CSS LABS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000039, "TOSHIBA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00003A, "CHYRON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00003B, "HYUNDAI ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00003C, "AUSPEX SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00003D, "UNISYS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00003E, "SIMPACT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00003F, "SYNTREX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000040, "APPLICON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000041, "ICE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000042, "METIER MANAGEMENT SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000043, "MICRO TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000044, "CASTELLE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000045, "FORD AEROSPACE & COMM. CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000046, "OLIVETTI NORTH AMERICA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000047, "NICOLET INSTRUMENTS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000048, "SEIKO EPSON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000049, "APRICOT COMPUTERS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00004A, "ADC CODENOLL TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00004B, "ICL DATA OY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00004C, "NEC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00004D, "DCI CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00004E, "AMPEX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00004F, "LOGICRAFT INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000050, "RADISYS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000051, "HOB ELECTRONIC GMBH & CO. KG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000052, "OPTICAL DATA SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000053, "COMPUCORP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000054, "MODICON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000055, "COMMISSARIAT A L`ENERGIE ATOM." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000056, "DR. B. STRUCK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000057, "SCITEX CORPORATION LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000058, "RACORE COMPUTER PRODUCTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000059, "HELLIGE GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00005A, "SYSKONNECTA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00005B, "ELTEC ELEKTRONIK GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00005C, "TELEMATICS INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00005D, "RCE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00005E, "USC INFORMATION SCIENCES INST" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00005F, "SUMITOMO ELECTRIC IND. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000060, "KONTRON ELEKTRONIK GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000061, "GATEWAY COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000062, "BULL HN INFORMATION SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000063, "DR.ING.SEUFERT GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000064, "YOKOGAWA DIGITAL COMPUTER CORP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000065, "NETWORK ASSOCIATES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000066, "TALARIS SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000067, "SOFT * RITE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000068, "ROSEMOUNT CONTROLS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000069, "CONCORD COMMUNICATIONS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00006A, "COMPUTER CONSOLES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00006B, "SILICON GRAPHICS INC./MIPS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00006D, "CRAY COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00006E, "ARTISOFT INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00006F, "MADGE NETWORKS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000070, "HCL LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000071, "ADRA SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000072, "MINIWARE TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000073, "SIECOR CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000074, "RICOH COMPANY LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000075, "NORTHERN TELECOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000076, "ABEKAS VIDEO SYSTEM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000077, "INTERPHASE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000078, "LABTAM LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000079, "NETWORTH INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00007A, "DANA COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00007B, "RESEARCH MACHINES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00007C, "AMPERE INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00007D, "CRAY RESEARCH SUPERSERVERS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00007E, "CLUSTRIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00007F, "LINOTYPEHELL AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000080, "CRAY COMMUNICATIONS A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000081, "BAY NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000082, "LECTRA SYSTEMES SA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000083, "TADPOLE TECHNOLOGY PLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000084, "SUPERNET" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000085, "CANON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000086, "MEGAHERTZ CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000087, "HITACHI LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000088, "COMPUTER NETWORK TECH. CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000089, "CAYMAN SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00008A, "DATAHOUSE INFORMATION SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00008B, "INFOTRON" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00008C, "ALLOY COMPUTER PRODUCTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00008D, "VERDIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00008E, "SOLBOURNE COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00008F, "RAYTHEON COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000090, "MICROCOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000091, "ANRITSU CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000092, "COGENT DATA TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000093, "PROTEON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000094, "ASANTE TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000095, "SONY TEKTRONIX CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000096, "MARCONI ELECTRONICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000097, "EPOCH SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000098, "CROSSCOMM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000099, "MTX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00009A, "RC COMPUTER A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00009B, "INFORMATION INTERNATIONAL INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00009C, "ROLM MILSPEC COMPUTERS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00009D, "LOCUS COMPUTING CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00009E, "MARLI S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00009F, "AMERISTAR TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A0, "TOKYO SANYO ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A1, "MARQUETTE ELECTRIC CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A2, "BAY NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A3, "NETWORK APPLICATION TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A4, "ACORN COMPUTERS LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A5, "COMPATIBLE SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A6, "NETWORK GENERAL CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A7, "NETWORK COMPUTING DEVICES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A8, "STRATUS COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000A9, "NETWORK SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000AA, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000AB, "LOGIC MODELING CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000AC, "CONWARE COMPUTER CONSULTING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000AD, "BRUKER INSTRUMENTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000AE, "DASSAULT ELECTRONIQUE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000AF, "NUCLEAR DATA INSTRUMENTATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B0, "RNDRAD NETWORK DEVICES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B1, "ALPHA MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B2, "TELEVIDEO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B3, "CIMLINC INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B4, "EDIMAX COMPUTER COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B5, "DATABILITY SOFTWARE SYS. INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B6, "MICROMATIC RESEARCH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B7, "DOVE COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B8, "SEIKOSHA CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000B9, "MCDONNELL DOUGLAS COMPUTER SYS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000BA, "SIIG INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000BB, "TRIDATA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000BC, "ALLENBRADLEY CO. INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000BD, "MITSUBISHI CABLE COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000BE, "THE NTI GROUP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000BF, "SYMMETRIC COMPUTER SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C0, "WESTERN DIGITAL CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C1, "OLICOM A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C2, "INFORMATION PRESENTATION TECH." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C3, "HARRIS CORP COMPUTER SYS DIV" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C4, "WATERS DIV. OF MILLIPORE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C5, "FARALLON COMPUTING/NETOPIA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C6, "EON SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C7, "ARIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C8, "ALTOS COMPUTER SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000C9, "EMULEX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000CA, "APPLITEK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000CB, "COMPUSHACK ELECTRONIC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000CC, "DENSAN CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000CD, "TELTREND (NZ) LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000CE, "MEGADATA CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000CF, "HAYES MICROCOMPUTER PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D0, "DEVELCON ELECTRONICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D1, "ADAPTEC INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D2, "SBE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D3, "WANG LABORATORIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D4, "PURE DATA LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D5, "MICROGNOSIS INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D6, "PUNCH LINE HOLDING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D7, "DARTMOUTH COLLEGE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D8, "NOVELL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000D9, "NIPPON T & T CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000DA, "ATEX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000DB, "BRITISH TELECOMMUNICATIONS PLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000DC, "HAYES MICROCOMPUTER PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000DD, "TCL INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000DE, "CETIA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000DF, "BELL & HOWELL PUB SYS DIV" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E0, "QUADRAM CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E1, "GRID SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E2, "ACER TECHNOLOGIES CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E3, "INTEGRATED MICRO PRODUCTS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E4, "IN2 GROUPE INTERTECHNIQUE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E5, "SIGMEX LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E6, "APTOR PRODUITS DE COMM INDUST" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E7, "STAR GATE TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E8, "ACCTON TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000E9, "ISICAD INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000EA, "UPNOD AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000EB, "MATSUSHITA COMM. IND. CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000EC, "MICROPROCESS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000ED, "APRIL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000EE, "NETWORK DESIGNERS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000EF, "KTI" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F0, "SAMSUNG ELECTRONICS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F1, "MAGNA COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F2, "SPIDER COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F3, "GANDALF DATA LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F4, "ALLIED TELESYN INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F5, "DIAMOND SALES LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F6, "APPLIED MICROSYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F7, "YOUTH KEEP ENTERPRISE CO LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F8, "DIGITAL EQUIPMENT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000F9, "QUOTRON SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000FA, "MICROSAGE COMPUTER SYSTEMS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000FB, "RECHNER ZUR KOMMUNIKATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000FC, "MEIKO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000FD, "HIGH LEVEL HARDWARE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000FE, "ANNAPOLIS MICRO SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0000FF, "CAMTEC ELECTRONICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0001C8, "THOMAS CONRAD CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0001C8, "CONRAD CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0001FE, "DIGITAL EQUIPMENT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000267, "NODE RUNNER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000288, "GLOBAL VILLAGE COMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000400, "LEXMARK INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0004AC, "IBM CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000502, "APPLE COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0005A8, "WYLE ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000629, "IBM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00067C, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0006C1, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000701, "RACALDATACOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000800, "MULTITECH SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0008C7, "COMPAQ COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001000, "CABLE TELEVISION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001001, "MCK COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001002, "ACTIA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001003, "IMATRON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001004, "THE BRANTLEY COILE COMPANY INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001005, "UEC COMMERCIAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001006, "RACAL RECORDERS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001007, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001008, "VIENNA SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001009, "HORO QUARTZ" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00100A, "WILLIAMS COMMUNICATIONS GROUP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00100B, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00100C, "ITO CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00100D, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00100E, "MICRO LINEAR COPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00100F, "INDUSTRIAL CPU SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001010, "INITIO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001011, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001012, "PROCESSOR SYSTEMS (I) PVT LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001013, "INDUSTRIAL COMPUTER SOURCE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001014, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001015, "OOMON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001016, "T.SQWARE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001017, "MICOS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001018, "BROADCOM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001019, "SIRONA DENTAL SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00101A, "PICTURETEL CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00101B, "CORNET TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00101C, "OHM TECHNOLOGIES INTL LLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00101D, "WINBOND ELECTRONICS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00101E, "MATSUSHITA ELECTRONIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00101F, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001020, "WELCH ALLYN DATA COLLECTION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001021, "ENCANTO NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001022, "SATCOM MEDIA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001023, "FLOWWISE NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001024, "NAGOYA ELECTRIC WORKS CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001025, "GRAYHILL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001026, "ACCELERATED NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001027, "L3 COMMUNICATIONS EAST" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001028, "COMPUTER TECHNICA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001029, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00102A, "ZF MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00102B, "UMAX DATA SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00102C, "PNP TECHNOLOGY A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00102D, "HITACHI SOFTWARE ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00102E, "NETWORK SYSTEMS & TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00102F, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001030, "WILAN INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001031, "OBJECTIVE COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001032, "ALTA TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001033, "ACCESSLAN COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001034, "GNP COMPUTERS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001035, "ELITEGROUP COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001036, "INTERTEL INTEGRATED SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001037, "CYQ'VE TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001038, "MICRO RESEARCH INSTITUTE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001039, "VECTRON SYSTEMS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00103A, "DIAMOND NETWORK TECH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00103B, "HIPPI NETWORKING FORUM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00103C, "IC ENSEMBLE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00103D, "PHASECOM LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00103E, "NETSCHOOLS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00103F, "TOLLGRADE COMMUNICATIONS INC."},
  { 0x000001, "XEROX CORPORATION" },
  { 0x001040, "INTERMEC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001041, "BRISTOL BABCOCK INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001042, "ALACRITECH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001043, "A2 CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001044, "INNOLABS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001045, "CAMBRIAN SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001046, "ALCORN MCBRIDE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001047, "ECHO ELETRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001048, "HTRC AUTOMATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001049, "SHORELINE TELEWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00104A, "THE PARVUC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00104B, "3COM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00104C, "COMPUTER ACCESS TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00104D, "SURTEC INDUSTRIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00104E, "CEOLOGIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00104F, "STORAGE TECHNOLOGY CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001050, "RION CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001051, "CMICRO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001052, "METTLERTOLEDO (ALBSTADT) GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001053, "COMPUTER TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001054, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001055, "FUJITSU MICROELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001056, "SODICK CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001057, "COREL COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001058, "ARROWPOINT COMMUNICATIONS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001059, "DIABLO RESEARCH CO. LLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00105A, "3COM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00105B, "NET INSIGHT AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00105C, "QUANTUM DESIGNS (H.K.) LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00105D, "DRAGER BUSINESS UNIT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00105E, "HEKIMIAN LABORATORIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00105F, "INSNEC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001060, "BILLIONTON SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001061, "HOSTLINK CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001062, "NX SERVER ILNC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001063, "STARGUIDE DIGITAL NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001064, "DIGITAL EQUIPMENT CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001065, "RADYNE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001066, "ADVANCED CONTROL SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001067, "REDBACK NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001068, "COMOS TELECOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001069, "HELIOSS COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00106A, "DIGITAL MICROWAVE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00106B, "SONUS NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00106C, "INFRATEC PLUS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00106D, "INTEGRITY COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00106E, "TADIRAN COM. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00106F, "TRENTON TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001070, "CARADON TREND LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001071, "ADVANET INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001072, "GVN TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001073, "TECHNOBOX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001074, "ATEN INTERNATIONAL CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001075, "CREATIVE DESIGN SOLUTIONS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001076, "EUREM GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001077, "SAF DRIVE SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001078, "NUERA COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001079, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00107A, "AMBICOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00107B, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00107C, "PCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00107D, "AURORA COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00107E, "BACHMANN ELECTRONIC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00107F, "CRESTRON ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001080, "METAWAVE COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001081, "DPS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001082, "JNA TELECOMMUNICATIONS LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001083, "HEWLETT-PACKARD COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001084, "KBOT COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001085, "POLARIS COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001086, "ATTO TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001087, "EPL LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001088, "AMERICAN NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001089, "WEBSONIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00108A, "TERALOGIC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00108B, "LASERANIMATION SOLLINGER GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00108C, "FUJITSU TELECOMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00108D, "JOHNSON CONTROLS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00108E, "HUGH SYMONS CONCEPT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00108F, "RAPTOR SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001090, "CIMETRICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001091, "NO WIRES NEEDED BV" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001092, "NETCORE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001093, "CMS COMPUTERS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001094, "ADTECH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001095, "THOMSON CONSUMER ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001096, "TRACEWELL SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001097, "WINNET METROPOLITAN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001098, "STARNET TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001099, "INNOMEDIA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00109A, "NETLINE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00109B, "VIXEL CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00109C, "MSYSTEM CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00109D, "CLARINET SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00109E, "AWARE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00109F, "PAVO INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A0, "INNOVEX TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A1, "KENDIN SEMICONDUCTOR INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A2, "HYUNDAI NETWORK SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A3, "OMNITRONIX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A4, "XIRCOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A5, "OXFORD INSTRUMENTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A6, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A7, "UNEX TECHNOLOGY CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A8, "RELIANCE COMPUTER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010A9, "ADHOC TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010AA, "MEDIA4 INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010AB, "KOITO INDUSTRIES LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010AC, "IMCI TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010AD, "SOFTRONICS USB INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010AE, "SHINKO ELECTRIC INDUSTRIES CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010AF, "TAC SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B0, "MERIDIAN TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B1, "FORA CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B2, "COACTIVE AESTHETICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B3, "NOKIA SATELLITE SYSTEMS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B4, "ATMOSPHERE NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B5, "ACCTON TECHNOLOGY CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B6, "ENTRATA COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B7, "COYOTE TECHNOLOGIES LLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B8, "ISHIGAKI COMPUTER SYSTEM CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010B9, "MAXTOR CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010BA, "MARTINHODAVIS SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010BB, "DATA & INFORMATION TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010BC, "APTIS COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010BD, "THE TELECOMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010BE, "TELEXIS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010BF, "INTER AIR WIRELESS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C0, "ARMA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C1, "OI ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C2, "WILLNET INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C3, "CSICONTROL SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C4, "MEDIA LINKS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C5, "PROTOCOL TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C6, "USI" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C7, "DATA TRANSMISSION NETWORK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C8, "COMMUNICATIONS ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010C9, "MITSUBISHI ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010CA, "INTEGRAL ACCESS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010CB, "FACIT K.K." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010CC, "CLP COMPUTER LOGISTIK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010CD, "INTERFACE CONCEPT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010CE, "VOLAMP LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010CF, "FIBERLANE COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D0, "WITCOM LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D1, "BLAZENET INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D2, "NITTO TSUSHINKI CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D3, "GRIPS ELECTRONIC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D4, "STORAGE COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D5, "IMASDE CANARIAS S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D6, "ITT A/CD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D7, "ARGOSY RESEARCH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D8, "CALISTA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010D9, "IBM JAPAN FUJISAWA MT+D" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010DA, "MOTION ENGINEERING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010DB, "NETSCREEN TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010DC, "MICROSTAR INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010DD, "ENABLE SEMICONDUCTOR INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010DE, "INTERNATIONAL DATACASTING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010DF, "RISE COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E0, "COBALT MICROSERVER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E1, "S.I. TECH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E2, "ARRAYCOMM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E3, "COMPAQ COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E4, "NSI CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E5, "SOLECTRON TEXAS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E6, "APPLIED INTELLIGENT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E7, "BREEZECOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E8, "ASPEN INTERNET SYSTEM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010E9, "RAIDTEC LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010EA, "ADEPT TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010EB, "SELSIUS SYSTEMS ILNC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010EC, "RPCG LLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010ED, "SUNDANCE TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010EE, "CTI PRODUCTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010EF, "DB NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F0, "RITTALWERK RUDOLF LOH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F1, "IO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F2, "ANTEC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F3, "NEXCOM INTERNATIONAL CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F4, "VERTICAL NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F5, "AMHERST SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F6, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F7, "IRIICHI TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F8, "KENWOOD TMI CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010F9, "UNIQUE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010FA, "ZAYANTE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010FB, "ZIDA TECHNOLOGIES LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010FC, "BROADBAND NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010FD, "COCOM A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010FE, "DIGITAL EQUIPMENT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0010FF, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x001C7C, "PERQ SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002000, "LEXMARK INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002001, "DSP SOLUTIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002002, "SERITECH ENTERPRISE CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002003, "PIXEL POWER LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002004, "YAMATAKEHONEYWELL CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002005, "SIMPLE TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002006, "GARRETT COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002007, "SFA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002008, "CABLE & COMPUTER TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002009, "PACKARD BELL ELEC. INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00200A, "SOURCECOMM CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00200B, "OCTAGON SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00200C, "ADASTRA SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00200D, "CARL ZEISS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00200E, "SATELLITE TECHNOLOGY MGMT INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00200F, "TANBAC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002010, "JEOL SYSTEM TECHNOLOGY CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002011, "CANOPUS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002012, "CAMTRONICS MEDICAL SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002013, "DIVERSIFIED TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002014, "GLOBAL VIEW CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002015, "ACTIS COMPUTER SA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002016, "SHOWA ELECTRIC WIRE & CABLE CO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002017, "ORBOTECH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002018, "CIS TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002019, "OHLER GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00201A, "NBASE SWITCH COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00201B, "NORTHERN TELECOM/NETWORK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00201C, "EXCEL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00201D, "KATANA PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00201E, "NETQUEST CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00201F, "BEST POWER TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002020, "MEGATRON COMPUTER INDUSTRIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002021, "ALGORITHMS SOFTWARE PVT. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002022, "TEKNIQUE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002023, "T.C. TECHNOLOGIES PTY. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002024, "PACIFIC COMMUNICATION SCIENCES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002025, "CONTROL TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002026, "AMKLY SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002027, "MING FORTUNE INDUSTRY CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002028, "WEST EGG SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002029, "TELEPROCESSING PRODUCTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00202A, "N.V. DZINE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00202B, "ADVANCED TELECOMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00202C, "WELLTRONIX CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00202D, "TAIYO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00202E, "DAYSTAR DIGITAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00202F, "ZETA COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002030, "ANALOG & DIGITAL SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002031, "ERTEC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002032, "ALCATEL TAISEL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002033, "SYNAPSE TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002034, "ROTEC INDUSTRIEAUTOMATION GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002035, "IBM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002036, "BMC SOFTWARE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002037, "SEAGATE TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002038, "VME MICROSYSTEMS INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002039, "SCINETS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00203A, "DIGITAL BI0METRICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00203B, "WISDM LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00203C, "EUROTIME AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00203D, "NOVAR ELECTRONICS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00203E, "LOGICAN TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00203F, "JUKI CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002040, "GENERAL INSTRUMENT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002041, "DATA NET" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002042, "DATAMETRICS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002043, "NEURON COMPANY LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002044, "GENITECH PTY LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002045, "SOLCOM SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002046, "CIPRICO INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002047, "STEINBRECHER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002048, "FORE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002049, "COMTRON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00204A, "PRONET GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00204B, "AUTOCOMPUTER CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00204C, "MITRON COMPUTER PTE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00204D, "INOVIS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00204E, "NETWORK SECURITY SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00204F, "DEUTSCHE AEROSPACE AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002050, "KOREA COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002051, "PHOENIX DATA COMMUNUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002052, "RAGULA SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002053, "HUNTSVILLE MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002054, "EASTERN RESEARCH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002055, "ALTECH CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002056, "NEOPRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002057, "TITZE DATENTECHNIK GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002058, "ALLIED SIGNAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002059, "MIRO COMPUTER PRODUCTS AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00205A, "COMPUTER IDENTICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00205B, "SKYLINE TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00205C, "INTERNET SYSTEMS/ FLORIDA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00205D, "NANOMATIC OY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00205E, "CASTLE ROCK INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00205F, "GAMMADATA COMPUTER GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002060, "ALCATEL ITALIA S.P.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002061, "DYNATECH COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002062, "SCORPION LOGIC LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002063, "WIPRO INFOTECH LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002064, "PROTEC MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002065, "SUPERNET NETWORKING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002066, "GENERAL MAGIC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002068, "ISDYNE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002069, "ISDN SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00206A, "OSAKA COMPUTER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00206B, "MINOLTA CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00206C, "EVERGREEN TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00206D, "DATA RACE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00206E, "XACT INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00206F, "FLOWPOINT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002070, "HYNET LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002071, "IBR GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002072, "WORKLINK INNOVATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002073, "FUSION SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002074, "SUNGWOON SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002075, "MOTOROLA COMMUNICATION ISRAEL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002076, "REUDO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002077, "KARDIOS SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002078, "RUNTOP INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002079, "MIKRON GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00207A, "WISE COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00207B, "LEVEL ONE COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00207C, "AUTEC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00207D, "ADVANCED COMPUTER APPLICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00207E, "FINECOM CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00207F, "KYOEI SANGYO CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002080, "SYNERGY (UK) LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002081, "TITAN ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002082, "ONEAC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002083, "PRESTICOM INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002084, "OCE PRINTING SYSTEMS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002085, "EXIDE ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002086, "MICROTECH ELECTRONICS LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002087, "MEMOTEC COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002088, "GLOBAL VILLAGE COMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002089, "T3PLUS NETWORKING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00208A, "SONIX COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00208B, "LAPIS TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00208C, "GALAXY NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00208D, "CMD TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00208E, "CHEVIN SOFTWARE ENG. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00208F, "ECI TELECOM LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002090, "ADVANCED COMPRESSION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002091, "J125 NATIONAL SECURITY AGENCY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002092, "CHESS ENGINEERING B.V." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002093, "LANDINGS TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002094, "CUBIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002095, "RIVA ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002096, "SIEBE ENVIRONMENTAL CONTROLS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002097, "APPLIED SIGNAL TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002098, "HECTRONIC AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x002099, "BON ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00209A, "THE 3DO COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00209B, "ERSAT ELECTRONIC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00209C, "PRIMARY ACCESS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00209D, "LIPPERT AUTOMATIONSTECHNIK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00209E, "BROWN'S OPERATING SYSTEM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00209F, "MERCURY COMPUTER SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A0, "OA LABORATORY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A1, "DOVATRON" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A2, "GALCOM NETWORKING LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A3, "DIVICOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A4, "MULTIPOINT NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A5, "API ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A6, "PROXIM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A7, "PAIRGAIN TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A8, "SAST TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020A9, "WHITE HORSE INDUSTRIAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020AA, "DIGIMEDIA VISION LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020AB, "MICRO INDUSTRIES CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020AC, "INTERFLEX DATENSYSTEME GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020AD, "LINQ SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020AE, "ORNET DATA COMMUNICATION TECH." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020AF, "3COM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B0, "GATEWAY DEVICES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B1, "COMTECH RESEARCH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B2, "GKD GESELLSCHAFT FUR" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B3, "SCLTEC COMMUNICATIONS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B4, "TERMA ELEKTRONIK AS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B5, "YASKAWA ELECTRIC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B6, "AGILE NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B7, "NAMAQUA COMPUTERWARE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B8, "PRIME OPTION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020B9, "METRICOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020BA, "CENTER FOR HIGH PERFORMANCE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020BB, "ZAX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020BC, "JTEC PTY LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020BD, "NIOBRARA R & D CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020BE, "LAN ACCESS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020BF, "AEHR TEST SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C0, "PULSE ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C1, "TAIKO ELECTRIC WORKS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C2, "TEXAS MEMORY SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C3, "COUNTER SOLUTIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C4, "INET INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C5, "EAGLE TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C6, "NECTEC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C7, "AKAI ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C8, "LARSCOM INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020C9, "VICTRON BV" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020CA, "DIGITAL OCEAN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020CB, "PRETEC ELECTRONICS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020CC, "DIGITAL SERVICES LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020CD, "HYBRID NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020CE, "LOGICAL DESIGN GROUP INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020CF, "TEST & MEASUREMENT SYSTEMS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D0, "VERSALYNX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D1, "MICROCOMPUTER SYSTEMS (M) SDN." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D2, "RAD DATA COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D3, "OST (OUEST STANDARD TELEMATIQUE)" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D4, "CABLETRON ZEITTNET INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D5, "VIPA GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D6, "BREEZECOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D7, "JAPAN MINICOMPUTER SYSTEMS CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D8, "NETWAVE TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020D9, "PANASONIC TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020DA, "XYLAN CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020DB, "XNET TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020DC, "DENSITRON TAIWAN LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020DD, "AWA LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020DE, "JAPAN DIGITAL LABORAT'Y CO.LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020DF, "KYOSAN ELECTRIC MFG. CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E0, "PREMAX ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E1, "ALAMAR ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E2, "INFORMATION RESOURCE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E3, "MCD KENCOM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E4, "HSING TECH ENTERPRISE CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E5, "APEX DATA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E6, "LIDKOPING MACHINE TOOLS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E7, "B&W NUCLEAR SERVICE COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E8, "DATATREK CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020E9, "DANTEL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020EA, "EFFICIENT NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020EB, "CINCINNATI MICROWAVE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020EC, "TECHWARE SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020ED, "GIGABYTE TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020EE, "GTECH CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020EF, "USC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F0, "UNIVERSAL MICROELECTRONICS CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F1, "ALTOS INDIA LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F2, "MAXIMUM STRATEGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F3, "RAYNET CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F4, "SPECTRIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F5, "PAN DACOM TELECOM'CATIONS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F6, "NET TEK AND KARLNET INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F7, "CYBERDATA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F8, "CARRERA COMPUTERS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020F9, "PARALINK NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020FA, "GDE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020FB, "OCTEL COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020FC, "MATROX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020FD, "ITV TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020FE, "TOPWARE INC. / GRAND COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0020FF, "SYMMETRICAL TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004000, "PCI COMPONENTES DA AMZONIA LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004001, "ZYXEL COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004002, "PERLE SYSTEMS LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004003, "WESTINGHOUSE PROCESS CONTROL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004004, "ICM CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004005, "ANI COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004006, "SAMPO TECHNOLOGY CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004007, "TELMAT INFORMATIQUE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004008, "A PLUS INFO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004009, "TACHIBANA TECTRON CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00400A, "PIVOTAL TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00400B, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00400C, "GENERAL MICRO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00400D, "LANNET DATA COMMUNICATIONS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00400E, "MEMOTEC COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00400F, "DATACOM TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004010, "SONIC SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004011, "ANDOVER CONTROLS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004012, "WINDATA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004013, "NTT DATA COMM. SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004014, "COMSOFT GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004015, "ASCOM INFRASYS AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004016, "HADAX ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004017, "XCD INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004018, "ADOBE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004019, "AEON SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00401A, "FUJI ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00401B, "PRINTER SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00401C, "AST RESEARCH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00401D, "INVISIBLE SOFTWARE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00401E, "ICC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00401F, "COLORGRAPH LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004020, "PINACL COMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004021, "RASTER GRAPHICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004022, "KLEVER COMPUTERS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004023, "LOGIC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004024, "COMPAC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004025, "MOLECULAR DYNAMICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004026, "MELCO INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004027, "SMC MASSACHUSETTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004028, "NETCOMM LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004029, "COMPEX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00402A, "CANOGAPERKINS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00402B, "TRIGEM COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00402C, "ISIS DISTRIBUTED SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00402D, "HARRIS ADACOM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00402E, "PRECISION SOFTWARE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00402F, "XLNT DESIGNS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004030, "GK COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004031, "KOKUSAI ELECTRIC CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004032, "DIGITAL COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004033, "ADDTRON TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004034, "BUSTEK CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004035, "OPCOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004036, "TRIBE COMPUTER WORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004037, "SEAILAN INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004038, "TALENT ELECTRIC INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004039, "OPTEC DAIICHI DENKO CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00403A, "IMPACT TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00403B, "SYNERJET INTERNATIONAL CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00403C, "FORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00403D, "TERADATA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00403E, "RASTER OPS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00403F, "SSANGYONG COMPUTER SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004040, "RING ACCESS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004041, "FUJIKURA LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004042, "N.A.T. GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004043, "NOKIA TELECOMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004044, "QNIX COMPUTER CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004045, "TWINHEAD CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004046, "UDC RESEARCH LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004047, "WIND RIVER SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004048, "SMD INFORMATICA S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004049, "TEGIMENTA AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00404A, "WEST AUSTRALIAN DEPARTMENT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00404B, "MAPLE COMPUTER SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00404C, "HYPERTEC PTY LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00404D, "TELECOMMUNICATIONS TECHNIQUES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00404E, "FLUENT INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00404F, "SPACE & NAVAL WARFARE SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004050, "IRONICS INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004051, "GRACILIS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004052, "STAR TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004053, "AMPRO COMPUTERS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004054, "CONNECTION MACHINES SERVICES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004055, "METRONIX GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004056, "MCM JAPAN LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004057, "LOCKHEED SANDERS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004058, "KRONOS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004059, "YOSHIDA KOGYO K. K." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00405A, "GOLDSTAR INFORMATION & COMM." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00405B, "FUNASSET LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00405C, "FUTURE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00405D, "STARTEK INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00405E, "NORTH HILLS ISRAEL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00405F, "AFE COMPUTERS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004060, "COMENDEC LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004061, "DATATECH ENTERPRISES CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004062, "ESYSTEMS INC./GARLAND DIV." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004063, "VIA TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004064, "KLA INSTRUMENTS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004065, "GTE SPACENET" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004066, "HITACHI CABLE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004067, "OMNIBYTE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004068, "EXTENDED SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004069, "LEMCOM SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00406A, "KENTEK INFORMATION SYSTEMS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00406B, "SYSGEN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00406C, "COPERNIQUE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00406D, "LANCO INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00406E, "COROLLARY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00406F, "SYNC RESEARCH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004070, "INTERWARE CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004071, "ATM COMPUTER GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004072, "APPLIED INNOVATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004073, "BASS ASSOCIATES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004074, "CABLE AND WIRELESS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004075, "MTRADE (UK) LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004076, "AMP INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004077, "MAXTON TECHNOLOGY CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004078, "WEARNES AUTOMATION PTE LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004079, "JUKO MANUFACTURE COMPANY LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00407A, "SOCIETE D'EXPLOITATION DU CNIT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00407B, "SCIENTIFIC ATLANTA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00407C, "QUME CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00407D, "EXTENSION TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00407E, "EVERGREEN SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00407F, "AGEMA INFRARED SYSTEMS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004080, "ATHENIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004081, "MANNESMANN SCANGRAPHIC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004082, "LABORATORY EQUIPMENT CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004083, "TDA INDUSTRIA DE PRODUTOS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004084, "HONEYWELL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004085, "SAAB INSTRUMENTS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004086, "MICHELS & KLEBERHOFF COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004087, "UBITREX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004088, "MOBIUS TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004089, "MEIDENSHA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00408A, "TPS TELEPROCESSING SYS. GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00408B, "RAYLAN CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00408C, "AXIS COMMUNICATIONS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00408D, "THE GOODYEAR TIRE & RUBBER CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00408E, "DIGILOG INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00408F, "WMDATA MINFO AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004090, "ANSEL COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004091, "PROCOMP INDUSTRIA ELETRONICA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004092, "ASP COMPUTER PRODUCTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004093, "PAXDATA NETWORKS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004094, "SHOGRAPHICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004095, "R.P.T. INTERGROUPS INT'L LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004096, "TELESYSTEMS SLW INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004097, "DATEX DIVISION OF" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004098, "DRESSLER GMBH & CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x004099, "NEWGEN SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00409A, "NETWORK EXPRESS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00409B, "HAL COMPUTER SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00409C, "TRANSWARE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00409D, "DIGIBOARD INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00409E, "CONCURRENT TECHNOLOGIES LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00409F, "LANCAST/CASAT TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A0, "GOLDSTAR CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A1, "ERGO COMPUTING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A2, "KINGSTAR TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A3, "MICROUNITY SYSTEMS ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A4, "ROSE ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A5, "CLINICOMP INTL." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A6, "CRAY RESEARCH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A7, "ITAUTEC INFORMATICA S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A8, "IMF INTERNATIONAL LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040A9, "DATACOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040AA, "VALMET AUTOMATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040AB, "ROLAND DG CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040AC, "SUPER WORKSTATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040AD, "SMA REGELSYSTEME GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040AE, "DELTA CONTROLS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040AF, "DIGITAL PRODUCTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B0, "BYTEX CORPORATION ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B1, "CODONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B2, "SYSTEMFORSCHUNG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B3, "PAR MICROSYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B4, "NEXTCOM K.K." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B5, "VIDEO TECHNOLOGY COMPUTERS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B6, "COMPUTERM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B7, "STEALTH COMPUTER SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B8, "IDEA ASSOCIATES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040B9, "MACQ ELECTRONIQUE SA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040BA, "ALLIANT COMPUTER SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040BB, "GOLDSTAR CABLE CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040BC, "ALGORITHMICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040BD, "STARLIGHT NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040BE, "BOEING DEFENSE & SPACE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040BF, "CHANNEL SYSTEMS INTERN'L INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C0, "VISTA CONTROLS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C1, "BIZERBAWERKE WILHEIM KRAUT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C2, "APPLIED COMPUTING DEVICES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C3, "FISCHER AND PORTER CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C4, "KINKEI SYSTEM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C5, "MICOM COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C6, "FIBERNET RESEARCH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C7, "RUBY TECH CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C8, "MILAN TECHNOLOGY CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040C9, "NCUBE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040CA, "FIRST INTERNAT'L COMPUTER INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040CB, "LANWAN TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040CC, "SILCOM MANUF'G TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040CD, "TERA MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040CE, "NETSOURCE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040CF, "STRAWBERRY TREE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D0, "MITAC INTERNATIONAL CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D1, "FUKUDA DENSHI CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D2, "PAGINE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D3, "KIMPSION INTERNATIONAL CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D4, "GAGE TALKER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D5, "SARTORIUS AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D6, "LOCAMATION B.V." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D7, "STUDIO GEN INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D8, "OCEAN OFFICE AUTOMATION LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040D9, "AMERICAN MEGATRENDS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040DA, "TELSPEC LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040DB, "ADVANCED TECHNICAL SOLUTIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040DC, "TRITEC ELECTRONIC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040DD, "HONG TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040DE, "ELETTRONICA SAN GIORGIO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040DF, "DIGALOG SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E0, "ATOMWIDE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E1, "MARNER INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E2, "MESA RIDGE TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E3, "QUIN SYSTEMS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E4, "EM TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E5, "SYBUS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E6, "C.A.E.N." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E7, "ARNOS INSTRUMENTS & COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E8, "CHARLES RIVER DATA SYSTEMS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040E9, "ACCORD SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040EA, "PLAIN TREE SYSTEMS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040EB, "MARTIN MARIETTA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040EC, "MIKASA SYSTEM ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040ED, "NETWORK CONTROLS INT'NATL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040EE, "OPTIMEM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040EF, "HYPERCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F0, "MICRO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F1, "CHUO ELECTRONICS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F2, "JANICH & KLASS COMPUTERTECHNIK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F3, "NETCOR" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F4, "CAMEO COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F5, "OEM ENGINES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F6, "KATRON COMPUTERS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F7, "POLAROID MEDICAL IMAGING SYS." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F8, "SYSTEMHAUS DISCOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040F9, "COMBINET" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040FA, "MICROBOARDS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040FB, "CASCADE COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040FC, "IBR COMPUTER TECHNIK GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040FD, "LXE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040FE, "SYMPLEX COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0040FF, "TELEBIT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005000, "NEXO COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005001, "YAMASHITA SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005002, "OMNISEC AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005003, "GRETAG MACBETH AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005006, "TAC AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005007, "SIEMENS TELECOMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005008, "TIVA MICROCOMPUTER CORP. (TMC)" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005009, "PHILIPS BROADBAND NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00500A, "IRIS TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00500C, "ETEK LABS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00500D, "SATORI ELECTORIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00500E, "CHROMATIS NETWORKS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00500F, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005010, "NOVANET LEARNING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005013, "CHAPARRAL TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005014, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005015, "BRIGHT STAR ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005016, "SST/WOODHEAD INDUSTRIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005017, "RSR S.R.L." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005018, "ADVANCED MULTIMEDIA INTERNET" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005019, "SPRING TIDE NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00501A, "UISIQN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00501B, "ABL CANADA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00501C, "JATOM SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00501E, "MIRANDA TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00501F, "MRG SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005020, "MEDIASTAR CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005021, "EIS INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005022, "ZONET TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005023, "PG DESIGN ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005024, "NAVIC SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005026, "COSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005027, "GENICOM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005028, "AVAL COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005029, "1394 PRINTER WORKING GROUP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00502A, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00502B, "GENRAD LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00502C, "SOYO COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00502D, "ACCEL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00502E, "CAMBEX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00502F, "TOLLBRIDGE TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005030, "FUTURE PLUS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005031, "AEROFLEX LABORATORIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005033, "MAYAN NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005036, "NETCAM LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005037, "KOGA ELECTRONICS CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005038, "DAIN TELECOM CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005039, "MARINER NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00503A, "DATONG ELECTRONICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00503B, "MEDIAFIRE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00503C, "TSINGHUA NOVEL ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00503E, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005040, "EMWARE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005041, "CTX OPTO ELECTRONIC CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005042, "SCI MANUFACTURING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005043, "MARVELL SEMICONDUCTOR INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005044, "ASACA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005045, "RIOWORKS SOLUTIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005046, "MENICX INTERNATIONAL CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005049, "ELLACOYA NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00504A, "ELTECO A.S." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00504B, "BARCO N.V. BCS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00504C, "GALIL MOTION CONTROL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00504F, "OLENCOM ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005050, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005051, "IWATSU ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005052, "TIARA NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005053, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005054, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005055, "DOMS A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005056, "VMWARE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005057, "BROADBAND ACCESS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005058, "VEGASTREAM LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005059, "SUITE TECHNOLOGY SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00505A, "NETWORK ALCHEMY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00505B, "KAWASAKI LSI U.S.A. INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00505C, "TUNDO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00505E, "DIGITEK MICROLOGIC S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00505F, "BRAND INNOVATORS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005060, "TANDBERG TELECOM AS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005062, "KOUWELL ELECTRONICS CORP. **" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005063, "OY COMSEL SYSTEM AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005064, "CAE ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005065, "NIPPON ELECTRIC INDUSTRY CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005066, "ATECOM GMBH ADVANCED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005067, "AEROCOMM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005068, "ELECTRONIC INDUSTRIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005069, "PIXSTREAM INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00506A, "EDEVA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00506B, "SPXATEG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00506C, "G & L BEIJER ELECTRONICS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00506D, "VIDEOJET SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00506E, "CORDER ENGINEERING CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00506F, "GCONNECT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005070, "CHAINTECH COMPUTER CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005071, "AIWA CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005073, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005074, "ADVANCED HITECH CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005075, "KESTREL SOLUTIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005076, "IBM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005077, "PROLIFIC TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005078, "MEGATON HOUSE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00507A, "XPEED INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00507B, "MERLOT COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00507C, "VIDEOCON AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00507D, "IFP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00507E, "NEWER TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005080, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005081, "MURATA MACHINERY LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005082, "FORESSON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005083, "GILBARCO INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005084, "ATL PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005086, "TELKOM SA LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005087, "TERASAKI ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005088, "AMANO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005089, "SAFETY MANAGEMENT SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00508C, "RSI SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00508D, "ABIT COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00508E, "OPTIMATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00508F, "MULTISTREAM SYSTEMS INTL. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005090, "DCTRI" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005091, "NETACCESS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005092, "RIGAKU INDUSTRIAL CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005093, "BOEING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005094, "PACE MICRO TECHNOLOGY PLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005095, "PERACOM NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005096, "SALIX TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005097, "MMCEMBEDDED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005098, "GLOBALOOP LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x005099, "3COM EUROPE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00509A, "TAG ELECTRONIC SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00509B, "BROADSWITCH AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00509C, "BETA RESEARCH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00509D, "SIMAC BROADBAND" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00509E, "LES TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00509F, "HORIZON COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A0, "DELTA COMPUTER SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A1, "CARLO GAVAZZI INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A2, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A3, "TRANSMEDIA COMMUNICATIONS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A4, "IO TECH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A5, "CAPITOL BUSINESS SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A6, "OPTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A7, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A8, "OPENCON SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050A9, "MOLDAT WIRELESS TECHNOLGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050AA, "KONICA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050AB, "NALTEC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050AC, "MAPLE COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050AD, "COMMUNIQUE WIRELESS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050AF, "INTERGON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B0, "TECHNOLOGY ATLANTA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B1, "GIDDINGS & LEWIS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B2, "BRODEL AUTOMATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B3, "VOICEBOARD CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B4, "SATCHWELL CONTROL SYSTEMS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B5, "FICHETBAUCHE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B6, "GOOD WAY IND. CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B7, "BOSER TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B8, "INOVA COMPUTERS GMBH & CO. KG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050B9, "XITRON TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050BA, "DLINK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050BB, "CMS TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050BC, "HAMMER STORAGE SOLUTIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050BD, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050BE, "FAST MULTIMEDIA AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050BF, "MOTOTECH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C0, "GATAN INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C1, "GEMFLEX NETWORKS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C2, "IEEE REGISTRATION AUTHORITY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C4, "IMD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C5, "ADS TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C6, "LOOP TELECOMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C8, "ADDONICS COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050C9, "MASPRO DENKOH CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050CA, "NET TO NET TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050CB, "JETTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050CC, "XYRATEX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050CD, "DIGIANSWER A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050CE, "LG INTERNATIONAL CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050CF, "VANLINK COMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D0, "MINERVA SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D3, "DIGITAL AUDIO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D4, "JOOHONG INFORMATION &" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D5, "AD SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D6, "ATLAS COPCO TOOLS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D7, "TELSTRAT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D8, "UNICORN COMPUTER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050D9, "ENGETRONENGENHARIA ELETRONICA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050DB, "CONTEMPORARY CONTROL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050DC, "TAS TELEFONBAU A. SCHWABE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050DD, "SERRA SOLDADURA S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050DE, "SIGNUM SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050DF, "AIRFIBER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050E1, "NS TECH ELECTRONICS SDN BHD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050E2, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050E3, "TELEGATE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050E4, "APPLE COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050E6, "HAKUSAN CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050E7, "PARADISE INNOVATIONS (ASIA)" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050EB, "ALPHATOP CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050EC, "OLICOM A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050ED, "ANDA NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050EF, "SPE SYSTEMHAUS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050F1, "LIBIT SIGNAL PROCESSING LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050F2, "MICROSOFT CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050F3, "GLOBAL NET INFORMATION CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050F4, "SIGMATEK GMBH & CO. KG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050F6, "PANINTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050F7, "VENTURE MANUFACTURING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050F8, "ENTREGA TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050FA, "OXTEL LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050FB, "VSK ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050FC, "EDIMAX TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050FD, "ISIONCOMM CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0050FE, "PCTVNET ASA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006000, "XYCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006001, "INNOSYS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006002, "SCREEN SUBTITLING SYSTEMS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006003, "TERAOKA WEIGH SYSTEM PTE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006004, "COMPUTADORES MODULARES SA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006005, "FEEDBACK DATA LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006006, "SOTEC CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006007, "ACRES GAMING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006008, "3COM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006009, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00600A, "SORD COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00600B, "LOGWARE GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00600C, "APPLIED DATA SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00600D, "MICRODESIGN GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00600E, "WAVENET INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00600F, "WESTELL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006010, "NETWORK MACHINES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006011, "CRYSTAL SEMICONDUCTOR CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006012, "POWER COMPUTING CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006013, "NETSTAL MASCHINEN AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006014, "EDEC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006015, "NET2NET CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006016, "CLARIION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006017, "TOKIMEC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006018, "STELLAR ONE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006019, "BOEHRINGER MANNHEIM CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00601A, "KEITHLEY INSTRUMENTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00601B, "MESA ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00601C, "TELXON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00601D, "LUCENT TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00601E, "SOFTLAB INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00601F, "STALLION TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006020, "PIVOTAL NETWORKING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006021, "DSC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006022, "VICOM SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006023, "PERICOM SEMICONDUCTOR CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006024, "GRADIENT TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006025, "ACTIVE IMAGING PLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006026, "VIKING COMPONENTS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006027, "GENERAL TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006028, "MACROVISION CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006029, "CARY PERIPHERALS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00602A, "SYMICRON COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00602B, "PEAK AUDIO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00602C, "LINX DATA TERMINALS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00602D, "ALERTON TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00602E, "CYCLADES CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00602F, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006030, "VILLAGE TRONIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006031, "HRK SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006032, "ICUBE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006033, "ACUITY IMAGING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006034, "ROBERT BOSCH GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006035, "DALLAS SEMICONDUCTOR INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006036, "AUSTRIAN RESEARCH CENTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006037, "PHILIPS SEMICONDUCTORS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006038, "NORTEL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006039, "SANCOM TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00603A, "QUICK CONTROLS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00603B, "AMTEC SPA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00603C, "HAGIWARA SYSCOM CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00603D, "3CX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00603E, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00603F, "PATAPSCO DESIGNS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006040, "NETRO CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006041, "3A INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006042, "TKS (USA) INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006043, "COMSOFT SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006044, "LITTON/POLYSCIENTIFIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006045, "PATHLIGHT TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006046, "VMETRO INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006047, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006048, "EMC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006049, "VINA TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00604A, "SAIC IDEAS GROUP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00604B, "BIODATA GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00604C, "SAT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00604D, "MMC NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00604E, "CYCLE COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00604F, "SUZUKI MFG. CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006050, "INTERNIX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006051, "QUALITY SEMICONDUCTOR" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006052, "PERIPHERALS ENTERPRISE CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006053, "TOYODA MACHINE WORKS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006054, "CONTROLWARE GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006055, "CORNELL UNIVERSITY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006056, "NETWORK TOOLS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006057, "MURATA MANUFACTURING CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006058, "COPPER MOUNTAIN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006059, "TECHNICAL COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00605A, "CELCORE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00605B, "INTRASERVER TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00605C, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00605D, "SCANIVALVE CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00605E, "LIBERTY TECHNOLOGY NETWORKING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00605F, "NIPPON UNISOFT CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006060, "DAWNING TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006061, "WHISTLE COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006062, "TELESYNC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006063, "PSION DACOM PLC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006064, "NETCOMM LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006065, "BERNECKER & RAINER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006066, "LACROIX TECHNOLGIE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006067, "ACER NETXUS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006068, "EICON TECHNOLOGY CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006069, "BROCADE COMMUNICATIONS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00606A, "MITSUBISHI WIRELESS COMM. INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00606B, "AICHI ELECTRONICS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00606C, "ARESCOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00606D, "DIGITAL EQUIPMENT CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00606E, "DAVICOM SEMICONDUCTOR INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00606F, "CLARION CORPORATION OF AMERICA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006070, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006071, "MIDAS LAB INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006072, "VXL INSTRUMENTS LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006073, "REDCREEK COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006074, "QSC AUDIO PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006075, "PENTEK INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006076, "SCHLUMBERGER TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006077, "PRISA NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006078, "POWER MEASUREMENT LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006079, "WAVEPHORE NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00607A, "DVS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00607B, "FORE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00607C, "WAVEACCESS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00607D, "SENTIENT NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00607E, "GIGALABS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00607F, "AURORA TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006080, "MICROTRONIX DATACOM LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006081, "TV/COM INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006082, "NOVALINK TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006083, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006084, "DIGITAL VIDEO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006085, "STORAGE CONCEPTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006086, "LOGIC REPLACEMENT TECH. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006087, "KANSAI ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006088, "WHITE MOUNTAIN DSP INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006089, "XATA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00608A, "CITADEL COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00608B, "CONFERTECH INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00608C, "3COM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00608D, "UNIPULSE CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00608E, "HE ELECTRONICS TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00608F, "TEKRAM TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006090, "ABLE COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006091, "FIRST PACIFIC NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006092, "MICRO/SYS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006093, "VARIAN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006094, "IBM CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006095, "ACCUTIME SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006096, "T.S. MICROTECH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006097, "3COM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006098, "HT COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x006099, "LAN MEDIA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00609A, "NJK TECHNO CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00609B, "ASTROMED INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00609C, "PERKINELMER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00609D, "PMI FOOD EQUIPMENT GROUP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00609E, "X3 INFORMATION TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00609F, "PHAST CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A0, "SWITCHED NETWORK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A1, "VPNET" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A2, "NIHON UNISYS LIMITED CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A3, "CONTINUUM TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A4, "GRINAKER SYSTEM TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A5, "PERFORMANCE TELECOM CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A6, "PARTICLE MEASURING SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A7, "MICROSENS GMBH & CO. KG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A8, "TIDOMAT AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060A9, "GESYTEC MBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060AA, "INTELLIGENT DEVICES INC. (IDI)" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060AB, "LARSCOM INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060AC, "RESILIENCE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060AD, "MEGACHIPS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060AE, "TRIO INFORMATION SYSTEMS AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060AF, "PACIFIC MICRO DATA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B0, "HEWLETT-PACKARD CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B1, "INPUT/OUTPUT INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B2, "PROCESS CONTROL CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B3, "ZCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B4, "GLENAYRE R&D INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B5, "KEBA GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B6, "LAND COMPUTER CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B7, "CHANNELMATIC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B8, "CORELIS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060B9, "NITSUKO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060BA, "SAHARA NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060BB, "CABLETRON NETLINK INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060BC, "KEUNYOUNG ELECTRONICS &" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060BD, "HUBBELLPULSECOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060BE, "WEBTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060BF, "MACRAIGOR SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C0, "NERA AS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C1, "WAVESPAN CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C2, "MPL AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C3, "NETVISION CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C4, "SOLITON SYSTEMS K.K." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C5, "ANCOT CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C6, "DCS AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C7, "AMATI COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C8, "KUKA WELDING SYSTEMS & ROBOTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060C9, "CONTROLNET INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060CA, "HARMONIC SYSTEMS INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060CB, "HITACHI ZOSEN CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060CC, "EMTRAK INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060CD, "VIDEOSERVER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060CE, "ACCLAIM COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060CF, "ALTEON NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D0, "SNMP RESEARCH INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D1, "CASCADE COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D2, "LUCENT TECHNOLOGIES TAIWAN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D3, "AT&T" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D4, "ELDAT COMMUNICATION LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D5, "MIYACHI TECHNOS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D6, "NOVATEL WIRELESS TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D7, "ECOLE POLYTECHNIQUE FEDERALE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D8, "ELMIC SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060D9, "TRANSYS NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060DA, "JBM ELECTRONICS CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060DB, "NTP ELEKTRONIK A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060DC, "TOYO COMMUNICATION EQUIPMENT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060DD, "MYRICOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060DE, "KAYSERTHREDE GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060DF, "INRANGE TECHNOLOGIES CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E0, "AXIOM TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E1, "ORCKIT COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E2, "QUEST ENGINEERING & DEV." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E3, "ARBIN INSTRUMENTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E4, "COMPUSERVE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E5, "FUJI AUTOMATION CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E6, "SHOMITI SYSTEMS INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E7, "RANDATA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E8, "HITACHI COMPUTER PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060E9, "ATOP TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060EA, "STREAMLOGIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060EB, "FOURTHTRACK SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060EC, "HERMARY OPTO ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060ED, "RICARDO TEST AUTOMATION LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060EE, "APOLLO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060EF, "FLYTECH TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F0, "JOHNSON & JOHNSON MEDICAL INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F1, "EXP COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F2, "LASERGRAPHICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F3, "NETCOM SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F4, "ADVANCED COMPUTER SOLUTIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F5, "ICON WEST INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F6, "NEXTEST COMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F7, "DATAFUSION SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F8, "LORAN INTERNATIONAL TECHN. INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060F9, "DIAMOND LANE COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060FA, "EDUCATIONAL TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060FB, "PACKETEER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060FC, "CONSERVATION THROUGH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060FD, "NETICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060FE, "LYNX SYSTEM DEVELOPERS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0060FF, "QUVIS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0070B0, "M/ACOM INC. COMPANIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0070B3, "DATA RECALL LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008000, "MULTITECH SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008001, "PERIPHONICS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008002, "SATELCOM (UK) LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008003, "HYTEC ELECTRONICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008004, "ANTLOW COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008005, "CACTUS COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008006, "COMPUADD CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008007, "DLOG NCSYSTEME" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008008, "DYNATECH COMPUTER SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008009, "JUPITER SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00800A, "JAPAN COMPUTER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00800B, "CSK CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00800C, "VIDECOM LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00800D, "VOSSWINKEL F.U." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00800E, "ATLANTIX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00800F, "STANDARD MICROSYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008010, "COMMODORE INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008011, "DIGITAL SYSTEMS INT'L. INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008012, "INTEGRATED MEASUREMENT SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008013, "THOMASCONRAD CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008014, "ESPRIT SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008015, "SEIKO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008016, "WANDEL AND GOLTERMANN" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008017, "PFU LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008018, "KOBE STEEL LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008019, "DAYNA COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00801A, "BELL ATLANTIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00801B, "KODIAK TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00801C, "NEWPORT SYSTEMS SOLUTIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00801D, "INTEGRATED INFERENCE MACHINES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00801E, "XINETRON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00801F, "KRUPP ATLAS ELECTRONIK GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008020, "NETWORK PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008021, "NEWBRIDGE RESEARCH CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008022, "SCANOPTICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008023, "INTEGRATED BUSINESS NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008024, "KALPANA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008025, "STOLLMANN GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008026, "NETWORK PRODUCTS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008027, "ADAPTIVE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008028, "TRADPOST (HK) LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008029, "EAGLE TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00802A, "TEST SYSTEMS & SIMULATIONS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00802B, "INTEGRATED MARKETING CO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00802C, "THE SAGE GROUP PLC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00802D, "XYLOGICS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00802E, "CASTLE ROCK COMPUTING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00802F, "NATIONAL INSTRUMENTS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008030, "NEXUS ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008031, "BASYS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008032, "ACCESS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008033, "FORMATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008034, "SMT GOUPIL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008035, "TECHNOLOGY WORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008036, "REFLEX MANUFACTURING SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008037, "TELEFON AB LM ERICSSON CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008038, "DATA RESEARCH & APPLICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008039, "ALCATEL STC AUSTRALIA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00803A, "VARITYPER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00803B, "APT COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00803C, "TVS ELECTRONICS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00803D, "SURIGIKEN CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00803E, "SYNERNETICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00803F, "TATUNG COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008040, "JOHN FLUKE MANUFACTURING CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008041, "VEB KOMBINAT ROBOTRON" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008042, "FORCE COMPUTERS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008043, "NETWORLD INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008044, "SYSTECH COMPUTER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008045, "MATSUSHITA ELECTRIC IND. CO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008046, "UNIVERSITY OF TORONTO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008047, "INNET CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008048, "COMPEX INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008049, "NISSIN ELECTRIC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00804A, "PROLOG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00804B, "EAGLE TECHNOLOGIES PTY.LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00804C, "CONTEC CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00804D, "CYCLONE MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00804E, "APEX COMPUTER COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00804F, "DAIKIN INDUSTRIES LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008050, "ZIATECH CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008051, "FIBERMUX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008052, "TECHNICALLY ELITE CONCEPTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008053, "INTELLICOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008054, "FRONTIER TECHNOLOGIES CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008055, "FERMILAB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008056, "SPHINX ELEKTRONIK GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008057, "ADSOFT LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008058, "PRINTER SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008059, "STANLEY ELECTRIC CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00805A, "TULIP COMPUTERS INTERNAT'L B.V" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00805B, "CONDOR SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00805C, "AGILIS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00805D, "CANSTAR" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00805E, "LSI LOGIC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00805F, "COMPAQ COMPUTER CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008060, "NETWORK INTERFACE CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008061, "LITTON SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008062, "INTERFACE CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008063, "RICHARD HIRSCHMANN GMBH & CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008064, "WYSE TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008065, "CYBERGRAPHIC SYSTEMS PTY LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008066, "ARCOM CONTROL SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008067, "SQUARE D COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008068, "YAMATECH SCIENTIFIC LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008069, "COMPUTONE SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00806A, "ERI (EMPAC RESEARCH INC.)" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00806B, "SCHMID TELECOMMUNICATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00806C, "CEGELEC PROJECTS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00806D, "CENTURY SYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00806E, "NIPPON STEEL CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00806F, "ONELAN LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008070, "COMPUTADORAS MICRON" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008071, "SAI TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008072, "MICROPLEX SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008073, "DWB ASSOCIATES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008074, "FISHER CONTROLS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008075, "PARSYTEC GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008076, "MCNC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008077, "BROTHER INDUSTRIES LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008078, "PRACTICAL PERIPHERALS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008079, "MICROBUS DESIGNS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00807A, "AITECH SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00807B, "ARTEL COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00807C, "FIBERCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00807D, "EQUINOX SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00807E, "SOUTHERN PACIFIC LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00807F, "DY4 INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008080, "DATAMEDIA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008081, "KENDALL SQUARE RESEARCH CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008082, "PEP MODULAR COMPUTERS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008083, "AMDAHL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008084, "THE CLOUD INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008085, "HTHREE SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008086, "COMPUTER GENERATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008087, "OKI ELECTRIC INDUSTRY CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008088, "VICTOR COMPANY OF JAPAN LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008089, "TECNETICS (PTY) LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00808A, "SUMMIT MICROSYSTEMS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00808B, "DACOLL LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00808C, "FRONTIER SOFTWARE DEVELOPMENT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00808D, "WESTCOAST TECHNOLOGY B.V." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00808E, "RADSTONE TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00808F, "C. ITOH ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008090, "MICROTEK INTERNATIONAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008091, "TOKYO ELECTRIC CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008092, "JAPAN COMPUTER INDUSTRY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008093, "XYRON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008094, "ALFA LAVAL AUTOMATION AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008095, "BASIC MERTON HANDELSGES.M.B.H." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008096, "HUMAN DESIGNED SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008097, "CENTRALP AUTOMATISMES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008098, "TDK CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x008099, "KLOCKNER MOELLER IPC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00809A, "NOVUS NETWORKS LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00809B, "JUSTSYSTEM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00809C, "LUXCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00809D, "DATACRAFT MANUFACTUR'G PTY LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00809E, "DATUS GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00809F, "ALCATEL BUSINESS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A0, "EDISA HEWLETT PACKARD S/A" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A1, "MICROTEST INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A2, "CREATIVE ELECTRONIC SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A3, "LANTRONIX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A4, "LIBERTY ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A5, "SPEED INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A6, "REPUBLIC TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A7, "MEASUREX CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A8, "VITACOM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080A9, "CLEARPOINT RESEARCH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080AA, "MAXPEED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080AB, "DUKANE NETWORK INTEGRATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080AC, "IMLOGIX DIVISION OF GENESYS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080AD, "CNET TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080AE, "HUGHES NETWORK SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080AF, "ALLUMER CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B0, "ADVANCED INFORMATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B1, "SOFTCOM A/S" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B2, "NETWORK EQUIPMENT TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B3, "AVAL DATA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B4, "SOPHIA SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B5, "UNITED NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B6, "THEMIS COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B7, "STELLAR COMPUTER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B8, "BUG INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080B9, "ARCHE TECHNOLIGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080BA, "SPECIALIX (ASIA) PTE LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080BB, "HUGHES LAN SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080BC, "HITACHI ENGINEERING CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080BD, "THE FURUKAWA ELECTRIC CO. LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080BE, "ARIES RESEARCH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080BF, "TAKAOKA ELECTRIC MFG. CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C0, "PENRIL DATACOMM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C1, "LANEX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C2, "IEEE 802 COMMITTEE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C3, "BICC INFORMATION SYSTEMS & SVC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C4, "DOCUMENT TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C5, "NOVELLCO DE MEXICO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C6, "NATIONAL DATACOMM CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C7, "XIRCOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C8, "DLINK SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080C9, "ALBERTA MICROELECTRONIC CENTRE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080CA, "NETCOM RESEARCH INCORPORATED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080CB, "FALCO DATA PRODUCTS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080CC, "MICROWAVE BYPASS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080CD, "MICRONICS COMPUTER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080CE, "BROADCAST TELEVISION SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080CF, "EMBEDDED PERFORMANCE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D0, "COMPUTER PERIPHERALS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D1, "KIMTRON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D2, "SHINNIHONDENKO CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D3, "SHIVA CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D4, "CHASE RESEARCH LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D5, "CADRE TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D6, "NUVOTECH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D7, "FANTUM ENGINEERING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D8, "NETWORK PERIPHERALS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080D9, "EMK ELEKTRONIK" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080DA, "BRUEL & KJAER" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080DB, "GRAPHON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080DC, "PICKER INTERNATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080DD, "GMX INC/GIMIX" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080DE, "GIPSI S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080DF, "ADC CODENOLL TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E0, "XTP SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E1, "STMICROELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E2, "T.D.I. CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E3, "CORAL NETWORK CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E4, "NORTHWEST DIGITAL SYSTEMS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E5, "MYLEX CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E6, "PEER NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E7, "LYNWOOD SCIENTIFIC DEV. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E8, "CUMULUS CORPORATIION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080E9, "MADGE NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080EA, "THE FIBER COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080EB, "COMPCONTROL B.V." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080EC, "SUPERCOMPUTING SOLUTIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080ED, "IQ TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080EE, "THOMSON CSF" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080EF, "RATIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F0, "KYUSHU MATSUSHITA ELECTRIC CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F1, "OPUS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F2, "RAYCOM SYSTEMS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F3, "SUN ELECTRONICS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F4, "TELEMECANIQUE ELECTRIQUE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F5, "QUANTEL LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F6, "SYNERGY MICROSYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F7, "ZENITH ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F8, "MIZAR INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080F9, "HEURIKON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080FA, "RWT GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080FB, "BVM LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080FC, "AVATAR CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080FD, "EXSCEED CORPRATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080FE, "AZURE TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0080FF, "SOC. DE TELEINFORMATIQUE RTC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009000, "DIAMOND MULTIMEDIA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009001, "NISHIMU ELCTRONICS INDUSTRIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009002, "ALLGON WESTCOM AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009003, "APLIO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009004, "3COM EUROPE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009005, "PROTECH SYSTEMS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009006, "HAMAMATSU PHOTONICS K.K." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009007, "DOMEX TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009008, "HAN A SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009009, "HYUNDAI INFORMATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00900A, "PROTON ELECTRONIC INDUSTRIAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00900B, "LANNER ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00900C, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00900D, "OVERLAND DATA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00900E, "HANDLINK TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00900F, "KAWASAKI HEAVY INDUSTRIES LTD" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009010, "SIMULATION LABORATORIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009011, "WAVTRACE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009012, "GLOBESPAN SEMICONDUCTOR INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009013, "SAMSAN CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009014, "ROTORK INSTRUMENTS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009015, "CENTIGRAM COMMUNICATIONS CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009016, "ZAC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009017, "ZYPCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009018, "ITO ELECTRIC INDUSTRY CO LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009019, "HERMES ELECTRONICS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00901A, "REDSTONE COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00901B, "DIGITAL CONTROLS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00901C, "MPS SOFTWARE GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00901D, "PEC (NZ) LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00901E, "SELESTA INGEGNE RIA S.P.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00901F, "ADTEC PRODUCTIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009020, "PHILIPS ANALYTICAL XRAY B.V." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009021, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009022, "BRIVIDA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009023, "ZILOG INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009024, "PIPELINKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009025, "VISION SYSTEMS LTD. PTY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009026, "ADVANCED SWITCHING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009027, "INTEL CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009028, "NIPPON SIGNAL CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009029, "CRYPTO AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00902A, "COMMUNICATION DEVICES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00902B, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00902C, "DATA & CONTROL EQUIPMENT LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00902D, "DATA ELECTRONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00902E, "NAMCO LIMITED" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00902F, "NETCORE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009030, "HONEYWELLDATING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009031, "MYSTICOM LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009032, "PELCOMBE GROUP LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009033, "INNOVAPHONE GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009034, "IMAGIC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009035, "ALPHA TELECOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009036, "ENS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009037, "ACUCOMM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009038, "FOUNTAIN TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009039, "SHASTA NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00903A, "NIHON MEDIA TOOL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00903B, "TRIEMS RESEARCH LAB INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00903C, "ATLANTIC NETWORK SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00903D, "BIOPAC SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00903E, "N.V. PHILIPS INDUSTRIAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00903F, "AZTEC RADIOMEDIA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009040, "CASTLE NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009041, "APPLIED DIGITAL ACCESS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009042, "ECCS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009043, "NICHIBEI DENSHI CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009044, "ASSURED DIGITAL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009045, "MARIPOSA TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009046, "DEXDYNE LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009047, "GIGA FAST E. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009048, "ZEAL CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009049, "ENTRIDIA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00904A, "CONCUR SYSTEM TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00904B, "GEMTEK TECHNOLOGY CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00904C, "EPIGRAM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00904D, "SPEC S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00904E, "DELEM BV" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00904F, "ABB POWER T&D COMPANY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009050, "TELESTE OY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009051, "ULTIMATE TECHNOLOGY CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009052, "SELCOM ELETTRONICA S.R.L." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009053, "DAEWOO ELECTRONICS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009054, "INNOVATIVE SEMICONDUCTORS INC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009055, "PARKER HANNIFIN CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009056, "TELESTREAM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009057, "AANETCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009058, "ULTRA ELECTRONICS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009059, "TELECOM DEVICE K.K." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00905A, "DEARBORN GROUP INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00905B, "RAYMOND AND LAE ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00905C, "EDMI" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00905D, "NETCOM SICHERHEITSTECHNIK GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00905E, "RAULANDBORG CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00905F, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009060, "SYSTEM CREATE CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009061, "PACIFIC RESEARCH & ENGINEERING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009062, "ICP VORTEX COMPUTERSYSTEME" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009063, "COHERENT COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009064, "THOMSON BROADCAST SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009065, "FINISAR CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009066, "TROIKA DESIGN INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009067, "WALKABOUT COMPUTERS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009068, "DVT CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009069, "JUNIPER NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00906A, "TURNSTONE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00906B, "APPLIED RESOURCES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00906C, "GWT GLOBAL WEIGHING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00906D, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00906E, "PRAXON INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00906F, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009070, "NEO NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009071, "BADGER TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009072, "SIMRAD AS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009073, "GAIO TECHNOLOGY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009074, "ARGON NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009075, "NEC DO BRASIL S.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009076, "FMT AIRCRAFT GATE SUPPORT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009077, "ADVANCED FIBRE COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009078, "MER TELEMANAGEMENT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009079, "CLEARONE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00907A, "SPECTRALINK CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00907B, "ETECH INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00907C, "DIGITALCAST INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00907D, "HOME WIRELESS NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00907E, "VETRONIX CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00907F, "WATCHGUARD TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009080, "NOT LIMITED INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009081, "ALOHA NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009082, "FORCE INSTITUTE" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009083, "TURBO COMMUNICATION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009084, "ATECH SYSTEM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009085, "GOLDEN ENTERPRISES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009086, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009087, "ITIS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009088, "BAXALL SECURITY LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009089, "SOFTCOM MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00908A, "BAYLY COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00908B, "CELL COMPUTING INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00908C, "ETREND ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00908D, "VICKERS ELECTRONICS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00908E, "PROMATORY COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00908F, "AUDIOCODES LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009090, "IBUS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009091, "DIGITALSCAPE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009092, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009093, "NANAO CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009094, "OSPREY TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009095, "UNIVERSAL AVIONICS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009096, "ASKEY COMPUTER CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009097, "SYCAMORE NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009098, "SBC DESIGNS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009099, "ALLIED TELESIS K.K." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00909A, "ONE WORLD SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00909B, "MARKPOINT AB" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00909C, "COMBOX LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00909D, "GSE SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00909E, "DELPHI ENGINEERING GROUP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00909F, "DIGIDATA CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A0, "8X8 INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A1, "FLYING PIG SYSTEMS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A2, "CYBERTAN TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A3, "MEDIALINCS CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A4, "ALTIGA NETWORKS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A5, "SPECTRA LOGIC" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A6, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A7, "CLIENTEC CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A8, "NINETILES NETWORKS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090A9, "WESTERN DIGITAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090AA, "INDIGO ACTIVE VISION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090AB, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090AC, "OPTIVISION INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090AD, "ASPECT ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090AE, "ITALTEL SPA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090AF, "J. MORITA MFG. CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B0, "VADEM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B1, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B2, "AVICI SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B3, "AGRANAT SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B4, "WILLOWBROOK TECHNOLOGIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B5, "NIKON CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B6, "FIBEX SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B7, "DIGITAL LIGHTWAVE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B8, "ROHDE & SCHWARZ GMBH & CO. KG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090B9, "BERAN INSTRUMENTS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090BA, "VALID NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090BB, "TAINET COMMUNICATION SYSTEM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090BC, "TELEMANN CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090BD, "OMNIA COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090BE, "IBC/INTEGRATED BUSINESS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090BF, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C0, "K.J. LAW ENGINEERS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C1, "EDA INDUSTRIES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C2, "JK MICROSYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C3, "TOPIC SEMICONDUCTOR CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C4, "JAVELIN SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C5, "INTERNET MAGIC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C6, "OPTIM SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C7, "ICOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C8, "WAVERIDER COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090C9, "PRODUCTIVITY ENHANCEMENT" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090CA, "ACCORD VIDEO" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090CB, "WIRELESS ONLINE INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090CC, "PLANEX COMMUNICATIONS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090CD, "ENTEMPRESA NACIONAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090CE, "TETRA GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090CF, "NORTEL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D0, "ALCATEL BELL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D1, "LEICHU ENTERPRISE CO. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D2, "ARTEL VIDEO SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D3, "GIESECKE & DEVRIENT GMBH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D4, "BINDVIEW DEVELOPMENT CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D5, "EUPHONIX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D6, "CRYSTAL GROUP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D7, "NETBOOST CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D8, "WHITECROSS SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090D9, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090DA, "DYNARC INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090DB, "NEXT LEVEL COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090DC, "TECO INFORMATION SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090DD, "THE MIHARU COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090DE, "CARDKEY SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090DF, "MITSUBISHI CHEMICAL" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E0, "SYSTRAN CORP." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E1, "TELENA S.P.A." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E2, "DISTRIBUTED PROCESSING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E3, "AVEX ELECTRONICS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E4, "NEC AMERICA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E5, "TEKNEMA INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E6, "ACER LABORATORIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E7, "HORSCH ELEKTRONIK AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E8, "MOXA TECHNOLOGIES CORP. LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090E9, "JANZ COMPUTER AG" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090EA, "ALPHA TECHNOLOGIES INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090EB, "SENTRY TELECOM SYSTEMS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090EC, "PYRESCOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090ED, "CENTRAL SYSTEM RESEARCH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090EE, "PERSONAL COMMUNICATIONS" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090EF, "INTEGRIX INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F0, "HARMONIC LIGHTWAVES LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F1, "BOXHILL SYSTEMS CORPORATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F2, "CISCO SYSTEMS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F3, "ASPECT TELECOMMUNICATIONS CORP" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F4, "LIGHTNING INSTRUMENTATION" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F5, "CLEVO CO." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F6, "ESCALATE NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F7, "NBASE COMMUNICATIONS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F8, "MEDIATRIX TELECOM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090F9, "LEITCH" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090FA, "GIGANET INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090FB, "PORTWELL INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090FC, "NETWORK COMPUTING DEVICES" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090FD, "COPPERCOM INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090FE, "ELECOM CO. LTD. (LANEED DIV.)" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x0090FF, "TELLUS TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x009D8E, "CARDIAC RECORDERS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A000, "CENTILLION NETWORKS INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A001, "WATKINSJOHNSON COMPANY" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A002, "LEEDS & NORTHRUP AUSTRALIA" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A003, "STAEFA CONTROL SYSTEM" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A004, "NETPOWER INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A005, "DANIEL INSTRUMENTS LTD." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A006, "IMAGE DATA PROCESSING" },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A007, "APEXX TECHNOLOGY INC." },
  { 0x000001, "XEROX CORPORATION" },
  { 0x00A008, "NETCORP" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A009, "WHITETREE NETWORK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A00A, "R.D.C. COMMUNICATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A00B, "COMPUTEX CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A00C, "KINGMAX TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A00D, "THE PANDA PROJECT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A00E, "VISUAL NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A00F, "BROADBAND TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A010, "SYSLOGIC DATENTECHNIK AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A011, "MUTOH INDUSTRIES LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A012, "B.A.T.M. ADVANCED TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A013, "SECURICOR TELECOMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A014, "CSIR" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A015, "WYLE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A016, "MICROPOLIS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A017, "J B M CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A018, "CREATIVE CONTROLLERS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A019, "NEBULA CONSULTANTS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A01A, "BINAR ELEKTRONIK AB" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A01B, "PREMISYS COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A01C, "NASCENT NETWORKS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A01D, "SIXNET" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A01E, "EST CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A01F, "TRICORD SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A020, "CITICORP/TTI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A021, "GTE GOVERNMENT SYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A022, "CENTRE FOR DEVELOPMENT OF" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A023, "APPLIED CREATIVE TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A024, "3COM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A025, "REDCOM LABS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A026, "TELDAT S.A." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A027, "FIREPOWER SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A028, "CONNER PERIPHERALS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A029, "COULTER CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A02A, "TRANCELL SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A02B, "TRANSITIONS RESEARCH CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A02C, "INTERWAVE COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A02D, "SKIPSTONE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A02E, "BRAND COMMUNICATIONS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A02F, "PIRELLI CAVI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A030, "CAPTOR NV/SA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A031, "HAZELTINE CORPORATION MS 117" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A032, "GES SINGAPORE PTE. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A033, "IMC MESSSYSTEME GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A034, "AXEL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A035, "CYLINK CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A036, "APPLIED NETWORK TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A037, "DATASCOPE CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A038, "EMAIL ELECTRONICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A039, "ROSS TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A03A, "KUBOTEK CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A03B, "TOSHIN ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A03C, "EG&G NUCLEAR INSTRUMENTS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A03D, "OPTO 22" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A03E, "ATM FORUM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A03F, "COMPUTER SOCIETY MICROPROCES'R" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A040, "APPLE COMPUTER" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A041, "LEYBOLDINFICON" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A042, "SPUR PRODUCTS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A043, "AMERICAN TECHNOLOGY LABS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A044, "NTT INTELLIGENT TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A045, "PHOENIX CONTACT GMBH & CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A046, "SCITEX CORP. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A047, "INTEGRATED FITNESS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A048, "QUESTECH LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A049, "DIGITECH INDUSTRIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A04A, "NISSHIN ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A04B, "TFL LAN INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A04C, "INNOVATIVE SYSTEMS & TECH. INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A04D, "EDA INSTRUMENTS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A04E, "VOELKER TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A04F, "AMERITEC CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A050, "CYPRESS SEMICONDUCTOR" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A051, "ANGIA COMMUNICATIONS. INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A052, "STANILITE ELECTRONICS PTY. LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A053, "COMPACT DEVICES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A054, "GASSAN SALMAN" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A055, "LINKTECH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A056, "MICROPROSS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A057, "ELSA AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A058, "GLORY LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A059, "HAMILTON HALLMARK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A05A, "KOFAX IMAGE PRODUCTS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A05B, "MARQUIP INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A05C, "INVENTORY CONVERSION INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A05D, "CS COMPUTER SYSTEME GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A05E, "MYRIAD LOGIC INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A05F, "BTG ENGINEERING BV" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A060, "ACER PERIPHERALS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A061, "PURITAN BENNETT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A062, "AES PRODATA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A063, "JRL SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A064, "KVB/ANALECT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A065, "NEXLAND INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A066, "ISA CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A067, "NETWORK SERVICES GROUP" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A069, "TRUETIME" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A06A, "VERILINK CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A06B, "DMS DORSCH MIKROSYSTEM GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A06D, "MANNESMANN TALLY CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A06E, "AUSTRON INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A06F, "THE APPCON GROUP INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A070, "COASTCOM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A071, "VIDEO LOTTERY TECHNOLOGIES INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A072, "OVATION SYSTEMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A073, "COM21 INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A074, "PERCEPTION TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A075, "MICRON ELECTRONICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A076, "CARDWARE LAB INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A077, "FUJITSU NEXION INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A078, "CELLACCESS TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A079, "ALPS ELECTRIC (USA) INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A07A, "ADVANCED PERIPHERALS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A07B, "DAWN COMPUTER INCORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A07C, "TONYANG NYLON CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A07D, "SEEQ TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A07E, "AVID TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A07F, "GSMSYNTEL LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A080, "ANTARES MICROSYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A081, "ALCATEL DATA NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A082, "NKT ELEKTRONIK A/S" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A083, "ASIMMPHONY TURKEY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A084, "DATAPLEX PTY. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A086, "AMBER WAVE SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A087, "MITEL SEMICONDUCTOR LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A088, "ESSENTIAL COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A089, "XPOINT TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A08A, "BROOKTROUT TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A08B, "ASTON ELECTRONIC DESIGNS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A08C, "MULTIMEDIA LANS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A08D, "JACOMO CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A08E, "IPSILON NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A08F, "DESKNET SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A090, "TIMESTEP CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A091, "APPLICOM INTERNATIONAL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A092, "H. BOLLMANN MANUFACTURERS LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A093, "B/E AEROSPACE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A094, "COMSAT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A095, "ACACIA NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A096, "MITSUMI ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A097, "JC INFORMATION SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A098, "NETWORK APPLIANCE CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A099, "KNET LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A09A, "NIHON KOHDEN AMERICA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A09B, "QPSX COMMUNICATIONS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A09C, "XYPLEX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A09D, "JOHNATHON FREEMAN TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A09E, "ICTV" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A09F, "COMMVISION CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A0, "COMPACT DATA LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A1, "EPIC DATA INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A2, "DIGICOM S.P.A." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A3, "RELIABLE POWER METERS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A4, "MICROS SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A5, "TEKNOR MICROSYSTEME INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A6, "M.I. SYSTEMS K.K." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A7, "VORAX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A8, "RENEX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0A9, "GN NETTEST (CANADA) INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0AA, "SPACELABS MEDICAL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0AB, "NETCS INFORMATIONSTECHNIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0AC, "GILAT SATELLITE NETWORKS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0AD, "MARCONI SPA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0AE, "NUCOM SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0AF, "WMS INDUSTRIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B0, "IO DATA DEVICE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B1, "FIRST VIRTUAL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B2, "SHIMA SEIKI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B3, "ZYKRONIX" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B4, "TEXAS MICROSYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B5, "3H TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B6, "SANRITZ AUTOMATION CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B7, "CORDANT INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B8, "SYMBIOS LOGIC INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0B9, "EAGLE TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0BA, "PATTON ELECTRONICS CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0BB, "HILAN GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0BC, "VIASAT INCORPORATED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0BD, "ITECH CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0BE, "INTEGRATED CIRCUIT SYSTEMS INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0BF, "WIRELESS DATA GROUP MOTOROLA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C0, "DIGITAL LINK CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C1, "ORTIVUS MEDICAL AB" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C2, "R.A. SYSTEMS CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C3, "UNICOMPUTER GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C4, "CRISTIE ELECTRONICS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C5, "ZYXEL COMMUNICATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C6, "QUALCOMM INCORPORATED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C7, "TADIRAN TELECOMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C8, "ADTRAN INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0C9, "INTEL CORPORATION HF106" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0CA, "FUJITSU DENSO LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0CB, "ARK TELECOMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0CC, "LITEON COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0CD, "DR. JOHANNES HEIDENHAIN GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0CE, "ASTROCOM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0CF, "SOTAS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D0, "TEN X TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D1, "INVENTEC CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D2, "ALLIED TELESIS INTERNATIONAL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D3, "INSTEM COMPUTER SYSTEMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D4, "RADIOLAN INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D5, "SIERRA WIRELESS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D6, "SBE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D7, "KASTEN CHASE APPLIED RESEARCH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D8, "SPECTRA TEK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0D9, "CONVEX COMPUTER CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0DA, "INTEGRATED SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0DB, "FISHER & PAYKEL PRODUCTION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0DC, "O.N. ELECTRONIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0DD, "AZONIX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0DE, "YAMAHA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0DF, "STS TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E0, "TENNYSON TECHNOLOGIES PTY LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E1, "WESTPORT RESEARCH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E2, "KEISOKU GIKEN CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E3, "XKL SYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E4, "OPTIQUEST" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E5, "NHC COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E6, "DIALOGIC CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E7, "CENTRAL DATA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E8, "REUTERS HOLDINGS PLC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0E9, "ELECTRONIC RETAILING SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0EA, "ETHERCOM CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0EB, "FASTCOMM COMMUNICATIONS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0EC, "TRANSMITTON LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0ED, "PRI AUTOMATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0EE, "NASHOBA NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0EF, "LUCIDATA LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F0, "TORONTO MICROELECTRONICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F1, "MTI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F2, "INFOTEK COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F3, "STAUBLI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F4, "GE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F5, "RADGUARD LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F6, "AUTOGAS SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F7, "V.I COMPUTER CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F8, "SYMBOL TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0F9, "BINTEC COMMUNICATIONS GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0FA, "ANT NACHRICHTENTECHNIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0FB, "TORAY ENGINEERING CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0FC, "IMAGE SCIENCES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0FD, "SCITEX DIGITAL PRINTING INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0FE, "BOSTON TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00A0FF, "TELLABS OPERATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00AA00, "INTEL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00AA01, "INTEL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00AA02, "INTEL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00AA3C, "OLIVETTI TELECOM SPA (OLTECO)" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00BB01, "OCTOTHORPE CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00BBF0, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C000, "LANOPTICS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C001, "DIATEK PATIENT MANAGMENT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C002, "SERCOMM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C003, "GLOBALNET COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C004, "JAPAN BUSINESS COMPUTER CO.LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C005, "LIVINGSTON ENTERPRISES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C006, "NIPPON AVIONICS CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C007, "PINNACLE DATA SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C008, "SECO SRL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C009, "KT TECHNOLOGY (S) PTE LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C00A, "MICRO CRAFT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C00B, "NORCONTROL A.S." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C00C, "RELIA TECHNOLGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C00D, "ADVANCED LOGIC RESEARCH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C00E, "PSITECH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C00F, "QUANTUM SOFTWARE SYSTEMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C010, "HIRAKAWA HEWTECH CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C011, "INTERACTIVE COMPUTING DEVICES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C012, "NETSPAN CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C013, "NETRIX" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C014, "TELEMATICS CALABASAS INT'L INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C015, "NEW MEDIA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C016, "ELECTRONIC THEATRE CONTROLS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C017, "FORTE NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C018, "LANART CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C019, "LEAP TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C01A, "COROMETRICS MEDICAL SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C01B, "SOCKET COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C01C, "INTERLINK COMMUNICATIONS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C01D, "GRAND JUNCTION NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C01E, "LA FRANCAISE DES JEUX" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C01F, "S.E.R.C.E.L." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C020, "ARCO ELECTRONIC CONTROL LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C021, "NETEXPRESS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C022, "LASERMASTER TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C023, "TUTANKHAMON ELECTRONICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C024, "EDEN SISTEMAS DE COMPUTACAO SA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C025, "DATAPRODUCTS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C026, "LANS TECHNOLOGY CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C027, "CIPHER SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C028, "JASCO CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C029, "KABEL RHEYDT AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C02A, "OHKURA ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C02B, "GERLOFF GESELLSCHAFT FUR" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C02C, "CENTRUM COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C02D, "FUJI PHOTO FILM CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C02E, "NETWIZ" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C02F, "OKUMA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C030, "INTEGRATED ENGINEERING B. V." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C031, "DESIGN RESEARCH SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C032, "ICUBED LIMITED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C033, "TELEBIT COMMUNICATIONS APS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C034, "DALE COMPUTER CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C035, "QUINTAR COMPANY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C036, "RAYTECH ELECTRONIC CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C037, "DYNATEM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C038, "RASTER IMAGE PROCESSING SYSTEM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C039, "TDK SEMICONDUCTOR CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C03A, "MENMIKRO ELEKTRONIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C03B, "MULTIACCESS COMPUTING CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C03C, "TOWER TECH S.R.L." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C03D, "WIESEMANN & THEIS GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C03E, "FA. GEBR. HELLER GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C03F, "STORES AUTOMATED SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C040, "ECCI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C041, "DIGITAL TRANSMISSION SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C042, "DATALUX CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C043, "STRATACOM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C044, "EMCOM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C045, "ISOLATION SYSTEMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C046, "KEMITRON LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C047, "UNIMICRO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C048, "BAY TECHNICAL ASSOCIATES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C049, "U.S. ROBOTICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C04A, "GROUP 2000 AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C04B, "CREATIVE MICROSYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C04C, "DEPARTMENT OF FOREIGN AFFAIRS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C04D, "MITEC INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C04E, "COMTROL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C04F, "DELL COMPUTER CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C050, "TOYO DENKI SEIZO K.K." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C051, "ADVANCED INTEGRATION RESEARCH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C052, "BURRBROWN" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C053, "DAVOX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C054, "NETWORK PERIPHERALS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C055, "MODULAR COMPUTING TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C056, "SOMELEC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C057, "MYCO ELECTRONICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C058, "DATAEXPERT CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C059, "NIPPON DENSO CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C05A, "SEMAPHORE COMMUNICATIONS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C05B, "NETWORKS NORTHWEST INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C05C, "ELONEX PLC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C05D, "L&N TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C05E, "VARILITE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C05F, "FINEPAL COMPANY LIMITED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C060, "ID SCANDINAVIA AS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C061, "SOLECTEK CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C062, "IMPULSE TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C063, "MORNING STAR TECHNOLOGIES INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C064, "GENERAL DATACOMM IND. INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C065, "SCOPE COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C066, "DOCUPOINT INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C067, "UNITED BARCODE INDUSTRIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C068, "PHILIP DRAKE ELECTRONICS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C069, "ADAPTIVE BROADBAND CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C06A, "ZAHNERELEKTRIK GMBH & CO. KG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C06B, "OSI PLUS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C06C, "SVEC COMPUTER CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C06D, "BOCA RESEARCH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C06E, "HAFT TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C06F, "KOMATSU LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C070, "SECTRA SECURETRANSMISSION AB" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C071, "AREANEX COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C072, "KNX LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C073, "XEDIA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C074, "TOYODA AUTOMATIC LOOM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C075, "XANTE CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C076, "IDATA INTERNATIONAL AS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C077, "DAEWOO TELECOM LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C078, "COMPUTER SYSTEMS ENGINEERING" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C079, "FONSYS CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C07A, "PRIVA B.V." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C07B, "ASCEND COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C07C, "HIGHTECH INFORMATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C07D, "RISC DEVELOPMENTS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C07E, "KUBOTA CORPORATION ELECTRONIC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C07F, "NUPON COMPUTING CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C080, "NETSTAR INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C081, "METRODATA LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C082, "MOORE PRODUCTS CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C083, "TRACE MOUNTAIN PRODUCTS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C084, "DATA LINK CORP. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C085, "ELECTRONICS FOR IMAGING INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C086, "THE LYNK CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C087, "UUNET TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C088, "EKF ELEKTRONIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C089, "TELINDUS DISTRIBUTION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C08A, "LAUTERBACH DATENTECHNIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C08B, "RISQ MODULAR SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C08C, "PERFORMANCE TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C08D, "TRONIX PRODUCT DEVELOPMENT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C08E, "NETWORK INFORMATION TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C08F, "MATSUSHITA ELECTRIC WORKS LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C090, "PRAIM S.R.L." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C091, "JABIL CIRCUIT INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C092, "MENNEN MEDICAL INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C093, "ALTA RESEARCH CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C094, "VMX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C095, "ZNYX" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C096, "TAMURA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C097, "ARCHIPEL SA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C098, "CHUNTEX ELECTRONIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C099, "YOSHIKI INDUSTRIAL CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C09A, "PHOTONICS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C09B, "RELIANCE COMM/TEC RTEC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C09C, "TOA ELECTRONIC LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C09D, "DISTRIBUTED SYSTEMS INT'L INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C09E, "CACHE COMPUTERS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C09F, "QUANTA COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A0, "ADVANCE MICRO RESEARCH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A1, "TOKYO DENSHI SEKEI CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A2, "INTERMEDIUM A/S" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A3, "DUAL ENTERPRISES CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A4, "UNIGRAF OY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A5, "DICKENS DATA SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A6, "EXICOM AUSTRALIA PTY. LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A7, "SEEL LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A8, "GVC CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0A9, "BARRON MCCANN LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0AA, "SILICON VALLEY COMPUTER" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0AB, "JUPITER TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0AC, "GAMBIT COMPUTER COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0AD, "MARBEN COMMUNICATION SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0AE, "TOWERCOM CO. INC. DBA PC HOUSE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0AF, "TEKLOGIX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B0, "GCC TECHNOLOGIES INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B1, "GENIUS NET CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B2, "NORAND CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B3, "COMSTAT DATACOMM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B4, "MYSON TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B5, "CORPORATE NETWORK SYSTEMS INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B6, "MERIDIAN DATA INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B7, "AMERICAN POWER CONVERSION CORP" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B8, "FRASER'S HILL LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0B9, "FUNK SOFTWARE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0BA, "NETVANTAGE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0BB, "FORVAL CREATIVE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0BC, "TELECOM AUSTRALIA/CSSC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0BD, "INEX TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0BE, "ALCATEL SEL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0BF, "TECHNOLOGY CONCEPTS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C0, "SHORE MICROSYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C1, "QUAD/GRAPHICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C2, "INFINITE NETWORKS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C3, "ACUSON COMPUTED SONOGRAPHY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C4, "COMPUTER OPERATIONAL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C5, "SID INFORMATICA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C6, "PERSONAL MEDIA CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C7, "SPARKTRUM MICROSYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C8, "MICRO BYTE PTY. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0C9, "ELSAG BAILEY PROCESS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0CA, "ALFA INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0CB, "CONTROL TECHNOLOGY CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0CC, "TELESCIENCES CO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0CD, "COMELTA S.A." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0CE, "CEI SYSTEMS & ENGINEERING PTE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0CF, "IMATRAN VOIMA OY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D0, "RATOC SYSTEM INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D1, "COMTREE TECHNOLOGY CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D2, "SYNTELLECT INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D3, "OLYMPUS IMAGE SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D4, "AXON NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D5, "QUANCOM ELECTRONIC GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D6, "J1 SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D7, "TAIWAN TRADING CENTER DBA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D8, "UNIVERSAL DATA SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0D9, "QUINTE NETWORK CONFIDENTIALITY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0DA, "NICE SYSTEMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0DB, "IPC CORPORATION (PTE) LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0DC, "EOS TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0DD, "ANCOR COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0DE, "ZCOMM INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0DF, "KYE SYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E0, "DSC COMMUNICATION CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E1, "SONIC SOLUTIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E2, "CALCOMP INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E3, "OSITECH COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E4, "LANDIS & GYR POWERS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E5, "GESPAC S.A." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E6, "TXPORT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E7, "FIBERDATA AB" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E8, "PLEXCOM INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0E9, "OAK SOLUTIONS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0EA, "ARRAY TECHNOLOGY LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0EB, "SEH COMPUTERTECHNIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0EC, "DAUPHIN TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0ED, "US ARMY ELECTRONIC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0EE, "KYOCERA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0EF, "ABIT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F0, "KINGSTON TECHNOLOGY CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F1, "SHINKO ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F2, "TRANSITION NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F3, "NETWORK COMMUNICATIONS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F4, "INTERLINK SYSTEM CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F5, "METACOMP INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F6, "CELAN TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F7, "ENGAGE COMMUNICATION INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F8, "ABOUT COMPUTING INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0F9, "HARRIS AND JEFFRIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0FA, "CANARY COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0FB, "ADVANCED TECHNOLOGY LABS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0FC, "ELASTIC REALITY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0FD, "PROSUM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0FE, "APTEC COMPUTER SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00C0FF, "BOX HILL SYSTEMS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00CF1C, "COMMUNICATION MACHINERY CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D001, "VST TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D006, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D008, "MACTELL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D009, "HSING TECH. ENTERPRISE CO. LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D00A, "LANACCESS TELECOM S.A." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D00B, "RHK TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D00D, "MICROMERITICS INSTRUMENT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D014, "ROOT INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D01B, "MIMAKI ENGINEERING CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D01C, "SBS TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D01D, "FURUNO ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D01E, "PINGTEL CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D023, "INFORTREND TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D024, "COGNEX" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D027, "APPLIED AUTOMATION INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D02A, "FLEXION SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D02B, "JETCELL INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D02C, "CAMPBELL SCIENTIFIC INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D032, "YANO ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D034, "ORMEC SYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D03A, "ZONE AUTOMATION INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D040, "SYSMATE CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D041, "AMIGO TECHNOLOGY CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D04A, "PRESENCE TECHNOLOGY GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D04C, "EUROTEL TELECOM LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D04E, "LOGIBAG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D051, "O2 MICRO INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D054, "SAS INSTITUTE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D058, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D059, "AMBIT MICROSYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D05C, "TECHNOTREND SYSTEMTECHNIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D05D, "INTELLIWORXX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D065, "TOKO ELECTRIC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D067, "CAMPIO COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D068, "IWILL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D06C, "SHAREWAVE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D06D, "ACRISON INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D06E, "TRENDVIEW RECORDERS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D074, "TAQUA SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D075, "ALARIS MEDICAL SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D076, "MERRILL LYNCH & CO. INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D07A, "AMAQUEST COMPUTER CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D07B, "COMCAM INTERNATIONAL LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D080, "EXABYTE CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D084, "NEXCOMM SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D087, "MICROFIRST INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D08A, "PHOTRON USA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D08C, "GENOA TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D08F, "ARDENT TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D091, "SMARTSAN SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D099, "ELCARD OY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D09A, "FILANET CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D09D, "VERIS INDUSTRIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0A0, "MIPS DENMARK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0A1, "OSKAR VIERLING GMBH + CO. KG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0A2, "INTEGRATED DEVICE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0A8, "NETWORK ENGINES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0A9, "SHINANO KENSHI CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0AB, "DELTAKABEL TELECOM CV" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0AE, "ORESIS COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0B2, "XIOTECH CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0B8, "IOMEGA CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0BB, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0C0, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0C7, "PATHWAY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0C9, "ADVANTECH CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0CA, "INTRINSYC SOFTWARE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0CC, "TECHNOLOGIES LYRE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0CD, "ATAN TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0D1, "SIROCCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0D4, "VBITS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0D5, "GRUNDIG AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0D9, "DEDICATED MICROCOMPUTERS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0DD, "SUNRISE TELECOM INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0E1, "AVIONITEK ISRAEL INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0E6, "IBOND INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0E7, "VCON TELECOMMUNICATION LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0EB, "LIGHTERA NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0EE, "DICTAPHONE CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0F1, "SEGA ENTERPRISES LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0F2, "MONTEREY NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0F6, "NORTHCHURCH COMMUNICATIONS INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00D0FD, "OPTIMA NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD00, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD01, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD02, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD03, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD04, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD05, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD06, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD07, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD08, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD09, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD0A, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD0B, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD0C, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD0D, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD0E, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00DD0F, "UNGERMANNBASS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E000, "FUJITSU LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E001, "STRAND LIGHTING LIMITED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E002, "CROSSROADS SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E003, "INTALK INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E004, "PMCSIERRA INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E005, "TECHNICAL CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E006, "SILICON INTEGRATED SYS. CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E007, "NETWORK ALCHEMY LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E008, "AMAZING CONTROLS! INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E009, "MARATHON TECHNOLOGIES CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E00A, "DIBA INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E00B, "ROOFTOP COMMUNICATIONS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E00C, "MOTOROLA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E00D, "RADIANT SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E00E, "AVALON IMAGING SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E00F, "SHANGHAI BAUD DATA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E010, "HESS SBAUTOMATENBAU GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E011, "UNIDEN SAN DIEGO" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E012, "PLUTO TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E013, "EASTERN ELECTRONIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E014, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E015, "HEIWA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E016, "RAPID CITY COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E017, "EXXACT GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E018, "ASUSTEK COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E019, "ING. GIORDANO ELETTRONICA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E01A, "COMTEC SYSTEMS. CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E01B, "SPHERE COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E01C, "ELECTRONICS ACCESSORY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E01D, "WEBTV NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E01E, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E01F, "AVIDIA SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E020, "TECNOMEN OY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E021, "FREEGATE CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E022, "MEDIALIGHT INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E023, "TELRAD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E024, "GADZOOX NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E025, "DIT CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E026, "EASTMAN KODAK CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E027, "DUX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E028, "APTIX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E029, "STANDARD MICROSYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E02A, "TANDBERG TELEVISION AS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E02B, "EXTREME NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E02C, "AST COMPUTER" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E02D, "INNOMEDIALOGIC INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E02E, "SPC ELECTRONICS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E02F, "MCNS HOLDINGS L.P." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E030, "MELITA INTERNATIONAL CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E031, "HAGIWARA ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E032, "MISYS FINANCIAL SYSTEMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E033, "E.E.P.D. GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E034, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E035, "LOUGHBOROUGH SOUND IMAGES PLC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E036, "PIONEER DIGITAL TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E037, "CENTURY CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E038, "PROXIMA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E039, "PARADYNE CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E03A, "CABLETRON SYSTEMS ILNC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E03B, "PROMINET CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E03C, "ADVANSYS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E03D, "FOCON ELECTRONIC SYSTEMS A/S" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E03E, "ALFATECH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E03F, "JATON CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E040, "DESKSTATION TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E041, "CSPI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E042, "PACOM DATA LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E043, "VITALCOM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E044, "LSICS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E045, "TOUCHWAVE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E046, "BENTLY NEVADA CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E047, "INFOCUS SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E048, "SDL COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E049, "MICROWI ELECTRONIC GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E04A, "ENHANCED MESSAGING SYSTEMS INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E04B, "JUMP INDUSTRIELLE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E04C, "REALTEK SEMICONDUCTOR CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E04D, "INTERNET INITIATIVE JAPAN INC"},
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E04E, "SANYO DENKI CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E04F, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E050, "EXECUTONE INFORMATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E051, "TALX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E052, "FOUNDRY NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E053, "CELLPORT LABS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E054, "KODAI HITEC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E055, "INGENIERIA ELECTRONICA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E056, "HOLONTECH CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E057, "HAN MICROTELECOM. CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E058, "PHASE ONE DENMARK A/S" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E059, "CONTROLLED ENVIRONMENTS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E05A, "GALEA NETWORK SECURITY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E05B, "WEST END SYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E05C, "MATSUSHITA KOTOBUKI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E05D, "UNITEC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E05E, "JAPAN AVIATION ELECTRONICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E05F, "ENET INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E060, "SHERWOOD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E061, "EDGEPOINT NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E062, "HOST ENGINEERING" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E063, "CABLETRON YAGO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E064, "SAMSUNG ELECTRONICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E065, "OPTICAL ACCESS INTERNATIONAL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E066, "PROMAX SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E067, "EAC AUTOMATIONCONSULTING GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E068, "MERRIMAC SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E069, "JAYCOR NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E06A, "KAPSCH AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E06B, "W&G SPECIAL PRODUCTS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E06C, "ZERGO LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E06D, "COMPUWARE CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E06E, "FAR SYSTEMS SPA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E06F, "TERAYON CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E070, "DH TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E071, "EPIS MICROCOMPUTER" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E072, "LYNK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E073, "NATIONAL AMUSEMENT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E074, "TIERNAN COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E075, "ATLAS COMPUTER EQUIPMENT INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E076, "DEVELOPMENT CONCEPTS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E077, "WEBGEAR INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E078, "BERKELEY NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E079, "A.T.N.R." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E07A, "MIKRODIDAKT AB" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E07B, "BAY NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E07C, "METTLERTOLEDO INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E07D, "NETRONIX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E07E, "WALT DISNEY IMAGINEERING" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E07F, "LOGISTISTEM SRL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E080, "CONTROL RESOURCES CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E081, "TYAN COMPUTER CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E082, "ANERMA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E083, "JATO TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E084, "COMPULITE R&D" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E085, "GLOBAL MAINTECH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E086, "CYBEX COMPUTER PRODUCTS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E087, "LECROY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E088, "LTX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E089, "MICROFRAME INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E08A, "GEC AVERY LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E08B, "QLOGIC CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E08C, "NEOPARADIGM LABS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E08D, "PRESSURE SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E08E, "UTSTARCOM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E08F, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E090, "BECKMAN LAB. AUTOMATION DIV." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E091, "LG ELECTRONICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E092, "ADMTEK INCORPORATED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E093, "ACKFIN NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E094, "OSAI SRL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E095, "ADVANCEDVISION TECHNOLGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E096, "SHIMADZU CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E097, "CARRIER ACCESS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E098, "ABOCOM SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E099, "SAMSON AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E09A, "POSITRON INDUSTRIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E09B, "ENGAGE NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E09C, "MII" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E09D, "SARNOFF CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E09E, "QUANTUM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E09F, "PIXEL VISION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A0, "WILTRON CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A1, "HIMA PAUL HILDEBRANDT" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A2, "MICROSLATE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A3, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A4, "ESAOTE S.P.A." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A5, "COMCORE SEMICONDUCTOR INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A6, "TELOGY NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A7, "IPC INFORMATION SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A8, "SAT GMBH&CO" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0A9, "FUNAI ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0AA, "ELECTROSONIC LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0AB, "DIMAT S.A." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0AC, "MIDSCO INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0AD, "EES TECHNOLOGY LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0AE, "XAQTI CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0AF, "GENERAL DYNAMICS INFORMATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B0, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B1, "PACKET ENGINES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B2, "TELMAX COMMUNICATIONS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B3, "ETHERWAN SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B4, "TECHNO SCOPE CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B5, "ARDENT COMMUNICATIONS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B6, "OSICOM TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B7, "PI GROUP LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B8, "GATEWAY 2000" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0B9, "BYAS SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0BA, "BERGHOF AUTOMATIONSTECHNIK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0BB, "NBX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0BC, "SYMON COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0BD, "INTERFACE SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0BE, "GENROCO INTERNATIONAL INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0BF, "TORRENT NETWORKING" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C0, "SEIWA ERECTRIC MFG. CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C1, "MEMOREX TELEX JAPAN LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C2, "NECSY SPA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C3, "SAKAI SYSTEM DEVELOPMENT CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C4, "HORNER ELECTRIC INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C5, "BCOM ELECTRONICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C6, "LINK2IT L.L.C." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C7, "EUROTECH SRL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C8, "VIRTUAL ACCESS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0C9, "AUTOMATEDLOGIC CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0CA, "BEST DATA PRODUCTS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0CB, "RESON INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0CC, "HERO SYSTEMS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0CD, "SENSIS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0CE, "ARN" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0CF, "INTEGRATED DEVICE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D0, "NETSPEED INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D1, "TELSIS LIMITED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D2, "VERSANET COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D3, "DATENTECHNIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D4, "EXCELLENT COMPUTER" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D5, "ARCXEL TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D6, "COMPUTER & COMMUNICATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D7, "SUNSHINE ELECTRONICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D8, "LANBIT COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0D9, "TAZMO CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0DA, "ASSURED ACCESS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0DB, "VIAVIDEO COMMUNICATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0DC, "NEXWARE CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0DD, "ZENITH ELECTRONICS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0DE, "DATAX NV" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0DF, "KE KOMMUNIKATIONSELECTRONIK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E0, "SI ELECTRONICS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E1, "G2 NETWORKS ILNC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E2, "INNOVA CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E3, "SKELEKTRONIK GMBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E4, "FANUC ROBOTICS NORTH AMERICA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E5, "CINCO NETWORKS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E6, "INCAA DATACOM B.V." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E7, "RAYTHEON ESYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E8, "GRETACODER DATA SYSTEMS AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0E9, "DATA LABS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0EA, "INNOVAT COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0EB, "DIGICOM SYSTEMS INCORPORATED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0EC, "CELESTICA INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0ED, "SILICOM LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0EE, "MAREL HF" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0EF, "DIONEX" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F0, "ABLER TECHNOLOGY INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F1, "THAT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F2, "ARLOTTO COMNET INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F3, "WEBSPRINT COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F4, "INSIDE TECHNOLOGY A/S" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F5, "TELES AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F6, "DECISION EUROPE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F7, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F8, "DIANA CONTROL AB" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0F9, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0FA, "TRL TECHNOLOGY LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0FB, "LEIGHTRONIX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0FC, "HUAWEI TECHNOLOGIES CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0FD, "ATREND TECHNOLOGY CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0FE, "CISCO SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E0FF, "SECURITY DYNAMICS TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x00E6D3, "NIXDORF COMPUTER CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x020701, "RACALDATACOM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x021C7C, "PERQ SYSTEMS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x026086, "LOGIC REPLACEMENT TECH. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x02608C, "3COM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x027001, "RACALDATACOM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x0270B0, "M/ACOM INC. COMPANIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x0270B3, "DATA RECALL LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x029D8E, "CARDIAC RECORDERS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x02AA3C, "OLIVETTI TELECOMM SPA (OLTECO)" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x02BB01, "OCTOTHORPE CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x02C08C, "3COM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x02CF1C, "COMMUNICATION MACHINERY CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x02E6D3, "NIXDORF COMPUTER CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x040AE0, "XMIT AG COMPUTER NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x04E0C4, "TRIUMPHADLER AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080001, "COMPUTERVISION CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080002, "BRIDGE COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080003, "ADVANCED COMPUTER COMM." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080004, "CROMEMCO INCORPORATED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080005, "SYMBOLICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080006, "SIEMENS AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080007, "APPLE COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080008, "BOLT BERANEK AND NEWMAN INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080009, "HEWLETT PACKARD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08000A, "NESTAR SYSTEMS INCORPORATED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08000B, "UNISYS CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08000C, "MIKLYN DEVELOPMENT CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08000D, "INTERNATIONAL COMPUTERS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08000E, "NCR CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08000F, "MITEL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080011, "TEKTRONIX INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080012, "BELL ATLANTIC INTEGRATED SYST." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080013, "EXXON" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080014, "EXCELAN" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080015, "STC BUSINESS SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080016, "BARRISTER INFO SYS CORP" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080017, "NATIONAL SEMICONDUCTOR" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080018, "PIRELLI FOCOM NETWORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080019, "GENERAL ELECTRIC CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08001A, "TIARA/ 10NET" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08001B, "DATA GENERAL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08001C, "KDDKOKUSAI DEBNSIN DENWA CO." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08001D, "ABLE COMMUNICATIONS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08001E, "APOLLO COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08001F, "SHARP CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080020, "SUN MICROSYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080021, "3M COMPANY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080022, "NBI INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080023, "MATSUHITA GRAPHIC COMM SYS INC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080024, "10NET COMMUNICATIONS/DCA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080025, "CONTROL DATA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080026, "NORSK DATA A.S." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080027, "CADMUS COMPUTER SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080028, "TEXAS INSTRUMENTS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080029, "MEGATEK CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08002A, "MOSAIC TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08002B, "DIGITAL EQUIPMENT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08002C, "BRITTON LEE INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08002D, "LANTEC INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08002E, "METAPHOR COMPUTER SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08002F, "PRIME COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080030, "NETWORK RESEARCH CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080030, "CERN" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080030, "ROYAL MELBOURNE INST OF TECH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080031, "LITTLE MACHINES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080032, "TIGAN INCORPORATED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080033, "BAUSCH & LOMB" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080034, "FILENET CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080035, "MICROFIVE CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080036, "INTERGRAPH CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080037, "FUJIXEROX CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080038, "CII HONEYWELL BULL" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080039, "SPIDER SYSTEMS LIMITED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08003A, "ORCATECH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08003B, "TORUS SYSTEMS LIMITED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08003C, "SCHLUMBERGER WELL SERVICES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08003D, "CADNETIX CORPORATIONS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08003E, "CODEX CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08003F, "FRED KOSCHARA ENTERPRISES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080040, "FERRANTI COMPUTER SYS. LIMITED" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080041, "RACALMILGO INFORMATION SYS.." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080042, "JAPAN MACNICS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080043, "PIXEL COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080044, "DAVID SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080045, "CONCURRENT COMPUTER CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080046, "SONY CORPORATION LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080047, "SEQUENT COMPUTER SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080048, "EUROTHERM GAUGING SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080049, "UNIVATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08004A, "BANYAN SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08004B, "PLANNING RESEARCH CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08004C, "HYDRA COMPUTER SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08004D, "CORVUS SYSTEMS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08004E, "3COM EUROPE LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08004F, "CYGNET SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080050, "DAISY SYSTEMS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080051, "EXPERDATA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080052, "INSYSTEC" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080053, "MIDDLE EAST TECH. UNIVERSITY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080055, "STANFORD TELECOMM. INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080056, "STANFORD LINEAR ACCEL. CENTER" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080057, "EVANS & SUTHERLAND" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080058, "SYSTEMS CONCEPTS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080059, "A/S MYCRON" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08005A, "IBM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08005B, "VTA TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08005C, "FOUR PHASE SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08005D, "GOULD INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08005E, "COUNTERPOINT COMPUTER INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08005F, "SABER TECHNOLOGY CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080060, "INDUSTRIAL NETWORKING INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080061, "JAROGATE LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080062, "GENERAL DYNAMICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080063, "PLESSEY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080064, "AUTOPHON AG" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080065, "GENRAD INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080066, "AGFA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080067, "COMDESIGN" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080068, "RIDGE COMPUTERS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080069, "SILICON GRAPHICS INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08006A, "ATT BELL LABORATORIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08006B, "ACCEL TECHNOLOGIES INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08006C, "SUNTEK TECHNOLOGY INT'L" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08006D, "WHITECHAPEL COMPUTER WORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08006E, "MASSCOMP" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08006F, "PHILIPS APELDOORN B.V." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080070, "MITSUBISHI ELECTRIC CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080071, "MATRA (DSIE)" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080072, "XEROX CORP UNIV GRANT PROGRAM" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080073, "TECMAR INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080074, "CASIO COMPUTER CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080075, "DANSK DATA ELECTRONIK" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080076, "PC LAN TECHNOLOGIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080077, "TSL COMMUNICATIONS LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080078, "ACCELL CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080079, "THE DROID WORKS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08007A, "INDATA" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08007B, "SANYO ELECTRIC CO. LTD." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08007C, "VITALINK COMMUNICATIONS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08007E, "AMALGAMATED WIRELESS(AUS) LTD" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08007F, "CARNEGIE MELLON UNIVERSITY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080080, "AES DATA INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080081, "ASTECH INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080082, "VERITAS SOFTWARE" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080083, "SEIKO INSTRUM. AND ELECTRONICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080084, "TOMEN ELECTRONICS CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080085, "ELXSI" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080086, "IMAGEN CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080087, "XYPLEX" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080088, "MCDATA CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080089, "KINETICS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08008A, "PERFORMANCE TECHNOLOGY" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08008B, "PYRAMID TECHNOLOGY CORP." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08008C, "NETWORK RESEARCH CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08008D, "XYVISION INC." },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08008E, "TANDEM COMPUTERS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08008F, "CHIPCOM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x080090, "SONOMA SYSTEMS" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x08BBCC, "AKNORD EDV VERTRIEBSGES. MBH" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x10005A, "IBM CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x1000E8, "NATIONAL SEMICONDUCTOR" },
{ 0x000001, "XEROX CORPORATION" },
{ 0x800010, "ATT BELL LABORATORIES" },
{ 0x000001, "XEROX CORPORATION" },
{ 0xAA0000, "DIGITAL EQUIPMENT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0xAA0001, "DIGITAL EQUIPMENT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0xAA0002, "DIGITAL EQUIPMENT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0xAA0003, "DIGITAL EQUIPMENT CORPORATION" },
{ 0x000001, "XEROX CORPORATION" },
{ 0xAA0004, "DIGITAL EQUIPMENT CORPORATION" },
  { 0x0, NULL }
};  

static VendorInfo specialMacInfo[] = {
  { 0x01000C, "Cisco CDPD/VTP" },
  { 0x010010, "Hughes Lan" },
  { 0x01001D, "Cabletron" },
  { 0x01003C, "Auspex Systems" },
  { 0x01005E, "DoD Internet Multicast" },
  { 0x010081, "Synoptics" },
  { 0x012025, "Control Tech. Inc." },
  { 0x018024, "Kalpana Etherswitch" },
  { 0x0180C2, "Bridge Sp. Tree/OSI Route" },
  { 0x01DD00, "UngermannBass" },
  { 0x01DD01, "UngermannBass" },
  { 0x030000, "NetBios" },
  { 0x030040, "NetBios" },
  { 0x090002, "Vitalink" },
  { 0x090007, "AppleTalk" },
  { 0x090009, "HP Probe" },
  { 0x09000D, "ICL" },
  { 0x09001E, "Apollo" },
  { 0x090026, "Vitalink" },
  { 0x09002B, "DEC" },
  { 0x090039, "Spider Systems" },
  { 0x09004C, "BICC" },
  { 0x09004E, "Novell IPX" },
  { 0x090056, "Stanford" },
  { 0x09006A, "TOP NetBIOS" },
  { 0x090077, "Retix" },
  { 0x09007C, "Vitalink" },
  { 0x090087, "Xyplex" },
  { 0x0D1E15, "HP" },
  { 0x333300, "IPv6" },
  { 0xAB0000, "DEC MOP/DECNET" },
  { 0xAB0003, "DEC LAT" },
  { 0xAB0004, "DEC VAX" },
  { 0xCF0000, "Ethernet CTP" },
  { 0xFFFF00, "Lantastic" },
  { 0xFFFF01, "Lantastic" },
  { 0xFFFFFF, "Ethernet Broadcast" },
  { 0x0, NULL }
};

VendorInfo* vendorHash[VENDORHASHNAMESIZE];
VendorInfo* specialMacHash[SHORTHASHNAMESIZE];

/* *********************************** */

static void addMacTableEntry(VendorInfo* theMacHash[], 
			     VendorInfo* entry, 
			     u_int tableLen) {
  u_int idx;

  idx = (u_int)(entry->vendorId % tableLen);

#ifdef DEBUG
  printf("%d %x '%s'\n", idx,
	 entry->vendorId,
	 entry->vendorName);
#endif

  for(;;) {
    if(theMacHash[idx] == NULL) {      
      theMacHash[idx] = entry;
      break;
    }    
    idx = (idx+1)%tableLen;
  }
}

/* *********************************** */

char* getMacInfo(VendorInfo* vendorTable[], 
		 u_char* ethAddress,
		 u_int tableLen, short encodeString) {
  u_int idx;
  unsigned long vendorValue;
  VendorInfo* cursor;

  vendorValue = 256*256*(unsigned long)ethAddress[0] 
    + 256*(unsigned long)ethAddress[1] 
    + (unsigned long)ethAddress[2];
  idx = (u_int)((u_int)vendorValue % tableLen);

#ifdef DEBUG
  printf("%d %ld\n", idx, vendorValue);
#endif

  for(;;) {
    cursor = vendorTable[idx];
    
    if(vendorTable[idx] == NULL) {
      /* Unknown vendor */
      return("");
    } else if(vendorTable[idx] != NULL) {
      if(vendorTable[idx]->vendorId == vendorValue) {
	if(encodeString) {
	  static char vendorName[256];
	  int a, b;

	  for(a=0, b=0; vendorTable[idx]->vendorName[a] != '\0'; a++)
	    if(vendorTable[idx]->vendorName[a] == ' ') {
	      vendorName[b++] = '&';
	      vendorName[b++] = 'n';
	      vendorName[b++] = 'b';
	      vendorName[b++] = 's';
	      vendorName[b++] = 'p';
	      vendorName[b++] = ';';
	    } else
	      vendorName[b++] = vendorTable[idx]->vendorName[a];

	  vendorName[b] = '\0';	    
	  return(vendorName);
	} else
	  return(vendorTable[idx]->vendorName);

      }
    }

    idx = (idx+1)%tableLen;
  }
}

/* *********************************** */

char* getVendorInfo(u_char* ethAddress, short encodeString) {
  return(getMacInfo(vendorHash, ethAddress, VENDORHASHNAMESIZE, encodeString));
}

/* *********************************** */

char* getSpecialMacInfo(u_char* ethAddress, short encodeString) {
#ifdef HAVE_GDBM_H
  datum key_data, data_data;
  static char tmpBuf[96];
#endif
  char* ret = getMacInfo(specialMacHash, ethAddress, SHORTHASHNAMESIZE, encodeString);

  if((ret != NULL) && (ret[0] != '\0'))
    return(ret);
  
#ifndef HAVE_GDBM_H
  return("");
#else

  /* Search the specified MAC address into 'ntop.db' */
  strcpy(tmpBuf, etheraddr_string(ethAddress));
  key_data.dptr = tmpBuf;
  key_data.dsize = strlen(tmpBuf)+1;

#ifdef DEBUG
  printf("Fetching '%s'\n", tmpBuf);
#endif

#ifdef MULTITHREADED
  accessMutex(&gdbmMutex);
#endif 

  data_data = gdbm_fetch(gdbm_file, key_data);

#ifdef MULTITHREADED
  releaseMutex(&gdbmMutex);
#endif 

  if(data_data.dptr != NULL) {    
    strcpy(tmpBuf, data_data.dptr);
    free(data_data.dptr);
    return(tmpBuf);
  } else
    return("");

#endif /* HAVE_GDBM_H */
}

/* *********************************** */

void createVendorTable() 
{
  int idx;

  for(idx=0; vendorInfo[idx].vendorName != NULL; idx++)
    addMacTableEntry(vendorHash, &vendorInfo[idx], VENDORHASHNAMESIZE);

  for(idx=0; specialMacInfo[idx].vendorName != NULL; idx++)
    addMacTableEntry(specialMacHash, &specialMacInfo[idx], SHORTHASHNAMESIZE);
}

