
/* $Id: linein.c,v 1.14 2000/06/14 06:26:09 aito Exp $ */
#include "fm.h"
#include "local.h"
#include "myctype.h"

#ifdef MOUSE
#ifdef USE_GPM
#include <gpm.h>
#endif
#if defined(USE_GPM) || defined(USE_SYSMOUSE)
extern int do_getch();
#define getch()	do_getch()
#endif				/* USE_GPM */
#endif				/* MOUSE */

#ifdef __EMX__
#include <sys/kbdscan.h>
#endif

#define STR_LEN	256

static Str strBuf;
static Lineprop strProp[STR_LEN];

static Str CompleteBuf;
static Str CFileName;
static Str CBeforeBuf;
static Str CAfterBuf;
static Str CDirBuf;
static char **CFileBuf = NULL;
static int NCFileBuf;
static int NCFileOffset;

static
void insertself(char c), _mvR(void), _mvL(void), delC(void), insC(void),
 _mvB(void), _mvE(void), _enter(void), _quo(void), _bs(void), killn(void),
 killb(void), _inbrk(void), _esc(void), _prev(void), _next(void), _compl(void),
 _rcompl(void), _tcompl(void);

#define iself ((void(*)())insertself)

static
void next_compl(int next);
static
Str doComplete(Str ifn, int *status, int next);

void (*InputKeymap[32]) () = {
/* C-@          C-a     C-b     C-c     C-d     C-e     C-f     C-g     */
    _compl, _mvB, _mvL, _inbrk, delC, _mvE, _mvR, _inbrk,
/* C-h          C-i     C-j     C-k     C-l     C-m     C-n     C-o     */
	_bs, iself, _enter, killn, iself, _enter, _next, iself,
/* C-p          C-q     C-r     C-s     C-t     C-u     C-v     C-w     */
	_prev, _quo, iself, iself, iself, killb, _quo, iself,
/* C-x          C-y     C-z     C-[     C-\     C-]     C-^     C-_     */
	_tcompl, iself, iself, _esc, iself, iself, iself, iself,
};

static void setStrType(Str str, Lineprop * prop);

static int CPos, CLen;
static int i_cont, i_broken, i_quote;
static int cm_mode, cm_next, cm_clear;

static Hist *CurrentHist;
static int use_hist;
static int in_kanji;

char *
inputLineHist(char *prompt, char *def_str, int flag, Hist * hist)
{
    int i, opos, offset, x;
    char c, *p;
    int redrawOK;
    Lineprop mode;
#ifdef JP_CHARSET
    Str tmp = Strnew();
#endif				/* JP_CHARSET */

    mode = PC_ASCII;
    in_kanji = FALSE;

    CurrentHist = hist;
    if (hist != NULL)
	use_hist = TRUE;
    else
	use_hist = FALSE;
    if (flag & IN_FILENAME)
	cm_mode = CPL_ALWAYS;
    else if (flag & IN_PASSWORD)
	cm_mode = CPL_NEVER;
    else if (flag & IN_COMMAND)
	cm_mode = CPL_ON;
    else
	cm_mode = CPL_OFF;
    opos = strlen(prompt);
    move(LASTLINE, 0);
    addstr(prompt);
    strBuf = Strnew();
    i = 0;
    if (def_str) {
	Strcat_charp(strBuf, def_str);
	setStrType(strBuf, strProp);
	for (; i < strBuf->length; i++) {
	    if (flag & IN_PASSWORD)
		addChar('*', 0);
	    else
		addChar(strBuf->ptr[i], strProp[i]);
	}
    }
    clrtoeolx();
    refresh();
    CLen = CPos = i;
    offset = 0;
    i_cont = TRUE;
    i_broken = FALSE;
    i_quote = FALSE;
    cm_next = FALSE;
    do {
	c = getch();
#ifdef __EMX__
	if (!c)
	    switch (getch()) {
	    case K_DEL:
		c=CTRL_D;
		break;
	    case K_LEFT:
		c=CTRL_B;
		break;
	    case K_RIGHT:
		c=CTRL_F;
		break;
	    case K_UP:
		c=CTRL_P;
		break;
	    case K_DOWN:
		c=CTRL_N;
		break;
	    case K_HOME:
	    case K_CTRL_LEFT:
		c=CTRL_A;
		break;
	    case K_END:
	    case K_CTRL_RIGHT:
		c=CTRL_E;
		break;
	    case K_CTRL_HOME:
		c=CTRL_U;
		break;
	    case K_CTRL_END:
		c=CTRL_K;
	    }
#endif
	redrawOK = TRUE;
	cm_clear = TRUE;
	if (!i_quote &&
	    (((cm_mode & CPL_ALWAYS) && (c == CTRL_I || c == ' ')) ||
	     ((cm_mode & CPL_ON) && (c == CTRL_I)))) {
	    _compl();
	}
	else if (c == 0177) {
	    if (!i_quote)
		_bs();
	    else
		insertself(c);
	    i_quote = FALSE;
	    cm_next = FALSE;
	}
	else if (IS_CNTRL(c)) {	/* Control code */
	    if (!i_quote)
		(*InputKeymap[(int) c]) (c);
	    else {
		insertself(c);
		i_quote = FALSE;
	    }
	    if (cm_clear)
		cm_next = FALSE;
#ifdef JP_CHARSET
	}
	else if (mode == PC_KANJI1) {
	    i_quote = FALSE;
	    cm_next = FALSE;
	    if (CLen >= STR_LEN)
		continue;
	    Strcat_char(tmp, (c | (DisplayCode == 'S' ? 0 : 0x80)));
	    tmp = conv(tmp->ptr, (DisplayCode == 'S' ? 'S' : 'E'), InnerCode);
	    insC();
	    strBuf->ptr[CPos] = tmp->ptr[0];
	    strProp[CPos] = PC_KANJI1;
	    CPos++;
	    insC();
	    strBuf->ptr[CPos] = tmp->ptr[1];
	    strProp[CPos] = PC_KANJI2;
	    CPos++;
	    mode = PC_KANJI2;
	}
	else if ((c & 0x80) || in_kanji) {	/* Kanji 1 */
	    i_quote = FALSE;
	    cm_next = FALSE;
	    if (CLen >= STR_LEN - 1)
		continue;
	    Strclear(tmp);
	    Strcat_char(tmp, (c | 0x80));
	    mode = PC_KANJI1;
	    redrawOK = FALSE;
#endif				/* JP_CHARSET */
	}
	else {
	    i_quote = FALSE;
	    cm_next = FALSE;
	    if (CLen >= STR_LEN)
		continue;
	    insC();
	    strBuf->ptr[CPos] = c;
	    strProp[CPos] = PC_ASCII;
	    CPos++;
	    mode = PC_ASCII;
	}
	if (redrawOK) {
	    if (CPos - offset < 10)
		offset = (CPos > 10) ? (CPos - 10) : 0;
	    if (flag & IN_PASSWORD) {
		x = opos + (offset > 0) + CPos - offset;
		if (x > COLS - 2) {
		    offset = opos + 1 + CPos - COLS + 2;
		    x = COLS - 2;
		}
	    }
	    else {
		x = calcPosition(&strBuf->ptr[offset], CPos - offset, opos + (offset > 0), CP_FORCE);
		while (x > COLS - 2) {
		    offset += x - COLS + 2;
		    if (offset >= CPos)
			offset = CPos - 1;
		    x = calcPosition(&strBuf->ptr[offset], CPos - offset, opos + 1, CP_FORCE);
		}
	    }
	    move(LASTLINE, 0);
	    addstr(prompt);
	    i = offset;
	    if (offset) {
		addstr("{");
#ifdef JP_CHARSET
		if (strProp[offset] == PC_KANJI2 && !(flag & IN_PASSWORD)) {
		    addstr(" ");
		    i++;
		}
#endif				/* JP_CHARSET */
	    }
	    for (; strBuf->ptr[i] != '\0'; i++) {
		if (flag & IN_PASSWORD)
		    addChar('*', 0);
		else
		    addChar(strBuf->ptr[i], strProp[i]);
	    }
	    clrtoeolx();
	    move(LASTLINE, x);
	    refresh();
	}
    } while (i_cont);
    if (use_hist)
	hist->position = (hist->offset + 1) % hist->size;
    if (i_broken)
	return NULL;
    move(LASTLINE, 0);
    refresh();
    p = strBuf->ptr;
    if (flag & (IN_FILENAME | IN_COMMAND)) {
	SKIP_BLANKS(p);
    }
    if (use_hist) {
	if (strcmp(hist->line[hist->offset], p))
	    addHist(hist, p);
    }
    if (flag & IN_FILENAME)
	return expandName(p);
    else
	return allocStr(p, 0);
}

static void
_esc(void)
{
    char c, c2;

    switch (c = getch()) {
    case '[':
    case 'O':
	switch (c = getch()) {
	case 'A':
	    _prev();
	    break;
	case 'B':
	    _next();
	    break;
	case 'C':
	    _mvR();
	    break;
	case 'D':
	    _mvL();
	    break;
	}
	break;
    case CTRL_I:
    case ' ':
	_rcompl();
	break;
    case '$':
	/* ISO-2022-jp characters */
	c2 = getch();
	in_kanji = TRUE;
	break;
    case '(':
	/* ISO-2022-jp characters */
	c2 = getch();
	in_kanji = FALSE;
	break;
    }
}

static void
insC(void)
{
    int i;

    Strinsert_char(strBuf, CPos, ' ');
    CLen = strBuf->length;
    for (i = CLen; i > CPos; i--) {
	strProp[i] = strProp[i - 1];
    }
}

static void
delC(void)
{
    int i = CPos;
    int delta = 1;

    if (CLen == CPos)
	return;
#ifdef JP_CHARSET
    if (strProp[i] == PC_KANJI1)
	delta = 2;
#endif				/* JP_CHARSET */
    for (i = CPos; i < CLen; i++) {
	strProp[i] = strProp[i + delta];
    }
    Strdelete(strBuf, CPos, delta);
    CLen -= delta;
}

static void
_mvL(void)
{
    if (CPos > 0)
	CPos--;
#ifdef JP_CHARSET
    if (strProp[CPos] == PC_KANJI2)
	CPos--;
#endif				/* JP_CHARSET */
}

static void
_mvR(void)
{
    if (CPos < CLen)
	CPos++;
#ifdef JP_CHARSET
    if (strProp[CPos] == PC_KANJI2)
	CPos++;
#endif				/* JP_CHARSET */
}

static void
_bs(void)
{
    if (CPos > 0) {
	_mvL();
	delC();
    }
}

static void
_enter(void)
{
    i_cont = FALSE;
}

static void
insertself(char c)
{
    if (CLen >= STR_LEN)
	return;
    insC();
    strBuf->ptr[CPos] = c;
    strProp[CPos] = PC_CTRL;
    CPos++;
}

static void
_quo(void)
{
    i_quote = TRUE;
}

static void
_mvB(void)
{
    CPos = 0;
}

static void
_mvE(void)
{
    CPos = CLen;
}

static void
killn(void)
{
    CLen = CPos;
    Strtruncate(strBuf, CLen);
}

static void
killb(void)
{
    while (CPos > 0)
	_bs();
}

static void
_inbrk(void)
{
    i_cont = FALSE;
    i_broken = TRUE;
}

static void
_compl(void)
{
    next_compl(1);
}

static void
_rcompl(void)
{
    next_compl(-1);
}

static void
_tcompl(void)
{
    if (cm_mode & CPL_OFF)
	cm_mode = CPL_ON;
    else if (cm_mode & CPL_ON)
	cm_mode = CPL_OFF;
}

static void
next_compl(int next)
{
    int status;
    int b, a;
    Str buf;
    Str s;

    if (cm_mode == CPL_NEVER || cm_mode & CPL_OFF)
	return;
    cm_clear = FALSE;
    if (!cm_next) {
	for (b = CPos - 1; b >= 0; b--) {
	    if (strBuf->ptr[b] == ' ' || strBuf->ptr[b] == CTRL_I)
		break;
	}
	b++;
	a = CPos;
	CBeforeBuf = Strsubstr(strBuf, 0, b);
	buf = Strsubstr(strBuf, b, a - b);
	CAfterBuf = Strsubstr(strBuf, a, strBuf->length - a);
	s = doComplete(buf, &status, next);
    }
    else {
	s = doComplete(strBuf, &status, next);
    }

    if (status != CPL_OK && status != CPL_MENU)
	bell();
    if (status == CPL_FAIL)
	return;

    strBuf = Strnew_m_charp(CBeforeBuf->ptr, s->ptr, CAfterBuf->ptr, NULL);
    CLen = strBuf->length;
    CPos = CBeforeBuf->length + s->length;
    setStrType(strBuf, strProp);
}

static Str
doComplete(Str ifn, int *status, int next)
{
    int fl, i;
    char *fn;
    DIR *d;
    Directory *dir;
    struct stat st;

    if (!cm_next) {
	CompleteBuf = Strdup(ifn);
	while (Strlastchar(CompleteBuf) != '/' &&
	       CompleteBuf->length > 0)
	    Strshrink(CompleteBuf, 1);
	CDirBuf = Strdup(CompleteBuf);
	if (CompleteBuf->length == 0) {
	    Strcat_char(CompleteBuf, '.');
	}
	if (Strlastchar(CompleteBuf) == '/' && CompleteBuf->length > 1) {
	    Strshrink(CompleteBuf, 1);
	}
	if ((d = opendir(expandName(CompleteBuf->ptr))) == NULL) {
	    CompleteBuf = Strdup(ifn);
	    *status = CPL_FAIL;
	    return CompleteBuf;
	}
	fn = lastFileName(ifn->ptr);
	fl = strlen(fn);
	NCFileBuf = 0;
	CFileName = Strnew();
	for (;;) {
	    dir = readdir(d);
	    if (dir == NULL)
		break;
	    if (fl == 0 && (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, "..")))
		continue;
	    if (!strncmp(dir->d_name, fn, fl)) {	/* match */
		NCFileBuf++;
		CFileBuf = New_Reuse(char *, CFileBuf, NCFileBuf);
		CFileBuf[NCFileBuf - 1] = New_N(char, strlen(dir->d_name) + 1);
		strcpy(CFileBuf[NCFileBuf - 1], dir->d_name);
		if (NCFileBuf == 1) {
		    CFileName = Strnew_charp(dir->d_name);
		}
		else {
		    for (i = 0; CFileName->ptr[i] == dir->d_name[i]; i++);
		    Strtruncate(CFileName, i);
		}
	    }
	}
	closedir(d);
	if (NCFileBuf == 0) {
	    CompleteBuf = Strdup(ifn);
	    *status = CPL_FAIL;
	    return CompleteBuf;
	}
	qsort(CFileBuf, NCFileBuf, sizeof(CFileBuf[0]), strCmp);
	NCFileOffset = 0;
	if (NCFileBuf >= 2) {
	    cm_next = TRUE;
	    *status = CPL_AMBIG;
	}
	else {
	    *status = CPL_OK;
	}
    }
    else {
	CFileName = Strnew_charp(CFileBuf[NCFileOffset]);
	NCFileOffset = (NCFileOffset + next + NCFileBuf) % NCFileBuf;
	*status = CPL_MENU;
    }
    CompleteBuf = Strdup(CDirBuf);
    if (CompleteBuf->length == 0)
	Strcat(CompleteBuf, CFileName);
    else if (Strlastchar(CompleteBuf) == '/')
	Strcat(CompleteBuf, CFileName);
    else {
	Strcat_char(CompleteBuf, '/');
	Strcat(CompleteBuf, CFileName);
    }
    if (*status != CPL_AMBIG) {
	if (stat(expandName(CompleteBuf->ptr), &st) != -1 && S_ISDIR(st.st_mode))
	    Strcat_char(CompleteBuf, '/');
    }
    return CompleteBuf;
}

static void
_prev(void)
{
    Hist *hist = CurrentHist;
    int p;

    if (!use_hist || hist == NULL)
	return;
    if (hist->size <= 0)
	return;

    p = (hist->offset - hist->length + 1 + hist->size) % hist->size;
    if (hist->position == p)
	return;
    p = hist->position;
    hist->position = (hist->position - 1 + hist->size) % hist->size;
    if (hist->position == hist->offset)
	hist->line[p] = Strdup(strBuf)->ptr;
    strBuf = Strnew_charp(hist->line[hist->position]);
    setStrType(strBuf, strProp);
    CLen = CPos = strBuf->length;
}

static void
_next(void)
{
    Hist *hist = CurrentHist;
    int p;

    if (!use_hist || hist == NULL)
	return;
    if (hist->size <= 0)
	return;

    p = (hist->offset + 1) % hist->size;
    if (hist->position == p)
	return;
    hist->position = (hist->position + 1) % hist->size;
    strBuf = Strnew_charp(hist->line[hist->position]);
    setStrType(strBuf, strProp);
    CLen = CPos = strBuf->length;
}

static void
setStrType(Str str, Lineprop * prop)
{
    Lineprop ctype = PC_ASCII, prev_ctype;
    int i = 0;
    char *s = str->ptr;

    for (; *s != '\0' && i < STR_LEN; s++, i++) {
	prev_ctype = ctype;
	prop[i] = ctype = get_ctype((unsigned char) *s, prev_ctype);
#ifdef JP_CHARSET
	if (prev_ctype == PC_KANJI1 && ctype != PC_KANJI2)
	    prop[i - 1] = PC_ASCII;
#endif				/* JP_CHARSET */
    }
}
