---
layout: api
page_title: Libraries and SDKs - HTTP API
sidebar_current: api-libraries-and-sdks
description: |-
  There are many third-party libraries for interacting with Consul's HTTP API.
  This page lists the HashiCorp and community-maintained Consul HTTP API client
  libraries.
---

# Client Libraries & SDKs

The programming libraries listed on this page can be used to consume the API
more conveniently. Some are officially maintained while others are provided by
the community.

<ul>
  <li>
    <a href="https://github.com/hashicorp/consul/tree/master/api">api</a> - Official Go client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/gmr/consulate">consulate</a> - Python client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/cablehead/python-consul">python-consul</a> - Python client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/vdloo/consul-kv">consul-kv</a> - Python 3 client for the Consul KV-store
  </li>
  <li>
    <a href="https://github.com/sensiolabs/consul-php-sdk">consul-php-sdk</a> - PHP client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/dcarbone/php-consul-api">php-consul-api</a> - GO-like PHP Client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/tolitius/envoy">envoy</a> - Consul Clojure client with watchers and other goodies
  </li>
  <li>
    <a href="https://github.com/hadielmougy/clj-consul-catalog">clj-consul-catalog</a> - Clojure discovery client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/Verizon/helm">helm</a> - A native Scala client for interacting with Consul
  </li>
  <li>
    <a href="https://github.com/rickfast/consul-client">consul-client</a> - Java client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/Ecwid/consul-api">consul-api</a> - Java client for the Consul HTTP API
  </li>
   <li>
   <a href="http://cloud.spring.io/spring-cloud-consul/">Spring Cloud Consul</a> - Consul integration for <a href="https://projects.spring.io/spring-boot/">Spring Boot</a> applications (Uses
    <a href="https://github.com/Ecwid/consul-api">consul-api</a> internally)
  </li>
  <li>
    <a href="https://github.com/vert-x3/vertx-consul-client">vertx-consul-client</a> - Vert.x client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/undeadlabs/discovery">discovery</a> - Erlang/OTP client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/xaviershay/consul-client">consul-client</a> - Ruby client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/WeAreFarmGeek/diplomat">diplomat</a> - Ruby library to query Consul's KV-store and services directory
  </li>
  <li>
    <a href="https://www.npmjs.com/package/consul">node-consul</a> - Node.js client for the Consul HTTP API
  </li>
  <li>
    <a href="https://www.nuget.org/packages/Consul">Consul.NET</a> - C# client for the Consul HTTP API
  </li>
  <li>
    <a href="https://metacpan.org/pod/Consul">Consul</a> - Perl client for the Consul HTTP API
  </li>
  <li>
    <a href="https://github.com/Drawaes/CondenserDotNet">CondenserDotNet</a> - C# an opinionated API for .NET that provides higher level functionality for services using the HTTP API
  </li>
  <li>
    <a href="https://github.com/cpageler93/ConsulSwift">ConsulSwift</a> - Swift client for the Consul HTTP API
  </li>
</ul>
