/*
 * API for Kerberos Login Principal Translation plugins
 */
 
#include <KerberosLogin/KerberosLogin.h>
 
#ifndef KLPrincipalTranslation_h_
#define KLPrincipalTranslation_h_

/* API Versions */

enum {
	kKLPT_APIVersion_1				= 1,
	kKLPT_APIVersion_Current		= kKLPT_APIVersion_1
};

/* File types */

const OSType kKLPT_PluginFileType = FOUR_CHAR_CODE ('PTrn');

/* Types */

typedef UInt32	KLPT_APIVersion;

/* Function prototypes */

#ifdef __cplusplus
extern "C" {
#endif

#pragma export on

KLStatus KerberosLoginPrincipalTranslation_InitializePlugin (
	KLPT_APIVersion		inAPIVersion);

KLStatus KerberosLoginPrincipalTranslation_TranslatePrincipal (
	const char*		inName,
	const char*		inInstance,
	const char*		inRealm,
	const char**	outName,
	const char**	outInstance,
	const char**	outRealm,
	KLBoolean*		outChanged);

void KerberosLoginPrincipalTranslation_ReleasePrincipal (
	char*	inName,
	char*	inInstance,
	char*	inRealm);

#ifdef __cplusplus
}
#endif

#endif /* KLPrincipalTranslation_h_ */