/*
	Pobiera logi ekg z stdin i wypluwa w adnej formie na stdout
	Zalety: 
		+ szybki
		+ napisany w C
	Wady:
		- troch nieprawidowo wywietla linijki zawierajce tekst `\n' lub `\r'
			(literalnie, jeli kto wpisaby backslash i [rn] w treci wiadomoci)
		- wymaga glib'a
		- trzeba go skompilowa
		- autor jest debilem.

	Autor: Robert Goliasz <rgoliasz@poczta.onet.pl>
*/

#define FORMAT_TIME   "%02d%s%02d"
#define FORMAT_SEC    ":%02d"
#define FORMAT_FROM   "<%s< "
#define FORMAT_TO     ">%s> "
#define FORMAT_STATUS "|%s| "

#define COLOR_NORM    "\033[0;37m"
#define COLOR_ERR     "\033[0;37;41;1m"
#define COLOR_NOTICE  "\033[0;37;1m"
#define COLOR_TIME    "\033[0;36m"
#define COLOR_RECTIME "\033[0;34m"
#define COLOR_FROM    "\033[0;32;1m"
#define COLOR_TO      "\033[0;34;1m"
#define COLOR_STATUS  "\033[0;37m"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <time.h>

// zmienne okrelajce parametry:
int nodate=0,notime=0,shownick=-1,showrecd=0,justify=0,showsec=0;
int showrecsec=0,nobad=0,color=0,nostatus=0,showcolon=0;
char *uin=NULL, *nick=NULL;

long lastdate=0;

void showhelp()
{
	fprintf(stderr,
		"Pobiera logi ekg z stdin i wypluwa w adnej formie na stdout\n"
		"Uycie:\n\n"
		"t      -- nie wywietlaj w ogle czasu\n"
		"d      -- nie wywietlaj zmiany dni\n"
		"x      -- zawsze wywietlaj ksywk\n"
		"v      -- nigdy nie wywietlaj ksywki \n"
		"            (domylnie: wywietlaj jeli nie podano opcji `u' ani `n')\n"
		"r      -- wywietlaj czas odebrania w wiadomociach przychodzcych\n"
		"R      -- j/w i wyrwnaj wiadomoci wychodzce\n"
		"s      -- wywietlaj sekundy\n"
		"S      -- wywietlaj sekundy przy czasie odebrania\n"
		"C      -- wywietlaj dwukropek midzy godzin a minut\n"
		"b      -- nie wywietlaj bdnych linijek (zaczynaj si od !!!)\n"
		"a      -- nie wywietlaj zmian statusu\n"
		"c      -- wywietlaj kolorki\n"
		"h      -- this help screen\n"
		"u UIN  -- pokazuj tylko wiadomoci od/do UIN\n"
		"n NICK -- pokazuj tylko wiadomoci od/do NICKa\n\n"
		"mona poprzedzi `-', mona czy lub nie, `u' lub `n' powinny by\n"
		"na kocu i nie powinny wystpowa razem\n");
			
	exit(1);
}

void fatal(char *s)
{
	perror(s);
	fprintf(stderr,"Aby uzyska pomoc uyj opcji -h\n");
	exit(2);
}

void set_params(int argc, char **argv) 
	// moje wasne, moe nie dziaa w 100% przypadkw
{
	int i;
	
	for(i=1;(i<argc) && (!uin) && (!nick);i++)
	{
		int j;
		for(j=0;j<strlen(argv[i]);j++)
		{
			switch(argv[i][j])
			{
				case 't':
					notime=1;
					break;
				case 'd':
					nodate=1;
					break;
				case 'x':
					shownick=1;
					break;
				case 'v':
					shownick=0;
					break;
				case 'r':
					showrecd=1;
					break;
				case 'R':
					showrecd=1;
					justify=1;
					break;
				case 's':
					showsec=1;
					break;
				case 'S':
					showrecsec=1;
					break;
				case 'C':
					showcolon=1;
					break;
				case 'b':
					nobad=1;
					break;
				case 'c':
					color=1;
					break;
				case 'a':
					nostatus=1;
					break;
				case 'h':
					showhelp();
					break;

				case '-':
					break;
				case 'u':
					if(i+1>=argc)
						fatal("Za mao/ze parametry");
					uin=argv[i+1];
					break;
				case 'n':
	 				if(i+1>=argc)
						fatal("Za mao/ze parametry");
					nick=argv[i+1];
					break;
			}
		}
	}
	if(shownick==-1)
	{
		if(uin || nick)
			shownick=0;
		else
			shownick=1;
	}
}

// notime, showrecd, justify, showsec, showrecsec

void print_time(time_t sent, time_t recd)
{
	struct tm *tim;
	long date;

	tim=localtime(&sent);

	if(!nodate)
	{
		date=(tim->tm_year)*1000+tim->tm_yday;
		if(date!=lastdate)
		{
			if(color)
				printf(COLOR_NOTICE);
			printf("-!- Dzie %02d-%02d-%04d\n",
					tim->tm_mday,tim->tm_mon+1,tim->tm_year+1900);
			lastdate=date;
		}
	}
	
	if(!notime)
	{
		// czas wysania
		if(color)
			printf(COLOR_TIME);
		printf(FORMAT_TIME,
				tim->tm_hour,
				showcolon ? ":" : "",
				tim->tm_min);
		if(showsec)
			printf(FORMAT_SEC,tim->tm_sec);
		printf(" ");

		// czas odbioru
		if(recd && showrecd)
		{
			if(color)
				printf(COLOR_RECTIME);
			tim=localtime(&recd);
			printf("("FORMAT_TIME,
					tim->tm_hour,
					showcolon ? ":" : "",
					tim->tm_min);
			if(showrecsec)
				printf(FORMAT_SEC,tim->tm_sec);
			printf(") ");
		}
		else if(justify)
		{
			printf("       ");
			if(showrecsec)
				printf("   ");
			if(showcolon)
				printf(" ");
		}
	}
}

int check_line(char *u, char *n)
{
	if(uin && strcmp(uin,u))
		return 0;

	if(nick && strcmp(nick,n))
		return 0;

	return 1;
}

// przerabia linijk eby nie zawieraa `\', kod jest do bani, ale chyba dziaa
char *reformat(char *a, int part, char chr)
{
	static char buf[300];
	int i,len;
	
	// usu pocztkowe "
	if(!part && a[0]=='"')
		strcpy(buf,a+1);
	else
		strcpy(buf,a);
	
	// zamie \" na "
	// zamie \r\n na <CR> << 
	// zamie \\ na \ . 
	len=strlen(buf);
	for(i=len-2;i>=0;i--)
	{
		if(buf[i]=='\\')
		{
			switch(buf[i+1])
			{
				case '"':
					buf[i]='"';
					break;
				case '\'':
					buf[i]='\'';
					break;
				case 'n':
					buf[i]=chr;
					buf[i+1]=' ';
					continue;
					break;
				case 'r':
					buf[i]='\n';
					buf[i+1]=chr;
					continue;
					break;
			}
			memmove(buf+i+1,buf+i+2,strlen(buf+i+2)+1);
		}
	}

	// usu kocowe "
	if(
			buf[strlen(buf)-1]=='\n' && 
			buf[strlen(buf)-2]=='"')
	{
		buf[strlen(buf)-2]='\n';
		buf[strlen(buf)-1]=0;
	}
	
	return buf;
}

void process_line()
{
	char linebuf[255]; // zakadam e nagwki nie przekraczaj 249 znakw...
	int printed=1,reformatted=0;
	char chr;
	
	if(!fgets(linebuf,250,stdin))
		return;
	
	if(
			!strncmp(linebuf,"msgrecv", 7) ||
			!strncmp(linebuf,"chatrecv",8) )
	{
		char **a;
		char *l;
		
		chr='<';
		a=g_strsplit(linebuf,",",5);
		l=a[5];
		if(a[5][0]=='"')
		{
			reformatted=1;
			l=reformat(a[5],0,chr);
		}
		if(check_line(a[1],a[2]))
		{
			print_time(atol(a[3]), atol(a[4]));
			if(color)
				printf(COLOR_FROM);
			printf(FORMAT_FROM"%s",shownick?(a[2][0]?a[2]:a[1]):"",l);
		}
		else printed=0;

		g_strfreev(a);
	}
	else if(
			!strncmp(linebuf,"msgsend", 7) ||
			!strncmp(linebuf,"chatsend",8) )
	{
		char **a;
		char *l;
		
		chr='>';
		a=g_strsplit(linebuf,",",4);
		l=a[4];
		if(a[4][0]=='"')
		{
			reformatted=1;
			l=reformat(a[4],0,chr);
		}
		if(check_line(a[1],a[2]))		
		{
			print_time(atol(a[3]),0);
			if(color)
				printf(COLOR_TO);
			printf(FORMAT_TO"%s",shownick?(a[2][0]?a[2]:a[1]):"",l);
		}
		else printed=0;
		
		g_strfreev(a);
	}
	else if(!strncmp(linebuf,"status",6))
	{
		char **a;
		char *l;

		chr='|';
		a=g_strsplit(linebuf,",",6);
		l=a[6];
		if(l && l[0]=='"')
		{
			reformatted=1;
			l=reformat(l,0,chr);
		}
		if(check_line(a[1],a[2]) && !nostatus)
		{
			print_time(atol(a[4]),0);
			if(color)
				printf(COLOR_STATUS);
			printf(FORMAT_STATUS"%s",shownick?(a[2][0]?a[2]:a[1]):"",a[5]);
			if(l)
				printf(": %s",l);
		}
		else printed=0;

		g_strfreev(a);
	}
	else
	{
		if(!nobad)
		{
			if(color)
				printf(COLOR_ERR);
			printf("!!! %s",linebuf); // nieznana linijka
		}
		else
			printed=0;
	}
	
	// linijki dusze ni 250 znakw (jeli printed)
	while(strlen(linebuf)==249 && linebuf[248]!='\n')  // [249] bdzie zerem
	{
		fgets(linebuf,250,stdin);
		if(printed)
		{
			printf("%s",reformatted?reformat(linebuf,1,chr):linebuf);
		}
	}
}

int main(int argc, char **argv)
{
	set_params(argc,argv);

	if(color)
		printf(COLOR_NOTICE);
	if(uin)
		printf("-!- Rozmowa z UIN %s\n",uin);
	if(nick)
		printf("-!- Rozmowa z %s\n",nick);
	
	while(!feof(stdin))
		process_line();
	if(color)
		printf(COLOR_NORM);
	return 0;
}
