/*
 * dcc.h: Things dealing client to client connections. 
 *
 * Written By Troy Rollo <troy@plod.cbme.unsw.oz.au> 
 *
 * Copyright(c) 1991 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: dcc.h,v 1.6 1994/07/26 15:33:23 mrg Exp $
 */

/*
 * this file must be included after irc.h as i needed <sys/types.h>
 */

#ifndef _DCC_H_
#define _DCC_H_

#include "irc_std.h"

extern	void	close_all_dcc _((void));
extern  int	dcc_active _((char *));
extern	void	dcc_chat_transmit _((char *, char *, char *));
extern	void	dcc_check _((fd_set *));
extern	void	dcc_list _((char *));
extern	void	dcc_message_transmit _((char *, char *, int, int, char *));
extern	char *	dcc_raw_connect _((char *, u_short));
extern	char *	dcc_raw_listen _((int));
extern	void	dcc_reject _((char *, char *, char *));
extern	void	process_dcc _((char *));
extern	void	register_dcc_offer _((char *, char *, char *, char *, char *, char *, char *));
extern	void	set_dcc_bits _((fd_set *, fd_set *));
extern	char *	DCC_get_current_transfer _((void));

#define DCC_CHAT	((unsigned) 0x0001)
#define DCC_FILEOFFER	((unsigned) 0x0002)
#define DCC_FILEREAD	((unsigned) 0x0003)
#define	DCC_RAW		((unsigned) 0x0004)
#define	DCC_RAW_LISTEN	((unsigned) 0x0005)
#define DCC_TYPES	((unsigned) 0x000f)
#define DCC_WAIT	((unsigned) 0x0010)
#define DCC_ACTIVE	((unsigned) 0x0020)
#define DCC_OFFER	((unsigned) 0x0040)
#define DCC_DELETE	((unsigned) 0x0080)
#define DCC_TWOCLIENTS	((unsigned) 0x0100)
#define DCC_STATES	((unsigned) 0xfff0)

#define DCC_BLOCK_SIZE BIG_BUFFER_SIZE

#endif /* _DCC_H_ */
