/*
 * irc.h: header file for all of ircII! 
 *
 * Written By Michael Sandrof
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: irc.h,v 1.26 1994/07/25 14:35:43 mrg Exp $
 */

#ifndef __irc_h
#define __irc_h

#define IRCII_COMMENT   "All the things phone wont include....."
#define IRCRC_NAME "/.ircrc"
#define EMAIL_CONTACT "ircii-epic@concentric.net"

/*
 * Here you can set the in-line quote character, normally backslash, to
 * whatever you want.  Note that we use two backslashes since a backslash is
 * also C's quote character.  You do not need two of any other character.
 */
#define QUOTE_CHAR '\\'

#if defined(ISC30)		/* for some reason it doesn't get defined */
# define _POSIX_SOURCE
#endif /* ISC30 */

#include "defs.h"
#include "config.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#ifndef WINS
#include <netinet/in.h>
#else
#include <sys/twg_config.h>
#include <sys/in.h>
#undef server
#endif
#include <arpa/inet.h>
#include <signal.h>
#include <sys/param.h>

#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif /* HAVE_SYS_TIME_H */
#endif /* TIME_WITH_SYS_TIME */

#ifdef HAVE_SYS_FCNTL_H
# include <sys/fcntl.h>
#else
# ifdef HAVE_FCNTL_H
#  include <fcntl.h>
# endif /* HAVE_FCNTL_H */
#endif /* HAVE_SYS_FCNTL_H */

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif

/* machines we don't want to use <unistd.h> on 'cause its broken */
#if defined(pyr) || defined(_SEQUENT_) || defined(IN_EXEC_C)
# undef HAVE_UNISTD_H
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif

#ifdef HAVE_TERMCAP_H
# include <termcap.h>
#endif

#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif

#ifdef INCLUDE_GLOB_FUNCTION
#ifdef NEED_GLOB
# include "glob.h"
#else
# include <glob.h>
#endif
#endif

#include "irc_std.h"
#include "newio.h"

/* these define what characters do, inverse, underline, bold and all off */
/*	CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION
 *	CAUTION						CAUTION
 *	CAUTION		DONT CHANGE THESE!		CAUTION
 *	CAUTION						CAUTION
 *	CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION CAUTION
 *
 * If you want to change the key bindings for your highlight characters,
 * then please use /bind .. BOLD, /bind .. REVERSE, /bind .. UNDERLINE, 
 * or /bind .. HIGHLIGHT_OFF.  These are REQUIRED to be set to the way
 * they are now, as the keybindings simply change whatever you bind these
 * to these actual values, so if you change these, it will break how
 * other people see your messages!
 */
#define REV_TOG		'\026'		/* ^V */
#define REV_TOG_STR	"\026"
#define UND_TOG		'\037'		/* ^_ */
#define UND_TOG_STR	"\037"
#define BOLD_TOG	'\002'		/* ^B */
#define BOLD_TOG_STR	"\002"
#define ALL_OFF		'\017'		/* ^O */
#define ALL_OFF_STR	"\017"

#define IRCD_BUFFER_SIZE	1024
#define BIG_BUFFER_SIZE		(IRCD_BUFFER_SIZE * 2)

#ifndef INPUT_BUFFER_SIZE
#define INPUT_BUFFER_SIZE	(IRCD_BUFFER_SIZE / 4)
#endif

#define LONG_NICKNAME_LEN 30
#define NICKNAME_LEN 9
#define NAME_LEN 80
#define REALNAME_LEN 50
#define PATH_LEN 1024

#if defined(__hpux) || defined(hpux) || defined(_HPUX_SOURCE)
# undef HPUX
# define HPUX
# ifndef HPUX7
#  define killpg(pgrp,sig) kill(-pgrp,sig)
# endif
#endif

#if defined(__sgi)
# define USE_TERMIO
#endif /* __sgi */

#ifdef DGUX
# define USE_TERMIO
# define inet_addr(x) inet_network(x)	/* dgux lossage */
#endif /* DGUX */

/*
 * Lame Linux doesn't define X_OK in a non-broken header file, so
 * we define it here.. 
 */
#if defined(linux) && !defined(X_OK)
# define X_OK  1
#endif /* linux */

#if __osf__
# define _BSD
#endif

#if defined(UNICOS) && !defined(USE_TERMIO)
# define USE_TERMIO
#endif /* UNICOS */

/* systems without getwd() can lose, if this dies */
#if defined(NEED_GETCWD)
# define getcwd(b, c)	getwd(b);
#endif

#if defined(ISC22) || defined(ISC30)
# define USE_TERMIO
# define ISC
#endif /* ISC22 || ISC30 */

#if defined(_AUX_SOURCE) && !defined(USE_TERMIO)
# define USE_TERMIO
#endif

/* doh! */
#if defined(NEED_STRERROR)
# define strerror(x) sys_errlist[x]
#endif

/* This should be depreciated */
#define stat_file stat

/* irc.c's global variables */
extern		int	away_set;
extern		int	background;
extern		int	current_numeric;
extern		int	dumb;
extern		int	irc_port;
extern		int	quick_startup;
extern		int	current_on_hook;
extern		int	use_flow_control;
extern		int	who_mask;
extern		int	use_input;
extern		int	waiting;
extern		char *	args_str;
extern		char *	cannot_open;
extern		char *	cut_buffer;
extern		char	empty_string[];
extern		char	space[];
extern		char **	environ;
extern		char	global_all_off[];
extern		char	hostname[];
extern		char *	invite_channel;
extern		char *	ircrc_file;
extern		char *	irc_lib;
extern		char *	irc_path;
extern		char *	joined_nick;
extern		char	lame_wait_nick[];
extern		char *	last_notify_nick;
extern		char *	my_path;
extern		char	MyHostName[];
extern		char *	LocalHostName;
extern		char	nickname[];
extern		char	oper_command;
extern		char *	public_nick;
extern		char	realname[];
extern		char *	send_umode;
extern		char	username[];
extern		char *	who_name;
extern		char *	who_host;
extern		char *	who_server;
extern		char *	who_file;
extern		char *	who_nick;
extern		char *	who_real;
extern		char	wait_nick[];
extern		char	whois_nick[];
extern	struct	in_addr MyHostAddr;
extern	struct	in_addr	LocalHostAddr;
extern	struct	in_addr	local_ip_address;
extern		time_t	start_time;
extern		time_t	idle_time;
extern		int	x_debug;
extern const 	char irc_version[];
extern const 	char internal_version[];
extern		fd_set readables;

/* irc.c's extern functions */
extern	void	beep_em _((int));
extern	int	connect_by_number _((char *, unsigned short *, int, int));
#if 0
extern  int     connect_by_number _((int, char *)); /* this is in ircaux.c */
#endif
extern	void	do_server _((fd_set *));
extern	char	get_a_char _((void));
extern  void	get_line_return _((char, char *));
extern	void	get_line _((char *, int, void (*) (char, char *)));
extern	char *	get_server_nickname _((int));
extern	char *	getenv _((const char *));
extern	void	io _((void));
extern	void	irc_exit _((int, char *, ...));
extern	void	irc_quit _((char, char *));
extern	int	is_channel _((char *));
extern	void	new_stty _((char *));
extern	char *	next_expr _((char **, char));
extern	int	wild_match _((char *, char *));

#endif /* __irc_h */
