/*
 * keys.h: header for keys.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: keys.h.proto,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _KEYS_H_
#define _KEYS_H_

#include "irc_std.h"

enum KEY_TYPES {
	BACKSPACE,
	BACKWARD_CHARACTER,
	BACKWARD_HISTORY,
	BACKWARD_WORD,
	BEGINNING_OF_LINE,
	BOLD,
	CLEAR_SCREEN,
	COMMAND_COMPLETION,
	DELETE_CHARACTER,
	DELETE_NEXT_WORD,
	DELETE_PREVIOUS_WORD,
	DELETE_TO_PREVIOUS_SPACE,
	END_OF_LINE,
	ENTER_DIGRAPH,
	ENTER_MENU,
	ERASE_LINE,
	ERASE_TO_BEG_OF_LINE,
	ERASE_TO_END_OF_LINE,
	FORWARD_CHARACTER,
	FORWARD_HISTORY,
	FORWARD_WORD,
	HIGHLIGHT_OFF,
/* These MUST be in order and must be together... */
	META1_CHARACTER,
	META2_CHARACTER,
	META3_CHARACTER,
	META4_CHARACTER,
	META5_CHARACTER,
	META6_CHARACTER,
	META7_CHARACTER,
	META8_CHARACTER,
	META9_CHARACTER,
/* If they arent, everything will break.  Got it? */
	NEXT_WINDOW,
	NOTHING,
	PARSE_COMMAND,
	PREVIOUS_WINDOW,
	QUIT_IRC,
	QUOTE_CHARACTER,
	REFRESH_INPUTLINE,
	REFRESH_SCREEN,
	REVERSE,
	SCROLL_BACKWARD,
	SCROLL_END,
	SCROLL_FORWARD,
	SCROLL_START,
	SELF_INSERT,
	SEND_LINE,
	SHOVE_TO_HISTORY,
	STOP_IRC,
	SWAP_LAST_WINDOW,
	SWAP_NEXT_WINDOW,
	SWAP_PREVIOUS_WINDOW,
	SWITCH_CHANNELS,
	TOGGLE_INSERT_MODE,
	TOGGLE_STOP_SCREEN,
	TRANSPOSE_CHARACTERS,
	TYPE_TEXT,
	UNDERLINE,
	UNSTOP_ALL_WINDOWS,
	YANK_FROM_CUTBUFFER,
	NUMBER_OF_FUNCTIONS
};

/* I hate typdefs... */
typedef void (*KeyBinding) _((char, char *));

/* KeyMap: the structure of the irc keymaps */
typedef struct
{
	enum KEY_TYPES	key_index;
		char	changed;
		int	global;
		char	*stuff;
}	KeyMap;


/* KeyMapNames: the structure of the keymap to realname array */
typedef struct
{
	char	*name;
	KeyBinding func;
}	KeyMapNames;

extern	KeyMap	*keys[10][256];
extern	KeyMapNames key_names[];

extern	KeyBinding 	get_send_line 		_((void));
extern	void		save_bindings 		_((FILE *, int));
extern	void		input_add_character	_((char, char *));
extern	void		bindcmd 		_((char *, char *, char *));
extern  void    	rbindcmd 		_((char *, char *, char *));
extern  void    	parsekeycmd 		_((char *, char *, char *));
extern  void    	type 			_((char *, char *, char *));
extern	void		init_keys_1 		_((void));

#endif /* _KEYS_H_ */
