/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.AboutBox;
import com.gallery.GalleryRemote.AddFileDialog;
import com.gallery.GalleryRemote.AlbumInspector;
import com.gallery.GalleryRemote.CoreUtils;
import com.gallery.GalleryRemote.DroppableList;
import com.gallery.GalleryRemote.DroppableTree;
import com.gallery.GalleryRemote.GRApplet;
import com.gallery.GalleryRemote.GalleryComm;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.NewAlbumDialog;
import com.gallery.GalleryRemote.PictureInspector;
import com.gallery.GalleryRemote.PictureSelection;
import com.gallery.GalleryRemote.PreviewFrame;
import com.gallery.GalleryRemote.SlideshowFrame;
import com.gallery.GalleryRemote.StatusBar;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.ThumbnailCache;
import com.gallery.GalleryRemote.UploadProgress;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PreferencesDialog;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import com.gallery.GalleryRemote.util.OsShutdown;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame
implements ActionListener,
ItemListener,
ListSelectionListener,
ListDataListener,
TreeSelectionListener,
TreeModelListener,
FocusListener,
GalleryRemoteCore,
PreferenceNames {
    public static final String MODULE = "MainFrame";
    public static final String FILE_TYPE = ".grg";
    public PreviewFrame previewFrame = null;
    private static final String DIALOGTITLE = "Gallery Remote  --  ";
    private File lastOpenedFile = null;
    private boolean m_isDirty = false;
    public DefaultComboBoxModel galleries = null;
    private boolean inProgress = false;
    ThumbnailCache thumbnailCache = new ThumbnailCache();
    boolean running = true;
    public StatusBar jStatusBar = new StatusBar();
    PictureSelection ps = null;
    JPanel jTopPanel = new JPanel();
    JMenuBar jMenuBar1 = new JMenuBar();
    JLabel jLabel1 = new JLabel();
    JPanel jBottomPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel jAlbumPanel = new JPanel();
    JScrollPane jAlbumScroll = new JScrollPane();
    public DroppableTree jAlbumTree = new DroppableTree();
    JComboBox jGalleryCombo = new JComboBox();
    JButton jNewGalleryButton = new JButton();
    JButton jLoginButton = new JButton();
    JSplitPane jInspectorDivider = new JSplitPane();
    JSplitPane jAlbumPictureDivider = new JSplitPane();
    JButton jUploadButton = new JButton();
    JButton jBrowseButton = new JButton();
    JButton jSortButton = new JButton();
    JComboBox jSortCombo = new JComboBox();
    JButton jNewAlbumButton = new JButton();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuItemQuit = new JMenuItem();
    JMenu jMenuEdit = new JMenu();
    JMenuItem jMenuItemCut = new JMenuItem();
    JMenuItem jMenuItemCopy = new JMenuItem();
    JMenuItem jMenuItemPaste = new JMenuItem();
    JMenu jMenuOptions = new JMenu();
    JCheckBoxMenuItem jCheckBoxMenuThumbnails = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuPreview = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jCheckBoxMenuPath = new JCheckBoxMenuItem();
    JMenuItem jMenuItemPrefs = new JMenuItem();
    JMenuItem jMenuItemClearCache = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuItemAbout = new JMenuItem();
    DroppableList jPicturesList = new DroppableList();
    JPanel jInspectorPanel = new JPanel();
    CardLayout jInspectorCardLayout = new CardLayout();
    PictureInspector jPictureInspector = new PictureInspector();
    AlbumInspector jAlbumInspector = new AlbumInspector();
    JScrollPane jPictureScroll = new JScrollPane();
    public static Image iconImage = new ImageIcon((class$com$gallery$GalleryRemote$GalleryRemote == null ? (class$com$gallery$GalleryRemote$GalleryRemote = MainFrame.class$("com.gallery.GalleryRemote.GalleryRemote")) : class$com$gallery$GalleryRemote$GalleryRemote).getResource("/rar_icon_16.gif")).getImage();
    public static final String CARD_PICTURE = "picture";
    public static final String CARD_ALBUM = "album";
    static FileFilter galleryFileFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(MainFrame.FILE_TYPE);
        }

        public String getDescription() {
            return "GalleryRemote galleries";
        }
    };
    static /* synthetic */ Class class$com$gallery$GalleryRemote$GalleryRemote;
    static /* synthetic */ Class class$com$gallery$GalleryRemote$prefs$URLPanel;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$java$lang$String;

    public void initMainFrame() {
        block5: {
            this.macOSXRegistration();
            PropertiesFile p = GalleryRemote._().properties;
            this.galleries = new DefaultComboBoxModel();
            if (!GalleryRemote._().isAppletMode()) {
                int i = 0;
                while (true) {
                    try {
                        Gallery g;
                        while ((g = Gallery.readFromProperties((GalleryProperties)p, (int)i++, (StatusUpdate)this.jStatusBar)) != null) {
                            this.galleries.addElement(g);
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        Log.log((int)1, (String)MODULE, (String)("Error trying to load Gallery profile " + i));
                        Log.logException((int)1, (String)MODULE, (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            Applet applet = GalleryRemote._().getApplet();
            GRApplet.AppletInfo info = ((GRApplet)applet).getGRAppletInfo();
            info.gallery.addTreeModelListener((TreeModelListener)this);
            this.galleries.addElement(info.gallery);
        }
        this.setIconImage(iconImage);
    }

    public void startup() {
        try {
            this.jbInit();
            this.jbInitEvents();
        }
        catch (Exception e) {
            Log.logException((int)0, (String)MODULE, (Throwable)e);
        }
        this.setBounds(GalleryRemote._().properties.getMainBounds());
        this.setJMenuBar(this.jMenuBar1);
        this.jGalleryCombo.setEditable(false);
        this.jGalleryCombo.setRenderer(new GalleryListRenderer());
        this.jPicturesList.setCellRenderer((ListCellRenderer)new CoreUtils.FileCellRenderer());
        this.jPicturesList.setInputMap(1, null);
        this.jPicturesList.setInputMap(0, null);
        this.jPicturesList.setInputMap(2, null);
        this.jAlbumTree.setMainFrame(this);
        this.jAlbumTree.setRootVisible(false);
        this.jAlbumTree.setScrollsOnExpand(true);
        this.jAlbumTree.setShowsRootHandles(true);
        this.jAlbumTree.setExpandsSelectedPaths(true);
        this.jAlbumTree.setEnabled(true);
        this.jAlbumTree.getSelectionModel().setSelectionMode(1);
        AlbumTreeRenderer albumTreeRenderer = new AlbumTreeRenderer();
        albumTreeRenderer.setLeafIcon(null);
        albumTreeRenderer.setOpenIcon(null);
        albumTreeRenderer.setClosedIcon(null);
        this.jAlbumTree.setCellRenderer(albumTreeRenderer);
        ToolTipManager.sharedInstance().registerComponent(this.jAlbumTree);
        this.jPictureInspector.setMainFrame(this);
        this.jAlbumInspector.setMainFrame(this);
        this.setGalleries(this.galleries);
        this.jInspectorDivider.setDividerLocation(GalleryRemote._().properties.getIntProperty("inspectorDividerLocation"));
        this.jAlbumPictureDivider.setDividerLocation(GalleryRemote._().properties.getIntProperty("albumPictureDividerLocation"));
        this.setVisible(true);
        this.previewFrame = new PreviewFrame();
        this.previewFrame.initComponents();
        this.previewFrame.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.jCheckBoxMenuPreview.setState(false);
            }
        });
        if (GalleryRemote._().properties.getShowPreview()) {
            this.previewFrame.setVisible(true);
        }
        this.toFront();
        this.readPreferences(GalleryRemote._().properties);
        if (GalleryRemote._().isAppletMode()) {
            this.fetchAlbums();
        }
        this.resetUIState();
        ImageUtils.deferredTasks();
    }

    private void setGalleries(DefaultComboBoxModel galleries) {
        this.galleries = galleries;
        this.jGalleryCombo.setModel(galleries);
        galleries.addListDataListener(this);
        this.selectedGalleryChanged();
        this.setDirtyFlag(false);
    }

    void thisWindowClosing(WindowEvent e) {
        this.shutdown(false, false);
    }

    public void shutdown() {
        this.shutdown(false, false);
    }

    public void shutdown(boolean shutdownOs) {
        this.shutdown(false, shutdownOs);
    }

    private void shutdown(boolean halt, boolean shutdownOs) {
        if (!shutdownOs) {
            // empty if block
        }
        if (this.running) {
            this.running = false;
            Log.log((int)2, (String)MODULE, (String)"Shutting down GR");
            try {
                PropertiesFile p = GalleryRemote._().properties;
                p.setMainBounds(this.getBounds());
                p.setPreviewBounds(this.previewFrame.getBounds());
                p.setIntProperty("inspectorDividerLocation", this.jInspectorDivider.getDividerLocation());
                p.setIntProperty("albumPictureDividerLocation", this.jAlbumPictureDivider.getDividerLocation());
                p.write();
                if (!halt) {
                    this.setVisible(false);
                    this.dispose();
                    this.previewFrame.setVisible(false);
                    this.previewFrame.dispose();
                }
                ImageUtils.purgeTemp();
            }
            catch (Throwable t) {
                Log.log((int)1, (String)MODULE, (String)("Error while closing: " + t));
            }
            if (shutdownOs) {
                OsShutdown.shutdown();
            }
            Log.log((int)2, (String)MODULE, (String)"Shutting down log");
            Log.shutdown();
            if (!GalleryRemote._().isAppletMode()) {
                if (!halt) {
                    Runtime.getRuntime().exit(0);
                }
            } else {
                ((GRApplet)GalleryRemote._().getApplet()).hasShutdown();
                GalleryRemote.shutdownInstance();
            }
        }
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
        this.resetUIState();
    }

    private void setDirtyFlag(boolean newDirtyState) {
        this.m_isDirty = newDirtyState;
        this.resetUIState();
    }

    void resetUIState() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Album currentAlbum = MainFrame.this.getCurrentAlbum();
                Gallery currentGallery = MainFrame.this.getCurrentGallery();
                boolean uploadEnabled = currentAlbum != null && currentAlbum.sizePictures() > 0 && !MainFrame.this.inProgress && MainFrame.this.jAlbumTree.getSelectionCount() > 0;
                MainFrame.this.jUploadButton.setEnabled(uploadEnabled);
                MainFrame.this.jSortCombo.setEnabled(uploadEnabled);
                MainFrame.this.jSortButton.setEnabled(uploadEnabled);
                MainFrame.this.setTitle("Gallery Remote");
                MainFrame.this.jLoginButton.setEnabled(!MainFrame.this.inProgress && currentGallery != null);
                MainFrame.this.jGalleryCombo.setEnabled(!MainFrame.this.inProgress);
                MainFrame.this.jNewGalleryButton.setEnabled(!MainFrame.this.inProgress);
                if (currentGallery != null && currentGallery.getUsername() != null && currentGallery.hasComm() && currentGallery.getComm((StatusUpdate)MainFrame.this.jStatusBar).isLoggedIn()) {
                    MainFrame.this.jLoginButton.setText(GRI18n.getString((String)MainFrame.MODULE, (String)"Log_out"));
                } else {
                    MainFrame.this.jLoginButton.setText(GRI18n.getString((String)MainFrame.MODULE, (String)"Log_in"));
                }
                MainFrame.this.jAlbumTree.setEnabled(!MainFrame.this.inProgress && MainFrame.this.jAlbumTree.getModel().getRoot() != null && MainFrame.this.jAlbumTree.getModel().getChildCount(MainFrame.this.jAlbumTree.getModel().getRoot()) >= 1);
                boolean enabled = !MainFrame.this.inProgress && currentAlbum != null && MainFrame.this.jAlbumTree.getModel().getChildCount(MainFrame.this.jAlbumTree.getModel().getRoot()) >= 1;
                MainFrame.this.jBrowseButton.setEnabled(enabled && currentAlbum.getCanAdd());
                MainFrame.this.jPictureInspector.setEnabled(enabled);
                MainFrame.this.jPicturesList.setEnabled(enabled && currentAlbum.getCanAdd());
                MainFrame.this.jNewAlbumButton.setEnabled(!MainFrame.this.inProgress && currentGallery != null && currentGallery.hasComm() && currentGallery.getComm((StatusUpdate)MainFrame.this.jStatusBar).hasCapability((StatusUpdate)MainFrame.this.jStatusBar, 6));
                int sel = MainFrame.this.jPicturesList.getSelectedIndex();
                if (currentAlbum != null && currentAlbum.getSize() < 1) {
                    sel = -1;
                }
                if (GalleryRemote._().properties.getShowPreview() && MainFrame.this.previewFrame != null) {
                    if (sel != -1) {
                        MainFrame.this.previewFrame.displayPicture(currentAlbum.getPicture(sel), true);
                    } else {
                        MainFrame.this.previewFrame.displayPicture(null, true);
                    }
                    if (!MainFrame.this.previewFrame.isVisible()) {
                        MainFrame.this.previewFrame.setVisible(true);
                    }
                }
                if (currentAlbum == null) {
                    MainFrame.this.jPictureInspector.setPictures(null);
                    MainFrame.this.jStatusBar.setStatus(GRI18n.getString((String)MainFrame.MODULE, (String)"notLogged"));
                } else if (currentAlbum.sizePictures() > 0) {
                    MainFrame.this.jPictureInspector.setPictures(MainFrame.this.jPicturesList.getSelectedValues());
                    int selN = MainFrame.this.jPicturesList.getSelectedIndices().length;
                    if (sel == -1) {
                        Object[] params = new Object[]{new Integer(currentAlbum.sizePictures()), new Integer((int)(currentAlbum.getPictureFileSize() / 1024L))};
                        MainFrame.this.jStatusBar.setStatus(GRI18n.getString((String)MainFrame.MODULE, (String)"statusBarNoSel", (Object[])params));
                    } else {
                        Object[] params = new Object[]{new Integer(selN), GRI18n.getString((String)MainFrame.MODULE, (String)(selN == 1 ? "oneSel" : "manySel")), new Integer((int)Album.getObjectFileSize((Object[])MainFrame.this.jPicturesList.getSelectedValues()) / 1024)};
                        MainFrame.this.jStatusBar.setStatus(GRI18n.getString((String)MainFrame.MODULE, (String)"statusBarSel", (Object[])params));
                    }
                } else {
                    MainFrame.this.jPictureInspector.setPictures(null);
                    MainFrame.this.jStatusBar.setStatus(GRI18n.getString((String)MainFrame.MODULE, (String)"noSelection"));
                }
                MainFrame.this.jAlbumInspector.setAlbum(currentAlbum);
                MainFrame.this.jAlbumTree.repaint();
            }
        });
    }

    private void selectedGalleryChanged() {
        Gallery currentGallery = this.getCurrentGallery();
        Log.log((int)3, (String)MODULE, (String)("updateGalleryParams: current gallery: " + currentGallery));
        if (currentGallery != null && this.jAlbumTree.getModel() != currentGallery) {
            this.jAlbumTree.setModel((TreeModel)currentGallery);
        } else {
            this.jAlbumTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
        if (currentGallery == null || currentGallery.getRoot() == null) {
            this.jAlbumTree.setEnabled(false);
            this.jPicturesList.setEnabled(false);
        } else {
            this.jAlbumTree.setEnabled(!this.inProgress);
        }
        this.updatePicturesList();
    }

    private void updatePicturesList() {
        Album currentAlbum = this.getCurrentAlbum();
        Log.log((int)3, (String)MODULE, (String)("updatePicturesList: current album: " + currentAlbum));
        if (currentAlbum == null) {
            this.jPicturesList.setModel((ListModel)new Album(null));
        } else {
            if (this.jPicturesList.getModel() != currentAlbum) {
                this.jPicturesList.setModel((ListModel)currentAlbum);
                currentAlbum.addListDataListener((ListDataListener)this);
            }
            this.jPictureInspector.setPictures(null);
        }
        this.resetUIState();
    }

    public void browseAddPictures() {
        this.jStatusBar.setStatus(GRI18n.getString((String)MODULE, (String)"selPicToAdd"));
        File[] files = AddFileDialog.addFiles((Component)this);
        if (files != null) {
            this.addPictures(files, false);
        }
    }

    public void addPictures(File[] files, boolean select) {
        this.addPictures(null, files, -1, select);
    }

    public void addPictures(Album album, File[] files, boolean select) {
        this.addPictures(album, files, -1, select);
    }

    public void addPictures(File[] files, int index, boolean select) {
        this.addPictures(null, files, index, select);
    }

    public void addPictures(Album album, File[] files, int index, boolean select) {
        if (album == null) {
            album = this.getCurrentAlbum();
        }
        Log.log((int)3, (String)MODULE, (String)("Adding " + files.length + " pictures to album " + album));
        ArrayList newPictures = null;
        newPictures = index == -1 ? album.addPictures(files) : album.addPictures(files, index);
        this.preloadThumbnails(newPictures.iterator());
        if (select) {
            this.selectAddedPictures(files, index);
        }
        this.setDirtyFlag(true);
    }

    public void addPictures(Picture[] pictures, boolean select) {
        this.addPictures(null, pictures, -1, select);
    }

    public void addPictures(Album album, Picture[] pictures, boolean select) {
        this.addPictures(album, pictures, -1, select);
    }

    public void addPictures(Picture[] pictures, int index, boolean select) {
        this.addPictures(null, pictures, index, select);
    }

    public void addPictures(Album album, Picture[] pictures, int index, boolean select) {
        if (album == null) {
            album = this.getCurrentAlbum();
        }
        if (index == -1) {
            album.addPictures(Arrays.asList(pictures));
        } else {
            album.addPictures(Arrays.asList(pictures), index);
        }
        if (select) {
            this.selectAddedPictures(pictures, index);
        }
        this.setDirtyFlag(true);
    }

    private void selectAddedPictures(Object[] objects, int index) {
        int[] indices = new int[objects.length];
        if (index == -1) {
            index = this.getCurrentAlbum().getSize() - 1;
        }
        for (int i = 0; i < objects.length; ++i) {
            indices[i] = index + i;
        }
        this.jPicturesList.setSelectedIndices(indices);
    }

    public void uploadPictures() {
        Log.log((int)2, (String)MODULE, (String)"uploadPictures starting");
        File f = this.lastOpenedFile;
        if (null == f) {
            f = this.getCurrentGallery().getGalleryDefaultFile();
        }
        this.getCurrentGallery().doUploadFiles((StatusUpdate)new UploadProgress((Frame)this));
    }

    public void sortPictures() {
        int sortType = GalleryRemote._().properties.getIntProperty("sortType");
        switch (sortType) {
            case 1: {
                this.getCurrentAlbum().sortPicturesAlphabetically();
                break;
            }
            case 2: {
                this.getCurrentAlbum().sortPicturesCreated();
                break;
            }
            default: {
                Log.log((int)1, (String)MODULE, (String)("Bad sort value: " + sortType));
            }
        }
        this.setDirtyFlag(true);
    }

    public void setSortType(int sortType) {
        GalleryRemote._().properties.setIntProperty("sortType", sortType);
        this.jSortButton.setText(GRI18n.getString((String)MODULE, (String)"sortBtnTxt", (Object[])new Object[]{GRI18n.getString((String)MODULE, (String)("sort." + sortType))}));
    }

    public void fetchAlbums() {
        Log.log((int)2, (String)MODULE, (String)"fetchAlbums starting");
        this.getCurrentGallery().doFetchAlbums((StatusUpdate)this.jStatusBar);
        Object root = this.jAlbumTree.getModel().getRoot();
        if (root != null && this.jAlbumTree.getModel().getChildCount(root) > 0) {
            this.jAlbumTree.setSelectionPath(null);
        }
    }

    public void fetchAlbumImages() {
        Log.log((int)2, (String)MODULE, (String)"fetchAlbumImages starting");
        this.getCurrentAlbum().fetchAlbumImages((StatusUpdate)this.jStatusBar, false, 0);
    }

    public void newAlbum() {
        NewAlbumDialog dialog = new NewAlbumDialog((Frame)this, this.getCurrentGallery(), this.getCurrentAlbum());
        Album newAlbum = dialog.getNewAlbum();
        if (newAlbum == null) {
            return;
        }
        String newAlbumName = this.getCurrentGallery().doNewAlbum(newAlbum, GalleryRemote._().getCore().getMainStatusUpdate());
        if (newAlbumName.equals(newAlbum.getName())) {
            newAlbum.setName(newAlbumName);
        }
        this.getCurrentGallery().reload();
        Log.log((int)3, (String)MODULE, (String)("Album '" + newAlbum + "' created."));
        Log.log((int)3, (String)MODULE, (String)("Selecting " + newAlbum));
        TreePath path = new TreePath(newAlbum.getPath());
        this.jAlbumTree.scrollPathToVisible(path);
        this.jAlbumTree.setSelectionPath(path);
        this.setDirtyFlag(true);
    }

    public void slideshow() {
        SlideshowFrame sf = new SlideshowFrame();
        sf.showSlideshow();
        sf.start(this.getCurrentAlbum().getPicturesList());
    }

    public void setShowThumbnails(boolean show) {
        GalleryRemote._().properties.setShowThumbnails(show);
        if (show) {
            if (this.getCurrentAlbum() != null) {
                this.preloadThumbnails(this.getCurrentAlbum().getPictures());
            }
            this.jPicturesList.setFixedCellHeight(GalleryRemote._().properties.getThumbnailSize().height + 4);
        } else {
            this.thumbnailCache.cancelLoad();
            this.jPicturesList.setFixedCellHeight(-1);
        }
    }

    public void setShowPreview(boolean show) {
        GalleryRemote._().properties.setShowPreview(show);
        if (show) {
            this.previewFrame.show();
            this.previewFrame.displayPicture((Picture)this.jPicturesList.getSelectedValue(), true);
        } else {
            this.previewFrame.hide();
        }
    }

    public ImageIcon getThumbnail(Picture p) {
        if (p == null) {
            return null;
        }
        ImageIcon thumb = this.thumbnailCache.getThumbnail(p);
        thumb = thumb == null ? ImageUtils.defaultThumbnail : ImageUtils.rotateImageIcon((ImageIcon)thumb, (int)p.getAngle(), (boolean)p.isFlipped(), (Component)this.getGlassPane());
        return thumb;
    }

    public void thumbnailLoadedNotify() {
        this.jPicturesList.repaint();
    }

    public void showAboutBox() {
        try {
            AboutBox ab = new AboutBox(this);
            ab.setVisible(true);
        }
        catch (Exception err) {
            Log.logException((int)1, (String)MODULE, (Throwable)err);
        }
    }

    public void doCut() {
        this.doCopy();
        this.deleteSelectedPictures();
        this.setDirtyFlag(true);
    }

    public void doCopy() {
        if (this.jPicturesList.isEnabled() && this.jPicturesList.getSelectedIndices().length > 0) {
            this.ps = new PictureSelection((JList)this.jPicturesList);
        }
    }

    public void doPaste() {
        if (this.jPicturesList.isEnabled() && this.ps != null && !this.ps.isEmpty()) {
            this.getCurrentAlbum().addPictures((List)this.ps, this.jPicturesList.getSelectedIndex());
        }
        this.setDirtyFlag(true);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTopPanel.setLayout(new GridBagLayout());
        this.jBottomPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setHgap(5);
        this.jAlbumPanel.setLayout(new BorderLayout());
        this.jLabel1.setText(GRI18n.getString((String)MODULE, (String)"Gallery_URL"));
        this.jLoginButton.setText(GRI18n.getString((String)MODULE, (String)"Log_in"));
        this.jLoginButton.setToolTipText(GRI18n.getString((String)MODULE, (String)"loginButtonTip"));
        this.jLoginButton.setActionCommand("Fetch");
        this.jLoginButton.setIcon(GalleryRemote.iLogin);
        this.jNewAlbumButton.setText(GRI18n.getString((String)MODULE, (String)"newAlbmBtnTxt"));
        this.jNewAlbumButton.setToolTipText(GRI18n.getString((String)MODULE, (String)"newAlbmBtnTip"));
        this.jNewAlbumButton.setActionCommand("NewAlbum");
        this.jNewAlbumButton.setIcon(GalleryRemote.iNewAlbum);
        this.jUploadButton.setText(GRI18n.getString((String)MODULE, (String)"upldBtnTxt"));
        this.jUploadButton.setActionCommand("Upload");
        this.jUploadButton.setToolTipText(GRI18n.getString((String)MODULE, (String)"upldBtnTip"));
        this.jInspectorDivider.setOrientation(1);
        this.jInspectorDivider.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString((String)MODULE, (String)"inspDvdr")));
        this.jInspectorDivider.setOneTouchExpandable(true);
        this.jInspectorDivider.setResizeWeight(0.66);
        this.jAlbumPictureDivider.setOneTouchExpandable(true);
        this.jAlbumPictureDivider.setResizeWeight(0.5);
        this.jTopPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString((String)MODULE, (String)"panel1")));
        this.jBrowseButton.setText(GRI18n.getString((String)MODULE, (String)"brwsBtnTxt"));
        this.jBrowseButton.setActionCommand("Browse");
        this.jBrowseButton.setToolTipText(GRI18n.getString((String)MODULE, (String)"brwsBtnTip"));
        this.jSortCombo.setActionCommand("SortAlternative");
        this.jSortCombo.setToolTipText(GRI18n.getString((String)MODULE, (String)"sortAlternativesBtnTip"));
        this.jSortButton.setActionCommand("Sort");
        this.jSortButton.setToolTipText(GRI18n.getString((String)MODULE, (String)"sortBtnTip"));
        this.jSortButton.setText(GRI18n.getString((String)MODULE, (String)"sortBtnTxt"));
        this.jGalleryCombo.setActionCommand("Url");
        this.jGalleryCombo.setToolTipText(GRI18n.getString((String)MODULE, (String)"gllryCombo"));
        this.jMenuFile.setText(GRI18n.getString((String)MODULE, (String)"menuFile"));
        this.jMenuItemQuit.setText(GRI18n.getString((String)MODULE, (String)"menuQuit"));
        this.jMenuItemQuit.setActionCommand("File.Quit");
        this.jMenuItemQuit.setIcon(GalleryRemote.iQuit);
        this.jMenuItemQuit.setAccelerator(KeyStroke.getKeyStroke(81, GalleryRemote.ACCELERATOR_MASK));
        this.jMenuEdit.setText(GRI18n.getString((String)MODULE, (String)"menuEdit"));
        this.jMenuItemCut.setText(GRI18n.getString((String)MODULE, (String)"menuCut"));
        this.jMenuItemCut.setActionCommand("Edit.Cut");
        this.jMenuItemCut.setIcon(GalleryRemote.iCut);
        this.jMenuItemCut.setAccelerator(KeyStroke.getKeyStroke(88, GalleryRemote.ACCELERATOR_MASK));
        this.jMenuItemCopy.setText(GRI18n.getString((String)MODULE, (String)"menuCopy"));
        this.jMenuItemCopy.setActionCommand("Edit.Copy");
        this.jMenuItemCopy.setIcon(GalleryRemote.iCopy);
        this.jMenuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, GalleryRemote.ACCELERATOR_MASK));
        this.jMenuItemPaste.setText(GRI18n.getString((String)MODULE, (String)"menuPaste"));
        this.jMenuItemPaste.setActionCommand("Edit.Paste");
        this.jMenuItemPaste.setIcon(GalleryRemote.iPaste);
        this.jMenuItemPaste.setAccelerator(KeyStroke.getKeyStroke(86, GalleryRemote.ACCELERATOR_MASK));
        this.jMenuOptions.setText(GRI18n.getString((String)MODULE, (String)"menuOptions"));
        this.jCheckBoxMenuThumbnails.setActionCommand("Options.Thumbnails");
        this.jCheckBoxMenuThumbnails.setText(GRI18n.getString((String)MODULE, (String)"cbmenuThumb"));
        this.jCheckBoxMenuPreview.setActionCommand("Options.Preview");
        this.jCheckBoxMenuPreview.setText(GRI18n.getString((String)MODULE, (String)"cbmenuPreview"));
        this.jCheckBoxMenuPath.setActionCommand("Options.Path");
        this.jCheckBoxMenuPath.setText(GRI18n.getString((String)MODULE, (String)"cbmenuPath"));
        this.jMenuItemPrefs.setText(GRI18n.getString((String)MODULE, (String)"menuPref"));
        this.jMenuItemPrefs.setActionCommand("Options.Prefs");
        this.jMenuItemPrefs.setIcon(GalleryRemote.iPreferences);
        this.jMenuItemClearCache.setText(GRI18n.getString((String)MODULE, (String)"menuClearCache"));
        this.jMenuItemClearCache.setActionCommand("Options.ClearCache");
        this.jMenuHelp.setText(GRI18n.getString((String)MODULE, (String)"menuHelp"));
        this.jMenuItemAbout.setActionCommand("Help.About");
        this.jMenuItemAbout.setText(GRI18n.getString((String)MODULE, (String)"menuAbout"));
        this.jMenuItemAbout.setIcon(GalleryRemote.iAbout);
        this.jNewGalleryButton.setText(GRI18n.getString((String)MODULE, (String)"newGalleryBtn"));
        this.jNewGalleryButton.setActionCommand("NewGallery");
        this.jNewGalleryButton.setIcon(GalleryRemote.iNewGallery);
        this.jInspectorPanel.setLayout(this.jInspectorCardLayout);
        this.jPictureScroll.setHorizontalScrollBarPolicy(30);
        this.jPictureScroll.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), GRI18n.getString((String)MODULE, (String)"pictures")));
        this.jAlbumScroll.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), GRI18n.getString((String)MODULE, (String)"albums")));
        this.jAlbumScroll.setHorizontalScrollBarPolicy(31);
        this.setupKeyboardHandling(this.jPictureScroll);
        this.setupKeyboardHandling(this.jAlbumScroll);
        if (!GalleryRemote._().isAppletMode()) {
            this.getContentPane().add((Component)this.jTopPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.jTopPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jInspectorDivider, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 2), 0, 0));
        this.jInspectorDivider.add((Component)this.jInspectorPanel, "right");
        this.jInspectorDivider.add((Component)this.jAlbumPictureDivider, "left");
        this.jInspectorPanel.add((Component)new JScrollPane(this.jPictureInspector), CARD_PICTURE);
        this.jInspectorPanel.add((Component)new JScrollPane(this.jAlbumInspector), CARD_ALBUM);
        this.jAlbumPictureDivider.add((Component)this.jPictureScroll, "right");
        this.jAlbumPictureDivider.add((Component)this.jAlbumPanel, "left");
        this.jAlbumPanel.add((Component)this.jAlbumScroll, "Center");
        this.jAlbumPanel.add((Component)this.jNewAlbumButton, "South");
        this.jAlbumScroll.getViewport().add((Component)this.jAlbumTree, null);
        this.jPictureScroll.getViewport().add((Component)this.jPicturesList, null);
        this.getContentPane().add((Component)this.jBottomPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jBottomPanel.add((Component)this.jBrowseButton, null);
        JPanel sortPanel = new JPanel(new FlowLayout(1, 0, 0));
        sortPanel.add(this.jSortButton);
        sortPanel.add(this.jSortCombo);
        this.jBottomPanel.add((Component)sortPanel, null);
        this.jBottomPanel.add((Component)this.jUploadButton, null);
        this.getContentPane().add((Component)this.jStatusBar, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jTopPanel.add((Component)this.jGalleryCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jTopPanel.add((Component)this.jNewGalleryButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.jTopPanel.add((Component)this.jLoginButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        if (!GalleryRemote.IS_MAC_OS_X) {
            this.jMenuBar1.add(this.jMenuFile);
        }
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuBar1.add(this.jMenuOptions);
        if (!GalleryRemote.IS_MAC_OS_X) {
            this.jMenuBar1.add(this.jMenuHelp);
        }
        if (!GalleryRemote.IS_MAC_OS_X) {
            this.jMenuFile.add(this.jMenuItemQuit);
            this.jMenuHelp.add(this.jMenuItemAbout);
        }
        this.jMenuEdit.add(this.jMenuItemCut);
        this.jMenuEdit.add(this.jMenuItemCopy);
        this.jMenuEdit.add(this.jMenuItemPaste);
        this.jMenuOptions.add(this.jCheckBoxMenuThumbnails);
        this.jMenuOptions.add(this.jCheckBoxMenuPreview);
        this.jMenuOptions.add(this.jCheckBoxMenuPath);
        this.jMenuOptions.addSeparator();
        this.jMenuOptions.add(this.jMenuItemClearCache);
        if (!GalleryRemote.IS_MAC_OS_X) {
            this.jMenuOptions.addSeparator();
            this.jMenuOptions.add(this.jMenuItemPrefs);
        }
        this.setJMenuBar(this.jMenuBar1);
        for (int i = 1; i <= 2; ++i) {
            this.jSortCombo.addItem(new SortType(i, GRI18n.getString((String)MODULE, (String)("sort." + i))));
        }
        this.jSortCombo.setSelectedIndex(GalleryRemote._().properties.getIntProperty("sortType") - 1);
    }

    private void setupKeyboardHandling(JComponent c) {
        c.setInputMap(1, null);
    }

    private void jbInitEvents() {
        this.jLoginButton.addActionListener(this);
        this.jNewAlbumButton.addActionListener(this);
        this.jUploadButton.addActionListener(this);
        this.jSortButton.addActionListener(this);
        this.jSortCombo.addActionListener(this);
        this.jBrowseButton.addActionListener(this);
        this.jNewGalleryButton.addActionListener(this);
        this.jAlbumTree.addTreeSelectionListener(this);
        this.jMenuItemPrefs.addActionListener(this);
        this.jMenuItemClearCache.addActionListener(this);
        this.jMenuItemQuit.addActionListener(this);
        this.jMenuItemAbout.addActionListener(this);
        this.jMenuItemCut.addActionListener(this);
        this.jMenuItemCopy.addActionListener(this);
        this.jMenuItemPaste.addActionListener(this);
        this.jCheckBoxMenuThumbnails.addItemListener(this);
        this.jCheckBoxMenuPreview.addItemListener(this);
        this.jCheckBoxMenuPath.addItemListener(this);
        this.jPicturesList.addListSelectionListener((ListSelectionListener)this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.thisWindowClosing(e);
            }
        });
        this.jPicturesList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MainFrame.this.jListKeyPressed(e);
            }
        });
        this.jPicturesList.addFocusListener((FocusListener)this);
        this.jAlbumTree.addFocusListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Log.log((int)2, (String)MODULE, (String)("Command selected " + command));
        if (command.equals("File.Quit")) {
            this.thisWindowClosing(null);
        } else if (command.equals("Edit.Cut")) {
            this.doCut();
        } else if (command.equals("Edit.Copy")) {
            this.doCopy();
        } else if (command.equals("Edit.Paste")) {
            this.doPaste();
        } else if (command.equals("Options.Prefs")) {
            this.showPreferencesDialog();
        } else if (command.equals("Options.ClearCache")) {
            ImageUtils.purgeTemp();
            this.flushMemory();
        } else if (command.equals("Help.About")) {
            this.showAboutBox();
        } else if (command.equals("Fetch")) {
            if (this.getCurrentGallery().hasComm() && this.getCurrentGallery().getComm((StatusUpdate)this.jStatusBar).isLoggedIn()) {
                this.getCurrentGallery().logOut();
                this.lastOpenedFile = null;
                this.setDirtyFlag(false);
            } else {
                GalleryComm comm = this.getCurrentGallery().getComm((StatusUpdate)this.jStatusBar);
                if (comm != null && !GalleryComm.wasAuthFailure()) {
                    this.fetchAlbums();
                }
            }
        } else if (command.equals("NewAlbum")) {
            this.newAlbum();
        } else if (command.equals("Browse")) {
            this.browseAddPictures();
        } else if (command.equals("Upload")) {
            this.uploadPictures();
        } else if (command.equals("SortAlternative")) {
            int sortType = ((SortType)this.jSortCombo.getSelectedItem()).type;
            this.setSortType(sortType);
        } else if (command.equals("Sort")) {
            this.sortPictures();
        } else if (command.equals("NewGallery")) {
            this.showPreferencesDialog((class$com$gallery$GalleryRemote$prefs$URLPanel == null ? (class$com$gallery$GalleryRemote$prefs$URLPanel = MainFrame.class$("com.gallery.GalleryRemote.prefs.URLPanel")) : class$com$gallery$GalleryRemote$prefs$URLPanel).getName());
        } else {
            Log.log((int)1, (String)MODULE, (String)("Unhandled command " + command));
        }
    }

    public void showPreferencesDialog() {
        this.showPreferencesDialog(null);
    }

    private void showPreferencesDialog(String panel) {
        PropertiesFile oldProperties = (PropertiesFile)GalleryRemote._().properties.clone();
        PreferencesDialog pd = new PreferencesDialog(this);
        if (panel != null) {
            pd.setPanel(panel);
        }
        pd.setVisible(true);
        if (pd.isOK()) {
            this.readPreferences(oldProperties);
        }
    }

    public void readPreferences(PropertiesFile op) {
        PropertiesFile p = GalleryRemote._().properties;
        p.write();
        this.jCheckBoxMenuThumbnails.setSelected(p.getShowThumbnails());
        this.jCheckBoxMenuPreview.setSelected(p.getShowPreview());
        this.jCheckBoxMenuPath.setSelected(p.getShowPath());
        this.previewFrame.setVisible(p.getShowPreview());
        this.setShowThumbnails(p.getShowThumbnails());
        if (!op.getThumbnailSize().equals(p.getThumbnailSize())) {
            this.thumbnailCache.reload();
        }
    }

    public void removeGallery(Gallery g) {
        Log.log((int)2, (String)MODULE, (String)("Deleting Gallery " + g));
        this.galleries.removeElement(g);
        for (int i = 0; i < this.galleries.getSize(); ++i) {
            Gallery gg = (Gallery)this.galleries.getElementAt(i);
            gg.setPrefsIndex(i);
            gg.writeToProperties(GalleryRemote._().properties);
        }
        Gallery.removeFromProperties((PropertiesFile)GalleryRemote._().properties, (int)this.galleries.getSize());
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable item = e.getItemSelectable();
        if (item == this.jCheckBoxMenuThumbnails) {
            this.setShowThumbnails(e.getStateChange() == 1);
        } else if (item == this.jCheckBoxMenuPreview) {
            this.setShowPreview(e.getStateChange() == 1);
        } else if (item == this.jCheckBoxMenuPath) {
            GalleryRemote._().properties.setShowPath(e.getStateChange() == 1);
            this.jPicturesList.repaint();
        } else {
            Log.log((int)1, (String)MODULE, (String)("Unhandled item state change " + item));
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int sel = this.jPicturesList.getSelectedIndex();
        if (sel != -1) {
            this.thumbnailCache.preloadThumbnailFirst(this.getCurrentAlbum().getPicture(sel));
        }
        this.resetUIState();
        this.jInspectorCardLayout.show(this.jInspectorPanel, CARD_PICTURE);
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.updatePicturesList();
        this.jAlbumInspector.setAlbum(this.getCurrentAlbum());
        this.jInspectorCardLayout.show(this.jInspectorPanel, CARD_ALBUM);
    }

    public void albumChanged(Album a) {
        if (a == this.getCurrentAlbum()) {
            this.jAlbumInspector.setAlbum(a);
        }
    }

    public void contentsChanged(ListDataEvent e) {
        Object source = e.getSource();
        Log.log((int)3, (String)MODULE, (String)("Contents changed: " + e));
        if (source instanceof Album) {
            this.updatePicturesList();
        } else if (source instanceof DefaultComboBoxModel) {
            this.selectedGalleryChanged();
        } else {
            Log.log((int)1, (String)MODULE, (String)("Unknown source " + source));
        }
    }

    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
    }

    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    public void jListKeyPressed(KeyEvent e) {
        if (!this.inProgress) {
            int vKey = e.getKeyCode();
            switch (vKey) {
                case 8: 
                case 127: {
                    this.deleteSelectedPictures();
                    break;
                }
                case 37: {
                    this.movePicturesUp();
                    break;
                }
                case 39: {
                    this.movePicturesDown();
                    break;
                }
                case 38: {
                    CoreUtils.selectPrevPicture();
                    break;
                }
                case 40: {
                    CoreUtils.selectNextPicture();
                    break;
                }
                default: {
                    return;
                }
            }
            this.setDirtyFlag(true);
        }
    }

    public Gallery getCurrentGallery() {
        Gallery gallery = (Gallery)this.jGalleryCombo.getSelectedItem();
        return gallery;
    }

    public Album getCurrentAlbum() {
        Object album = this.jAlbumTree.getLastSelectedPathComponent();
        if (!(album instanceof Album)) {
            return null;
        }
        if (album == null) {
            this.jAlbumTree.setSelectionRow(0);
            album = this.jAlbumTree.getLastSelectedPathComponent();
            if (album == null || !(album instanceof Album)) {
                return null;
            }
        }
        return (Album)album;
    }

    private void macOSXRegistration() {
        if (GalleryRemote.IS_MAC_OS_X) {
            try {
                Class<?> theMacOSXAdapter = Class.forName("com.gallery.GalleryRemote.util.MacOSXAdapter");
                Class[] defArgs = new Class[]{class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = MainFrame.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, class$java$lang$String == null ? (class$java$lang$String = MainFrame.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MainFrame.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MainFrame.class$("java.lang.String")) : class$java$lang$String};
                Method registerMethod = theMacOSXAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this, "showAboutBox", "shutdown", "showPreferencesDialog"};
                    registerMethod.invoke(theMacOSXAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                Log.logException((int)1, (String)MODULE, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                Log.logException((int)1, (String)MODULE, (Throwable)e);
            }
            catch (Exception e) {
                Log.logException((int)1, (String)MODULE, (Throwable)e);
            }
        }
    }

    public void deleteSelectedPictures() {
        CoreUtils.deleteSelectedPictures();
        this.setDirtyFlag(true);
    }

    public void movePicturesUp() {
        CoreUtils.movePicturesUp();
        this.setDirtyFlag(true);
    }

    public void movePicturesDown() {
        CoreUtils.movePicturesDown();
        this.setDirtyFlag(true);
    }

    public void flushMemory() {
        this.thumbnailCache.flushMemory();
        this.previewFrame.flushMemory();
        for (int i = 0; i < this.galleries.getSize(); ++i) {
            Gallery g = (Gallery)this.galleries.getElementAt(i);
            this.preloadThumbnails(g.getAllPictures().iterator());
        }
    }

    public void preloadThumbnails(Iterator pictures) {
        this.thumbnailCache.preloadThumbnails(pictures);
    }

    public StatusUpdate getMainStatusUpdate() {
        return this.jStatusBar;
    }

    public DefaultComboBoxModel getGalleries() {
        return this.galleries;
    }

    public JList getPicturesList() {
        return this.jPicturesList;
    }

    public void focusGained(FocusEvent e) {
        if (e.getComponent() == this.jAlbumTree) {
            this.jInspectorCardLayout.show(this.jInspectorPanel, CARD_ALBUM);
        } else if (e.getComponent() == this.jPicturesList) {
            this.jInspectorCardLayout.show(this.jInspectorPanel, CARD_PICTURE);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void treeNodesChanged(TreeModelEvent e) {
        TreePath treePath = e.getTreePath();
        if (treePath != null && this.getCurrentGallery().getRoot() != treePath.getLastPathComponent()) {
            this.albumChanged((Album)treePath.getLastPathComponent());
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SortType {
        int type;
        String text;

        public SortType(int type, String text) {
            this.type = type;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    class GalleryListRenderer
    extends DefaultListCellRenderer {
        GalleryListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Gallery gallery = null;
            if (value instanceof Gallery && value != null) {
                gallery = (Gallery)value;
            }
            if (gallery != null && gallery.getRoot() != null) {
                Font font = this.getFont().deriveFont(1);
                this.setFont(font);
            } else {
                Font font = this.getFont().deriveFont(0);
                this.setFont(font);
            }
            return this;
        }
    }

    class AlbumTreeRenderer
    extends DefaultTreeCellRenderer {
        Album album = null;

        AlbumTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String name;
            TreePath selectionPath = tree.getSelectionPath();
            if (selectionPath != null && selectionPath.getLastPathComponent() == value) {
                sel = true;
            }
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.album = value instanceof Album ? (Album)value : null;
            Font font = this.getFont();
            if (font != null) {
                if (this.album != null && this.album.getSize() > 0) {
                    this.setFont(font.deriveFont(1));
                } else {
                    this.setFont(font.deriveFont(0));
                }
            }
            if (this.album != null && this.album.isHasFetchedImages()) {
                this.setForeground(Color.green);
            }
            if ((name = this.getText()) != null) {
                name = name.trim();
            }
            this.setText(name);
            this.setToolTipText(name);
            return this;
        }

        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension((int)((double)retDimension.width * 1.5 + 15.0), retDimension.height);
            }
            return retDimension;
        }
    }
}

