/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import java.io.Serializable;

public class Rational
extends Number
implements Serializable {
    private final int numerator;
    private final int denominator;
    private int maxSimplificationCalculations = 1000;

    public Rational(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    public final int intValue() {
        return (int)this.doubleValue();
    }

    public final long longValue() {
        return (long)this.doubleValue();
    }

    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final int getDenominator() {
        return this.denominator;
    }

    public final int getNumerator() {
        return this.numerator;
    }

    public Rational getReciprocal() {
        return new Rational(this.denominator, this.numerator);
    }

    public boolean isInteger() {
        return this.denominator == 1 || this.denominator != 0 && this.numerator % this.denominator == 0 || this.denominator == 0 && this.numerator == 0;
    }

    public String toString() {
        return this.numerator + "/" + this.denominator;
    }

    public String toSimpleString(boolean bl) {
        String string;
        if (this.denominator == 0 && this.numerator != 0) {
            return this.toString();
        }
        if (this.isInteger()) {
            return Integer.toString(this.intValue());
        }
        if (this.numerator != 1 && this.denominator % this.numerator == 0) {
            int n = this.denominator / this.numerator;
            return new Rational(1, n).toSimpleString(bl);
        }
        Rational rational = this.getSimplifiedInstance();
        if (bl && (string = Double.toString(rational.doubleValue())).length() < 5) {
            return string;
        }
        return rational.toString();
    }

    private boolean tooComplexForSimplification() {
        double d = (double)(Math.min(this.denominator, this.numerator) - 1) / 5.0 + 2.0;
        return d > (double)this.maxSimplificationCalculations;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rational)) {
            return false;
        }
        Rational rational = (Rational)object;
        return this.doubleValue() == rational.doubleValue();
    }

    public Rational getSimplifiedInstance() {
        if (this.tooComplexForSimplification()) {
            return this;
        }
        int n = 2;
        while (n <= Math.min(this.denominator, this.numerator)) {
            if (!(n % 2 == 0 && n > 2 || n % 5 == 0 && n > 5 || this.denominator % n != 0 || this.numerator % n != 0)) {
                return new Rational(this.numerator / n, this.denominator / n);
            }
            ++n;
        }
        return this;
    }
}

