/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- April 1998
 */

// AskYesNo.h : ask yes or no !

#if !defined(AFX_ASKYESNO_H__5946A8C4_8517_11D1_8949_444553540000__INCLUDED_)
#define AFX_ASKYESNO_H__5946A8C4_8517_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class UStr;

const char *AskYesNo(void);
	// prompt for yes or no, returns "yes" or "no"

bool PromptMessage(const char *msg, const char *title = "Message",
				   const char *def = "OK", const char *cncl = "Cancel");
	// prompt for yes or no, returns "yes" or "no"

bool PromptEditMessage(const char *msg, UStr & edit, const char *title = "Message",
				   const char *def = "OK", const char *cncl = "Cancel");
	// prompt for yes or no, returns "yes" or "no" and the value of the edit
	// field.

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CAskYesNo dialog

class CAskYesNo : public CDialog
{
// Construction
public:
	CAskYesNo(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CAskYesNo)
	enum { IDD = IDD_YESNO };
	CString	m_passwd;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAskYesNo)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CAskYesNo)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_ASKYESNO_H__5946A8C4_8517_11D1_8949_444553540000__INCLUDED_)
