/*
** The cvsgui protocol used by WinCvs
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
** 
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- November 1999
 */

/*
 * cvsgui.h --- glue code for communicating with cvs over pipes
 */

#ifndef CVSGUI_H
#define CVSGUI_H

#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif

#ifdef WIN32
#	include <process.h> // exit
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * glue code to intercept some low level calls and tunnel them
 * inside the communication pipes.
 */
#define getenv cvsguiglue_getenv
#define getpass cvsguiglue_getpass

// RCH - extra #define for Solaris
#define getpassphrase cvsguiglue_getpass

#define main cvsguiglue_main
#define exit cvsguiglue_exit

extern char * cvsguiglue_getenv(const char *env);
extern char * cvsguiglue_getpass(const char *prompt);
extern int cvsguiglue_main(int argc, char *argv[]);
extern void cvsguiglue_exit(int code);
extern void cvsguiglue_flushconsole(int closeit);

// Mach-o OSX
#if TARGET_RT_MAC_MACHO
#	define CVSGUI_PIPE						// cvs protocol
#	define BINHEX_STUFF						// resource fork encoding/deconding
#	define O_BINARY 0x8000					// not defined on OSX
#	define BROKEN_READWRITE_CONVERSION		// required for BINHEX_STUFF
#	define MACOS							// Necessary for Z Library
#	define RSA_IDENTITY_SUPPORT				// extension for passing args to ssh
#endif

#ifdef __cplusplus
}
#endif

#endif /* CVSGUI_H */
