package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.14.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
	"net/url"
)

// ServerFarmsClient is the use these APIs to manage Azure Websites resources
// through the Azure Resource Manager. All task operations conform to the
// HTTP/1.1 protocol specification and each operation returns an
// x-ms-request-id header that can be used to obtain information about the
// request. You must make sure that requests made to these resources are
// secure. For more information, see <a
// href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
// Azure Resource Manager requests.</a>
type ServerFarmsClient struct {
	ManagementClient
}

// NewServerFarmsClient creates an instance of the ServerFarmsClient client.
func NewServerFarmsClient(subscriptionID string) ServerFarmsClient {
	return NewServerFarmsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewServerFarmsClientWithBaseURI creates an instance of the
// ServerFarmsClient client.
func NewServerFarmsClientWithBaseURI(baseURI string, subscriptionID string) ServerFarmsClient {
	return ServerFarmsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateServerFarm sends the create or update server farm request.
// This method may poll for completion. Polling can be canceled by passing
// the cancel channel argument. The channel will be used to cancel polling
// and any outstanding HTTP requests.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan serverFarmEnvelope is details of App Service Plan allowPendingState
// is oBSOLETE: If true, allow pending state for App Service Plan
func (client ServerFarmsClient) CreateOrUpdateServerFarm(resourceGroupName string, name string, serverFarmEnvelope ServerFarmWithRichSku, allowPendingState *bool, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdateServerFarmPreparer(resourceGroupName, name, serverFarmEnvelope, allowPendingState, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateServerFarm", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateServerFarmSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateServerFarm", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateServerFarm", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateServerFarmPreparer prepares the CreateOrUpdateServerFarm request.
func (client ServerFarmsClient) CreateOrUpdateServerFarmPreparer(resourceGroupName string, name string, serverFarmEnvelope ServerFarmWithRichSku, allowPendingState *bool, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if allowPendingState != nil {
		queryParameters["allowPendingState"] = allowPendingState
	}

	return autorest.Prepare(&http.Request{Cancel: cancel},
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"),
		autorest.WithJSON(serverFarmEnvelope),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// CreateOrUpdateServerFarmSender sends the CreateOrUpdateServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) CreateOrUpdateServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateServerFarmResponder handles the response to the CreateOrUpdateServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) CreateOrUpdateServerFarmResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateOrUpdateVnetRoute sends the create or update vnet route request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan vnetName is name of virtual network routeName is name of the virtual
// network route route is the route object
func (client ServerFarmsClient) CreateOrUpdateVnetRoute(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	req, err := client.CreateOrUpdateVnetRoutePreparer(resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateVnetRoute", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateVnetRoute", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "CreateOrUpdateVnetRoute", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetRoutePreparer prepares the CreateOrUpdateVnetRoute request.
func (client ServerFarmsClient) CreateOrUpdateVnetRoutePreparer(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"routeName":         url.QueryEscape(routeName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"),
		autorest.WithJSON(route),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// CreateOrUpdateVnetRouteSender sends the CreateOrUpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) CreateOrUpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateVnetRouteResponder handles the response to the CreateOrUpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) CreateOrUpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteServerFarm sends the delete server farm request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan
func (client ServerFarmsClient) DeleteServerFarm(resourceGroupName string, name string) (result SetObject, err error) {
	req, err := client.DeleteServerFarmPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteServerFarm", nil, "Failure preparing request")
	}

	resp, err := client.DeleteServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteServerFarm", resp, "Failure sending request")
	}

	result, err = client.DeleteServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteServerFarm", resp, "Failure responding to request")
	}

	return
}

// DeleteServerFarmPreparer prepares the DeleteServerFarm request.
func (client ServerFarmsClient) DeleteServerFarmPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// DeleteServerFarmSender sends the DeleteServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) DeleteServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteServerFarmResponder handles the response to the DeleteServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) DeleteServerFarmResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteVnetRoute sends the delete vnet route request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan vnetName is name of virtual network routeName is name of the virtual
// network route
func (client ServerFarmsClient) DeleteVnetRoute(resourceGroupName string, name string, vnetName string, routeName string) (result SetObject, err error) {
	req, err := client.DeleteVnetRoutePreparer(resourceGroupName, name, vnetName, routeName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteVnetRoute", nil, "Failure preparing request")
	}

	resp, err := client.DeleteVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteVnetRoute", resp, "Failure sending request")
	}

	result, err = client.DeleteVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "DeleteVnetRoute", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetRoutePreparer prepares the DeleteVnetRoute request.
func (client ServerFarmsClient) DeleteVnetRoutePreparer(resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"routeName":         url.QueryEscape(routeName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// DeleteVnetRouteSender sends the DeleteVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) DeleteVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteVnetRouteResponder handles the response to the DeleteVnetRoute request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) DeleteVnetRouteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRouteForVnet sends the get route for vnet request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan vnetName is name of virtual network routeName is name of the virtual
// network route
func (client ServerFarmsClient) GetRouteForVnet(resourceGroupName string, name string, vnetName string, routeName string) (result ListVnetRoute, err error) {
	req, err := client.GetRouteForVnetPreparer(resourceGroupName, name, vnetName, routeName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRouteForVnet", nil, "Failure preparing request")
	}

	resp, err := client.GetRouteForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRouteForVnet", resp, "Failure sending request")
	}

	result, err = client.GetRouteForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRouteForVnet", resp, "Failure responding to request")
	}

	return
}

// GetRouteForVnetPreparer prepares the GetRouteForVnet request.
func (client ServerFarmsClient) GetRouteForVnetPreparer(resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"routeName":         url.QueryEscape(routeName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetRouteForVnetSender sends the GetRouteForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetRouteForVnetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetRouteForVnetResponder handles the response to the GetRouteForVnet request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetRouteForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRoutesForVnet sends the get routes for vnet request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan vnetName is name of virtual network
func (client ServerFarmsClient) GetRoutesForVnet(resourceGroupName string, name string, vnetName string) (result ListVnetRoute, err error) {
	req, err := client.GetRoutesForVnetPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRoutesForVnet", nil, "Failure preparing request")
	}

	resp, err := client.GetRoutesForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRoutesForVnet", resp, "Failure sending request")
	}

	result, err = client.GetRoutesForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetRoutesForVnet", resp, "Failure responding to request")
	}

	return
}

// GetRoutesForVnetPreparer prepares the GetRoutesForVnet request.
func (client ServerFarmsClient) GetRoutesForVnetPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetRoutesForVnetSender sends the GetRoutesForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetRoutesForVnetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetRoutesForVnetResponder handles the response to the GetRoutesForVnet request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetRoutesForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarm sends the get server farm request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan
func (client ServerFarmsClient) GetServerFarm(resourceGroupName string, name string) (result ServerFarmWithRichSku, err error) {
	req, err := client.GetServerFarmPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarm", nil, "Failure preparing request")
	}

	resp, err := client.GetServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarm", resp, "Failure sending request")
	}

	result, err = client.GetServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarm", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmPreparer prepares the GetServerFarm request.
func (client ServerFarmsClient) GetServerFarmPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetServerFarmSender sends the GetServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServerFarmResponder handles the response to the GetServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmResponder(resp *http.Response) (result ServerFarmWithRichSku, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarmMetricDefintions sends the get server farm metric defintions
// request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan
func (client ServerFarmsClient) GetServerFarmMetricDefintions(resourceGroupName string, name string) (result MetricDefinitionCollection, err error) {
	req, err := client.GetServerFarmMetricDefintionsPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetricDefintions", nil, "Failure preparing request")
	}

	resp, err := client.GetServerFarmMetricDefintionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetricDefintions", resp, "Failure sending request")
	}

	result, err = client.GetServerFarmMetricDefintionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetricDefintions", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmMetricDefintionsPreparer prepares the GetServerFarmMetricDefintions request.
func (client ServerFarmsClient) GetServerFarmMetricDefintionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metricdefinitions"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetServerFarmMetricDefintionsSender sends the GetServerFarmMetricDefintions request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmMetricDefintionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServerFarmMetricDefintionsResponder handles the response to the GetServerFarmMetricDefintions request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmMetricDefintionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarmMetrics sends the get server farm metrics request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan details is if true, metrics are broken down per App Service Plan
// instance filter is return only usages/metrics specified in the filter.
// Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
// or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client ServerFarmsClient) GetServerFarmMetrics(resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	req, err := client.GetServerFarmMetricsPreparer(resourceGroupName, name, details, filter)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetServerFarmMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetrics", resp, "Failure sending request")
	}

	result, err = client.GetServerFarmMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmMetrics", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmMetricsPreparer prepares the GetServerFarmMetrics request.
func (client ServerFarmsClient) GetServerFarmMetricsPreparer(resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = details
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metrics"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetServerFarmMetricsSender sends the GetServerFarmMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServerFarmMetricsResponder handles the response to the GetServerFarmMetrics request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarmOperation sends the get server farm operation request.
//
// resourceGroupName is name of resource group name is name of server farm
// operationID is id of Server farm operation"&gt;
func (client ServerFarmsClient) GetServerFarmOperation(resourceGroupName string, name string, operationID string) (result ServerFarmWithRichSku, err error) {
	req, err := client.GetServerFarmOperationPreparer(resourceGroupName, name, operationID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmOperation", nil, "Failure preparing request")
	}

	resp, err := client.GetServerFarmOperationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmOperation", resp, "Failure sending request")
	}

	result, err = client.GetServerFarmOperationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmOperation", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmOperationPreparer prepares the GetServerFarmOperation request.
func (client ServerFarmsClient) GetServerFarmOperationPreparer(resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"operationId":       url.QueryEscape(operationID),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/operationresults/{operationId}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetServerFarmOperationSender sends the GetServerFarmOperation request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmOperationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServerFarmOperationResponder handles the response to the GetServerFarmOperation request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmOperationResponder(resp *http.Response) (result ServerFarmWithRichSku, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarms sends the get server farms request.
//
// resourceGroupName is name of resource group
func (client ServerFarmsClient) GetServerFarms(resourceGroupName string) (result ServerFarmCollection, err error) {
	req, err := client.GetServerFarmsPreparer(resourceGroupName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarms", nil, "Failure preparing request")
	}

	resp, err := client.GetServerFarmsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarms", resp, "Failure sending request")
	}

	result, err = client.GetServerFarmsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarms", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmsPreparer prepares the GetServerFarms request.
func (client ServerFarmsClient) GetServerFarmsPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetServerFarmsSender sends the GetServerFarms request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServerFarmsResponder handles the response to the GetServerFarms request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmsResponder(resp *http.Response) (result ServerFarmCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarmSites sends the get server farm sites request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan skipToken is skip to of web apps in a list. If specified, the
// resulting list will contain web apps starting from (including) the
// skipToken. Else, the resulting list contains web apps from the start of
// the list filter is supported filter: $filter=state eq running. Returns
// only web apps that are currently running top is list page size. If
// specified, results are paged.
func (client ServerFarmsClient) GetServerFarmSites(resourceGroupName string, name string, skipToken string, filter string, top string) (result SiteCollection, err error) {
	req, err := client.GetServerFarmSitesPreparer(resourceGroupName, name, skipToken, filter, top)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", nil, "Failure preparing request")
	}

	resp, err := client.GetServerFarmSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", resp, "Failure sending request")
	}

	result, err = client.GetServerFarmSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmSitesPreparer prepares the GetServerFarmSites request.
func (client ServerFarmsClient) GetServerFarmSitesPreparer(resourceGroupName string, name string, skipToken string, filter string, top string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = skipToken
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}
	if len(top) > 0 {
		queryParameters["$top"] = top
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetServerFarmSitesSender sends the GetServerFarmSites request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmSitesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServerFarmSitesResponder handles the response to the GetServerFarmSites request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmSitesResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarmSitesNextResults retrieves the next set of results, if any.
func (client ServerFarmsClient) GetServerFarmSitesNextResults(lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.SiteCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetServerFarmSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", resp, "Failure sending next results request request")
	}

	result, err = client.GetServerFarmSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmSites", resp, "Failure responding to next results request request")
	}

	return
}

// GetServerFarmVnetGateway sends the get server farm vnet gateway request.
//
// resourceGroupName is name of resource group name is name of the App Service
// Plan vnetName is name of the virtual network gatewayName is name of the
// gateway. Only the 'primary' gateway is supported.
func (client ServerFarmsClient) GetServerFarmVnetGateway(resourceGroupName string, name string, vnetName string, gatewayName string) (result VnetGateway, err error) {
	req, err := client.GetServerFarmVnetGatewayPreparer(resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmVnetGateway", nil, "Failure preparing request")
	}

	resp, err := client.GetServerFarmVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmVnetGateway", resp, "Failure sending request")
	}

	result, err = client.GetServerFarmVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetServerFarmVnetGateway", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmVnetGatewayPreparer prepares the GetServerFarmVnetGateway request.
func (client ServerFarmsClient) GetServerFarmVnetGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       url.QueryEscape(gatewayName),
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetServerFarmVnetGatewaySender sends the GetServerFarmVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetServerFarmVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetServerFarmVnetGatewayResponder handles the response to the GetServerFarmVnetGateway request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetServerFarmVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetFromServerFarm sends the get vnet from server farm request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan vnetName is name of virtual network
func (client ServerFarmsClient) GetVnetFromServerFarm(resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	req, err := client.GetVnetFromServerFarmPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetFromServerFarm", nil, "Failure preparing request")
	}

	resp, err := client.GetVnetFromServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetFromServerFarm", resp, "Failure sending request")
	}

	result, err = client.GetVnetFromServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetFromServerFarm", resp, "Failure responding to request")
	}

	return
}

// GetVnetFromServerFarmPreparer prepares the GetVnetFromServerFarm request.
func (client ServerFarmsClient) GetVnetFromServerFarmPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetVnetFromServerFarmSender sends the GetVnetFromServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetVnetFromServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetVnetFromServerFarmResponder handles the response to the GetVnetFromServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetVnetFromServerFarmResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetsForServerFarm sends the get vnets for server farm request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan
func (client ServerFarmsClient) GetVnetsForServerFarm(resourceGroupName string, name string) (result ListVnetInfo, err error) {
	req, err := client.GetVnetsForServerFarmPreparer(resourceGroupName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetsForServerFarm", nil, "Failure preparing request")
	}

	resp, err := client.GetVnetsForServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetsForServerFarm", resp, "Failure sending request")
	}

	result, err = client.GetVnetsForServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "GetVnetsForServerFarm", resp, "Failure responding to request")
	}

	return
}

// GetVnetsForServerFarmPreparer prepares the GetVnetsForServerFarm request.
func (client ServerFarmsClient) GetVnetsForServerFarmPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// GetVnetsForServerFarmSender sends the GetVnetsForServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) GetVnetsForServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetVnetsForServerFarmResponder handles the response to the GetVnetsForServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) GetVnetsForServerFarmResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RebootWorkerForServerFarm sends the reboot worker for server farm request.
//
// resourceGroupName is name of resource group name is name of server farm
// workerName is name of worker machine, typically IP address
func (client ServerFarmsClient) RebootWorkerForServerFarm(resourceGroupName string, name string, workerName string) (result SetObject, err error) {
	req, err := client.RebootWorkerForServerFarmPreparer(resourceGroupName, name, workerName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RebootWorkerForServerFarm", nil, "Failure preparing request")
	}

	resp, err := client.RebootWorkerForServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RebootWorkerForServerFarm", resp, "Failure sending request")
	}

	result, err = client.RebootWorkerForServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RebootWorkerForServerFarm", resp, "Failure responding to request")
	}

	return
}

// RebootWorkerForServerFarmPreparer prepares the RebootWorkerForServerFarm request.
func (client ServerFarmsClient) RebootWorkerForServerFarmPreparer(resourceGroupName string, name string, workerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"workerName":        url.QueryEscape(workerName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// RebootWorkerForServerFarmSender sends the RebootWorkerForServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) RebootWorkerForServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RebootWorkerForServerFarmResponder handles the response to the RebootWorkerForServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) RebootWorkerForServerFarmResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestartSitesForServerFarm sends the restart sites for server farm request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan softRestart is soft restart applies the configuration settings and
// restarts the apps if necessary. Hard restart always restarts and
// reprovisions the apps
func (client ServerFarmsClient) RestartSitesForServerFarm(resourceGroupName string, name string, softRestart *bool) (result SetObject, err error) {
	req, err := client.RestartSitesForServerFarmPreparer(resourceGroupName, name, softRestart)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RestartSitesForServerFarm", nil, "Failure preparing request")
	}

	resp, err := client.RestartSitesForServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RestartSitesForServerFarm", resp, "Failure sending request")
	}

	result, err = client.RestartSitesForServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "RestartSitesForServerFarm", resp, "Failure responding to request")
	}

	return
}

// RestartSitesForServerFarmPreparer prepares the RestartSitesForServerFarm request.
func (client ServerFarmsClient) RestartSitesForServerFarmPreparer(resourceGroupName string, name string, softRestart *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = softRestart
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites"),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// RestartSitesForServerFarmSender sends the RestartSitesForServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) RestartSitesForServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RestartSitesForServerFarmResponder handles the response to the RestartSitesForServerFarm request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) RestartSitesForServerFarmResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateServerFarmVnetGateway sends the update server farm vnet gateway
// request.
//
// resourceGroupName is the resource group name is the name of the App Service
// Plan vnetName is the name of the virtual network gatewayName is the name
// of the gateway. Only 'primary' is supported. connectionEnvelope is the
// gateway entity.
func (client ServerFarmsClient) UpdateServerFarmVnetGateway(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	req, err := client.UpdateServerFarmVnetGatewayPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateServerFarmVnetGateway", nil, "Failure preparing request")
	}

	resp, err := client.UpdateServerFarmVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateServerFarmVnetGateway", resp, "Failure sending request")
	}

	result, err = client.UpdateServerFarmVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateServerFarmVnetGateway", resp, "Failure responding to request")
	}

	return
}

// UpdateServerFarmVnetGatewayPreparer prepares the UpdateServerFarmVnetGateway request.
func (client ServerFarmsClient) UpdateServerFarmVnetGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       url.QueryEscape(gatewayName),
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// UpdateServerFarmVnetGatewaySender sends the UpdateServerFarmVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) UpdateServerFarmVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateServerFarmVnetGatewayResponder handles the response to the UpdateServerFarmVnetGateway request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) UpdateServerFarmVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetRoute sends the update vnet route request.
//
// resourceGroupName is name of resource group name is name of App Service
// Plan vnetName is name of virtual network routeName is name of the virtual
// network route route is the route object
func (client ServerFarmsClient) UpdateVnetRoute(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	req, err := client.UpdateVnetRoutePreparer(resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateVnetRoute", nil, "Failure preparing request")
	}

	resp, err := client.UpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateVnetRoute", resp, "Failure sending request")
	}

	result, err = client.UpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.ServerFarmsClient", "UpdateVnetRoute", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetRoutePreparer prepares the UpdateVnetRoute request.
func (client ServerFarmsClient) UpdateVnetRoutePreparer(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              url.QueryEscape(name),
		"resourceGroupName": url.QueryEscape(resourceGroupName),
		"routeName":         url.QueryEscape(routeName),
		"subscriptionId":    url.QueryEscape(client.SubscriptionID),
		"vnetName":          url.QueryEscape(vnetName),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"),
		autorest.WithJSON(route),
		autorest.WithPathParameters(pathParameters),
		autorest.WithQueryParameters(queryParameters))
}

// UpdateVnetRouteSender sends the UpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client ServerFarmsClient) UpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateVnetRouteResponder handles the response to the UpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client ServerFarmsClient) UpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
