#include "gps.1x.inc"
.\" This file Copyright 1999-2001 Felipe Bergo <bergo@seul.org>"
.\" It may be distributed under the GNU Public License, version 2, or"
.\" any later version.  See section COPYING of the GNU Public license"
.\" for conditions under which this file may be redistributed."
.\" THIS IS FILE WILL GO THORUGH A C PREPROCESSOR AND THE OUTPUT"
.\" MUST BE A VALID MAN PAGE. BE CAREFUL."
.TH GPS 1x "22 Feb 2001" CURRENT_OS "User Manuals"
.\"" /*
.SH NAME
gps \- graphical tool to report process status
.SH SYNOPSIS
gps [\fB\-c\fR] [\fB\-l\fR] [\fB-sc\fR \fIcolumn\fR] [\fB-sa\fR | \fB-sd\fR]
    [\fB-dn\fR] [\fB-pt\fR] [\fB-gb\fR | \fB-gl\fR]
    [\fB-v\fR | \fB--version\fR]

Extended Kill Mode (EKM) syntax:

gps k<\fBn\fR|\fBu\fR|\fBg\fR|\fBe\fR|\fBs\fR><\fBq\fR|\fBv\fR|\fBh\fR>[<\fBi\fR|\fBo\fR|\fBb\fR>]
    [-\fBsignal\fR] \fBmatch-text\fR [\fBmatch-text\fR ...]

.SH DESCRIPTION
This man page documents version 0.9.4 of \fBgps\fR on the
.\"" */
CURRENT_OS
.\"" /*
operating system.

.B "gps "
shows the list of processes in the machine it is run. It may refresh
continuously every second or wait for refresh requests from the user.
It also shows gauges and history for CPU and memory usage.
It is also possible to watch processes on remote computers when the
Network Watch feature is enabled.

The default behavior is to refresh only when the user clicks the
\fBRefresh\fR button.

Alternatively, \fBgps\fR may send signals to some processes and exit
without opening any graphical interface, see \fBExtended Kill Mode\fR
section for details. 

Processes may be selected in the list (one at a time) so that the user
may send it SIGHUP and SIGKILL signals with the \fBHang Up\fR and
\fBKill\fR buttons, respectively, or renice it with the \fBRenice...\fR
command from the \fBAction\fR menu. Read the \fBsignal (7)\fR man page
before using the \fBSend POSIX Signal\fR command in the \fBAction\fR menu
if you don't know what each of those signals mean. Remote processes cannot
be killed, signaled or reniced, for security reasons.

To hide some fields (columns) of the process list or change the
auto-refresh interval you can use the \fBView\fR | \fBSettings...\fR command.

To show the details of the selected process double-click it in the list,
press Enter, or choose the \fBDetails...\fR command from the \fBAction\fR
menu.

.B "gps "
sorts the list on whichever field you wish. Click the column title to sort
on that column, click again to reverse sorting order.
The default is to sort PIDs in ascending order if no \fI-sc\fR, \fI-sd\fR or
\fI-sa\fR command line options are specified.

The \fBAction\fR menu is enabled only when a process is selected in the
list. A process may only be signaled or reniced if you own it. Only
the superuser may lower Nice values.

.B "gps "
also filters processes via the \fBFilter\fR | \fBSet filter...\fR command.
The current filtering is shown in the status bar.

To show gauges and history on CPU and memory usage use the
\fBView\fR | \fBCPU and memory usage...\fR command.
On multi-processor machines (SMP, Linux-only) CPU average
is shown as a green bar and each individual CPU is shown as a
blue bar.
Each vertical range delimited by vertical bars in the
histories means 240 periods (1 minute with the default 250 msec
refresh interval).

To see a per-user usage of CPU and memory use the \fBView\fR |
\fBCPU and memory usage per user...\fR commands. This display is
refreshed once a second. The memory usage is based on the \fBSize\fR
field, so it includes swapped out data.

To see the processes organized in a tree use the \fBView\fR |
\fBTree view...\fR command. It is not updated continuously.

.SH "COMMAND-LINE OPTIONS"
.IP -c
start in continuous refresh mode
.IP -dn
start without connecting to the remote hosts configured through
Network watch. When you use this option, the connections may be
started later via \fBNetwork | Restart connections\fR or via
the \fBNetwork | Network watch...\fR dialog.
.IP -gb
Use gradient-style bars in the CPU/Memory window, instead of
the stripped default.
.IP -gl
Use gray tonalities instead of colors in diagrams, for low
bit depth systems.
.IP -l
start showing long filenames, i.e., the command-line of each process in
the name field.
.IP -pt
Use the top poller instead of the native one. The top poller provides
much less information about processes, and is intended for use only
in platforms where a native poller is not available. If the piped
top poller isn't compiled in gps's binary, this option has no effect.
.IP -sa
sets sorting direction to ascending (lesser values on top). This is
already the default if neither -sa nor -sd are specified.
.IP -sd
sets sorting direction to descending (greater values on top)
.IP "-sc \fIcolumn\fR"
sorts the list on \fIcolumn\fR, which is a number from 0 to 10 representing
the column to sort (0=PID, 1=Name, 2=Owner, 3=Machine, 4=State, 5=%CPU, 6=Size,
7=RSS, 8=Nice, 9=Pri, 10=Start). When this parameter is not specified \fBgps\fR
sorts on the PID column.
.IP -v
causes gps to print version and copyright information to standard output and
exit.
.IP --version
same as \fB-v\fR.

.SH "EXTENDED KILL MODE"

.B "gps"
provides a mode where it emulates the kill command with some filtering
extras. In Extended Kill Mode (EKM) \fBgps\fR will not open any
graphical interface elements. The syntax to call \fBgps\fR in
EKM mode is

gps k<filter type><verbosity>[<pipe-mode>] [-signal] text [text ...]

where:

.B "Filter Type"
is one of these:
.TP 0.8i
.B "n"
kill by PID, \fItext\fR arguments are PID values. \fBgps\fR
will select/signal all processes that match the given PIDs.
.TP 0.8i
.B "u"
kill by owner, \fItext\fR are user names. \fBgps\fR
will select/signal all processes that are owned by given
user names.
.TP 0.8i
.B "g"
kill by group, \fItext\fR are group names. \fBgps\fR
will select/signal all processes that are owned by
users of the given groups.
.TP 0.8i
.B "e"
kill by exact name match, \fItext\fR is free form text. \fBgps\fR
will select/signal all processes whose name matches
exactly (including case) any of given \fItext\fR values.
.TP 0.8i
.B "s"
kill by substring match in name/long name, \fItext\fR is free form
text. \fBgps\fR will select/signal all processes whose names or
long names (command line) contain any of the given \fItext\fR
values as substrings.

.TP 0i
.B "Verbosity"
is one of these:
.TP 0.8i
.B "q"
Quiet. Work silently.
.TP 0.8i
.B "v"
Verbose. Will print a summary of successes and the count of
processes that matched the filter.
.TP 0.8i
.B "h"
High Verbosity. Will list progress of each matched process, as
well as some process information. The number inside
parenthesis is the return value of the kill function,
0 means success, \-1 means error.

.TP 0i
.B "Pipe mode"
is only needed when piping several \fBgps\fR instances in EKM.
It is one of these:

.TP 0.8i
.B "o"
Output to pipe, supresses normal output (verbosity is ignored)
and formats output to serve as input to a \fBgps\fR process in
EKM.
.TP 0.8i
.B "i"
Input from pipe, reads a list of pre-filtered PIDs from
stdin, usually coming from another \fBgps\fR process in EKM.
.TP 0.8i
.B "b"
Both (Input from pipe, Output to pipe), combines \fBi\fR mode and
\fBo\fR mode.

.TP 0i
.B "-signal"
Indicates which signal to send to processes that match the criteria.
If not specified, \-HUP (SIGHUP) is sent. Only the last command
in a sequence of piped \fBgps\fR in EKM need to specify this.
\fI\-signal\fR is one of \-HUP, \-INT, \-QUIT, \-ILL, \-ABRT,
\-FPE, \-KILL, \-SEGV, \-PIPE, \-ALRM, \-TERM, \-USR1, \-USR2,
\-CHLD, \-STOP, \-CONT, \-TSTP, \-TTIN, \-TTOU.

.SH "EKM RETURN VALUE"
\fBgps\fR's return value (in EKM) depends on the success of
process matching and killing: It returns 0 (full success)
when at least one process matched the criteria and all
processes that matched were signaled successfully.
Returns 1 (partial success) when at least one process matched
the criteria and at least one was signaled successfully.
Returns 2 (failure) when at least one process matched the criteria
but no one could be signaled. Returns 3 (not found) when no
process matched the criteria.


.SH "EKM EXAMPLES"

\fBKill all processes owned by user \fRtrindade\fB with SIGKILL:\fR
.br
gps kuv -KILL trindade

\fBKill all \fRxboard\fB processes owned by people from group \fRnib\fB
with SIGSEGV:\fR
.br
gps keqo xboard | gps kgvi -SEGV nib

\fBKill all \fRsnes9x\fB processes owned by user \fRricbit\fB that
contain the \fRFF5.SMC\fB string in the command line with SIGTERM:\fR
.br
gps kuqo ricbit | gps keqb snes9x | gps ksvi -TERM FF5.SMC

\fBNetscape browsers are so reliable that you'll never need this one:\fR
.br
gps ksq -KILL netscape


However, \fBgps\fR is not perfect. For example,
.br
gps ksq -KILL solaris

will not make your SPARC go faster, you must still grab a
SPARC Linux CD and trash Solaris by hand.

Note on pipe modes: the first process in the pipe sequence must
be in \fBo\fR mode, all processes but first and last must be in
\fBb\fR mode, and the last process must be in \fBi\fR mode.

Note on self-mutilation: \fBgps\fR will not kill \fBgps\fR
processes in EKM.

.SH "FIELD DESCRIPTIONS"
.TP 0.8i
.B "PID "
The unique (per machine) id number of each process.
.TP 0.8i
.B "Name "
The process' name or command-line, depending on the
\fBShow long process names\fR
setting in the \fBView\fR menu.
.TP 0.8i
.B "Owner "
The process owner's username.
.TP 0.8i
.B "Machine "
The host where the process is running.
.TP 0.8i
.B "State "
The process' current state, made up of 3 fields. The first field is
.B R
for runnable,
.B S
for sleeping,
.B D
for uninterruptible sleep,
.B T
for stopped or traced, or
.B Z
for a zombie process.  The second field contains
.B W
if the process has no resident pages.  The third field is
.B N
if the process has a positive nice value
.RB ( Nice
field).
.TP 0.8i
.B "%CPU "
shows the cputime/realtime percentage.  It will not add up to 100%
unless you are lucky.  It is time used divided by the time the process
has been running.
.TP 0.8i
.B "Size "
The process' memory fingerprint. It is (code+data+stack).
.TP 0.8i
.B "RSS "
The amount of Size (code+data+stack) currently in memory.
.TP 0.8i
.B "Nice "
Standard unix nice value; a positive value means less cpu time.
.TP 0.8i
.B "Pri "
This is the counter field in the task struct.  It is the time in
hundreths of seconds of the process's possible timeslice.
.TP 0.8i
.B "Start "
The process' start time.

.SH "FIELD DESCRIPTIONS FOR THE DETAILS DIALOG"
The details dialog shows many "gut" details of processes. Some
fields are redundant with the main window list, others are explained
below.

\fBJiffies\fR - some fields show values in jiffies. One jiffy is 1/100 of a
second.

.TP 0.8i
.B "PPID "
The unique id number of a process' parent.
.TP 0.8i
.B "Flags "
Various flags set for each process. These are:
.\"" */
#ifdef Linux
.TP 1.6i
.B "   ALIGNWARN "
Process will print alignment warning messages.
.TP 1.6i
.B "   STARTING "
Process is starting.
.TP 1.6i
.B "   EXITING "
Process is dying.
.TP 1.6i
.B "   PTRACED "
Set when ptrace(0) is called.
.TP 1.6i
.B "   TRACESYS "
Tracing system calls.
.TP 1.6i
.B "   FORKNOEXEC "
Process forked but did not exec. This is not either an error or bad.
.TP 1.6i
.B "   SUPERPRIV "
Process used super-user privileges.
.TP 1.6i
.B "   DUMPCORE "
Process dumped core and left someone unhappy.
.TP 1.6i
.B "   SIGNALED "
Process was killed by a signal.
.TP 1.6i
.B "   MEMALLOC "
Process is allocating memory.
.TP 1.6i
.B "   VFORK "
Wake up parent in mm_release. If you understand it, document better.
.TP 1.6i
.B "   USEDFPU "
Task used FPU in its last timeslice.
.TP 1.6i
.B "   DTRACE "
Process uses delayed trace (used on i386, m68k).
#endif
#ifdef FreeBSD
.TP 1.6i
.B "   ADVLOCK"
Process may hold a POSIX advisory lock.
.TP 1.6i
.B "   CONTROLT"
Process has a controlling terminal.
.TP 1.6i
.B "   INMEM"
Process is loaded into memory.
.TP 1.6i
.B "   NOCLDSTOP"
No SIGCHLD when children stop.
.TP 1.6i
.B "   PPWAIT"
Parent is waiting for cild to exec/exit.
.TP 1.6i
.B "   PROFIL"
Has started profiling.
.TP 1.6i
.B "   SELECT"
Selecting; wakeup/waiting danger.
.TP 1.6i
.B "   SINTR"
Sleep is interruptible.
.TP 1.6i
.B "   SUGID"
Had set id privileges since last exec.
.TP 1.6i
.B "   SYSTEM"
System process: no signals, stats or swapping.
.TP 1.6i
.B "   TIMEOUT"
Timing out during sleep.
.TP 1.6i
.B "   TRACED"
Debugged process being traced.
.TP 1.6i
.B "   WAITED"
Debugged process has waited for child.
.TP 1.6i
.B "   WEXIT"
Working on exiting.
.TP 1.6i
.B "   EXEC"
Process called exec.
.TP 1.6i
.B "   NOSWAP"
Flag to prevent swapping out.
.TP 1.6i
.B "   PHYSIO"
Doing physical I/O.
.TP 1.6i
.B "   OWEUPC"
Owe process an addupc() call at next ast.
.TP 1.6i
.B "   SWAPPING"
Process is being swapped.
.TP 1.6i
.B "   SWAPPINREQ"
Swapin request due to wakeup.
.TP 1.6i
.B "   KTHREADP"
Process is a kernel thread.
.TP 1.6i
.B "   NOCLDWAIT"
No zombies if child dies.
#endif
#ifdef UNKNOWN
\fBThis man page was generated in an architecture where the flags
are neither stated nor documented.\fR
#endif
.\"" /*
.TP 0.8i
.B "RSS Limit "
The limit on RSS size, usually 2 GB.
.TP 0.8i
.B "Minor Faults (Process / Children) "
Minor faults are page faults that do not require loading the
missing pages from disk.
.TP 0.8i
.B "Major Faults (Process / Children) "
Major faults are page faults that require loading the missing
pages from disk.
.TP 0.8i
.B "Maximum jiffies in next timeslice "
This is the \fBPri\fR value from the main list.

Please mind that the values in the details dialog are static (they are not
refreshed continuously, not even when the main list is).

.SH "FILTERING"
.BR "gps "
decides which processes to include in the list (when a filter is set)
by comparison with a value, as set in the \fBSet filter...\fR dialog.
To enter values use the same notation used in the table, i.e.:

\fBMemory\fR: 420K

The start time field has special input. Aside from accepting values
as those in the list, it will accept the following syntax

\fBtoday\fR
.br
\fByesterday\fR
.br
\fB<number> <time-unit> ago\fR

where \fB<time-unit>\fR can be: seconds, minutes, hours, days,
weeks, months, years. Both plural and singular forms are
accepted. Examples of valid input:

\fB5 days ago\fR
.br
\fB1 month ago\fR

The other fields are compared numerically / lexicographically as
expected.

\fBSpecial note on memory filtering:\fR memory is formatted with suffixes
K, M, G, T, P to indicate Kilo, Mega, Giga, Tera and Peta, and no suffix
to indicate byte values. \fBgps\fR uses a higher unit if the numeric
value is higher than 99K (99<<10). So the M suffix will be used whenever
a memory size is greater than (99K)K=99M and K is used when size is
greater than 99K.
\fBgps\fR considers a K-ended memory string always lesser than
an M-ended string and so on. As most processes use more than 99K but
less than 99M of memory (and most of the exceptions use 0),
using K-ended strings should give you the filtering you want.

\fBSecond note on memory\fR: on 32-bit x86 machines you'll never
get T or P memory strings. I just included Tera and Peta in case
you there compiled this in that 64/128/(256<<n)-bit Linux box you got
getting dust in the corner.

.SH "NETWORK WATCH"
.BR "gps"
allows the watching of processes on remote machines. These machines
must be running a special poller (see \fBrgpsp\fR(1)) that will
gather information on each host. The Network contains the
commands needed to set up the watched hosts. The host configuration
is saved in the \fI~/.gpsrc\fR file.

.SH "RANDOM NOTES"
Different polling methods may provide different values for the same thing,
especially memory. The concept of free memory is not clear and some
pollers may include caches and buffers in "free memory", while others
may not. Usually the native poller provides more accurate information.

.BR "gps "
uses the
gtk+ library (The Gimp Toolkit, http://www.gtk.org). If someday \fBgps\fR
stops working, says something funny about library versions and refuses
to run,
you may have installed a different version of the gtk+ shared library
files, and gps (as well as any other gtk+ application) will need to
be relinked with the new library.

.SH "PORTABILITY"
.BR "gps "
works on Linux (all architectures) and FreeBSD (i386 only).
It may work under other POSIX systems using the rather limited
piped top poller.

.SH "BUGS"
FreeBSD: FreeBSD's process 0 makes a little mess with the
tree view. The piped top poller won't work with FreeBSD's top,
but as there is a native poller for FreeBSD, you don't need it.

\fBLinux\fR: none that I know of.

.SH "UNRESTRICTIONS"
.BR "gps "
is free; anyone may redistribute copies of \fBgps\fR to anyone under the
terms stated in the GNU General Public License.
A copy of the license accompanies each copy of \fBgps\fR.

.SH "FILES"
The file paths stated below assume \fBgps\fR was installed in the default
installation prefix, \fI/usr/local\fR. If you installed gps from a RPM
package the default prefix is \fI/usr\fR.

.IR ~/.gpsrc
.br
.IR /usr/local/doc/gps-0.9.4/README
.br
.IR /usr/local/doc/gps-0.9.4/INSTALL
.br
.IR /usr/local/doc/gps-0.9.4/COPYING
.br
.IR /usr/local/share/icons/xray-tux.xpm
.br

.SH "AUTHORS"
.BR "gps "
was written by Felipe Bergo <bergo@seul.org>, with contributions
from Beat Christen (Network watch ideas, rtop) <spiff@seul.org> 

.SH "WEB SITE"
http://www.gps.seul.org

.SH "SEE ALSO"
\fBproc\fR(5), \fBsignal\fR(7), \fBps\fR(1), \fBtop\fR(1), \fBrenice\fR(8), \fBkill\fR(1), \fBrpm\fR(8), \fBrgpsp\fR(1)
.\"" */
