/* $Id: simple.c,v 1.3 2004/12/11 19:26:05 ellson Exp $ $Revision: 1.3 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

#include <dotneato.h>

int main(int argc, char **argv)
{
    Agraph_t *g;
    Agnode_t *n;
    FILE *fp;
    char buf[BUFSIZ];
    point p;

    aginit();

    if (argc > 1)
	fp = fopen(argv[1], "r");
    else
	fp = stdin;
    g = agread(fp);

    dot_layout(g);

    agnodeattr(g, "pos", "");
    for (n = agfstnode(g); n; n = agnxtnode(g, n)) {
	p = ND_coord_i(n);
	sprintf(buf, "%d,%d", p.x, p.y);
	agset(n, "pos", buf);
	printf("node %s at position (%s)\n", n->name, buf);
    }
    agwrite(g, stdout);

    dot_cleanup(g);
    return 0;
}
