/* $Id: UVCross.cpp,v 1.6 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "dynadag/DynaDAG.h"

namespace DynaDAG {

Crossings uvcross(DDModel::Node *v, DDModel::Node *w, bool use_in, bool use_out) {
	Crossings ret;
	if(use_in) 
		for(DDModel::inedge_iter ei = w->ins().begin(); ei!=w->ins().end(); ++ei) 
			for(DDModel::inedge_iter ej = v->ins().begin(); ej!=v->ins().end(); ++ej) 
				if(DDd((*ej)->tail).order > DDd((*ei)->tail).order)
					ret.add(*ei,*ej);
	if (use_out) 
		for(DDModel::outedge_iter ei = w->outs().begin(); ei!=w->outs().end(); ++ei) 
			for(DDModel::outedge_iter ej = v->outs().begin(); ej!=v->outs().end(); ++ej) 
				if(DDd((*ej)->head).order > DDd((*ei)->head).order)
					ret.add(*ei,*ej);
	return ret;
}

} // namespace DynaDAG
