/* $Id: gengraph.cpp,v 1.4 2005/04/05 11:32:54 ellson Exp $ $Revision: 1.4 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "common/LGraph-cdt.h"
#include "common/StrAttr.h"
#include "common/emitGraph.h"
#include <time.h>
#include <stdlib.h>
#include <iostream>

using namespace std;

int main(int narg,char *argh[]) {
	int V = 100, E = 100;
	if(narg>1)
		V = atoi(argh[1]);
	if(narg>2)
		E = atoi(argh[2]);
	if(!V || !E) {
		fprintf(stderr,"gengraph #nodes #edges\n");
		return 1;
	}
	unsigned seed = (unsigned)time(NULL);
	srand(seed);

	StrGraph g;
	char buf[20];
	sprintf(buf,"%d",seed);
	gd<StrAttrs>(&g)["seed"] = buf;
	vector<StrGraph::Node*> ez;
	ez.resize(V);
	int v = V;
	while(v--) {
		char name[10];
		sprintf(name,"%d",v);
		ez[v] = g.create_node(name);
	}
	while(E--) {
		int t,h;
		do 
			t = rand()%V, h = rand()%V;
		while(t==h || g.find_edge(ez[t],ez[h]) || g.find_edge(ez[h],ez[t])); // play to dynagraph's weaknesses
		StrGraph::Edge *e = g.create_edge(ez[t],ez[h]).first;
		char *color=0;
		switch(rand()%3) {
			case 0: color = "red";
				break;
			case 1: color = "yellow";
				break;
			case 2: color = "blue";
				break;
		}
		gd<StrAttrs>(e)["color"] = color;
	}
	emitGraph(cout,&g);
	return 0;
}
