/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "main.h"
#include "utils.h"
#include "configure.h"
#include "diskfree.h"
#include "widgets.h"
#include "interface.h"
#include "about.h"
#include "mount.h"
#include "options.h"
#include "menus.h"

#include "icons/mount.xpm"
#include "icons/umount.xpm"
#include "icons/refresh.xpm"
#include "icons/stop.xpm"
#include "icons/options.xpm"
#include "icons/help.xpm"

GtkWidget *selection_widget;

/* Signals */
void
gui_menu_copy_clicked (GtkWidget *widget, gint *have_selection)
{
       	*have_selection = gtk_selection_owner_set(selection_widget,
						  GDK_SELECTION_PRIMARY,
						  GDK_CURRENT_TIME);
	
	return;
}

void
gui_menu_copy_handle (GtkWidget *widget, GtkSelectionData *selection_data,
		      guint info, guint time_stamp, gint *have_selection)
{
	gint i;
	gchar *str = NULL, *s1, *s2;
	GtkTreeIter iter;
	GtkTreeSelection *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(list_treeview));
	
	if (!gtk_tree_selection_get_selected(selection, NULL, &iter))
		return;
	
	for (i = FILESYSTEM_COLUMN ; i <= MOUNT_POINT_COLUMN ; i++) {
		if (options->show_columns[i] || options->show_columns_all) {
			gtk_tree_model_get(list_treemodel, &iter, i, &s2, -1);
			if (str != NULL) {
				s1 = g_strdup(str);
				g_free(str);
				str = g_strconcat(s1, SPACE_CHAR, SPACE_CHAR, s2, NULL);
				g_free(s1);
			} else
				str = g_strdup(s2);
			g_free(s2);
		}
	}
	gtk_selection_data_set_text(selection_data, str, strlen(str));
	g_free(str);
	
	return;
}

gboolean
gui_menu_copy_clear (GtkWidget *widget, GdkEventSelection *event,
		     gint *have_selection)
{
	*have_selection = FALSE;
	
	return TRUE;
}

void
gui_menu_mount_clicked (GtkWidget *wdg, order_t action)
{
	gint state;
	gchar *mntpt, *type;
	GtkTreeIter iter;
	GtkTreeSelection *selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(list_treeview));
	
	if (!gtk_tree_selection_get_selected(selection, NULL, &iter))
		return;
	
	gtk_tree_model_get(list_treemodel, &iter, STATUS_COLUMN, &state, -1);
	gtk_tree_model_get(list_treemodel, &iter, MOUNT_POINT_COLUMN, &mntpt, -1);
	gtk_tree_model_get(list_treemodel, &iter, FILESYSTEM_TYPE_COLUMN, &type, -1);
	
	switch (action) {
	case MOUNT:
		if (state == FS_UMOUNTED)
			mount_fs(mntpt, type);
		break;
	case UMOUNT:
		if (state == FS_MOUNTED)
			umount_fs(mntpt, type);
		break;
	default:
		break;
	}
	g_free(mntpt);
	g_free(type);
	
	return;
}

gboolean
gui_popup_menu_signal (GtkWidget *widget, GdkEventButton *ev,
		       gpointer data)
{
	if (ev->button == 3) {
		if (GTK_WIDGET_VISIBLE(popup))
			gtk_menu_popdown(GTK_MENU(popup));
		else
			gtk_menu_popup(GTK_MENU(popup), NULL,
				       NULL, NULL, NULL,
				       ev->button, ev->time);
		return TRUE;
	}
	
	return FALSE;
}

/* Create */
void
gui_main_menu_create (GtkWidget *box)
{
	GtkWidget *menubar;
	GtkWidget *main_menu;
	GtkWidget *main_item;
	GtkWidget *menu_item;
	
	/* -- Create menu bar -- */
	
	menu_handle_box = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(box), menu_handle_box, TRUE, FALSE, 0);
	
	menubar = gtk_menu_bar_new();
	gtk_container_add(GTK_CONTAINER(menu_handle_box), menubar);
	gtk_widget_show(menubar);
	
	/* -- File menu -- */
	
	main_item = gtk_menu_item_new_with_label(_("File"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), main_item);
	gtk_widget_show(main_item);
	
	main_menu = widget_menu_add(main_item);
	
	menu_item = widget_menu_item_add(main_menu, _("Mount"));
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(gui_menu_mount_clicked),
			 (gpointer)MOUNT);
	
	menu_item = widget_menu_item_add(main_menu, _("Umount"));
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(gui_menu_mount_clicked),
			 (gpointer)UMOUNT);
	
	widget_menu_item_add(main_menu, NULL);
	
	menu_item = widget_menu_item_add(main_menu, _("Refresh"));
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(gui_statusbar_timeout_update),
			 (gpointer)REFRESH);
	
	menu_item = widget_menu_item_add(main_menu, _("Stop"));
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(gui_statusbar_timeout_update),
			 (gpointer)STOP);
	
	widget_menu_item_add(main_menu, NULL);
	
	menu_item = widget_menu_item_add(main_menu, _("Exit"));
	g_signal_connect_object(G_OBJECT(menu_item), "activate",
				G_CALLBACK(gtk_main_quit), NULL, 0);
	
  
	/* -- Edit menu -- */
	
	main_item = gtk_menu_item_new_with_label(_("Edit"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), main_item);
	gtk_widget_show(main_item);
	
	main_menu = widget_menu_add(main_item);
	
	menu_item = widget_menu_item_add(main_menu, _("Properties"));
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(ui_options_window_create),
			 NULL);
	
	
	/* -- Help menu -- */
	
	main_item = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_item_right_justify(GTK_MENU_ITEM(main_item));
	gtk_menu_bar_append( GTK_MENU_BAR(menubar), main_item);
	gtk_widget_show(main_item);
	
	main_menu = widget_menu_add(main_item);
	
	menu_item = widget_menu_item_add(main_menu, _("About"));
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(gui_about_window), NULL);

	gtk_widget_show_all(menu_handle_box);
	
	return;
}

void
gui_toolbar_create (GtkWidget *box)
{
	GdkWindow *win = mwindow_attr.mwindow->window;
	GtkWidget *toolbar;
	GtkWidget *icon;
	
	tool_handle_box = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(box), tool_handle_box, FALSE, FALSE, 0);
	
	toolbar = gtk_toolbar_new();
	gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_HORIZONTAL);
	gtk_container_add(GTK_CONTAINER(tool_handle_box), toolbar);
	gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_tooltips(GTK_TOOLBAR(toolbar), TRUE);
	gtk_widget_show_all(tool_handle_box);
	
	/*--*/
	icon = widget_pixmap_create_from_data(win, mount_xpm);
	gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL, _("Mount"),
				NULL, icon,
				GTK_SIGNAL_FUNC(gui_menu_mount_clicked),
				(gpointer)MOUNT);
	/*--*/
	icon = widget_pixmap_create_from_data(win, umount_xpm);
	gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL, _("Umount"),
				NULL, icon,
				GTK_SIGNAL_FUNC(gui_menu_mount_clicked),
				(gpointer)UMOUNT);
	/*--*/  
	icon = widget_pixmap_create_from_data(win, refresh_xpm);
	gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL, _("Refresh"),
				NULL, icon,
				GTK_SIGNAL_FUNC(gui_statusbar_timeout_update),
				(gpointer)REFRESH);
	/*--*/
	icon = widget_pixmap_create_from_data(win, stop_xpm);
	gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL, _("Stop"),
				NULL, icon,
				GTK_SIGNAL_FUNC(gui_statusbar_timeout_update),
				(gpointer)STOP);
	/*--*/
	icon = widget_pixmap_create_from_data(win, options_xpm);
	gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL, _("Properties"),
				NULL, icon,
				GTK_SIGNAL_FUNC(ui_options_window_create),
				NULL);
	/*--*/
	icon = widget_pixmap_create_from_data(win, help_xpm);
	gtk_toolbar_append_item( GTK_TOOLBAR(toolbar), NULL, _("Help"),
				 NULL, icon, GTK_SIGNAL_FUNC(gui_about_window),
				 NULL);
	
	return;
}

void
gui_popup_create (void)
{
	static int have_selection = FALSE;
	GtkWidget *item;
	
	popup = gtk_menu_new();
	
	item = widget_menu_item_add(popup, _("Mount"));
	g_signal_connect(G_OBJECT(item), "activate",
			 G_CALLBACK(gui_menu_mount_clicked),
			 (gpointer)MOUNT);
	
	item = widget_menu_item_add(popup, _("Umount"));
	g_signal_connect(G_OBJECT(item), "activate",
			 G_CALLBACK(gui_menu_mount_clicked),
			 (gpointer)UMOUNT);
	
	widget_menu_item_add(popup, NULL);
	
	item = widget_menu_item_add(popup, _("Refresh"));
	g_signal_connect(G_OBJECT(item), "activate",
			 G_CALLBACK(gui_statusbar_timeout_update),
			 (gpointer)REFRESH);
	
	item = widget_menu_item_add(popup, _("Stop"));
	g_signal_connect(G_OBJECT(item), "activate",
			 G_CALLBACK(gui_statusbar_timeout_update),
			 (gpointer)STOP);
	
	widget_menu_item_add(popup, NULL);
	
	selection_widget = gtk_invisible_new();
	item = widget_menu_item_add(popup, _("Copy"));
	g_signal_connect(G_OBJECT(item), "activate",
			 G_CALLBACK(gui_menu_copy_clicked),
			 &have_selection);
	g_signal_connect(G_OBJECT(selection_widget), "selection_clear_event",
			 G_CALLBACK(gui_menu_copy_clear),
			 &have_selection);
	gtk_selection_add_target(selection_widget,
				 GDK_SELECTION_PRIMARY,
				 GDK_SELECTION_TYPE_STRING,
				 1);
	g_signal_connect(G_OBJECT(selection_widget), "selection_get",
			 G_CALLBACK(gui_menu_copy_handle),
			 &have_selection);
	
	widget_menu_item_add(popup, NULL);
	
	item = widget_menu_item_add(popup, _("Properties"));
	g_signal_connect(G_OBJECT(item), "activate",
			 G_CALLBACK(ui_options_window_create),
			 NULL);
	
	return;
}
