/* 
 *	HT Editor
 *	analy_x86.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Sebastian Biallas (sb@web-productions.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "x86dis.h"
#include "analy_x86.h"
#include "analy_register.h"
#include <string.h>

/*
 *
 */
void analy_x86_disassembler::init(analyser *A)
{
	analy_disassembler::init(A);
}

/*
 *
 */
int  analy_x86_disassembler::load(ht_object_stream *f)
{
	return analy_disassembler::load(f);
}

/*
 *
 */
void analy_x86_disassembler::done()
{
	analy_disassembler::done();
}

OBJECT_ID	analy_x86_disassembler::object_id()
{
	return ATOM_ANALY_X86;
}

/*
 *
 */
ADDR	analy_x86_disassembler::branch_addr(OPCODE *opcode)
{
	ADDR Addr = INVALID_ADDR;
	char *opcode_str = disasm->str(opcode, 0);
	sscanf(opcode_str, "%*s %x", &Addr);
	return Addr;
}

/*
 *
 */
void analy_x86_disassembler::init_disasm()
{
	dprintf("analy_x86_disassembler: initing x86dis\n");
	// FIXME: OPSIZE32 should be variable
	disasm = new x86dis(X86_OPSIZE32, X86_ADDRSIZE32);
	if (analy) analy->set_disasm(disasm);
}

/*
 *
 */
tbranchtype analy_x86_disassembler::is_branch(OPCODE *opcode)
{
	char *opcode_str = disasm->str(opcode, 0);

	if (opcode_str[0]=='j') {
		if (opcode_str[1]=='m') return brjump; else return brjXX;
	} else if ((opcode_str[0]=='l') && (opcode_str[1]=='o')  && (opcode_str[2]=='o')) {
		// loop opcode will be threated like a jXX
		return brjXX;
	} else if (strncmp("call", opcode_str, 4)==0) {
		return brcall;
	} else if (strncmp("ret", opcode_str, 3)==0) {
		return brreturn;
	} else return brnobranch;
}

/*
 *
 */
void analy_x86_disassembler::store(ht_object_stream *f)
{
	analy_disassembler::store(f);
}


