/*
**  FILE:          lists.h  - %W% %G% 
**  AUTHOR:        Kent Landfield
**
**  ABSTRACT:      Define the lists supported by hypermail
**
** This software is Copyright (c) 1996 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**                                                               
*/

#ifdef WU_FTPD

#define HYPERMAIL    "/usr/local/bin/hypermail" 
#define ARCHIVE      "/ftp/wu-ftpd/mail-archive" 
#define MAILBOXDIR   "/ftp/wu-ftpd/mail-archive/mailbox" 
#define LABEL        "WU-FTPD Development Mailing List"
#define ABOUT_LINK   "/wu-ftpd" 
#define LISTNAME     "wu-ftpd"
#define CONFIGFILE   "NONE"

#else
#ifdef WU_FTPD_DEV

#define HYPERMAIL    "/usr/local/bin/hypermail" 
#define ARCHIVE      "/wuftpd.org/ftp/wuftpd-dev"
#define MAILBOXDIR   "/wuftpd.org/ftp/wuftpd-dev/mail-archive/mailbox" 
#define LABEL        "WU-FTPD Open Development List"
#define ABOUT_LINK   "/mail-archive" 
#define LISTNAME     "wuftpd-dev"
#define CONFIGFILE   "NONE"

#else
#ifdef NFR_ANNOUNCE

#define HYPERMAIL    "/usr/local/bin/hypermail"
#define ARCHIVE      "/ftp/nfr/mail-archive/nfr-announce"
#define MAILBOXDIR   "/ftp/nfr/mail-archive/nfr-announce/mailbox"
#define LABEL        "Network Flight Recorder Announcements"
#define ABOUT_LINK   "/nfr/mail-archive"
#define LISTNAME     "nfr-announce"
#define CONFIGFILE   "/usr/local/lib/hypermail/nfr-announce.rc"

#else
#ifdef NFR_USERS

#define HYPERMAIL    "/usr/local/bin/hypermail"
#define ARCHIVE      "/ftp/nfr/mail-archive/nfr-users"
#define MAILBOXDIR   "/ftp/nfr/mail-archive/nfr-users/mailbox"
#define LABEL        "Network Flight Recorder Users Discussion List"
#define ABOUT_LINK   "/nfr/mail-archive"
#define LISTNAME     "nfr-users"
#define CONFIGFILE   "/usr/local/lib/hypermail/nfr-users.rc"


#else
#ifdef FAQ_MAINTAINERS

#define HYPERMAIL    "/usr/local/bin/faqhypermail"
#define ARCHIVE      "/ftp/faq-maintainers/mail-archive"
#define MAILBOXDIR   "/ftp/faq-maintainers/mail-archive/mailbox"
#define LABEL        "FAQ Maintainers Mailing List"
#define ABOUT_LINK   "/ftp/faq-maintainers/mail-archive"
#define LISTNAME     "faq-maintainers"
#define CONFIGFILE   "NONE"

#else
#ifdef ISN

#define HYPERMAIL    "/usr/local/bin/isnhypermail"
#define ARCHIVE      "/ftp/security/isn/mail-archive"
#define MAILBOXDIR   "/ftp/security/isn/mail-archive/mailbox"
#define LABEL        "Internet Security News"
#define ABOUT_LINK   "/isn/mail-archive"
#define LISTNAME     "isn"
#define CONFIGFILE   "NONE"

#else
#ifdef HYPERDEV

#define HYPERMAIL    "/usr/local/bin/hypermail"
#define ARCHIVE      "/ftp/hypermail/mail-archive"
#define MAILBOXDIR   "/ftp/hypermail/mail-archive/mailbox"
#define LABEL        "Hypermail Development List"
#define ABOUT_LINK   "/hypermail/mail-archive"
#define LISTNAME     "hypermail"
#define CONFIGFILE   "/usr/local/lib/hypermail/hypermail.rc"

#else
#ifdef HYPERTEST

#define HYPERMAIL    "../src/hypermail"
#define ARCHIVE      "../tests/mail-archive"
#define MAILBOXDIR   "../tests/mail-archive/mailbox"
#define LABEL        "Hypermail Test Archive"
#define ABOUT_LINK   "../"
#define LISTNAME     "hypermail-test"
#define CONFIGFILE   "../tests/test.rc"

#endif /* HYPERTEST */
#endif /* HYPERDEV */
#endif /* ISN */
#endif /* FAQ_MAINTAINERS */
#endif /* NFR_USERS */
#endif /* NFR_ANNOUNCE */
#endif /* WU_FTPD_DEV */
#endif /* WU_FTPD */
/*
** check to assure repost defines are in order...
*/
#if defined(NFR_USERS) + defined(NFR_ANNOUNCE) + defined(FAQ_MAINTAINERS) + defined(WU_FTPD) + defined(ISN) + defined(HYPERDEV) + defined(HYPERTEST) + defined(WU_FTPD_DEV) != 1
#include "ERROR - Can only define it one way...!"
#endif

